package com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.request.CommanderPromoCodeReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * 分销员推广码信息表服务接口
 *
 * @author erduo
 * @since 2021-04-13
 */
@Api(tags = {"分销员推广码信息表服务"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-biz-member-api-commander-query-ICommanderPromoCodeApi",
        name = "${bundle.commander.center.member.api.name:yundt-cube-center-member}", path = "/v1/commander-promo-code", url = "${bundle.commander.center.member.api:}")
public interface ICommanderPromoCodeApi {

    /**
     * 新增分销员推广码信息表
     *
     * @param addReqDto 分销员推广码信息表请求对象
     * @return 处理结果
     */
    @PostMapping("")
    @ApiOperation(value = "新增分销员推广码信息表", notes = "新增分销员推广码信息表")
    RestResponse<Long> addCommanderPromoCode(@RequestBody CommanderPromoCodeReqDto addReqDto);

    /**
     * 修改分销员推广码信息表
     *
     * @param modifyReqDto 分销员推广码信息表请求对象
     * @return 处理结果
     */
    @PutMapping("")
    @ApiOperation(value = "修改分销员推广码信息表", notes = "修改分销员推广码信息表")
    RestResponse<Void> modifyCommanderPromoCode(@RequestBody CommanderPromoCodeReqDto modifyReqDto);

    /**
     * 删除分销员推广码信息表
     *
     * @param id        分销员推广码信息表删除数据ID
     * @return 处理结果
     */
    @DeleteMapping("/{id}")
    @ApiOperation(value = "删除分销员推广码信息表", notes = "删除分销员推广码信息表")
    RestResponse<Void> removeCommanderPromoCode(@PathVariable("id") Long id);

    /**
     * 修改分销员推广码信息表的状态 1启用，0禁用
     *
     * @param
     * @return 处理结果
     */
    @PutMapping("/{id}/modifyStatus/{status}")
    @ApiOperation(value = "修改分销员推广码信息表的状态 1启用，0禁用", notes = "修改分销员推广码信息表的状态 1启用，0禁用")
    RestResponse<Void> modifyCommanderPromoCodeStatus(@PathVariable("id") Long id,
                                                      @PathVariable("status") Integer status);
}
