package com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.request;

import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.base.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * 团长申请信息UpdateReqDto
 * @author 周颠
 * @since 1.0.0
 */
@ApiModel(value = "CommanderApplyInfoUpdateReqDto", description = "团长申请信息UpdateReqDto")
public class CommanderApplyInfoUpdateReqDto extends BaseReqDto {
    /**
     * extension、tenant_id、instance_id、create_person、create_time、update_person、update_time
     * 以上字段存于父类中
     */

    @ApiModelProperty(name = "id", value = "id")
    private Long id;

    @ApiModelProperty(name = "memberId", value = "会员ID")
    private Long memberId;

    @ApiModelProperty(name = "commanderNo", value = "团长编号")
    private String commanderNo;

    @NotNull
    @ApiModelProperty(name = "orgId", value = "组织ID", required = true)
    private Long orgId;

    @ApiModelProperty(name = "distribType", value = "分销类型：1佣金分销，2加价分销")
    private Integer distribType;

    @ApiModelProperty(name = "cmdLabel", value = "分销员标签")
    private String cmdLabel;

    @NotNull
    @ApiModelProperty(name = "idCardNo", value = "身份证号", required = true)
    private String idCardNo;

    @NotNull
    @ApiModelProperty(name = "commanderShopName", value = "团长店铺", required = true)
    private String commanderShopName;

    @ApiModelProperty(name = "recommendCommanderNo", value = "推荐团长编号")
    private String recommendCommanderNo;

    @ApiModelProperty(name = "commanderLevelId", value = "团长等级ID")
    private Long commanderLevelId;

    @ApiModelProperty(name = "commanderLevelName", value = "团长等级名称")
    private String commanderLevelName;

    @NotNull
    @ApiModelProperty(name = "commanderType", value = "团长类型：1普通团长，2专业团长", required = true)
    private Integer commanderType;

    @ApiModelProperty(name = "receivingPhone", value = "团长收货备用手机")
    private String receivingPhone;

    @ApiModelProperty(name = "receivingProvinceCode", value = "收货人：省编码")
    private String receivingProvinceCode;

    @ApiModelProperty(name = "receivingCityCode", value = "收货人：市编码")
    private String receivingCityCode;

    @ApiModelProperty(name = "receivingDistrictCode", value = "收货人：区编码")
    private String receivingDistrictCode;

    @ApiModelProperty(name = "receivingProvinceName", value = "收货人：省名称")
    private String receivingProvinceName;

    @ApiModelProperty(name = "receivingCityName", value = "收货人：市名称")
    private String receivingCityName;

    @ApiModelProperty(name = "receivingDistrictName", value = "收货人：区名称")
    private String receivingDistrictName;

    @ApiModelProperty(name = "receivingAddress", value = "收货人：详细地址")
    private String receivingAddress;

    @ApiModelProperty(name = "deliveryType", value = "配送方式：1跟随平台设定，2团长店铺自提，3团长送货上门")
    private Integer deliveryType;

    @ApiModelProperty(name = "bankName", value = "开户银行")
    private String bankName;

    @ApiModelProperty(name = "bankAccountName", value = "银行账号名称")
    private String bankAccountName;

    @ApiModelProperty(name = "bankAccountNo", value = "银行账户账号")
    private String bankAccountNo;

    @ApiModelProperty(name = "bankRemittanceAccountNo", value = "银行汇付账号")
    private String bankRemittanceAccountNo;

    @ApiModelProperty(name = "auditOpinion", value = "审核意见")
    private String auditOpinion;

    @ApiModelProperty(name = "isAgreement", value = "是否同意申请协议：1同意，0不同意")
    private Integer isAgreement;


    public Long getId(){
        return id;
    }

    public void setId(Long id){
        this.id = id;
    }

    public Long getMemberId(){
        return memberId;
    }

    public void setMemberId(Long memberId){
        this.memberId = memberId;
    }

    public String getCommanderNo(){
        return commanderNo;
    }

    public void setCommanderNo(String commanderNo){
        this.commanderNo = commanderNo;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public Integer getDistribType() {
        return distribType;
    }

    public void setDistribType(Integer distribType) {
        this.distribType = distribType;
    }

    public String getCmdLabel() {
        return cmdLabel;
    }

    public void setCmdLabel(String cmdLabel) {
        this.cmdLabel = cmdLabel;
    }

    public String getIdCardNo(){
        return idCardNo;
    }

    public void setIdCardNo(String idCardNo){
        this.idCardNo = idCardNo;
    }

    public String getCommanderShopName(){
        return commanderShopName;
    }

    public void setCommanderShopName(String commanderShopName){
        this.commanderShopName = commanderShopName;
    }

    public String getRecommendCommanderNo(){
        return recommendCommanderNo;
    }

    public void setRecommendCommanderNo(String recommendCommanderNo){
        this.recommendCommanderNo = recommendCommanderNo;
    }

    public Long getCommanderLevelId(){
        return commanderLevelId;
    }

    public void setCommanderLevelId(Long commanderLevelId){
        this.commanderLevelId = commanderLevelId;
    }

    public String getCommanderLevelName(){
        return commanderLevelName;
    }

    public void setCommanderLevelName(String commanderLevelName){
        this.commanderLevelName = commanderLevelName;
    }

    public Integer getCommanderType(){
        return commanderType;
    }

    public void setCommanderType(Integer commanderType){
        this.commanderType = commanderType;
    }

    public String getReceivingPhone(){
        return receivingPhone;
    }

    public void setReceivingPhone(String receivingPhone){
        this.receivingPhone = receivingPhone;
    }

    public String getReceivingProvinceCode(){
        return receivingProvinceCode;
    }

    public void setReceivingProvinceCode(String receivingProvinceCode){
        this.receivingProvinceCode = receivingProvinceCode;
    }

    public String getReceivingCityCode(){
        return receivingCityCode;
    }

    public void setReceivingCityCode(String receivingCityCode){
        this.receivingCityCode = receivingCityCode;
    }

    public String getReceivingDistrictCode(){
        return receivingDistrictCode;
    }

    public void setReceivingDistrictCode(String receivingDistrictCode){
        this.receivingDistrictCode = receivingDistrictCode;
    }

    public String getReceivingProvinceName(){
        return receivingProvinceName;
    }

    public void setReceivingProvinceName(String receivingProvinceName){
        this.receivingProvinceName = receivingProvinceName;
    }

    public String getReceivingCityName(){
        return receivingCityName;
    }

    public void setReceivingCityName(String receivingCityName){
        this.receivingCityName = receivingCityName;
    }

    public String getReceivingDistrictName(){
        return receivingDistrictName;
    }

    public void setReceivingDistrictName(String receivingDistrictName){
        this.receivingDistrictName = receivingDistrictName;
    }

    public String getReceivingAddress(){
        return receivingAddress;
    }

    public void setReceivingAddress(String receivingAddress){
        this.receivingAddress = receivingAddress;
    }

    public Integer getDeliveryType(){
        return deliveryType;
    }

    public void setDeliveryType(Integer deliveryType){
        this.deliveryType = deliveryType;
    }

    public String getBankName(){
        return bankName;
    }

    public void setBankName(String bankName){
        this.bankName = bankName;
    }

    public String getBankAccountName(){
        return bankAccountName;
    }

    public void setBankAccountName(String bankAccountName){
        this.bankAccountName = bankAccountName;
    }

    public String getBankAccountNo(){
        return bankAccountNo;
    }

    public void setBankAccountNo(String bankAccountNo){
        this.bankAccountNo = bankAccountNo;
    }

    public String getBankRemittanceAccountNo(){
        return bankRemittanceAccountNo;
    }

    public void setBankRemittanceAccountNo(String bankRemittanceAccountNo){
        this.bankRemittanceAccountNo = bankRemittanceAccountNo;
    }
    public String getAuditOpinion() {
        return auditOpinion;
    }

    public void setAuditOpinion(String auditOpinion) {
        this.auditOpinion = auditOpinion;
    }

    public Integer getIsAgreement() {
        return isAgreement;
    }

    public void setIsAgreement(Integer isAgreement) {
        this.isAgreement = isAgreement;
    }
}