package com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.request;

import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.base.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 团长分佣参数配置UpdateReqDto
 * @author 周颠
 * @since 1.0.0
 */
@ApiModel(value = "CommanderComsCfgUpdateReqDto", description = "团长分佣参数配置UpdateReqDto")
public class CommanderComsCfgUpdateReqDto extends BaseReqDto {
    /**
     * extension、tenant_id、instance_id、create_person、create_time、update_person、update_time
     * 以上字段存于父类中
     */

    @ApiModelProperty(name = "id", value = "id")
    private Long id;

	@ApiModelProperty(name = "comsMode", value = "分销模式：1一级分销，2二级分销")
	private Integer comsMode;

	@ApiModelProperty(name = "comsCalType", value = "分佣计算方式：1按比例计算，2按固定值计算")
	private Integer comsCalType;

	@ApiModelProperty(name = "directComs", value = "直接上级佣金（固定值时，单位：分钱）")
	private Double directComs;

	@ApiModelProperty(name = "indirectComs", value = "间接上级佣金（固定值时，单位：分钱）")
	private Double indirectComs;

	@ApiModelProperty(name = "directPoints", value = "直接上级积分")
	private Double directPoints;

	@ApiModelProperty(name = "indirectPoints", value = "间接上级积分")
	private Double indirectPoints;

	@ApiModelProperty(name = "bindingScene", value = "客户关系-绑定场景：1下单付款，2注册会员（废弃字段，即将删除）")
	private Integer bindingScene;

	@ApiModelProperty(name = "isBindOrder", value = "下单付款是否绑定客户关系：1是，0否")
	private Integer isBindOrder;

	@ApiModelProperty(name = "isBindRegister", value = "注册会员是否绑定客户关系：1是，0否")
	private Integer isBindRegister;

	@ApiModelProperty(name = "unbindType", value = "客户关系-自动解绑：1永久绑定，2有效期绑定")
	private Integer unbindType;

	@ApiModelProperty(name = "bindingDays", value = "有效期绑定的天数")
	private Integer bindingDays;

	@ApiModelProperty(name = "settlementType", value = "结算方式：1逐笔结算，2按月结算")
	private Integer settlementType;

	@ApiModelProperty(name = "singleDays", value = "逐笔结算设置的天数")
	private Integer singleDays;

	@ApiModelProperty(name = "monthDays", value = "按月结算设置的天数")
	private Integer monthDays;

	@ApiModelProperty(name = "isOpenDec", value = "是否开启结算说明：1开启，0关闭")
	private Integer isOpenDec;

	@ApiModelProperty(name = "settlementDec", value = "结算说明")
	private String settlementDec;

	@ApiModelProperty(name = "isPriceDistribution", value = "是否开启加价分销：1开启，0关闭")
	private Integer isPriceDistribution;

	@ApiModelProperty(name = "priceDistributionType", value = "加价限制方式：1按比例限制，2按固定值限制")
	private Integer priceDistributionType;

	@ApiModelProperty(name = "limitPriceBottom", value = "限制加价下限（固定值时，单位：分钱）")
	private Double limitPriceBottom;

	@ApiModelProperty(name = "limitPriceTop", value = "限制加价上限（固定值时，单位：分钱）")
	private Double limitPriceTop;

	@ApiModelProperty(name = "isCommissionDistribution", value = "是否开启佣金分销：1开启，0关闭")
	private Integer isCommissionDistribution;

	@ApiModelProperty(name = "isShopMode", value = "是否是独立店铺:1是，0否")
	private Integer isShopMode;

	public Integer getIsBindOrder() {
		return isBindOrder;
	}

	public void setIsBindOrder(Integer isBindOrder) {
		this.isBindOrder = isBindOrder;
	}

	public Integer getIsBindRegister() {
		return isBindRegister;
	}

	public void setIsBindRegister(Integer isBindRegister) {
		this.isBindRegister = isBindRegister;
	}

	public Integer getComsMode(){
		return comsMode;
	}

	public void setComsMode(Integer comsMode){
		this.comsMode = comsMode;
	}

	public Integer getComsCalType(){
		return comsCalType;
	}

	public void setComsCalType(Integer comsCalType){
		this.comsCalType = comsCalType;
	}

	public Double getDirectComs(){
		return directComs;
	}

	public void setDirectComs(Double directComs){
		this.directComs = directComs;
	}

	public Double getIndirectComs(){
		return indirectComs;
	}

	public void setIndirectComs(Double indirectComs){
		this.indirectComs = indirectComs;
	}

	public Double getDirectPoints(){
		return directPoints;
	}

	public void setDirectPoints(Double directPoints){
		this.directPoints = directPoints;
	}

	public Double getIndirectPoints(){
		return indirectPoints;
	}

	public void setIndirectPoints(Double indirectPoints){
		this.indirectPoints = indirectPoints;
	}

	public Integer getBindingScene(){
		return bindingScene;
	}

	public void setBindingScene(Integer bindingScene){
		this.bindingScene = bindingScene;
	}

	public Integer getUnbindType(){
		return unbindType;
	}

	public void setUnbindType(Integer unbindType){
		this.unbindType = unbindType;
	}

	public Integer getBindingDays(){
		return bindingDays;
	}

	public void setBindingDays(Integer bindingDays){
		this.bindingDays = bindingDays;
	}

	public Integer getSettlementType(){
		return settlementType;
	}

	public void setSettlementType(Integer settlementType){
		this.settlementType = settlementType;
	}

	public Integer getSingleDays(){
		return singleDays;
	}

	public void setSingleDays(Integer singleDays){
		this.singleDays = singleDays;
	}

	public Integer getMonthDays(){
		return monthDays;
	}

	public void setMonthDays(Integer monthDays){
		this.monthDays = monthDays;
	}

	public String getSettlementDec(){
		return settlementDec;
	}

	public void setSettlementDec(String settlementDec){
		this.settlementDec = settlementDec;
	}


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

	public Integer getIsOpenDec() {
		return isOpenDec;
	}

	public void setIsOpenDec(Integer isOpenDec) {
		this.isOpenDec = isOpenDec;
	}

	public Integer getIsCommissionDistribution() {
		return isCommissionDistribution;
	}

	public void setIsCommissionDistribution(Integer isCommissionDistribution) {
		this.isCommissionDistribution = isCommissionDistribution;
	}

	public Integer getIsShopMode() {
		return isShopMode;
	}

	public void setIsShopMode(Integer isShopMode) {
		this.isShopMode = isShopMode;
	}

	public Integer getIsPriceDistribution() {
		return isPriceDistribution;
	}

	public void setIsPriceDistribution(Integer isPriceDistribution) {
		this.isPriceDistribution = isPriceDistribution;
	}

	public Integer getPriceDistributionType() {
		return priceDistributionType;
	}

	public void setPriceDistributionType(Integer priceDistributionType) {
		this.priceDistributionType = priceDistributionType;
	}

	public Double getLimitPriceBottom() {
		return limitPriceBottom;
	}

	public void setLimitPriceBottom(Double limitPriceBottom) {
		this.limitPriceBottom = limitPriceBottom;
	}

	public Double getLimitPriceTop() {
		return limitPriceTop;
	}

	public void setLimitPriceTop(Double limitPriceTop) {
		this.limitPriceTop = limitPriceTop;
	}
}
