package com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.request;

import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.base.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * 团长周期数据统计记录UpdateReqDto
 * @author 周颠
 * @since 1.0.0
 */
@ApiModel(value = "CommanderCycleRecordUpdateReqDto", description = "团长周期数据统计记录UpdateReqDto")
public class CommanderCycleRecordUpdateReqDto extends BaseReqDto {
    /**
     * extension、tenant_id、instance_id、create_person、create_time、update_person、update_time
     * 以上字段存于父类中
     */

    @ApiModelProperty(name = "id", value = "id")
    private Long id;

    @ApiModelProperty(name = "commanderId", value = "团长id")
    private Long commanderId;

    @ApiModelProperty(name = "memberId", value = "会员id")
    private Long memberId;

    @ApiModelProperty(name = "commanderNo", value = "团长编号")
    private String commanderNo;

    @ApiModelProperty(name = "cycleType", value = "周期类型：1周，2月，3季度，4年，5日")
    private Integer cycleType;

    @ApiModelProperty(name = "statisticalTime", value = "统计时间")
    private Date statisticalTime;

    @ApiModelProperty(name = "levelId", value = "最新等级id（月份周期才有）")
    private Long levelId;

    @ApiModelProperty(name = "historyLevelId", value = "历史最高等级id（月份周期才有）")
    private Long historyLevelId;

    @ApiModelProperty(name = "settlementLevelId", value = "本周期结算等级id")
    private Long settlementLevelId;

    @ApiModelProperty(name = "commanderPoints", value = "个人积分")
    private Integer commanderPoints;

    @ApiModelProperty(name = "teamPoints", value = "团队积分")
    private Integer teamPoints;

    @ApiModelProperty(name = "teamCycleCount", value = "团队人数")
    private Integer teamCycleCount;

    @ApiModelProperty(name = "customerCount", value = "客户人数")
    private Integer customerCount;

    @ApiModelProperty(name = "comsMoney", value = "预估佣金")
    private Integer comsMoney;

    @ApiModelProperty(name = "orderCount", value = "订单数")
    private Integer orderCount;

    @ApiModelProperty(name = "commanderHistoryPoints", value = "个人累积分")
    private Integer commanderHistoryPoints;

    @ApiModelProperty(name = "teamHistoryPoints", value = "团队累积分")
    private Integer teamHistoryPoints;

    @ApiModelProperty(name = "teamCount", value = "累计团队人数")
    private Integer teamCount;


    public Long getCommanderId(){
        return commanderId;
    }

    public void setCommanderId(Long commanderId){
        this.commanderId = commanderId;
    }

    public String getCommanderNo(){
        return commanderNo;
    }

    public void setCommanderNo(String commanderNo){
        this.commanderNo = commanderNo;
    }

    public Integer getCycleType(){
        return cycleType;
    }

    public void setCycleType(Integer cycleType){
        this.cycleType = cycleType;
    }

    public Date getStatisticalTime(){
        return statisticalTime;
    }

    public void setStatisticalTime(Date statisticalTime){
        this.statisticalTime = statisticalTime;
    }

    public Long getLevelId(){
        return levelId;
    }

    public void setLevelId(Long levelId){
        this.levelId = levelId;
    }

    public Long getHistoryLevelId(){
        return historyLevelId;
    }

    public void setHistoryLevelId(Long historyLevelId){
        this.historyLevelId = historyLevelId;
    }

    public Long getSettlementLevelId(){
        return settlementLevelId;
    }

    public void setSettlementLevelId(Long settlementLevelId){
        this.settlementLevelId = settlementLevelId;
    }

    public Integer getCommanderPoints(){
        return commanderPoints;
    }

    public void setCommanderPoints(Integer commanderPoints){
        this.commanderPoints = commanderPoints;
    }

    public Integer getTeamPoints(){
        return teamPoints;
    }

    public void setTeamPoints(Integer teamPoints){
        this.teamPoints = teamPoints;
    }

    public Integer getTeamCycleCount(){
        return teamCycleCount;
    }

    public void setTeamCycleCount(Integer teamCycleCount){
        this.teamCycleCount = teamCycleCount;
    }

    public Integer getCustomerCount(){
        return customerCount;
    }

    public void setCustomerCount(Integer customerCount){
        this.customerCount = customerCount;
    }

    public Integer getComsMoney(){
        return comsMoney;
    }

    public void setComsMoney(Integer comsMoney){
        this.comsMoney = comsMoney;
    }

    public Integer getOrderCount(){
        return orderCount;
    }

    public void setOrderCount(Integer orderCount){
        this.orderCount = orderCount;
    }

    public Integer getCommanderHistoryPoints(){
        return commanderHistoryPoints;
    }

    public void setCommanderHistoryPoints(Integer commanderHistoryPoints){
        this.commanderHistoryPoints = commanderHistoryPoints;
    }

    public Integer getTeamHistoryPoints(){
        return teamHistoryPoints;
    }

    public void setTeamHistoryPoints(Integer teamHistoryPoints){
        this.teamHistoryPoints = teamHistoryPoints;
    }

    public Integer getTeamCount(){
        return teamCount;
    }

    public void setTeamCount(Integer teamCount){
        this.teamCount = teamCount;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getMemberId() {
        return memberId;
    }

    public void setMemberId(Long memberId) {
        this.memberId = memberId;
    }
}