package com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.request;

import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.base.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * 团长订单记录UpdateReqDto
 * @author 周颠
 * @since 1.0.0
 */
@ApiModel(value = "CommanderOrderRecordUpdateReqDto", description = "团长订单记录UpdateReqDto")
public class CommanderOrderRecordUpdateReqDto extends BaseReqDto {
    /**
     * extension、tenant_id、instance_id、create_person、create_time、update_person、update_time
     * 以上字段存于父类中
     */

    @ApiModelProperty(name = "id", value = "id")
    private Long id;

    @ApiModelProperty(name = "commanderId", value = "归属团长ID")
    private Long commanderId;

    @ApiModelProperty(name = "status", value = "订单状态：1已支付，2已退款")
    private Integer status;

    @ApiModelProperty(name = "orderNo", value = "订单编号")
    private String orderNo;

    @ApiModelProperty(name = "refundNo", value = "退款单号")
    private String refundNo;

    @ApiModelProperty(name = "orderTime", value = "订单时间")
    private Date orderTime;

    @ApiModelProperty(name = "refundTime", value = "退款时间")
    private Date refundTime;

    @ApiModelProperty(name = "orderPrice", value = "订单金额（单位：分钱）")
    private Integer orderPrice;

    @ApiModelProperty(name = "userId", value = "用户id")
    private Long userId;

    @ApiModelProperty(name = "recommendUserId", value = "推广用户id")
    private Long recommendUserId;

    @ApiModelProperty(name = "shopNo", value = "店铺编号")
    private String shopNo;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getCommanderId() {
        return commanderId;
    }

    public void setCommanderId(Long commanderId) {
        this.commanderId = commanderId;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getRefundNo() {
        return refundNo;
    }

    public void setRefundNo(String refundNo) {
        this.refundNo = refundNo;
    }

    public Date getOrderTime() {
        return orderTime;
    }

    public void setOrderTime(Date orderTime) {
        this.orderTime = orderTime;
    }

    public Date getRefundTime() {
        return refundTime;
    }

    public void setRefundTime(Date refundTime) {
        this.refundTime = refundTime;
    }

    public Integer getOrderPrice() {
        return orderPrice;
    }

    public void setOrderPrice(Integer orderPrice) {
        this.orderPrice = orderPrice;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getRecommendUserId() {
        return recommendUserId;
    }

    public void setRecommendUserId(Long recommendUserId) {
        this.recommendUserId = recommendUserId;
    }

    public String getShopNo() {
        return shopNo;
    }

    public void setShopNo(String shopNo) {
        this.shopNo = shopNo;
    }
}