package com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.request;

import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.base.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * 分销员（直接间接）客户订单记录Eo对象
 *
 * @author erduo
 * @since 2021-05-13
 */
@ApiModel(value = "CommanderOrderRelationReqDto", description = "分销员（直接间接）客户订单记录Eo对象")
public class CommanderOrderRelationReqDto extends BaseReqDto {
    /**
     * id
     */
    @ApiModelProperty(name = "id", value = "id")
    private Long id;
    /**
     * 分销员订单id
     */
    @ApiModelProperty(name = "commanderOrderId", value = "分销员订单id")
    private Long commanderOrderId;
    /**
     * 分销员id
     */
    @ApiModelProperty(name = "commanderId", value = "分销员id")
    private Long commanderId;
    /**
     * 分销员编号
     */
    @ApiModelProperty(name = "commanderNo", value = "分销员编号")
    private String commanderNo;
    /**
     * 所属组织id
     */
    @ApiModelProperty(name = "orgId", value = "所属组织id")
    private Long orgId;
    /**
     * 团长手机号码
     */
    @ApiModelProperty(name = "commanderPhone", value = "团长手机号码")
    private String commanderPhone;
    /**
     * 分销员会员id
     */
    @ApiModelProperty(name = "commanderMemberId", value = "分销员会员id")
    private Long commanderMemberId;
    /**
     * 分销员店铺id
     */
    @ApiModelProperty(name = "commanderShopId", value = "分销员店铺id")
    private Long commanderShopId;
    /**
     * 下单会员id
     */
    @ApiModelProperty(name = "memberId", value = "下单会员id")
    private Long memberId;
    /**
     * 下单会员编号
     */
    @ApiModelProperty(name = "memberNo", value = "下单会员编号")
    private String memberNo;
    /**
     * 下单会员名称
     */
    @ApiModelProperty(name = "memberName", value = "下单会员名称")
    private String memberName;
    /**
     * 下单用户手机
     */
    @ApiModelProperty(name = "memberPhone", value = "下单用户手机")
    private String memberPhone;
    /**
     * 下单用户头像
     */
    @ApiModelProperty(name = "memberAvatar", value = "下单用户头像")
    private String memberAvatar;
    /**
     * 订单状态：1已支付，2已退款，3已完成
     */
    @ApiModelProperty(name = "orderStatus", value = "订单状态：1已支付，2已退款，3已完成")
    private Integer orderStatus;
    /**
     * 下单时间
     */
    @ApiModelProperty(name = "orderTime", value = "下单时间")
    private Date orderTime;
    /**
     * 订单id
     */
    @ApiModelProperty(name = "orderId", value = "订单id")
    private Long orderId;
    /**
     * 订单编号
     */
    @ApiModelProperty(name = "orderNo", value = "订单编号")
    private String orderNo;
    /**
     * 订单交易金额（单位：分钱）
     */
    @ApiModelProperty(name = "orderPrice", value = "订单交易金额（单位：分钱）")
    private Integer orderPrice;
    /**
     * 订单来源：1直接上级，2间接上级，3自购返佣
     */
    @ApiModelProperty(name = "orderSource", value = "订单来源：1直接上级，2间接上级，3自购返佣")
    private Integer orderSource;
    /**
     * 交易流水号
     */
    @ApiModelProperty(name = "tradeCode", value = "交易流水号")
    private String tradeCode;
    /**
     * 下单店铺
     */
    @ApiModelProperty(name = "orderShop", value = "下单店铺")
    private String orderShop;
    /**
     * 收货人所在省
     */
    @ApiModelProperty(name = "receiverProvince", value = "收货人所在省")
    private String receiverProvince;
    /**
     * 收货人所在市
     */
    @ApiModelProperty(name = "receiverCity", value = "收货人所在市")
    private String receiverCity;
    /**
     * 收货人所在区
     */
    @ApiModelProperty(name = "receiverDistrict", value = "收货人所在区")
    private String receiverDistrict;
    /**
     * 运费金额（单位：分钱）
     */
    @ApiModelProperty(name = "freight", value = "运费金额（单位：分钱）")
    private Integer freight;
    /**
     * 实付金额（单位：分钱）
     */
    @ApiModelProperty(name = "payAmount", value = "实付金额（单位：分钱）")
    private Integer payAmount;
    /**
     * 优惠金额（单位：分钱）
     */
    @ApiModelProperty(name = "discountAmount", value = "优惠金额（单位：分钱）")
    private Integer discountAmount;
    /**
     * 支付时间
     */
    @ApiModelProperty(name = "payTime", value = "支付时间")
    private Date payTime;
    /**
     * 交易订单创建时间
     */
    @ApiModelProperty(name = "tradeOrderTime", value = "交易订单创建时间")
    private Date tradeOrderTime;
    /**
     * 收货人姓名
     */
    @ApiModelProperty(name = "receiverName", value = "收货人姓名")
    private String receiverName;
    /**
     * 收货人手机
     */
    @ApiModelProperty(name = "receiverPhone", value = "收货人手机")
    private String receiverPhone;
    /**
     * 支付单号
     */
    @ApiModelProperty(name = "payNo", value = "支付单号")
    private String payNo;

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public void setCommanderOrderId(Long commanderOrderId) {
        this.commanderOrderId = commanderOrderId;
    }

    public Long getCommanderOrderId() {
        return this.commanderOrderId;
    }

    public void setCommanderId(Long commanderId) {
        this.commanderId = commanderId;
    }

    public Long getCommanderId() {
        return this.commanderId;
    }

    public void setCommanderNo(String commanderNo) {
        this.commanderNo = commanderNo;
    }

    public String getCommanderNo() {
        return this.commanderNo;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public Long getOrgId() {
        return this.orgId;
    }

    public void setCommanderPhone(String commanderPhone) {
        this.commanderPhone = commanderPhone;
    }

    public String getCommanderPhone() {
        return this.commanderPhone;
    }

    public void setCommanderMemberId(Long commanderMemberId) {
        this.commanderMemberId = commanderMemberId;
    }

    public Long getCommanderMemberId() {
        return this.commanderMemberId;
    }

    public void setCommanderShopId(Long commanderShopId) {
        this.commanderShopId = commanderShopId;
    }

    public Long getCommanderShopId() {
        return this.commanderShopId;
    }

    public void setMemberId(Long memberId) {
        this.memberId = memberId;
    }

    public Long getMemberId() {
        return this.memberId;
    }

    public void setMemberNo(String memberNo) {
        this.memberNo = memberNo;
    }

    public String getMemberNo() {
        return this.memberNo;
    }

    public void setMemberName(String memberName) {
        this.memberName = memberName;
    }

    public String getMemberName() {
        return this.memberName;
    }

    public void setMemberPhone(String memberPhone) {
        this.memberPhone = memberPhone;
    }

    public String getMemberPhone() {
        return this.memberPhone;
    }

    public void setMemberAvatar(String memberAvatar) {
        this.memberAvatar = memberAvatar;
    }

    public String getMemberAvatar() {
        return this.memberAvatar;
    }

    public void setOrderStatus(Integer orderStatus) {
        this.orderStatus = orderStatus;
    }

    public Integer getOrderStatus() {
        return this.orderStatus;
    }

    public void setOrderTime(Date orderTime) {
        this.orderTime = orderTime;
    }

    public Date getOrderTime() {
        return this.orderTime;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }

    public Long getOrderId() {
        return this.orderId;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getOrderNo() {
        return this.orderNo;
    }

    public void setOrderPrice(Integer orderPrice) {
        this.orderPrice = orderPrice;
    }

    public Integer getOrderPrice() {
        return this.orderPrice;
    }

    public void setOrderSource(Integer orderSource) {
        this.orderSource = orderSource;
    }

    public Integer getOrderSource() {
        return this.orderSource;
    }

    public void setTradeCode(String tradeCode) {
        this.tradeCode = tradeCode;
    }

    public String getTradeCode() {
        return this.tradeCode;
    }

    public void setOrderShop(String orderShop) {
        this.orderShop = orderShop;
    }

    public String getOrderShop() {
        return this.orderShop;
    }

    public void setReceiverProvince(String receiverProvince) {
        this.receiverProvince = receiverProvince;
    }

    public String getReceiverProvince() {
        return this.receiverProvince;
    }

    public void setReceiverCity(String receiverCity) {
        this.receiverCity = receiverCity;
    }

    public String getReceiverCity() {
        return this.receiverCity;
    }

    public void setReceiverDistrict(String receiverDistrict) {
        this.receiverDistrict = receiverDistrict;
    }

    public String getReceiverDistrict() {
        return this.receiverDistrict;
    }

    public void setFreight(Integer freight) {
        this.freight = freight;
    }

    public Integer getFreight() {
        return this.freight;
    }

    public void setPayAmount(Integer payAmount) {
        this.payAmount = payAmount;
    }

    public Integer getPayAmount() {
        return this.payAmount;
    }

    public void setDiscountAmount(Integer discountAmount) {
        this.discountAmount = discountAmount;
    }

    public Integer getDiscountAmount() {
        return this.discountAmount;
    }

    public void setPayTime(Date payTime) {
        this.payTime = payTime;
    }

    public Date getPayTime() {
        return this.payTime;
    }

    public void setTradeOrderTime(Date tradeOrderTime) {
        this.tradeOrderTime = tradeOrderTime;
    }

    public Date getTradeOrderTime() {
        return this.tradeOrderTime;
    }

    public String getReceiverName() {
        return receiverName;
    }

    public void setReceiverName(String receiverName) {
        this.receiverName = receiverName;
    }

    public String getReceiverPhone() {
        return receiverPhone;
    }

    public void setReceiverPhone(String receiverPhone) {
        this.receiverPhone = receiverPhone;
    }

    public String getPayNo() {
        return payNo;
    }

    public void setPayNo(String payNo) {
        this.payNo = payNo;
    }
}
