package com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.response;

import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.base.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Map;

/**
 * 小程序的团长招募权限RespDto
 * @author 周颠
 * @since 1.0.0
 */
@ApiModel(value = "AppletRecruitAuthRespDto", description = "小程序的团长招募权限RespDto")
public class AppletRecruitAuthRespDto extends BaseRespDto {
    /**
     * id、extension、tenant_id、instance_id、create_person、create_time、update_person、update_time、dr
     * 以上字段存于父类中
     */

    @ApiModelProperty(name = "recruitEntranceStatus", value = "团长招募入口的状态：0关闭，1开启")
    private Integer recruitEntranceStatus;

    @ApiModelProperty(name = "applyButtonStatus", value = "团长申请按钮的状态：0未达到申请条件，1可以申请，2等待审核，3分享按钮")
    private Integer applyButtonStatus;

    @ApiModelProperty(name = "applyAgreementStatus", value = "申请协议选择是否开启：1开启，0关闭")
    private Integer applyAgreementStatus;

    @ApiModelProperty(name = "applyAgreementUrl", value = "协议地址URL")
    private String applyAgreementUrl;

    @ApiModelProperty(name = "recruitInfoStatus", value = "招募信息填写是否开启：1开启，0关闭")
    private Integer recruitInfoStatus;

    @ApiModelProperty(name = "recruitInfoSetting", value = "招募信息填写具体设置（json数组）")
    private String recruitInfoSetting;

    @ApiModelProperty(name = "distributionTypes", value = "分销类型：{'1':'佣金分销','2':加价分销'}")
    private Map<String, String> distributionTypes;

    public Integer getRecruitEntranceStatus() {
        return recruitEntranceStatus;
    }

    public void setRecruitEntranceStatus(Integer recruitEntranceStatus) {
        this.recruitEntranceStatus = recruitEntranceStatus;
    }

    public Integer getApplyButtonStatus() {
        return applyButtonStatus;
    }

    public void setApplyButtonStatus(Integer applyButtonStatus) {
        this.applyButtonStatus = applyButtonStatus;
    }

    public Integer getApplyAgreementStatus() {
        return applyAgreementStatus;
    }

    public void setApplyAgreementStatus(Integer applyAgreementStatus) {
        this.applyAgreementStatus = applyAgreementStatus;
    }

    public String getApplyAgreementUrl() {
        return applyAgreementUrl;
    }

    public void setApplyAgreementUrl(String applyAgreementUrl) {
        this.applyAgreementUrl = applyAgreementUrl;
    }

    public Integer getRecruitInfoStatus() {
        return recruitInfoStatus;
    }

    public void setRecruitInfoStatus(Integer recruitInfoStatus) {
        this.recruitInfoStatus = recruitInfoStatus;
    }

    public String getRecruitInfoSetting() {
        return recruitInfoSetting;
    }

    public void setRecruitInfoSetting(String recruitInfoSetting) {
        this.recruitInfoSetting = recruitInfoSetting;
    }

    public Map<String, String> getDistributionTypes() {
        return distributionTypes;
    }

    public void setDistributionTypes(Map<String, String> distributionTypes) {
        this.distributionTypes = distributionTypes;
    }
}