package com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.response;

import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.base.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * 团长客户关系RespDto
 * @author 周颠
 * @since 1.0.0
 */
@ApiModel(value = "CommanderCustomerRelationRespDto", description = "团长客户关系RespDto")
public class CommanderCustomerRelationRespDto extends BaseRespDto {
    /**
     * id、extension、tenant_id、instance_id、create_person、create_time、update_person、update_time、dr
     * 以上字段存于父类中
     */

    @ApiModelProperty(name = "commanderId", value = "团长ID")
    private Long commanderId;

    @ApiModelProperty(name = "memberId", value = "会员ID")
    private Long memberId;

    @ApiModelProperty(name = "memberNo", value = "会员编号")
    private String memberNo;

    @ApiModelProperty(name = "phone", value = "会员手机号码")
    private String phone;

    @ApiModelProperty(name = "totalMoney", value = "消费总金额(单位：分钱)")
    private Integer totalMoney;

    @ApiModelProperty(name = "lastMoney", value = "最后一次消费金额(单位：分钱)")
    private Integer lastMoney;

    @ApiModelProperty(name = "lastTime", value = "最后一次消费时间")
    private Date lastTime;

    /************************************************************************************************/

    @ApiModelProperty(name = "avatar", value = "头像")
    private String avatar;

    @ApiModelProperty(name = "realName", value = "姓名")
    private String realName;

    @ApiModelProperty(name = "status", value = "客户类型：0全部访客1已下单客户2未下单客户3全部客户")
    private Integer status;


    public Long getCommanderId(){
        return commanderId;
    }

    public void setCommanderId(Long commanderId){
        this.commanderId = commanderId;
    }

    public Long getMemberId(){
        return memberId;
    }

    public void setMemberId(Long memberId){
        this.memberId = memberId;
    }

    public String getMemberNo(){
        return memberNo;
    }

    public void setMemberNo(String memberNo){
        this.memberNo = memberNo;
    }

    public String getPhone(){
        return phone;
    }

    public void setPhone(String phone){
        this.phone = phone;
    }

    public Integer getTotalMoney(){
        return totalMoney;
    }

    public void setTotalMoney(Integer totalMoney){
        this.totalMoney = totalMoney;
    }

    public Integer getLastMoney(){
        return lastMoney;
    }

    public void setLastMoney(Integer lastMoney){
        this.lastMoney = lastMoney;
    }

    public Date getLastTime(){
        return lastTime;
    }

    public void setLastTime(Date lastTime){
        this.lastTime = lastTime;
    }

    public String getAvatar() {
        return avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public String getRealName() {
        return realName;
    }

    public void setRealName(String realName) {
        this.realName = realName;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }
}