package com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.request.CommanderAppletConfigQueryReqDto;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.response.AppletPromotionAuthRespDto;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.response.AppletRecruitAuthRespDto;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.response.CommanderAppletConfigRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 团长小程序参数配置QueryApi
 * @author 周颠
 * @since 1.0.0
 */
@Api(tags = {"会员中心：团长小程序参数配置"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-biz-member-api-commander-query-ICommanderAppletConfigQueryApi",
        name = "${bundle.commander.center.member.api.name:yundt-cube-center-member}", path = "/v1/commander-applet-config", url = "${bundle.commander.center.member.api:}")
public interface ICommanderAppletConfigQueryApi {

    /**
     * 根据id查询团长小程序参数配置
     * @param id
     * @return
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询团长小程序参数配置", notes = "根据id查询团长小程序参数配置")
    RestResponse<CommanderAppletConfigRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 根据批量id查询团长小程序参数配置
     * @param ids
     * @return
     */
    @PostMapping("/batch/query-by-id")
    @ApiOperation(value = "根据批量id查询团长小程序参数配置", notes = "根据批量id查询团长小程序参数配置")
    RestResponse<List<CommanderAppletConfigRespDto>> queryByIds(@RequestParam("ids") List<Long> ids);

    /**
     * 查询团长小程序参数配置
     * @param queryReqDto
     * @return
     */
    @GetMapping("/query")
    @ApiOperation(value = "查询团长小程序参数配置", notes = "查询团长小程序参数配置")
    RestResponse<List<CommanderAppletConfigRespDto>> queryCommanderAppletConfig(@SpringQueryMap CommanderAppletConfigQueryReqDto queryReqDto);

    /**
     * 分页查询团长小程序参数配置
     * @param queryReqDto
     * @param pageNum
     * @param pageSize
     * @return
     */
    @GetMapping(value = "/page")
    @ApiOperation(value = "分页查询团长小程序参数配置", notes = "分页查询团长小程序参数配置")
    @ApiImplicitParams({@ApiImplicitParam(name = "pageNum", value = "起始页", dataType = "integer", paramType = "query"),
            @ApiImplicitParam(name = "pageSize", value = "每一页的记录数", dataType = "integer", paramType = "query"),})
    RestResponse<PageInfo<CommanderAppletConfigRespDto>> queryCommanderAppletConfigByPage(@SpringQueryMap CommanderAppletConfigQueryReqDto queryReqDto, @RequestParam("pageNum") Integer pageNum, @RequestParam("pageSize") Integer pageSize);

    /**
     * 根据会员id查询小程序的团长推广权限
     * @param memberId
     * @return
     */
    @GetMapping("/query-applet-promotion-auth-by-memberId/{memberId}")
    @ApiOperation(value = "根据会员id查询小程序的团长推广权限", notes = "根据会员id查询小程序的团长推广权限")
    RestResponse<AppletPromotionAuthRespDto> queryAppletPromotionAuthByMemberId(@PathVariable("memberId")Long memberId);

    /**
     * 根据会员id查询小程序的团长招募权限
     * @param memberId
     * @return
     */
    @GetMapping("/query-applet-recruit-auth-by-memberId/{memberId}")
    @ApiOperation(value = "根据会员id查询小程序的团长招募权限", notes = "根据会员id查询小程序的团长招募权限")
    RestResponse<AppletRecruitAuthRespDto> queryAppletRecruitAuthByMemberId(@PathVariable("memberId")Long memberId);
}