package com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.query;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.request.CommanderApplyInfoQueryReqDto;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.response.CommanderApplyInfoRespDto;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.response.CommanderApplyInfoWithMemberInfoRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 团长申请信息QueryApi
 * @author 周颠
 * @since 1.0.0
 */
@Api(tags = {"会员中心：团长申请信息"})
@FeignClient(contextId="com-dtyunxi-yundt-imkt-cube-bundle-commander-center-member-api-query-ICommanderApplyInfoQueryApi",
        name = "${bundle.commander.center.member.api.name:yundt-cube-center-member}", path = "/v1/commander-apply-info", url = "${bundle.commander.center.member.api:}")
public interface ICommanderApplyInfoQueryApi {

    /**
     * 根据id查询团长申请信息
     * @param id
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-apply-info")
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询团长申请信息", notes = "根据id查询团长申请信息")
    RestResponse<CommanderApplyInfoRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 根据批量id查询团长申请信息
     * @param ids
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-apply-info")
    @PostMapping("/batch/query-by-id")
    @ApiOperation(value = "根据批量id查询团长申请信息", notes = "根据批量id查询团长申请信息")
    RestResponse<List<CommanderApplyInfoRespDto>> queryByIds(@RequestParam("ids") List<Long> ids);

    /**
     * 查询团长申请信息
     * @param queryReqDto
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-apply-info")
    @GetMapping("/query")
    @ApiOperation(value = "查询团长申请信息", notes = "查询团长申请信息")
    RestResponse<List<CommanderApplyInfoRespDto>> queryCommanderApplyInfo(@SpringQueryMap CommanderApplyInfoQueryReqDto queryReqDto);

    /**
     * 分页查询团长申请信息
     * @param queryReqDto
     * @param pageNum
     * @param pageSize
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-apply-info")
    @GetMapping(value = "/page")
    @ApiOperation(value = "分页查询团长申请信息", notes = "分页查询团长申请信息")
    @ApiImplicitParams({@ApiImplicitParam(name = "pageNum", value = "起始页", dataType = "integer", paramType = "query"),
            @ApiImplicitParam(name = "pageSize", value = "每一页的记录数", dataType = "integer", paramType = "query"),})
    RestResponse<PageInfo<CommanderApplyInfoRespDto>> queryCommanderApplyInfoByPage(@SpringQueryMap CommanderApplyInfoQueryReqDto queryReqDto, @RequestParam("pageNum") Integer pageNum, @RequestParam("pageSize") Integer pageSize);

    /**
     * 分页查询团长申请信息(附带会员信息)
     * @param queryReqDto
     * @param pageNum
     * @param pageSize
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-apply-info")
    @GetMapping(value = "/member-info/page")
    @ApiOperation(value = "分页查询团长申请信息(附带会员信息)", notes = "分页查询团长申请信息(附带会员信息)")
    @ApiImplicitParams({@ApiImplicitParam(name = "pageNum", value = "起始页", dataType = "integer", paramType = "query"),
            @ApiImplicitParam(name = "pageSize", value = "每一页的记录数", dataType = "integer", paramType = "query"),})
    RestResponse<PageInfo<CommanderApplyInfoWithMemberInfoRespDto>> queryCommanderApplyInfoWithMemberInfoByPage(@SpringQueryMap CommanderApplyInfoQueryReqDto queryReqDto, @RequestParam("pageNum") Integer pageNum, @RequestParam("pageSize") Integer pageSize);
}