package com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.query;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.request.CommanderInfoQueryReqDto;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.response.CommanderConfigInfoRespDto;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.response.CommanderInfoRespDto;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.response.CommanderInfoWithMemberInfoRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 团长信息QueryApi
 * @author 周颠
 * @since 1.0.0
 */
@Api(tags = {"会员中心：团长信息"})
@FeignClient(contextId="com-dtyunxi-yundt-imkt-cube-bundle-commander-center-member-api-query-ICommanderInfoQueryApi",
        name = "${bundle.commander.center.member.api.name:yundt-cube-center-member}", path = "/v1/commander-info", url = "${bundle.commander.center.member.api:}")
public interface ICommanderInfoQueryApi {
    /**
     * 根据id查询团长信息
     * @param id
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-info")
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询团长信息", notes = "根据id查询团长信息")
    RestResponse<CommanderInfoRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 根据批量id查询团长信息
     * @param ids
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-info")
    @PostMapping("/batch/query-by-id")
    @ApiOperation(value = "根据批量id查询团长信息", notes = "根据批量id查询团长信息")
    RestResponse<List<CommanderInfoRespDto>> queryByIds(@RequestParam("ids") List<Long> ids);

    /**
     * 查询团长信息
     * @param queryReqDto
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-info")
    @GetMapping("/query")
    @ApiOperation(value = "查询团长信息", notes = "查询团长信息")
    RestResponse<List<CommanderInfoRespDto>> queryCommanderInfo(@SpringQueryMap CommanderInfoQueryReqDto queryReqDto);

    /**
     * 分页查询团长信息(附带会员信息)
     * @param queryReqDto
     * @param pageNum
     * @param pageSize
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-info")
    @GetMapping(value = "/member-info/page")
    @ApiOperation(value = "分页查询团长信息(附带会员信息)", notes = "分页查询团长信息(附带会员信息)")
    @ApiImplicitParams({@ApiImplicitParam(name = "pageNum", value = "起始页", dataType = "integer", paramType = "query"),
            @ApiImplicitParam(name = "pageSize", value = "每一页的记录数", dataType = "integer", paramType = "query"),})
    RestResponse<PageInfo<CommanderInfoWithMemberInfoRespDto>> queryCommanderInfoWithMemberInfoByPage(@SpringQueryMap CommanderInfoQueryReqDto queryReqDto, @RequestParam("pageNum") Integer pageNum, @RequestParam("pageSize") Integer pageSize);

    /**
     * 分页查询团长信息
     * @param queryReqDto
     * @param pageNum
     * @param pageSize
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-info")
    @GetMapping(value = "/page")
    @ApiOperation(value = "分页查询团长信息", notes = "分页查询团长信息")
    @ApiImplicitParams({@ApiImplicitParam(name = "pageNum", value = "起始页", dataType = "integer", paramType = "query"),
            @ApiImplicitParam(name = "pageSize", value = "每一页的记录数", dataType = "integer", paramType = "query"),})
    RestResponse<PageInfo<CommanderInfoRespDto>> queryCommanderInfoByPage(@SpringQueryMap CommanderInfoQueryReqDto queryReqDto, @RequestParam("pageNum") Integer pageNum, @RequestParam("pageSize") Integer pageSize);

    /**
     * 根据会员id查询团长信息
     * @param memberId
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-info")
    @GetMapping("/query-by-memberId")
    @ApiOperation(value = "根据会员id查询团长信息", notes = "根据会员id查询团长信息")
    RestResponse<CommanderInfoRespDto> queryByMemberId(@RequestParam("memberId") Long memberId);

    @Capability(capabilityCode = "member.commander.commander-info")
    @GetMapping("/queryCommanderConfig")
    @ApiOperation(value = "根据用户id查询团长配置信息", notes = "根据用户id查询团长配置信息")
    RestResponse<CommanderConfigInfoRespDto> queryCommanderConfig(@RequestParam(value = "userId",required = false)  Long userId);

    /**
     * 根据shopId查询团长信息
     * @param shopId
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-info")
    @GetMapping("/queryByShopId/{shopId}")
    @ApiOperation(value = "根据shopId查询团长信息", notes = "根据shopId查询团长信息")
    RestResponse<CommanderInfoRespDto> queryByShopId(@PathVariable("shopId") Long shopId);

}