package com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.query;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.request.CommanderOrderRecordQueryReqDto;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.response.CommanderOrderRecordRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 团长订单记录QueryApi
 * @author 周颠
 * @since 1.0.0
 */
@Api(tags = {"会员中心：团长订单记录"})
@FeignClient(contextId="com-dtyunxi-yundt-imkt-cube-bundle-commander-center-member-api-query-ICommanderOrderRecordQueryApi",
        name = "${bundle.commander.center.member.api.name:yundt-cube-center-member}", path = "/v1/commander-order-record", url = "${bundle.commander.center.member.api:}")
public interface ICommanderOrderRecordQueryApi {

    /**
     * 根据id查询团长订单记录
     * @param id
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-order-record")
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询团长订单记录", notes = "根据id查询团长订单记录")
    RestResponse<CommanderOrderRecordRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 根据批量id查询团长订单记录
     * @param ids
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-order-record")
    @PostMapping("/batch/query-by-id")
    @ApiOperation(value = "根据批量id查询团长订单记录", notes = "根据批量id查询团长订单记录")
    RestResponse<List<CommanderOrderRecordRespDto>> queryByIds(@RequestParam("ids") List<Long> ids);

    /**
     * 查询团长订单记录
     * @param queryReqDto
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-order-record")
    @GetMapping("/query")
    @ApiOperation(value = "查询团长订单记录", notes = "查询团长订单记录")
    RestResponse<List<CommanderOrderRecordRespDto>> queryCommanderOrderRecord(@SpringQueryMap CommanderOrderRecordQueryReqDto queryReqDto);

    /**
     * 分页查询团长订单记录
     * @param queryReqDto
     * @param pageNum
     * @param pageSize
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-order-record")
    @GetMapping(value = "/page")
    @ApiOperation(value = "分页查询团长订单记录", notes = "分页查询团长订单记录")
    @ApiImplicitParams({@ApiImplicitParam(name = "pageNum", value = "起始页", dataType = "integer", paramType = "query"),
            @ApiImplicitParam(name = "pageSize", value = "每一页的记录数", dataType = "integer", paramType = "query"),})
    RestResponse<PageInfo<CommanderOrderRecordRespDto>> queryCommanderOrderRecordByPage(@SpringQueryMap CommanderOrderRecordQueryReqDto queryReqDto, @RequestParam("pageNum") Integer pageNum, @RequestParam("pageSize") Integer pageSize);

}