package com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.request.CommanderOrderRelationReqDto;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.response.CommanderOrderRelationRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.GetMapping;
import com.github.pagehelper.PageInfo;

/**
* 分销员（直接间接）客户订单记录服务接口
*
* @author erduo
* @since 2021-05-13
*/
@Api(tags = {"分销员（直接间接）客户订单记录服务"})
@FeignClient(name = "${bundle.commander.center.member.api.name:yundt-cube-center-member}", path = "/v1/commanderOrderRelation", url = "${bundle.commander.center.member.api:}")
public interface ICommanderOrderRelationQueryApi {

    /**
    * 根据id查询分销员（直接间接）客户订单记录
    *
    * @param id 分销员（直接间接）客户订单记录id
    * @return   分销员（直接间接）客户订单记录数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询分销员（直接间接）客户订单记录", notes = "根据id查询分销员（直接间接）客户订单记录")
    RestResponse<CommanderOrderRelationRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 分销员（直接间接）客户订单记录分页数据
    *
    * @param filter   分销员（直接间接）客户订单记录查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 分销员（直接间接）客户订单记录分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "分销员（直接间接）客户订单记录分页数据", notes = "根据filter查询条件查询分销员（直接间接）客户订单记录数据，filter=CommanderOrderRelationReqDto")
    RestResponse<PageInfo<CommanderOrderRelationRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 分销员（直接间接）客户订单详细记录分页数据（包含商品）
     *
     * @param filter   分销员（直接间接）客户订单记录查询条件
     * @param pageNum  当前页
     * @param pageSize 页大小
     * @return 分销员（直接间接）客户订单记录分页数据
     */
    @GetMapping("/detail/page")
    @ApiOperation(value = "分销员（直接间接）客户订单详细记录分页数据（包含商品）", notes = "分销员（直接间接）客户订单详细记录分页数据（包含商品），filter=CommanderOrderRelationReqDto")
    RestResponse<PageInfo<CommanderOrderRelationRespDto>> queryDetailByPage(@RequestParam("filter") String filter,
                                                                      @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                      @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
