package com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.request.CommanderSettlementQueryReqDto;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.response.CommanderSettlementRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 团长结算记录QueryApi
 * @author 周颠
 * @since 1.0.0
 */
@Api(tags = {"会员中心：团长结算记录"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-biz-member-api-commander-query-ICommanderSettlementQueryApi",
        name = "${bundle.commander.center.member.api.name:yundt-cube-center-member}", path = "/v1/commander-settlement", url = "${bundle.commander.center.member.api:}")
public interface ICommanderSettlementQueryApi {

    /**
     * 根据id查询团长结算记录
     * @param id
     * @return
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询团长结算记录", notes = "根据id查询团长结算记录")
    RestResponse<CommanderSettlementRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 根据批量id查询团长结算记录
     * @param ids
     * @return
     */
    @PostMapping("/batch/query-by-id")
    @ApiOperation(value = "根据批量id查询团长结算记录", notes = "根据批量id查询团长结算记录")
    RestResponse<List<CommanderSettlementRespDto>> queryByIds(@RequestParam("ids") List<Long> ids);

    /**
     * 查询团长结算记录
     * @param queryReqDto
     * @return
     */
    @GetMapping("/query")
    @ApiOperation(value = "查询团长结算记录", notes = "查询团长结算记录")
    RestResponse<List<CommanderSettlementRespDto>> queryCommanderSettlement(@SpringQueryMap CommanderSettlementQueryReqDto queryReqDto);

    /**
     * 分页查询团长结算记录
     * @param queryReqDto
     * @param pageNum
     * @param pageSize
     * @return
     */
    @GetMapping(value = "/page")
    @ApiOperation(value = "分页查询团长结算记录", notes = "分页查询团长结算记录")
    @ApiImplicitParams({@ApiImplicitParam(name = "pageNum", value = "起始页", dataType = "integer", paramType = "query"),
            @ApiImplicitParam(name = "pageSize", value = "每一页的记录数", dataType = "integer", paramType = "query"),})
    RestResponse<PageInfo<CommanderSettlementRespDto>> queryCommanderSettlementByPage(@SpringQueryMap CommanderSettlementQueryReqDto queryReqDto, @RequestParam("pageNum") Integer pageNum, @RequestParam("pageSize") Integer pageSize);

    /**
     * 导出团长结算记录
     * @param queryReqDto
     * @return
     */
    @GetMapping("/downExcel")
    @ApiOperation(value = "导出团长结算记录", notes = "导出团长结算记录")
    RestResponse<String> downExcel(@SpringQueryMap CommanderSettlementQueryReqDto queryReqDto);
}