package com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.request.CommanderStatisticsQueryReqDto;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.response.CommanderStatisticsRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 团长统计信息QueryApi
 * @author 周颠
 * @since 1.0.0
 */
@Api(tags = {"会员中心：团长统计信息"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-biz-member-api-commander-query-ICommanderStatisticsQueryApi",
        name = "${bundle.commander.center.member.api.name:yundt-cube-center-member}", path = "/v1/commander-statistics", url = "${bundle.commander.center.member.api:}")
public interface ICommanderStatisticsQueryApi {

    /**
     * 根据团长id查询团长统计信息
     * @param commanderId
     * @return
     */
    @GetMapping("/query-by-commanderId")
    @ApiOperation(value = "根据团长id查询团长统计信息", notes = "根据团长id查询团长统计信息")
    RestResponse<CommanderStatisticsRespDto> queryByCommanderId(@RequestParam("commanderId") Long commanderId);

    /**
     * 根据id查询团长统计信息
     * @param id
     * @return
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询团长统计信息", notes = "根据id查询团长统计信息")
    RestResponse<CommanderStatisticsRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 根据批量id查询团长统计信息
     * @param ids
     * @return
     */
    @PostMapping("/batch/query-by-id")
    @ApiOperation(value = "根据批量id查询团长统计信息", notes = "根据批量id查询团长统计信息")
    RestResponse<List<CommanderStatisticsRespDto>> queryByIds(@RequestParam("ids") List<Long> ids);

    /**
     * 查询团长统计信息
     * @param queryReqDto
     * @return
     */
    @GetMapping("/query")
    @ApiOperation(value = "查询团长统计信息", notes = "查询团长统计信息")
    RestResponse<List<CommanderStatisticsRespDto>> queryCommanderStatistics(@SpringQueryMap CommanderStatisticsQueryReqDto queryReqDto);

    /**
     * 分页查询团长统计信息
     * @param queryReqDto
     * @param pageNum
     * @param pageSize
     * @return
     */
    @GetMapping(value = "/page")
    @ApiOperation(value = "分页查询团长统计信息", notes = "分页查询团长统计信息")
    @ApiImplicitParams({@ApiImplicitParam(name = "pageNum", value = "起始页", dataType = "integer", paramType = "query"),
            @ApiImplicitParam(name = "pageSize", value = "每一页的记录数", dataType = "integer", paramType = "query"),})
    RestResponse<PageInfo<CommanderStatisticsRespDto>> queryCommanderStatisticsByPage(@SpringQueryMap CommanderStatisticsQueryReqDto queryReqDto, @RequestParam("pageNum") Integer pageNum, @RequestParam("pageSize") Integer pageSize);

}