/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.framework.yira.support;

import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.cube.framework.yira.annotation.XmetaApiScan;
import com.dtyunxi.cube.framework.yira.support.IXmetaApiToEndPointClient;
import com.dtyunxi.cube.framework.yira.support.IXmetaApiToEndPointProvider;
import com.dtyunxi.cube.framework.yira.support.XmetaApiEnhanceProperties;
import com.dtyunxi.cube.framework.yira.support.XmetaApiEnhancePropertiesResoler;
import com.dtyunxi.cube.framework.yira.support.client.collector.AbstractResolvedApiSourceInitializer;
import com.dtyunxi.cube.framework.yira.utils.BinderUtils;
import com.dtyunxi.huieryun.meta.annotation.XmetaApi;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.ScannedGenericBeanDefinition;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@ConditionalOnProperty(name={"cube.xmeta.enhance.enabled"}, havingValue="true")
@AutoConfigureBefore(name={"com.alibaba.boot.hsf.consumer.HsfConsumerAutoConfiguration"})
@AutoConfigureAfter(name={"com.dtyunxi.cube.framework.yira.config.XmetaApiEnhanceConfig", "org.springframework.cloud.openfeign.FeignClientsRegistrar"})
public class XmetaApiEnhanceBeanRegistrar
implements ImportBeanDefinitionRegistrar,
ResourceLoaderAware,
EnvironmentAware,
BeanClassLoaderAware {
    protected static final Logger LOG = LoggerFactory.getLogger(XmetaApiEnhanceBeanRegistrar.class);
    private ResourceLoader resourceLoader;
    private static final Set<Class<?>> X_META_PROVIDER_APIS = new HashSet();
    private static final Set<String> resolvedPackages = new HashSet<String>();
    private static final Set<Class<?>> resolvedClasses = new HashSet();
    private Environment environment;
    protected ClassLoader classLoader;

    public static Set<Class<?>> readXMetaProviderApis() {
        return X_META_PROVIDER_APIS;
    }

    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        DefaultListableBeanFactory beanFactory;
        long startEnhance = System.currentTimeMillis();
        XmetaApiEnhanceProperties enhanceProperties = BinderUtils.bind((ConfigurableEnvironment)this.environment, "cube.xmeta.enhance", XmetaApiEnhanceProperties.class);
        if (enhanceProperties == null || !enhanceProperties.isEnabled()) {
            LOG.info("\u6ca1\u5f00\u542f\u4ee3\u7801\u589e\u5f3a\uff0c\u81ea\u52a8\u9000\u51fa\uff01");
            return;
        }
        AnnotationAttributes annAttr = AnnotationAttributes.fromMap((Map)metadata.getAnnotationAttributes(XmetaApiScan.class.getName()));
        if (annAttr == null) {
            LOG.warn("\u627e\u4e0d\u5230XmetaApi\u626b\u5305\u8def\u5f84\u914d\u7f6e\uff01\uff01\uff01");
            return;
        }
        DefaultListableBeanFactory defaultListableBeanFactory = beanFactory = registry instanceof DefaultListableBeanFactory ? (DefaultListableBeanFactory)registry : null;
        if (beanFactory == null) {
            return;
        }
        this.initResolvedApiSource(metadata, beanFactory, enhanceProperties, this.environment);
        XmetaApiEnhancePropertiesResoler resoler = new XmetaApiEnhancePropertiesResoler(enhanceProperties, this.environment);
        LinkedHashSet<BeanDefinition> apiComponents = this.getApiComponents((ListableBeanFactory)beanFactory, metadata);
        if (CollectionUtil.isEmpty(apiComponents)) {
            LOG.warn("\u672a\u53d1\u73b0\u6807\u6ce8XmetaApi/FeignClient\u63a5\u53e3\u7c7b");
            return;
        }
        List<IXmetaApiToEndPointProvider> endPointProviders = this.getiXmetaApiToEndPointProviders(enhanceProperties, beanFactory, resoler);
        if (CollectionUtil.isEmpty(endPointProviders)) {
            LOG.warn("\u672a\u53d1\u73b0\u670d\u52a1\u7aef\u589e\u5f3a\u4ee3\u7801\u751f\u6210\u7c7b");
        }
        ArrayList<Class> clientBeanDefinitions = new ArrayList<Class>(apiComponents.size());
        Map<Class<?>, Class<?>> providerBeanDefinitions = this.buildApi2ApiImplMap(metadata, apiComponents, endPointProviders, clientBeanDefinitions);
        if (CollectionUtil.isNotEmpty(clientBeanDefinitions)) {
            IXmetaApiToEndPointClient xmetaApiToEndPointClient = this.getiXmetaApiToEndPointClient(enhanceProperties, resoler, (ListableBeanFactory)beanFactory);
            for (Class xMetaApiClass : clientBeanDefinitions) {
                if (resolvedClasses.contains(xMetaApiClass)) {
                    LOG.info("\u8be5API\u3010{}\u3011\u5df2\u88abEnableFeignClient\u626b\u63cf\uff0c\u65e0\u9700\u91cd\u590d\u751f\u6210api\u5ba2\u6237\u7aefbean", (Object)xMetaApiClass.getName());
                    continue;
                }
                LOG.info("\u6ca1\u627e\u5230\u5b9e\u73b0\u7c7b\uff0c\u9700\u8981\u8fdc\u7a0b\u8c03\u7528\uff01Api={}", (Object)xMetaApiClass.getName());
                xmetaApiToEndPointClient.setXmetaApiEnhancePropertiesResoler(resoler);
                xmetaApiToEndPointClient.setXmetaApiEnhanceProperties(enhanceProperties);
                xmetaApiToEndPointClient.createEndPointClient(xMetaApiClass, registry);
            }
        }
        if (CollectionUtil.isNotEmpty(providerBeanDefinitions)) {
            LOG.info("\u627e\u5230\u5b9e\u73b0\u7c7b\uff01Api\u6570\u91cf\uff1a{}", (Object)providerBeanDefinitions.size());
            for (IXmetaApiToEndPointProvider endPointProvider : endPointProviders) {
                for (Map.Entry<Class<?>, Class<?>> apiImplBeanDefintion : providerBeanDefinitions.entrySet()) {
                    if (endPointProvider.isHsfProvider()) {
                        LOG.info("\u627e\u5230\u5b9e\u73b0\u7c7b\uff0c\u751f\u6210HSF\u4ee3\u7406\u7c7b\uff01Api={}", (Object)apiImplBeanDefintion.getKey().getName());
                    } else {
                        LOG.info("\u627e\u5230\u5b9e\u73b0\u7c7b\uff0c\u751f\u6210Rest\u4ee3\u7406\u7c7b\uff01Api={}", (Object)apiImplBeanDefintion.getKey().getName());
                    }
                    endPointProvider.createEndPointProvider(apiImplBeanDefintion.getKey(), apiImplBeanDefintion.getValue(), registry);
                    X_META_PROVIDER_APIS.add(apiImplBeanDefintion.getKey());
                }
            }
        }
        long endEnhance = System.currentTimeMillis();
        LOG.info("launch elapse >> x-meta\u81ea\u5b9a\u4e49API\u589e\u5f3a\u6d41\u7a0b\u8017\u65f6\uff1a{} ms", (Object)(endEnhance - startEnhance));
    }

    private Map<Class<?>, Class<?>> buildApi2ApiImplMap(AnnotationMetadata metadata, LinkedHashSet<BeanDefinition> apiComponents, List<IXmetaApiToEndPointProvider> endPointProviders, List<Class> clientBeanDefinitions) {
        LinkedHashSet<String> bizImplPackages = this.getBizImplPackages(apiComponents, clientBeanDefinitions);
        Set<String> implBasePackages = this.getImplBasePackages(metadata);
        bizImplPackages.addAll(implBasePackages);
        LinkedHashSet<BeanDefinition> apiImplComponents = this.getApiImplComponents(bizImplPackages);
        Map<Class<?>, Class<?>> providerBeanDefinitions = this.getProviderBeanDefinitions(apiComponents, endPointProviders, clientBeanDefinitions, apiImplComponents);
        return providerBeanDefinitions;
    }

    private void initResolvedApiSource(AnnotationMetadata metadata, DefaultListableBeanFactory beanFactory, XmetaApiEnhanceProperties enhanceProperties, Environment environment) {
        long startInitResolvedApiSource = System.currentTimeMillis();
        this.doWithResolvedApiSourceInitializers((ListableBeanFactory)beanFactory, resolvedApiSourceInitializers -> {
            LinkedList<Class> clientBeanDefinitions;
            Map<Class<?>, Class<?>> api2ApiImplMap;
            resolvedApiSourceInitializers.collect(beanFactory);
            resolvedApiSourceInitializers.buildClientMetaResolver(enhanceProperties, environment);
            resolvedPackages.addAll(resolvedApiSourceInitializers.getResolvedPackages());
            resolvedClasses.addAll(resolvedApiSourceInitializers.getResolvedClasses());
            LinkedHashSet<BeanDefinition> beanDefinitions = this.getApiComponents((ListableBeanFactory)beanFactory, resolvedPackages);
            if (CollectionUtil.isEmpty(beanDefinitions)) {
                return;
            }
            XmetaApiEnhancePropertiesResoler resoler = new XmetaApiEnhancePropertiesResoler(enhanceProperties, environment);
            List<IXmetaApiToEndPointProvider> endPointProviders = this.getiXmetaApiToEndPointProviders(enhanceProperties, beanFactory, resoler);
            if (CollectionUtil.isEmpty(endPointProviders)) {
                LOG.warn("\u672a\u53d1\u73b0\u670d\u52a1\u7aef\u589e\u5f3a\u4ee3\u7801\u751f\u6210\u7c7b");
            }
            if ((api2ApiImplMap = this.buildApi2ApiImplMap(metadata, beanDefinitions, endPointProviders, clientBeanDefinitions = new LinkedList<Class>())) == null) {
                api2ApiImplMap = new HashMap();
            }
            for (BeanDefinition beanDefinition : beanDefinitions) {
                try {
                    Class<?> apiClass = Class.forName(beanDefinition.getBeanClassName());
                    if (!api2ApiImplMap.containsKey(apiClass)) continue;
                    X_META_PROVIDER_APIS.add(apiClass);
                }
                catch (ClassNotFoundException e) {
                    LOG.warn("\u52a0\u8f7d\u7c7b[{}]\u5f02\u5e38\uff1a", (Object)beanDefinition.getBeanClassName(), (Object)e);
                }
            }
        });
        long endInitResolvedApiSource = System.currentTimeMillis();
        LOG.info("launch elapse >> \u7b2c\u4e09\u65b9\u7ec4\u4ef6\uff08\u4f8b\u5982Feign\uff09\u81ea\u8eab\u5904\u7406\u7684API\u5ba2\u6237\u7aef\u6e90\u6807\u8bb0\u6d41\u7a0b\u8017\u65f6\uff1a{} ms", (Object)(endInitResolvedApiSource - startInitResolvedApiSource));
    }

    private LinkedHashSet<String> getBizImplPackages(LinkedHashSet<BeanDefinition> apiComponents, List<Class> clientBeanDefinitions) {
        if (apiComponents == null) {
            return new LinkedHashSet<String>();
        }
        LinkedHashSet<String> bziImplPackages = new LinkedHashSet<String>();
        for (BeanDefinition beanDefinition : apiComponents) {
            clientBeanDefinitions.add(ClassUtils.resolveClassName((String)beanDefinition.getBeanClassName(), (ClassLoader)this.classLoader));
            String beanName = beanDefinition.getBeanClassName();
            int endIndex = beanName.lastIndexOf(46);
            String bizPackName = beanName.substring(0, endIndex);
            if (bizPackName.endsWith(".api")) {
                bizPackName = bizPackName.substring(0, bizPackName.length() - 4) + ".**.apiimpl";
                bziImplPackages.add(bizPackName);
                continue;
            }
            int apiIndex = bizPackName.indexOf(".api.");
            if (apiIndex > 0) {
                bziImplPackages.add(bizPackName.replace(".api.", ".**.apiimpl."));
                continue;
            }
            bziImplPackages.add(bizPackName);
        }
        return bziImplPackages;
    }

    private LinkedHashSet<BeanDefinition> getApiComponents(ListableBeanFactory beanFactory, AnnotationMetadata metadata) {
        Set<String> basePackages = this.getBasePackages(metadata);
        return this.getApiComponents(beanFactory, basePackages);
    }

    private LinkedHashSet<BeanDefinition> getApiComponents(ListableBeanFactory beanFactory, Set<String> basePackages) {
        ClassPathScanningCandidateComponentProvider scanner = this.getScanner();
        scanner.setResourceLoader(this.resourceLoader);
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(XmetaApi.class));
        this.doWithResolvedApiSourceInitializers(beanFactory, resolvedApiSourceInitializers -> {
            for (AnnotationTypeFilter annotationTypeFilter : resolvedApiSourceInitializers.annotationTypeFilter()) {
                scanner.addIncludeFilter((TypeFilter)annotationTypeFilter);
            }
        });
        if (ObjectUtils.isEmpty(basePackages)) {
            return null;
        }
        LinkedHashSet<BeanDefinition> apiComponents = new LinkedHashSet<BeanDefinition>();
        for (String basePackage : basePackages) {
            apiComponents.addAll(scanner.findCandidateComponents(basePackage));
        }
        return apiComponents;
    }

    private Map<Class<?>, Class<?>> getProviderBeanDefinitions(LinkedHashSet<BeanDefinition> apiComponents, List<IXmetaApiToEndPointProvider> endPointProviders, List<Class> clientBeanDefinitions, LinkedHashSet<BeanDefinition> apiImplComponents) {
        if (CollectionUtil.isEmpty(apiImplComponents)) {
            return null;
        }
        ConcurrentHashMap providerBeanDefinitions = new ConcurrentHashMap(apiComponents.size());
        for (BeanDefinition beanDefinition : apiImplComponents) {
            Class xMetaApiImplClass;
            if (!(beanDefinition instanceof ScannedGenericBeanDefinition) || ObjectUtils.isEmpty((Object[])(xMetaApiImplClass = ClassUtils.resolveClassName((String)beanDefinition.getBeanClassName(), (ClassLoader)this.classLoader)).getInterfaces())) continue;
            for (Class<?> xMetaApiClass : xMetaApiImplClass.getInterfaces()) {
                if (!clientBeanDefinitions.contains(xMetaApiClass)) continue;
                clientBeanDefinitions.remove(xMetaApiClass);
                if (!CollectionUtil.isNotEmpty(endPointProviders)) continue;
                if (providerBeanDefinitions.containsKey(xMetaApiClass)) {
                    if (!xMetaApiImplClass.isAnnotationPresent(Primary.class)) continue;
                    providerBeanDefinitions.put(xMetaApiClass, xMetaApiImplClass);
                    continue;
                }
                providerBeanDefinitions.put(xMetaApiClass, xMetaApiImplClass);
            }
        }
        return providerBeanDefinitions;
    }

    private LinkedHashSet<BeanDefinition> getApiImplComponents(LinkedHashSet<String> bziImplPackages) {
        ClassPathScanningCandidateComponentProvider scanner = this.getScanner();
        scanner.setResourceLoader(this.resourceLoader);
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Service.class));
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Component.class));
        LinkedHashSet<BeanDefinition> apiImplComponents = new LinkedHashSet<BeanDefinition>();
        for (String basePackage : bziImplPackages) {
            apiImplComponents.addAll(scanner.findCandidateComponents(basePackage));
        }
        return apiImplComponents;
    }

    private List<IXmetaApiToEndPointProvider> getiXmetaApiToEndPointProviders(XmetaApiEnhanceProperties enhanceProperties, DefaultListableBeanFactory beanFactory, XmetaApiEnhancePropertiesResoler resoler) {
        Map providerMap = beanFactory.getBeansOfType(IXmetaApiToEndPointProvider.class);
        ArrayList<IXmetaApiToEndPointProvider> endPointProviders = new ArrayList<IXmetaApiToEndPointProvider>(providerMap.size());
        for (Map.Entry entry : providerMap.entrySet()) {
            IXmetaApiToEndPointProvider endPointProvider = (IXmetaApiToEndPointProvider)entry.getValue();
            endPointProvider.setXmetaApiEnhanceProperties(enhanceProperties);
            if (!endPointProvider.checkEnable()) continue;
            endPointProvider.setXmetaApiEnhancePropertiesResoler(resoler);
            if (endPointProvider.isHsfProvider()) {
                endPointProviders.add(0, endPointProvider);
                continue;
            }
            endPointProviders.add(endPointProvider);
        }
        return endPointProviders;
    }

    private void doWithResolvedApiSourceInitializers(ListableBeanFactory beanFactory, Consumer<AbstractResolvedApiSourceInitializer> consumer) {
        Map abstractResolvedApiSourceInitializersMap = beanFactory.getBeansOfType(AbstractResolvedApiSourceInitializer.class);
        abstractResolvedApiSourceInitializersMap.forEach((key, initializers) -> consumer.accept((AbstractResolvedApiSourceInitializer)initializers));
    }

    private IXmetaApiToEndPointClient getiXmetaApiToEndPointClient(XmetaApiEnhanceProperties enhanceProperties, XmetaApiEnhancePropertiesResoler resoler, ListableBeanFactory beanFactory) {
        IXmetaApiToEndPointClient xmetaApiToEndPointClient;
        Map clientMap = beanFactory.getBeansOfType(IXmetaApiToEndPointClient.class);
        ArrayList<IXmetaApiToEndPointClient> endPointClients = new ArrayList<IXmetaApiToEndPointClient>(clientMap.size());
        ConcurrentHashMap enableClientMap = new ConcurrentHashMap(clientMap.size());
        for (Map.Entry entry : clientMap.entrySet()) {
            IXmetaApiToEndPointClient client = (IXmetaApiToEndPointClient)entry.getValue();
            ((IXmetaApiToEndPointClient)entry.getValue()).setXmetaApiEnhanceProperties(enhanceProperties);
            if (!client.checkEnable()) continue;
            enableClientMap.put(entry.getKey(), entry.getValue());
            endPointClients.add(client);
        }
        switch (endPointClients.size()) {
            case 1: {
                xmetaApiToEndPointClient = (IXmetaApiToEndPointClient)endPointClients.get(0);
                break;
            }
            case 0: {
                LOG.warn("\u914d\u7f6e\u9519\u8bef\uff0c\u9ed8\u8ba4\u4f7f\u7528FeignClient");
                xmetaApiToEndPointClient = (IXmetaApiToEndPointClient)beanFactory.getBean("xmetaApiToFeignClient", IXmetaApiToEndPointClient.class);
                break;
            }
            default: {
                if (clientMap.containsKey("xmetaApiToFeignClient")) {
                    LOG.warn("\u914d\u7f6e\u9519\u8bef\uff0c\u9ed8\u8ba4\u4f7f\u7528FeignClient");
                    xmetaApiToEndPointClient = (IXmetaApiToEndPointClient)enableClientMap.get("xmetaApiToFeignClient");
                    break;
                }
                xmetaApiToEndPointClient = (IXmetaApiToEndPointClient)endPointClients.get(0);
                LOG.warn("\u914d\u7f6e\u9519\u8bef\uff0c\u9ed8\u8ba4\u4f7f\u7528\u7b2c\u4e00\u4e2a\uff01\uff01\u5904\u7406\u7c7b\uff1a{}", (Object)xmetaApiToEndPointClient.getClass().getName());
            }
        }
        xmetaApiToEndPointClient.setXmetaApiEnhancePropertiesResoler(resoler);
        return xmetaApiToEndPointClient;
    }

    protected ClassPathScanningCandidateComponentProvider getScanner() {
        return new ClassPathScanningCandidateComponentProvider(false, this.environment){

            protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
                boolean isCandidate = false;
                if (beanDefinition.getMetadata().isIndependent() && !beanDefinition.getMetadata().isAnnotation()) {
                    isCandidate = true;
                }
                return isCandidate;
            }
        };
    }

    protected Set<String> getBasePackages(AnnotationMetadata metadata) {
        String packageName;
        Map attributes = metadata.getAnnotationAttributes(XmetaApiScan.class.getCanonicalName());
        HashSet<String> basePackages = new HashSet<String>();
        for (String pkg : (String[])attributes.get("basePackages")) {
            if (!StringUtils.hasText((String)pkg) || resolvedPackages.contains(pkg)) continue;
            basePackages.add(pkg);
            resolvedPackages.add(pkg);
        }
        if (basePackages.isEmpty() && !resolvedPackages.contains(packageName = ClassUtils.getPackageName((String)metadata.getClassName()))) {
            basePackages.add(packageName);
            resolvedPackages.add(packageName);
        }
        return basePackages;
    }

    protected Set<String> getImplBasePackages(AnnotationMetadata metadata) {
        Map attributes = metadata.getAnnotationAttributes(XmetaApiScan.class.getCanonicalName());
        HashSet<String> implBasePackages = new HashSet<String>();
        for (String pkg : (String[])attributes.get("implBasePackages")) {
            if (!StringUtils.hasText((String)pkg)) continue;
            implBasePackages.add(pkg);
        }
        return implBasePackages;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

