/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.framework.yira.support.client.resolver;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import com.dtyunxi.cube.framework.yira.support.XmetaApiEnhanceProperties;
import com.dtyunxi.cube.framework.yira.support.client.resolver.AbstractClientMetaResolver;
import com.dtyunxi.huieryun.meta.annotation.XmetaApi;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.core.env.Environment;

public class XMetaClientMetaResolver
extends AbstractClientMetaResolver<XmetaApi> {
    public XMetaClientMetaResolver(XmetaApiEnhanceProperties enhanceProperties, Environment environment) {
        super(enhanceProperties, environment);
    }

    @Override
    public String getHsfProviderGroupName(Class<?> xMetaApiClass) {
        XmetaApi metaApi = xMetaApiClass.getAnnotation(XmetaApi.class);
        String groupName = this.getGroupName(metaApi);
        String hsfGroupName = this.resolve(null, groupName);
        if (StrUtil.isBlank((CharSequence)hsfGroupName)) {
            LOG.warn("XmetaApi \u672a\u8bbe\u7f6egroup\u5c5e\u6027\uff0c\u5219\u9ed8\u8ba4\u4f7f\u7528\"dtyunxi.env.module\"\u8bbe\u7f6e\u7684\u503c\uff01Api\u7c7b\u540d\uff1a${}", (Object)xMetaApiClass.getName());
            hsfGroupName = this.environment.getProperty("dtyunxi.env.module");
        }
        LOG.info("getHsfProviderGroupName,className={},group={},hsfGroupName={}", new Object[]{xMetaApiClass.getName(), groupName, hsfGroupName});
        return hsfGroupName;
    }

    @Override
    public String getGroupName(XmetaApi metaApi) {
        return (String)ObjectUtil.defaultIfBlank((CharSequence)metaApi.group(), (CharSequence)metaApi.name());
    }

    @Override
    public String getHsfClientGroupName(Class<?> xMetaApiClass) {
        XmetaApi metaApi = xMetaApiClass.getAnnotation(XmetaApi.class);
        String groupName = this.getGroupName(metaApi);
        String hsfGroupName = this.resolve(null, groupName);
        LOG.info("getHsfClientGroupName,className={},group={},hsfGroupName={}", new Object[]{xMetaApiClass.getName(), groupName, hsfGroupName});
        return hsfGroupName;
    }

    @Override
    public String getHsfServiceVersion(ConfigurableBeanFactory beanFactory, Class<?> xMetaApiClass) {
        XmetaApi metaApi = xMetaApiClass.getAnnotation(XmetaApi.class);
        String version = metaApi.version();
        if (StrUtil.isBlank((CharSequence)version)) {
            String path = XMetaClientMetaResolver.getPath(this.resolve(beanFactory, metaApi.value()));
            if (StrUtil.isBlank((CharSequence)path)) {
                path = XMetaClientMetaResolver.getPath(this.resolve(beanFactory, metaApi.path()));
            }
            if (StrUtil.isNotBlank((CharSequence)path) && ReUtil.isMatch((String)"^/v\\d/.*", (CharSequence)path)) {
                return path.substring(1, 3);
            }
        }
        if (StrUtil.isBlank((CharSequence)version)) {
            version = this.enhanceProperties.getVersion();
        }
        LOG.info("getHsfServiceVersion,className={},serviceVersion={}", (Object)xMetaApiClass.getName(), (Object)version);
        return version;
    }

    @Override
    public String getFeignApiPath(ConfigurableBeanFactory beanFactory, Class<?> xMetaApiClass) {
        return this.getPath(beanFactory, xMetaApiClass);
    }

    @Override
    public String getFeignApiName(Class<?> xMetaApiClass) {
        XmetaApi metaApi = xMetaApiClass.getAnnotation(XmetaApi.class);
        String groupName = this.getGroupName(metaApi);
        String feignApiName = XMetaClientMetaResolver.getName(this.resolve(null, groupName));
        LOG.info("getFeignApiName,className={},group={},feignApiName={}", new Object[]{xMetaApiClass.getName(), groupName, feignApiName});
        return feignApiName;
    }

    @Override
    public String getFeignApiUrl(Class<?> xMetaApiClass) {
        XmetaApi metaApi = xMetaApiClass.getAnnotation(XmetaApi.class);
        return XMetaClientMetaResolver.getUrl(this.resolve(null, metaApi.url()));
    }

    @Override
    public Class<?> getFeignClientFallback(Class<?> xMetaApiClass) {
        XmetaApi metaApi = xMetaApiClass.getAnnotation(XmetaApi.class);
        if (metaApi.fallback() != null && Void.class.equals((Object)metaApi.fallback())) {
            return null;
        }
        return metaApi.fallback();
    }

    @Override
    public Class<?> getFeignClientFallbackFactory(Class<?> xMetaApiClass) {
        XmetaApi metaApi = xMetaApiClass.getAnnotation(XmetaApi.class);
        if (metaApi.fallbackFactory() != null && Void.class.equals((Object)metaApi.fallbackFactory())) {
            return null;
        }
        return metaApi.fallbackFactory();
    }

    @Override
    public Class<?>[] getFeignClientConfiguration(Class<?> xMetaApiClass) {
        XmetaApi metaApi = xMetaApiClass.getAnnotation(XmetaApi.class);
        return metaApi.configuration();
    }

    @Override
    public String getPath(ConfigurableBeanFactory beanFactory, Class<?> xMetaApiClass) {
        XmetaApi metaApi = xMetaApiClass.getAnnotation(XmetaApi.class);
        String path = XMetaClientMetaResolver.getPath(this.resolve(beanFactory, metaApi.value()));
        if (StrUtil.isBlank((CharSequence)path)) {
            path = XMetaClientMetaResolver.getPath(this.resolve(beanFactory, metaApi.path()));
        }
        if (StrUtil.isBlank((CharSequence)path)) {
            LOG.warn("value and path is not set value.apiClass={}", (Object)xMetaApiClass.getName());
            return "";
        }
        String version = metaApi.version();
        if (StrUtil.isBlank((CharSequence)version)) {
            version = this.enhanceProperties.getVersion();
        }
        if (StrUtil.isBlank((CharSequence)version)) {
            return path;
        }
        if (path.startsWith("/" + version)) {
            return path;
        }
        if (ReUtil.isMatch((String)"^/v\\d/.*", (CharSequence)path)) {
            return path;
        }
        if (StrUtil.isNotBlank((CharSequence)version)) {
            return "/" + version + path;
        }
        return path;
    }
}

