/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.framework.yira.support.client.resolver;

import com.dtyunxi.cube.framework.yira.support.XmetaApiEnhanceProperties;
import com.dtyunxi.cube.framework.yira.support.client.resolver.IClientMetaResolver;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractClientMetaResolver<CLIENT_API>
implements IClientMetaResolver<CLIENT_API> {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractClientMetaResolver.class);
    protected final XmetaApiEnhanceProperties enhanceProperties;
    protected final Environment environment;

    public AbstractClientMetaResolver(XmetaApiEnhanceProperties enhanceProperties, Environment environment) {
        this.environment = environment;
        this.enhanceProperties = enhanceProperties;
    }

    protected String getRestControllerPath(ConfigurableBeanFactory beanFactory, Class<?> xMetaApiClass) {
        return this.getPath(beanFactory, xMetaApiClass);
    }

    protected String getThumbnailPackageName(Class<?> xMetaApiClass) {
        String[] packNameSnippets = xMetaApiClass.getPackage().getName().split("\\.");
        StringBuilder builder = new StringBuilder();
        for (String packNameSnippet : packNameSnippets) {
            builder.append(packNameSnippet.charAt(0));
        }
        return builder.toString();
    }

    protected static String getName(String name) {
        if (!StringUtils.hasText((String)name)) {
            return "";
        }
        String host = null;
        try {
            String url = !name.startsWith("http://") && !name.startsWith("https://") ? "http://" + name : name;
            host = new URI(url).getHost();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        Assert.state((host != null ? 1 : 0) != 0, (String)("Service id not legal hostname (" + name + ")"));
        return name;
    }

    protected static String getUrl(String url) {
        if (!(!StringUtils.hasText((String)url) || url.startsWith("#{") && url.contains("}"))) {
            if (!url.contains("://")) {
                url = "http://" + url;
            }
            try {
                new URL(url);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(url + " is malformed", e);
            }
        }
        return url;
    }

    protected static String getPath(String path) {
        if (StringUtils.hasText((String)path)) {
            if (!(path = path.trim()).startsWith("/")) {
                path = "/" + path;
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
        }
        return path;
    }

    protected String resolve(ConfigurableBeanFactory beanFactory, String value) {
        if (StringUtils.hasText((String)value)) {
            if (beanFactory == null) {
                return this.environment.resolvePlaceholders(value);
            }
            BeanExpressionResolver resolver = beanFactory.getBeanExpressionResolver();
            String resolved = beanFactory.resolveEmbeddedValue(value);
            if (resolver == null) {
                return resolved;
            }
            return String.valueOf(resolver.evaluate(resolved, new BeanExpressionContext(beanFactory, null)));
        }
        return value;
    }
}

