/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.commons.interceptor;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.util.MD5Util;
import com.dtyunxi.yundt.commons.utils.UserInfoUtil;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class RepeatDataInterceptor
extends HandlerInterceptorAdapter {
    private static final String resultMessage = "{\"resultCode\":-1,\"resultMsg\":\"\u8868\u5355\u91cd\u590d\u63d0\u4ea4\"}";
    private static final List<String> requestMethod = new ArrayList<String>();
    private static final String REPEAT_DATA_GROUP = "repeat-data";
    private static final Integer TIMEOUT = 2;
    private ICacheService cacheService;

    public RepeatDataInterceptor(ICacheService cacheService) {
        this.cacheService = cacheService;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (handler instanceof HandlerMethod) {
            String method = request.getMethod();
            if (requestMethod.contains(method)) {
                if (this.repeatDataValidator(request)) {
                    response.setCharacterEncoding("utf-8");
                    PrintWriter out = response.getWriter();
                    out.append(resultMessage);
                    out.close();
                    return false;
                }
                return true;
            }
            return true;
        }
        return super.preHandle(request, response, handler);
    }

    private boolean repeatDataValidator(HttpServletRequest request) {
        Long userId = UserInfoUtil.getUserInfo();
        if (userId == null) {
            return false;
        }
        String params = JSON.toJSONString((Object)request.getParameterMap());
        if (params.length() == 2) {
            return false;
        }
        String url = request.getRequestURI();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(url, params);
        String nowUrlParams = MD5Util.getMd5ByString((String)(userId + ":" + ((Object)map).toString()));
        Object preUrlParams = this.cacheService.getCache(REPEAT_DATA_GROUP, nowUrlParams, String.class);
        if (preUrlParams == null) {
            this.cacheService.setCache(REPEAT_DATA_GROUP, nowUrlParams, (Object)TIMEOUT, TIMEOUT.intValue());
            return false;
        }
        return true;
    }

    static {
        requestMethod.add("PUT");
        requestMethod.add("DELETE");
    }
}

