/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.commons.mq.config;

import com.dtyunxi.huieryun.mq.api.IConsumer;
import com.dtyunxi.huieryun.mq.api.IMQService;
import com.dtyunxi.huieryun.mq.api.IProducer;
import com.dtyunxi.huieryun.mq.api.MQFactory;
import com.dtyunxi.huieryun.mq.vo.MessageRegistryVo;
import com.dtyunxi.huieryun.registry.api.IRegistryService;
import com.dtyunxi.yundt.commons.mq.config.CommonsMqConstants;
import com.dtyunxi.yundt.commons.mq.config.MqRegistryVo;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CommonsMqConfig {
    @Resource
    private IRegistryService commonsRegistryService;

    @Bean
    public MessageRegistryVo messageRegistryVo() {
        MqRegistryVo registryVo = (MqRegistryVo)this.commonsRegistryService.getObject("yundt.commons.mq.topic.registryvo", MqRegistryVo.class);
        if (null == registryVo) {
            registryVo = new MqRegistryVo();
            registryVo.setPublishTopic("XL_PUBLISH_MQ_TOPIC");
            registryVo.setSingleTopic("XL_SINGLE_MQ_TOPIC");
        }
        CommonsMqConstants.DEFAULT_MQ_TOPIC = registryVo;
        return (MessageRegistryVo)this.commonsRegistryService.getObject("huieryun.messageregistryvo", MessageRegistryVo.class);
    }

    @Bean
    public IMQService commonMqConfigService(@Qualifier(value="messageRegistryVo") MessageRegistryVo messageRegistryVo) {
        return MQFactory.createMQ((MessageRegistryVo)messageRegistryVo);
    }

    @Bean
    public IConsumer commonsConsumer(@Qualifier(value="commonMqConfigService") IMQService commonMqConfigService) {
        return commonMqConfigService.createConsumer();
    }

    @Bean
    public IProducer commonsProducer(@Qualifier(value="commonMqConfigService") IMQService commonMqConfigService) {
        return commonMqConfigService.createProducer();
    }
}

