/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.commons.mq.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.huieryun.mq.api.IConsumer;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.api.IProducer;
import com.dtyunxi.huieryun.mq.constant.MessageType;
import com.dtyunxi.huieryun.mq.vo.MessageRegistryVo;
import com.dtyunxi.yundt.commons.config.SystemConfig;
import com.dtyunxi.yundt.commons.constant.MessageQueue;
import com.dtyunxi.yundt.commons.mq.config.CommonsMqConstants;
import com.dtyunxi.yundt.commons.mq.config.RetryMessageVo;
import com.dtyunxi.yundt.commons.mq.helper.CommonsMqHelper;
import com.dtyunxi.yundt.commons.mq.service.ICommonsErrorMsgService;
import com.dtyunxi.yundt.commons.mq.service.ICommonsMqService;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service(value="commonsMqService")
public class CommonsMqServiceImpl
implements ICommonsMqService {
    private static Logger logger = LoggerFactory.getLogger(CommonsMqServiceImpl.class);
    @Resource
    private IProducer commonsProducer;
    @Resource
    private IConsumer commonsConsumer;
    @Resource
    private MessageRegistryVo messageRegistryVo;
    @Resource
    private ICommonsErrorMsgService commonsErrorMsgService;
    @Value(value="${dtyunxi.env.module}")
    private String envModule;

    @Override
    public IProducer getCommonsProducer() {
        return this.commonsProducer;
    }

    public void setCommonsProducer(IProducer commonsProducer) {
        this.commonsProducer = commonsProducer;
    }

    public IConsumer getCommonsConsumer() {
        return this.commonsConsumer;
    }

    public void setCommonsConsumer(IConsumer commonsConsumer) {
        this.commonsConsumer = commonsConsumer;
    }

    public MessageRegistryVo getMessageRegistryVo() {
        return this.messageRegistryVo;
    }

    public void setMessageRegistryVo(MessageRegistryVo messageRegistryVo) {
        this.messageRegistryVo = messageRegistryVo;
    }

    public String getEnvModule() {
        return this.envModule;
    }

    public void setEnvModule(String envModule) {
        this.envModule = envModule;
    }

    @Override
    public void sendSingleMessage(String tag, Object msg, Long delayTime) {
        try {
            this.sendSingleMessageWithThrownException(tag, msg, delayTime);
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u70b9\u5bf9\u70b9\u5ef6\u8fdfMQ\u6d88\u606f\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
    }

    @Override
    public void sendSingleMessage(String tag, Object msg) {
        try {
            this.sendSingleMessageWithThrownException(tag, msg);
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001MQ\u6d88\u606f\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
    }

    @Override
    public void sendSingleMessageWithThrownException(String tag, Object msg, Long delayTime) {
        this.sendSingleMessageWithThrownException(CommonsMqConstants.DEFAULT_MQ_TOPIC.getSingleTopic(), tag, msg, delayTime);
    }

    @Override
    public void sendSingleMessageWithThrownException(String tag, Object msg) {
        this.sendSingleMessageWithThrownException(CommonsMqConstants.DEFAULT_MQ_TOPIC.getSingleTopic(), tag, msg);
    }

    @Override
    @Async
    public void sendSingleMessageAsync(String tag, Object msg) {
        this.sendSingleMessage(tag, msg);
    }

    @Override
    @Async
    public void sendSingleMessageAsync(String tag, Object msg, Long delayTime) {
        this.sendSingleMessage(tag, msg, delayTime);
    }

    @Override
    @Async
    public void sendSingleMessageAsyncWithThrownException(String tag, Object msg) {
        this.sendSingleMessageWithThrownException(tag, msg);
    }

    @Override
    @Async
    public void sendSingleMessageAsyncWithThrownException(String tag, Object msg, Long delayTime) {
        this.sendSingleMessageWithThrownException(tag, msg, delayTime);
    }

    @Override
    public void sendSingleMessage(String topic, String tag, Object msg, Long delayTime) {
        this.sendSingleMessageWithThrownException(topic, tag, msg, delayTime);
    }

    @Override
    public void sendSingleMessage(String topic, String tag, Object msg) {
        this.sendSingleMessageWithThrownException(topic, tag, msg);
    }

    @Override
    public void sendSingleMessageWithThrownException(String topic, String tag, Object msg, Long delayTime) {
        topic = MessageQueue.getMsgTopicName((String)topic);
        tag = this.parseTag(tag);
        logger.info("\u5f00\u59cb\u53d1\u9001\u70b9\u5bf9\u70b9MQ\u6d88\u606f\uff0ctopic:{}, tag\uff1a{}\uff0c msg\uff1a{}\uff0c delayTime\uff1a{}", new Object[]{topic, tag, JSON.toJSONString((Object)msg), delayTime});
        try {
            this.commonsProducer.sendSingleMessage(topic, tag, msg, delayTime.longValue());
        }
        catch (Exception e) {
            logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff0c \u6682\u5b58\u7f13\u5b58\u901a\u8fc7\u5b9a\u65f6\u4efb\u52a1\u8865\u507f\uff0c \u518d\u6b21\u6295\u9012\u4fe1\u606f", (Throwable)e);
            this.commonsErrorMsgService.dumpErrorMsg(new RetryMessageVo("single", topic, tag, msg));
            throw e;
        }
    }

    @Override
    public void sendSingleMessageWithThrownException(String topic, String tag, Object msg) {
        topic = MessageQueue.getMsgTopicName((String)topic);
        tag = this.parseTag(tag);
        logger.info("\u5f00\u59cb\u53d1\u9001\u70b9\u5bf9\u70b9MQ\u6d88\u606f\uff0ctopic :{}, tag\uff1a{}\uff0c msg\uff1a{}", new Object[]{topic, tag, JSON.toJSONString((Object)msg)});
        try {
            this.commonsProducer.sendSingleMessage(topic, tag, msg);
        }
        catch (Exception e) {
            logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff0c \u6682\u5b58\u7f13\u5b58\u901a\u8fc7\u5b9a\u65f6\u4efb\u52a1\u8865\u507f\uff0c \u518d\u6b21\u6295\u9012\u4fe1\u606f", (Throwable)e);
            this.commonsErrorMsgService.dumpErrorMsg(new RetryMessageVo("single", topic, tag, msg));
            throw e;
        }
    }

    @Override
    @Async
    public void sendSingleMessageAsync(String topic, String tag, Object msg) {
        this.sendSingleMessage(topic, tag, msg);
    }

    @Override
    @Async
    public void sendSingleMessageAsync(String topic, String tag, Object msg, Long delayTime) {
        this.sendSingleMessage(topic, tag, msg, delayTime);
    }

    @Override
    @Async
    public void sendSingleMessageAsyncWithThrownException(String topic, String tag, Object msg) {
        this.sendSingleMessageWithThrownException(topic, tag, msg);
    }

    @Override
    @Async
    public void sendSingleMessageAsyncWithThrownException(String topic, String tag, Object msg, Long delayTime) {
        this.sendSingleMessageWithThrownException(topic, tag, msg, delayTime);
    }

    @Override
    public void publishMessage(String tag, Object msg) {
        this.publishMessage(CommonsMqConstants.DEFAULT_MQ_TOPIC.getPublishTopic(), tag, msg);
    }

    @Override
    public void publishMessage(String tag, Object msg, Long delayTime) {
        this.publishMessage(CommonsMqConstants.DEFAULT_MQ_TOPIC.getPublishTopic(), tag, msg, delayTime);
    }

    @Override
    public void publishMessageWithThrownException(String tag, Object msg) {
        this.publishMessageWithThrownException(CommonsMqConstants.DEFAULT_MQ_TOPIC.getPublishTopic(), tag, msg);
    }

    @Override
    public void publishMessageWithThrownException(String tag, Object msg, Long delayTime) {
        this.publishMessageWithThrownException(CommonsMqConstants.DEFAULT_MQ_TOPIC.getPublishTopic(), tag, msg, delayTime);
    }

    @Override
    public void publishMessage(String topic, String tag, Object msg) {
        try {
            this.publishMessageWithThrownException(topic, tag, msg);
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u8ba2\u9605\u5ef6\u8fdfMQ\u6d88\u606f\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
    }

    @Override
    public void publishMessage(String topic, String tag, Object msg, Long delayTime) {
        try {
            this.publishMessageWithThrownException(topic, tag, msg, delayTime);
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u8ba2\u9605\u5ef6\u8fdfMQ\u6d88\u606f\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
    }

    @Override
    public void publishMessageWithThrownException(String topic, String tag, Object msg) {
        topic = MessageQueue.getMsgTopicName((String)topic);
        tag = this.parseTag(tag);
        logger.info("\u5f00\u59cb\u53d1\u9001\u8ba2\u9605MQ\u6d88\u606f\uff0c topic:{}, tag\uff1a{}\uff0c msg\uff1a{}", new Object[]{topic, tag, JSON.toJSONString((Object)msg)});
        try {
            this.commonsProducer.sendMessage(topic, tag, msg);
        }
        catch (Exception e) {
            logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff0c \u6682\u5b58\u7f13\u5b58\u901a\u8fc7\u5b9a\u65f6\u4efb\u52a1\u8865\u507f\uff0c \u518d\u6b21\u6295\u9012\u4fe1\u606f", (Throwable)e);
            this.commonsErrorMsgService.dumpErrorMsg(new RetryMessageVo("publish", topic, tag, msg));
            throw e;
        }
    }

    @Override
    public void publishMessageWithThrownException(String topic, String tag, Object msg, Long delayTime) {
        topic = MessageQueue.getMsgTopicName((String)topic);
        tag = this.parseTag(tag);
        logger.info("\u5f00\u59cb\u53d1\u9001\u8ba2\u9605MQ\u6d88\u606f\uff0ctopic:{}, tag\uff1a{}\uff0c msg\uff1a{}, delayTime:{}", new Object[]{topic, tag, JSON.toJSONString((Object)msg), delayTime});
        try {
            this.commonsProducer.sendMessage(topic, tag, msg, delayTime.longValue());
        }
        catch (Exception e) {
            logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff0c \u6682\u5b58\u7f13\u5b58\u901a\u8fc7\u5b9a\u65f6\u4efb\u52a1\u8865\u507f\uff0c \u518d\u6b21\u6295\u9012\u4fe1\u606f", (Throwable)e);
            this.commonsErrorMsgService.dumpErrorMsg(new RetryMessageVo("publish", topic, tag, msg));
            throw e;
        }
    }

    @Override
    @Async
    public void publishMessageAsync(String tag, Object msg) {
        this.publishMessage(tag, msg);
    }

    @Override
    @Async
    public void publishMessageAsync(String tag, Object msg, Long delayTime) {
        this.publishMessage(tag, msg, delayTime);
    }

    @Override
    @Async
    public void publishMessageAsync(String topic, String tag, Object msg) {
        this.publishMessage(topic, tag, msg);
    }

    @Override
    @Async
    public void publishMessageAsync(String topic, String tag, Object msg, Long delayTime) {
        this.publishMessage(topic, tag, msg, delayTime);
    }

    @Override
    @Async
    public void publishMessageAsyncWithThrownException(String tag, Object msg) {
        this.publishMessageWithThrownException(tag, msg);
    }

    @Override
    @Async
    public void publishMessageAsyncWithThrownException(String tag, Object msg, Long delayTime) {
        this.publishMessageWithThrownException(tag, msg, delayTime);
    }

    @Override
    @Async
    public void publishMessageAsyncWithThrownException(String topic, String tag, Object msg) {
        this.publishMessageWithThrownException(topic, tag, msg);
    }

    @Override
    @Async
    public void publishMessageAsyncWithThrownException(String topic, String tag, Object msg, Long delayTime) {
        this.publishMessageWithThrownException(topic, tag, msg, delayTime);
    }

    @Override
    public void receiveSingleMessage(Map<String, IMessageProcessor> processorMap) {
        this.receiveSingleMessage(CommonsMqConstants.DEFAULT_MQ_TOPIC.getSingleTopic(), this.getActiveModule(), processorMap);
    }

    @Override
    public void receiveSingleMessage(String topic, String queueName, Map<String, IMessageProcessor> processorMap) {
        logger.info("\u76d1\u542cTopic:{}, queueName:{}", (Object)topic, (Object)queueName);
        this.commonsConsumer.receiveMessage(MessageQueue.getMsgTopicName((String)topic), MessageQueue.getMsgQueue((String)queueName), this.parseTagMap(processorMap));
    }

    @Override
    public void subscribeMessage(Map<String, IMessageProcessor> processorMap) {
        this.subscribeMessage(CommonsMqConstants.DEFAULT_MQ_TOPIC.getPublishTopic(), this.getActiveModule(), processorMap);
    }

    @Override
    public void subscribeMessage(String topic, String queueName, Map<String, IMessageProcessor> processorMap) {
        logger.info("\u76d1\u542cTopic:{}, queueName:{}", (Object)topic, (Object)queueName);
        this.commonsConsumer.subscribe(MessageQueue.getMsgTopicName((String)topic), MessageQueue.getMsgQueue((String)queueName), this.parseTagMap(processorMap));
    }

    private String getActiveModule() {
        return StringUtils.isBlank((CharSequence)SystemConfig.getConsumerId()) ? "CID_" + String.valueOf(this.envModule).replace("-", "_") : SystemConfig.getConsumerId();
    }

    private String parseTag(String tag) {
        if (MessageType.RABBIT.getName().equalsIgnoreCase(this.messageRegistryVo.getType())) {
            tag = MessageQueue.getMsgQueue((String)tag);
        }
        return tag;
    }

    private Map<String, IMessageProcessor> parseTagMap(Map<String, IMessageProcessor> tagMap) {
        if (MessageType.RABBIT.getName().equalsIgnoreCase(this.messageRegistryVo.getType())) {
            HashMap<String, IMessageProcessor> map = new HashMap<String, IMessageProcessor>();
            for (String tag : tagMap.keySet()) {
                map.put(this.parseTag(tag), tagMap.get(tag));
            }
            return map;
        }
        return tagMap;
    }

    @Override
    public void subscribeMessage() {
        this.subscribeMessage(null, null);
    }

    @Override
    public void subscribeMessage(String topic, String queueName) {
        if (MessageType.RABBIT.getName().equalsIgnoreCase(this.messageRegistryVo.getType())) {
            Map<String, IMessageProcessor> publishProcessors;
            logger.info("\u76d1\u542c\u70b9\u5bf9\u70b9\u6d88\u606f");
            Map<String, IMessageProcessor> singleProcessors = CommonsMqHelper.getSingleProcessors();
            if (null != singleProcessors) {
                if (null != topic) {
                    this.receiveSingleMessage(topic, queueName, singleProcessors);
                } else {
                    this.receiveSingleMessage(singleProcessors);
                }
            }
            if (null != (publishProcessors = CommonsMqHelper.getPublishProcessors())) {
                if (null == topic) {
                    this.subscribeMessage(publishProcessors);
                } else {
                    this.subscribeMessage(topic, queueName, publishProcessors);
                }
            }
        } else {
            logger.info("\u76d1\u542c\u6d88\u606f-\u963f\u91cc\u4e91MQ");
            Map<String, IMessageProcessor> processors = CommonsMqHelper.getAllProcessors();
            if (CollectionUtils.isNotEmpty(processors.keySet())) {
                if (null == topic) {
                    this.subscribeMessage(processors);
                } else {
                    queueName = "CID_" + queueName;
                    this.subscribeMessage(topic, queueName, processors);
                }
            } else {
                logger.info("\u4e0d\u9700\u8981\u76d1\u542c\u6d88\u606f");
            }
        }
    }
}

