/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.commons.aop;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.MD5Util;
import com.dtyunxi.yundt.commons.utils.EmojiFilterUtil;
import com.dtyunxi.yundt.commons.utils.UserInfoUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public abstract class AbstractRepeatDataAspect {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRepeatDataAspect.class);
    private static final List<String> requestMethod = new ArrayList<String>();
    private static final String REPEAT_DATA_GROUP = "repeat-data";
    private static final Integer cacheTimeOut = 60;
    private static final List<String> whiteNameList = new ArrayList<String>();
    private static final ThreadLocal<String> cacheKey = new ThreadLocal();

    protected abstract void repeatDataPoint();

    @Around(value="repeatDataPoint()")
    public Object repeatDataProcess(ProceedingJoinPoint joinPoint) throws Throwable {
        String method = "";
        String url = "";
        try {
            ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            if (attributes != null) {
                HttpServletRequest request = attributes.getRequest();
                url = request.getRequestURI();
                method = request.getMethod();
                if (requestMethod.contains(method) && this.repeatDataValidator(request, joinPoint)) {
                    return new RestResponse(-1, "\u5185\u5bb9\u4e0d\u80fd\u91cd\u590d\u63d0\u4ea4\uff0c\u8bf7\u7a0d\u7b49");
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (!whiteNameList.contains(url) && requestMethod.contains(method)) {
            this.isExistEmoj(joinPoint);
        }
        Object obj = null;
        try {
            obj = joinPoint.proceed();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.getCacheService().delCache(REPEAT_DATA_GROUP, cacheKey.get());
        }
        return obj;
    }

    private Object isExistEmoj(ProceedingJoinPoint joinPoint) throws Throwable {
        try {
            MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
            Map<String, Object> paras = this.getArgsMap(methodSignature.getParameterNames(), joinPoint.getArgs());
            String source = JSON.toJSONString(paras.values());
            if (this.containsEmoji(source)) {
                return new RestResponse(-1, "\u7279\u6b8a\u8868\u60c5");
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        return null;
    }

    private boolean repeatDataValidator(HttpServletRequest request, ProceedingJoinPoint joinPoint) {
        String params = JSON.toJSONString((Object)request.getParameterMap());
        int paramsLength = 2;
        if (params == null || params.length() == paramsLength) {
            params = Arrays.toString(joinPoint.getArgs());
        }
        if (params == null || params.length() <= paramsLength) {
            return false;
        }
        Long userId = UserInfoUtil.getUserInfo();
        String url = request.getRequestURI();
        if (whiteNameList.contains(url)) {
            return false;
        }
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put(url, params);
        String nowUrlParams = MD5Util.getMd5ByString((String)(userId + ":" + ((Object)map).toString()));
        cacheKey.set(nowUrlParams);
        String preUrlParams = (String)this.getCacheService().getCache(REPEAT_DATA_GROUP, nowUrlParams, String.class);
        if (preUrlParams == null) {
            this.getCacheService().setCache(REPEAT_DATA_GROUP, nowUrlParams, (Object)cacheTimeOut, cacheTimeOut.intValue());
            return false;
        }
        return true;
    }

    protected abstract ICacheService getCacheService();

    private boolean isNotEmojiCharacter(char codePoint) {
        return codePoint == '\u0000' || codePoint == '\t' || codePoint == '\n' || codePoint == '\r' || codePoint >= ' ' && codePoint <= '\ud7ff' || codePoint >= '\ue000' && codePoint <= '\ufffd' || codePoint >= '\u10000' && codePoint <= '\u10ffff';
    }

    public boolean containsEmoji(String source) {
        int len = source.length();
        return EmojiFilterUtil.containsEmoji(source);
    }

    private Map<String, Object> getArgsMap(String[] paramsNames, Object[] objects) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        for (int i = 0; i < paramsNames.length; ++i) {
            logger.info("paramsNames:{}, value:{}", (Object)JSON.toJSONString((Object)paramsNames[i]), objects[i]);
            resultMap.put(paramsNames[i], objects[i]);
        }
        return resultMap;
    }

    public static void addWhiteName(String uri) {
        whiteNameList.add(uri);
    }

    static {
        requestMethod.add("POST");
        requestMethod.add("PUT");
        requestMethod.add("DELETE");
    }
}

