/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.commons.das;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.annotation.LogicColumn;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.AbstractCacheService;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.ds.BaseMapper;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.yundt.commons.annotation.CacheIgnore;
import com.dtyunxi.yundt.commons.utils.ReflectUtil;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.SqlUtil;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ComBaseDas<T extends BaseEo, P> {
    private static final String FIELD_VALUE_SEPARATOR = "#";
    private static final String FIELDS_SEPARATOR = ";";
    public static Integer DEFAULT_PAGE_NUMBER = 1;
    public static Integer DEFAULT_PAGE_SIZE = 10;
    private static String NULL_EXAMPLE_STR = "{}";
    private Logger logger = LoggerFactory.getLogger(ComBaseDas.class);
    protected static Set<String> defaultIgnoreFields = new HashSet<String>(20);

    protected abstract ICacheService getCacheService();

    protected abstract Map<String, BaseMapper> getMappers();

    protected abstract String getVersion();

    protected abstract ILockService getLockService();

    public BaseMapper<T> getMapper() {
        String tClassName = this.getTClassName();
        String mapperName = tClassName.substring(0, 1).toLowerCase() + tClassName.substring(1, tClassName.length() - 2) + "Mapper";
        BaseMapper mapper = this.getMappers().get(mapperName);
        if (null == mapper) {
            mapperName = tClassName.substring(0, tClassName.length() - 2) + "Mapper";
            mapper = this.getMappers().get(mapperName);
        }
        return mapper;
    }

    public Class<T> getTClass() {
        Class entityClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        return entityClass;
    }

    private String getTClassName() {
        return this.getTClass().getSimpleName();
    }

    private P getLogicKey(T record) {
        if (record != null) {
            List<Field> fields = ReflectUtil.getAllFields(record.getClass());
            for (Field field : fields) {
                if (!field.isAnnotationPresent(LogicColumn.class)) continue;
                field.setAccessible(true);
                Object objectValue = null;
                try {
                    objectValue = field.get(record);
                }
                catch (IllegalAccessException e) {
                    this.logger.error("\u83b7\u53d6\u903b\u8f91\u4e3b\u952e\u51fa\u9519", (Throwable)e);
                }
                return (P)objectValue;
            }
        }
        return null;
    }

    private T setLogicKey(P key) {
        if (key != null) {
            Class<T> entityClass = this.getTClass();
            try {
                BaseEo record = (BaseEo)entityClass.newInstance();
                List<Field> fields = ReflectUtil.getAllFields(record.getClass());
                for (Field field : fields) {
                    if (!field.isAnnotationPresent(LogicColumn.class)) continue;
                    field.setAccessible(true);
                    field.set(record, key);
                    return (T)record;
                }
            }
            catch (Exception e) {
                this.logger.error("\u8bbe\u7f6e\u903b\u8f91\u4e3b\u952e\u51fa\u9519", (Throwable)e);
            }
        }
        return null;
    }

    public String getCachePre() {
        return this.getActualArgumentClassName(0) + this.getVersion();
    }

    private String getActualArgumentClassName(int i) {
        Class entityClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[i];
        return entityClass.getSimpleName();
    }

    public void addCache(T record, Object key) {
        if (record == null) {
            this.logger.error("\u6dfb\u52a0\u7f13\u5b58\u5931\u8d25,record=null");
            return;
        }
        try {
            this.getCacheService().setCache(this.getCachePre() + key, record);
        }
        catch (Exception e) {
            this.logger.error("\u6dfb\u52a0\u7f13\u5b58\u5931\u8d25,record=" + record, (Throwable)e);
        }
    }

    private void addCache(PageInfo<T> pageInfo, String key) {
        if (pageInfo == null) {
            this.logger.error("\u6dfb\u52a0\u7f13\u5b58\u5931\u8d25,pageInfo=null");
            return;
        }
        try {
            this.getCacheService().setCache(key, pageInfo);
        }
        catch (Exception e) {
            this.logger.error("\u6dfb\u52a0\u7f13\u5b58\u5931\u8d25,pageInfo=" + pageInfo, (Throwable)e);
        }
    }

    public T getCacheByKey(Object key) {
        try {
            return (T)((BaseEo)this.getCacheService().getCache(this.getCachePre() + key, (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0]));
        }
        catch (Exception e) {
            this.logger.error("\u6839\u636e\u4e3b\u952e\u83b7\u53d6\u7f13\u5b58\u5931\u8d25\uff0c\u4e3b\u952e=" + key, (Throwable)e);
            return null;
        }
    }

    public void removeListCache(T record) {
        String globStylePattern;
        String group;
        Long id = record.getId();
        String className = this.getActualArgumentClassName(0);
        String domainIdField = className.substring(0, className.length() - 2) + "Id";
        domainIdField = StringUtils.uncapitalize((String)domainIdField);
        String pattern = "^(?=.*" + this.getCachePre() + ").(?=(.*(id" + FIELD_VALUE_SEPARATOR + id + "|" + domainIdField + FIELD_VALUE_SEPARATOR + id + ")|(?!(.*(id" + FIELD_VALUE_SEPARATOR + "|" + domainIdField + FIELD_VALUE_SEPARATOR + "))))).*";
        AbstractCacheService abstractCacheService = (AbstractCacheService)this.getCacheService();
        Set cascadedKeys = abstractCacheService.getKeys(group = abstractCacheService.getGroup(), globStylePattern = this.getCachePre() + FIELDS_SEPARATOR + "*");
        if (CollectionUtils.isEmpty((Collection)cascadedKeys)) {
            return;
        }
        for (String key : cascadedKeys) {
            boolean isMatch = Pattern.matches(pattern, key);
            if (!isMatch) continue;
            String tmp = key.replace(group + ":", "");
            this.getCacheService().delCache(tmp);
        }
    }

    public void removeCache(Object key) {
        try {
            this.getCacheService().delCache(this.getCachePre() + key);
        }
        catch (Exception e) {
            this.logger.error("\u5220\u9664\u7f13\u5b58\u5931\u8d25", (Throwable)e);
        }
    }

    public void removeCacheByExample(T record) {
        if (record != null) {
            P key = this.getLogicKey(record);
            if (key != null) {
                this.getCacheService().delCache(this.getCachePre() + key);
            }
            this.removeListCache(record);
        }
    }

    public List<T> select(T record) {
        try {
            String key = this.getCacheKey(record);
            List list = this.getCache(key);
            if ((list == null || list.size() == 0) && CollectionUtils.isNotEmpty((Collection)(list = this.getMapper().findList(record)))) {
                this.addCacheList(list, key);
            }
            return list;
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u5217\u8868\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    public List<T> select(T record, boolean cacheable) {
        if (cacheable) {
            return this.select(record);
        }
        return this.getMapper().findList(record);
    }

    private void addCacheList(List<T> list, String key) {
        this.getCacheService().rpush(key, list);
    }

    private List<T> getCache(String key) {
        if (null == key) {
            return null;
        }
        List result = this.getCacheService().getList(key, (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0]);
        return result;
    }

    private PageInfo<T> getPageCache(String key) {
        if (null == key) {
            return null;
        }
        Object json = this.getCacheService().getCache(key, Object.class);
        if (json == null) {
            return null;
        }
        String jsonStr = JSON.toJSONString((Object)json);
        Class<T> tClass = this.getTClass();
        PageInfo result = (PageInfo)JacksonUtil.readValue((String)jsonStr, PageInfo.class, (Class[])new Class[]{tClass});
        return result;
    }

    private String getCacheKey(T record) {
        String prefix = this.getCachePre() + FIELDS_SEPARATOR;
        return this.getCacheKey(record, prefix);
    }

    private String getCacheKey(Object record, String prefix) {
        ArrayList<FieldValuePair> pairList = new ArrayList<FieldValuePair>();
        this.getPairFromField(record, pairList);
        String key = "";
        if (CollectionUtils.isNotEmpty(pairList)) {
            StringBuilder sb = new StringBuilder();
            if (prefix != null) {
                sb.append(prefix);
            }
            for (FieldValuePair pair : pairList) {
                sb.append(pair.getField().getName());
                sb.append(FIELD_VALUE_SEPARATOR);
                sb.append(pair.getValue().toString());
                sb.append(FIELDS_SEPARATOR);
            }
            key = sb.toString();
            key = key.substring(0, key.length() - 1);
        }
        return key;
    }

    private void getPairFromField(Object record, List<FieldValuePair> pairList) {
        List<Field> fields = ReflectUtil.getAllFields(record.getClass());
        for (Field field : fields) {
            if (field.isAnnotationPresent(CacheIgnore.class) || defaultIgnoreFields.contains(field.getName())) continue;
            field.setAccessible(true);
            Object objectValue = null;
            try {
                objectValue = field.get(record);
                if (objectValue == null) {
                    continue;
                }
            }
            catch (IllegalAccessException e) {
                this.logger.error("\u83b7\u53d6\u7f13\u5b58\u952e\u51fa\u9519", (Throwable)e);
            }
            if (Iterable.class.isAssignableFrom(field.getType())) {
                Iterable iterable = (Iterable)objectValue;
                for (Object next : iterable) {
                    this.getPairFromField(next, pairList);
                }
                continue;
            }
            pairList.add(new FieldValuePair(field, objectValue));
        }
    }

    private String getCachePageKey(T record) {
        String key = this.getCacheKey(record);
        Page page = SqlUtil.getLocalPage();
        if (page != null) {
            String pageKey = this.getCacheKey(page, null);
            key = key + FIELDS_SEPARATOR + pageKey;
        }
        return key;
    }

    public PageInfo<T> selectPage(T record, Integer currentPage, Integer pageSize) {
        currentPage = null == currentPage ? DEFAULT_PAGE_NUMBER : currentPage;
        pageSize = null == pageSize ? DEFAULT_PAGE_SIZE : pageSize;
        PageHelper.startPage((int)currentPage, (int)pageSize);
        String key = this.getCachePageKey(record);
        PageInfo pageInfo = this.getPageCache(key);
        if (pageInfo == null) {
            List list = this.getMapper().findList(record);
            pageInfo = new PageInfo(list);
            this.addCache(pageInfo, key);
        }
        return pageInfo;
    }

    public PageInfo<T> selectPage(T record, Integer currentPage, Integer pageSize, Boolean cacheable) {
        if (cacheable != null && cacheable.booleanValue()) {
            return this.selectPage(record, currentPage, pageSize);
        }
        currentPage = null == currentPage ? DEFAULT_PAGE_NUMBER : currentPage;
        pageSize = null == pageSize ? DEFAULT_PAGE_SIZE : pageSize;
        PageHelper.startPage((int)currentPage, (int)pageSize);
        List list = this.getMapper().findList(record);
        return new PageInfo(list);
    }

    public PageInfo<T> selectPage(T record) {
        return this.selectPage(record, DEFAULT_PAGE_NUMBER, DEFAULT_PAGE_SIZE);
    }

    public PageInfo<T> selectPage(T record, Boolean cacheable) {
        if (cacheable != null && cacheable.booleanValue()) {
            return this.selectPage(record, DEFAULT_PAGE_NUMBER, DEFAULT_PAGE_SIZE);
        }
        return this.selectPage(record, DEFAULT_PAGE_NUMBER, DEFAULT_PAGE_SIZE, cacheable);
    }

    public T selectByPrimaryKey(Long key) {
        Object record = this.getCacheByKey(key);
        if (record != null) {
            return record;
        }
        record = this.getMapper().findById(this.getTClass(), key);
        if (record != null) {
            this.addCache(record, key);
        }
        return record;
    }

    public T selectByLogicKey(P key) {
        try {
            T returnRecord = this.getCacheByKey(key);
            if (returnRecord != null) {
                return returnRecord;
            }
            T record = this.setLogicKey(key);
            if (record != null && (returnRecord = this.selectOne(record)) != null) {
                this.addCache(returnRecord, key);
            }
            return returnRecord;
        }
        catch (Exception e) {
            this.logger.error("\u6839\u636e\u903b\u8f91\u4e3b\u952e\u67e5\u8be2\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    public T selectOne(T record) {
        return (T)this.getMapper().find(record);
    }

    public int count(T record) {
        try {
            return this.getMapper().countCondition(record);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u8ba1\u6570\u51fa\u9519", (Throwable)e);
            return -1;
        }
    }

    public int insert(T record) {
        this.logger.info("insert record {}", (Object)JSON.toJSONString(record));
        int result = this.getMapper().insert(record);
        this.removeListCache(record);
        return result;
    }

    public void update(T record) {
        int effectRows = this.getMapper().update(record);
        this.removeCache(record.getId());
        this.removeCacheByExample(record);
    }

    public void updateSelective(T record) {
        int effectRows = this.getMapper().updateSelective(record);
        this.removeCache(record.getId());
        this.removeCacheByExample(record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWithLock(T record) {
        block5: {
            block6: {
                if (this.getLockService() == null) {
                    throw new BusinessRuntimeException("updateWithLock must set the lockService");
                }
                if (record == null || !StringUtils.isNotBlank((CharSequence)record.tableName()) || record.getId() == null) break block6;
                Mutex mutex = null;
                try {
                    mutex = this.getLockService().lock(record.tableName(), record.getId());
                    this.update(record);
                }
                catch (Exception e) {
                    try {
                        this.logger.error("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25,tableName:{},id:{}", new Object[]{record.tableName(), record.getId(), e});
                    }
                    catch (Throwable throwable) {
                        this.getLockService().unlock(mutex);
                        throw throwable;
                    }
                    this.getLockService().unlock(mutex);
                    break block5;
                }
                this.getLockService().unlock(mutex);
                break block5;
            }
            this.logger.error("record && record's tableName && record's id must be not null!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSelectiveWithLock(T record) {
        block5: {
            block6: {
                if (this.getLockService() == null) {
                    throw new BusinessRuntimeException("updateWithLock must set the lockService");
                }
                if (record == null || !StringUtils.isNotBlank((CharSequence)record.tableName()) || record.getId() == null) break block6;
                Mutex mutex = null;
                try {
                    mutex = this.getLockService().lock(record.tableName(), record.getId());
                    this.updateSelective(record);
                }
                catch (Exception e) {
                    try {
                        this.logger.error("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25,tableName:{},id:{}", new Object[]{record.tableName(), record.getId(), e});
                    }
                    catch (Throwable throwable) {
                        this.getLockService().unlock(mutex);
                        throw throwable;
                    }
                    this.getLockService().unlock(mutex);
                    break block5;
                }
                this.getLockService().unlock(mutex);
                break block5;
            }
            this.logger.error("record && record's tableName && record's id must be not null!");
        }
    }

    public void updateSelectiveSqlFilter(T record) {
        this.getMapper().updateSelectiveSqlFilter(record);
        try {
            this.removeCache(record.getId());
            this.removeCacheByExample(record);
        }
        catch (Exception e) {
            this.logger.error("updateSelectiveSqlFilter \u79fb\u9664\u8bb0\u5f55 {} \u7f13\u5b58\u5931\u8d25", record, (Object)e);
        }
    }

    public void delete(T record) {
        this.deleteByExample(record, false);
    }

    public void logicDelete(T record) {
        this.deleteByExample(record, true);
        this.removeCache(record.getId());
        this.removeCacheByExample(record);
    }

    public void deleteById(Long id) {
        T record = this.selectByPrimaryKey(id);
        this.getMapper().deleteById(this.getTClass(), id);
        this.removeCache(id);
        this.removeCacheByExample(record);
    }

    public void logicDeleteById(Long id) {
        T record = this.selectByPrimaryKey(id);
        this.removeCache(id);
        this.removeCacheByExample(record);
        this.getMapper().deleteLogicById(this.getTClass(), id, Boolean.valueOf(true));
    }

    public void logicDeleteByExample(T example) {
        this.deleteByExample(example, true);
    }

    public void deleteByExample(T example) {
        this.deleteByExample(example, false);
    }

    private int deleteByExample(T example, Boolean isLogicDelete) {
        String json = JSON.toJSONString(example);
        if (NULL_EXAMPLE_STR.equals(json)) {
            return 0;
        }
        List<T> records = this.select(example);
        if (records.isEmpty()) {
            return 0;
        }
        List<Long> ids = this.getIds(records);
        int effects = this.getMapper().deleteLogicBatchIds(this.getTClass(), ids.toArray(new Long[ids.size()]), isLogicDelete);
        for (BaseEo record : records) {
            this.removeCache(record.getId());
            this.removeCacheByExample(record);
        }
        return effects;
    }

    public void deleteByLogicKey(P key) {
        this.removeCache(key);
        T record = this.setLogicKey(key);
        if (record != null) {
            this.getMapper().delete(record);
            this.removeCache(record.getId());
            this.removeCacheByExample(record);
        }
    }

    public void logicDeleteByLogicKey(P key) {
        this.removeCache(key);
        T record = this.setLogicKey(key);
        if (record != null) {
            this.getMapper().deleteLogic(record, Boolean.valueOf(true));
            this.removeCache(record.getId());
            this.removeCacheByExample(record);
        }
    }

    public int insertBatch(List<T> records) {
        if (records.isEmpty()) {
            return 0;
        }
        return this.getMapper().insertBatch(records);
    }

    public List<Long> getIds(List<T> tList) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (BaseEo t : tList) {
            ids.add(t.getId());
        }
        return ids;
    }

    public int insertBatchByExample(List<T> tList, T example) {
        String json = JSON.toJSONString(example);
        if (NULL_EXAMPLE_STR.equals(json)) {
            return 0;
        }
        int effectRows = 0;
        if (tList.isEmpty()) {
            return effectRows;
        }
        effectRows = this.deleteByExample(example, false);
        return (effectRows += this.insertBatch(tList)) + tList.size();
    }

    public List<T> selectAll() {
        return this.getMapper().findAll(this.getTClass());
    }

    static {
        defaultIgnoreFields.add("createPerson");
        defaultIgnoreFields.add("createTime");
        defaultIgnoreFields.add("updatePerson");
        defaultIgnoreFields.add("updateTime");
        defaultIgnoreFields.add("serialVersionUID");
        defaultIgnoreFields.add("logger");
        defaultIgnoreFields.add("mapColumns");
        defaultIgnoreFields.add("mapId");
        defaultIgnoreFields.add("EO_ATTRIBUTE");
        defaultIgnoreFields.add("TAB_COLUMN");
        defaultIgnoreFields.add("MAX_ARRAY_SIZE");
        defaultIgnoreFields.add("modCount");
        defaultIgnoreFields.add("elementData");
        defaultIgnoreFields.add("DEFAULTCAPACITY_EMPTY_ELEMENTDATA");
        defaultIgnoreFields.add("EMPTY_ELEMENTDATA");
        defaultIgnoreFields.add("DEFAULT_CAPACITY");
    }

    class FieldValuePair {
        Field field;
        Object value;

        public FieldValuePair(Field field, Object value) {
            this.field = field;
            this.value = value;
        }

        public Field getField() {
            return this.field;
        }

        public void setField(Field field) {
            this.field = field;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }
}

