/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.commons.service;

import com.github.pagehelper.PageInfo;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public abstract class AbstractService<T, V> {
    private static Logger logger = LoggerFactory.getLogger(AbstractService.class);

    protected T newTInstance(V vo) throws Exception {
        if (vo != null) {
            try {
                Class entityClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
                Object t = entityClass.newInstance();
                BeanUtils.copyProperties(vo, t);
                return t;
            }
            catch (ClassCastException ce) {
                return (T)vo;
            }
            catch (Exception e) {
                throw e;
            }
        }
        return null;
    }

    protected PageInfo<T> copyPage(PageInfo<V> pageV) {
        PageInfo pageT = new PageInfo();
        try {
            BeanUtils.copyProperties(pageV, (Object)pageT);
            pageT.setList(this.copyList(pageV.getList()));
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        return pageT;
    }

    protected List<T> copyList(List<V> listV) {
        ArrayList<T> tList = new ArrayList<T>();
        try {
            if (listV.isEmpty()) {
                return tList;
            }
            for (V v : listV) {
                T t = this.convert(v);
                tList.add(t);
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        return tList;
    }

    public T convert(V v) throws Exception {
        return this.newTInstance(v);
    }
}

