/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.commons.utils;

import com.dtyunxi.yundt.commons.constant.enums.StatusCode;
import com.dtyunxi.yundt.commons.exception.CommonBusinessRuntimeException;

public final class BusinessValidationUtil {
    public static void badRequestIfNull(Object obj) {
        BusinessValidationUtil.badRequestIf(null == obj, StatusCode.PARAM_NULL.getResultMsg());
    }

    public static void badRequestIf(boolean test) {
        BusinessValidationUtil.badRequestIf(test, StatusCode.PARAM_ERROR.getResultMsg());
    }

    public static void badRequestIf(boolean test, String businessErrorMsg) {
        if (test) {
            throw new CommonBusinessRuntimeException(businessErrorMsg);
        }
    }

    public static void forbiddenIfNull(Object obj) {
        if (null == obj) {
            BusinessValidationUtil.forbidden();
        }
    }

    public static void notFoundIfNull(Object obj) {
        BusinessValidationUtil.notFoundIf(null == obj);
    }

    public static void notFoundIf(boolean test) {
        if (test) {
            BusinessValidationUtil.notFound();
        }
    }

    public static void notFoundIfNull(Object obj, StatusCode statusCode) {
        if (null == obj) {
            throw new CommonBusinessRuntimeException(statusCode.getResultMsg());
        }
    }

    public static void notFound() {
        throw new CommonBusinessRuntimeException(StatusCode.NOT_FOUND.getResultMsg());
    }

    public static void forbidden() {
        throw new CommonBusinessRuntimeException(StatusCode.FORBIDDEN.getResultMsg());
    }

    public static void systemError() {
        throw new CommonBusinessRuntimeException(StatusCode.SYS_ERROR.getResultMsg());
    }

    public static <T extends CommonBusinessRuntimeException> void badRequestIfNull(Object obj, Class<T> clz) {
        BusinessValidationUtil.badRequestIf(null == obj, StatusCode.PARAM_NULL.getResultMsg(), clz);
    }

    public static <T extends CommonBusinessRuntimeException> void badRequestIf(boolean test, Class<T> clz) {
        BusinessValidationUtil.badRequestIf(test, StatusCode.PARAM_ERROR.getResultMsg(), clz);
    }

    public static <T extends CommonBusinessRuntimeException> void badRequestIf(boolean test, String businessErrorMsg, Class<T> clz) {
        if (test) {
            BusinessValidationUtil.throwException(businessErrorMsg, clz);
        }
    }

    public static <T extends CommonBusinessRuntimeException> void forbiddenIfNull(Object obj, Class<T> clz) {
        if (null == obj) {
            BusinessValidationUtil.forbidden(clz);
        }
    }

    public static <T extends CommonBusinessRuntimeException> void forbidden(Class<T> clz) {
        BusinessValidationUtil.throwException(StatusCode.FORBIDDEN.getResultMsg(), clz);
    }

    public static <T extends CommonBusinessRuntimeException> void notFoundIfNull(Object obj, Class<T> clz) {
        BusinessValidationUtil.notFoundIf(null == obj, clz);
    }

    public static <T extends CommonBusinessRuntimeException> void notFoundIf(boolean test, Class<T> clz) {
        if (test) {
            BusinessValidationUtil.throwException(StatusCode.NOT_FOUND.getResultMsg(), clz);
        }
    }

    public static <T extends CommonBusinessRuntimeException> void systemError(Class<T> clz) {
        BusinessValidationUtil.throwException(StatusCode.SYS_ERROR.getResultMsg(), clz);
    }

    public static <T extends CommonBusinessRuntimeException> void throwException(String businessErrorMsg, Class<T> clz) {
        CommonBusinessRuntimeException ex = null;
        try {
            ex = (CommonBusinessRuntimeException)((Object)clz.getConstructor(String.class).newInstance(businessErrorMsg));
        }
        catch (Exception e) {
            BusinessValidationUtil.systemError();
        }
        throw ex;
    }
}

