/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.commons.utils;

import org.apache.commons.lang3.StringUtils;

public class EmojiFilterUtil {
    public static boolean containsEmoji(String source) {
        int len = source.length();
        boolean isEmoji = false;
        for (int i = 0; i < len; ++i) {
            char ls;
            char hs = source.charAt(i);
            if ('\ud800' <= hs && hs <= '\udbff') {
                int uc;
                if (source.length() <= 1 || 118784 > (uc = (hs - 55296) * 1024 + ((ls = source.charAt(i + 1)) - 56320) + 65536) || uc > 128895) continue;
                return true;
            }
            if ('\u2100' <= hs && hs <= '\u27ff' && hs != '\u263b') {
                return true;
            }
            if ('\u2b05' <= hs && hs <= '\u2b07') {
                return true;
            }
            if ('\u2934' <= hs && hs <= '\u2935') {
                return true;
            }
            if ('\u3297' <= hs && hs <= '\u3299') {
                return true;
            }
            if (hs == '\u00a9' || hs == '\u00ae' || hs == '\u303d' || hs == '\u3030' || hs == '\u2b55' || hs == '\u2b1c' || hs == '\u2b1b' || hs == '\u2b50' || hs == '\u231a') {
                return true;
            }
            if (isEmoji || source.length() <= 1 || i >= source.length() - 1 || (ls = source.charAt(i + 1)) != '\u20e3') continue;
            return true;
        }
        return isEmoji;
    }

    private static boolean isEmojiCharacter(char codePoint) {
        return codePoint == '\u0000' || codePoint == '\t' || codePoint == '\n' || codePoint == '\r' || codePoint >= ' ' && codePoint <= '\ud7ff' || codePoint >= '\ue000' && codePoint <= '\ufffd' || codePoint >= '\u10000' && codePoint <= '\u10ffff';
    }

    public static String filterEmoji(String source) {
        if (StringUtils.isBlank((CharSequence)source)) {
            return source;
        }
        StringBuilder buf = null;
        int len = source.length();
        for (int i = 0; i < len; ++i) {
            char codePoint = source.charAt(i);
            if (!EmojiFilterUtil.isEmojiCharacter(codePoint)) continue;
            if (buf == null) {
                buf = new StringBuilder(source.length());
            }
            buf.append(codePoint);
        }
        if (buf == null) {
            return source;
        }
        if (buf.length() == len) {
            buf = null;
            return source;
        }
        return buf.toString();
    }
}

