/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.meta.biz.service;

import com.dtyunxi.yundt.cube.center.meta.api.dto.FileDownloadDto;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface IFileDownloadService<T> {
    public static final Logger LOGGER = LoggerFactory.getLogger(IFileDownloadService.class);

    public void process(T var1, HttpServletResponse var2, HttpServletRequest var3);

    public String fileType();

    public static void setFileDownloadHeader(HttpServletResponse response, String filename) {
        String headerValue = "attachment;";
        headerValue = headerValue + " filename=\"" + IFileDownloadService.encodeURIComponent(filename) + "\";";
        headerValue = headerValue + " filename*=utf-8''" + IFileDownloadService.encodeURIComponent(filename);
        response.setHeader("Content-Disposition", headerValue);
    }

    public static String encodeURIComponent(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.warn("uri\u7f16\u7801\u5f02\u5e38\uff1a", (Throwable)e);
            return null;
        }
    }

    default public void download(FileDownloadDto fileDownloadDto, HttpServletResponse response, HttpServletRequest request, CallBack callBack) {
        try {
            IFileDownloadService.setFileDownloadHeader(response, fileDownloadDto.getFileName());
            response.setContentType("application/x-msdownload;charset=utf-8");
            response.setCharacterEncoding("UTF-8");
            callBack.onEvent();
        }
        catch (Exception e) {
            LOGGER.warn("\u4e0b\u8f7d\u5f02\u5e38");
        }
    }

    public static interface CallBack {
        public void onEvent();
    }
}

