/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.meta.biz.service.impl;

import com.dtyunxi.yundt.cube.center.meta.api.dto.FileDownloadDto;
import com.dtyunxi.yundt.cube.center.meta.api.dto.request.DataDefinitionLanguageFileDto;
import com.dtyunxi.yundt.cube.center.meta.biz.service.IFileDownloadService;
import com.dtyunxi.yundt.cube.center.meta.biz.service.IMetaService;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="dataDefinitionLanguageFileDownloadService")
public class DataDefinitionLanguageFileDownloadServiceImpl
implements IFileDownloadService<DataDefinitionLanguageFileDto> {
    @Autowired
    private IMetaService metaService;

    @Override
    public String fileType() {
        return ".sql";
    }

    @Override
    public void process(DataDefinitionLanguageFileDto dataDefinitionLanguageFileDto, HttpServletResponse response, HttpServletRequest request) {
        FileDownloadDto fileDownloadDto = new FileDownloadDto();
        fileDownloadDto.setFileName(String.format("ddl%s", this.fileType()));
        fileDownloadDto.setDataDefinitionLanguageFileDto(dataDefinitionLanguageFileDto);
        List<String> ddlResults = this.metaService.sqlGenerator(dataDefinitionLanguageFileDto.getEntityIds());
        this.download(fileDownloadDto, response, request, () -> {
            try {
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)response.getOutputStream());
                for (String ddlResult : ddlResults) {
                    bufferedOutputStream.write(ddlResult.getBytes());
                    bufferedOutputStream.write("\n".getBytes());
                }
                bufferedOutputStream.close();
            }
            catch (IOException e) {
                LOGGER.warn("DDL\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38\uff1a", (Throwable)e);
            }
        });
    }

    private void testDdlContests(List<String> ddlResults) {
        ddlResults.add("drop table test;");
        ddlResults.add("drop table test2;");
    }
}

