/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.meta.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.meta.api.constants.AttributeIsCalcFactorEnum;
import com.dtyunxi.yundt.cube.center.meta.api.constants.ContainerType;
import com.dtyunxi.yundt.cube.center.meta.api.constants.EntityIsControlledEnum;
import com.dtyunxi.yundt.cube.center.meta.api.dto.request.AppCreateReqDto;
import com.dtyunxi.yundt.cube.center.meta.api.dto.request.AppModifyReqDto;
import com.dtyunxi.yundt.cube.center.meta.api.dto.request.AppQueryReqDto;
import com.dtyunxi.yundt.cube.center.meta.api.dto.request.AttributeDto;
import com.dtyunxi.yundt.cube.center.meta.api.dto.request.DomainDto;
import com.dtyunxi.yundt.cube.center.meta.api.dto.request.EntityControlledReqDto;
import com.dtyunxi.yundt.cube.center.meta.api.dto.request.EntityDto;
import com.dtyunxi.yundt.cube.center.meta.api.dto.request.FormConditionDto;
import com.dtyunxi.yundt.cube.center.meta.api.dto.request.FormDto;
import com.dtyunxi.yundt.cube.center.meta.api.dto.request.ModuleCreateReqDto;
import com.dtyunxi.yundt.cube.center.meta.api.dto.request.ModuleModifyReqDto;
import com.dtyunxi.yundt.cube.center.meta.api.dto.request.ModuleQueryReqDto;
import com.dtyunxi.yundt.cube.center.meta.api.dto.request.SourceAttrReqDto;
import com.dtyunxi.yundt.cube.center.meta.api.dto.response.AppRespDto;
import com.dtyunxi.yundt.cube.center.meta.api.dto.response.ModuleRespDto;
import com.dtyunxi.yundt.cube.center.meta.api.dto.response.SourceAttrRespDto;
import com.dtyunxi.yundt.cube.center.meta.biz.service.IMetaContainerDefService;
import com.dtyunxi.yundt.cube.center.meta.biz.service.IMetaService;
import com.dtyunxi.yundt.cube.center.meta.dao.das.AppDas;
import com.dtyunxi.yundt.cube.center.meta.dao.das.AppModuleRelationDas;
import com.dtyunxi.yundt.cube.center.meta.dao.das.AttributeDas;
import com.dtyunxi.yundt.cube.center.meta.dao.das.DomainDas;
import com.dtyunxi.yundt.cube.center.meta.dao.das.EntityDas;
import com.dtyunxi.yundt.cube.center.meta.dao.das.FormDas;
import com.dtyunxi.yundt.cube.center.meta.dao.das.MetaModuleDas;
import com.dtyunxi.yundt.cube.center.meta.dao.eo.AppEo;
import com.dtyunxi.yundt.cube.center.meta.dao.eo.AppModuleRelationEo;
import com.dtyunxi.yundt.cube.center.meta.dao.eo.AttributeEo;
import com.dtyunxi.yundt.cube.center.meta.dao.eo.DomainEo;
import com.dtyunxi.yundt.cube.center.meta.dao.eo.EntityEo;
import com.dtyunxi.yundt.cube.center.meta.dao.eo.FormEo;
import com.dtyunxi.yundt.cube.center.meta.dao.eo.MetaModuleEo;
import com.dtyunxi.yundt.cube.center.meta.dao.eo.StdDomainEo;
import com.dtyunxi.yundt.cube.center.meta.dao.vo.SourceAttrQueryVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import io.jsonwebtoken.lang.Assert;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MetaServiceImpl
implements IMetaService {
    private static final Logger logger = LoggerFactory.getLogger(MetaServiceImpl.class);
    @Resource
    private AttributeDas attributeDas;
    @Resource
    private FormDas formDas;
    @Resource
    private DomainDas domainDas;
    @Resource
    private EntityDas entityDas;
    @Resource
    private AppDas appDas;
    @Resource
    private IMetaContainerDefService metaContainerDefService;
    @Resource(name="metaModuleDas")
    private MetaModuleDas metaModuleDas;
    @Resource
    private AppModuleRelationDas appModuleRelationDas;

    @Override
    public List<DomainEo> queryDomainByCodes(List<String> domainCodes) {
        if (CollectionUtils.isEmpty(domainCodes)) {
            return new ArrayList<DomainEo>();
        }
        DomainEo domainEo = new DomainEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"code", (Object)StringUtils.join(domainCodes, (String)",")));
        domainEo.setSqlFilters(sqlFilters);
        return this.domainDas.select((BaseEo)domainEo);
    }

    @Override
    public void updateDomainSort(List<DomainEo> domainEos) {
        if (CollectionUtils.isNotEmpty(domainEos)) {
            Map<String, DomainEo> code2Eo = domainEos.stream().collect(Collectors.toMap(StdDomainEo::getCode, v -> v, (v1, v2) -> v1));
            List<DomainEo> results = this.queryDomainByCodes(new ArrayList<String>(code2Eo.keySet()));
            for (DomainEo domainEo : results) {
                DomainEo paramEo = code2Eo.get(domainEo.getCode());
                if (paramEo == null) continue;
                domainEo.setSort(paramEo.getSort());
                this.domainDas.updateSelective((BaseEo)domainEo);
            }
        }
    }

    @Override
    public PageInfo<DomainDto> queryDomainByPage(DomainDto domainDto, Integer pageNum, Integer pageSize) {
        DomainEo domainEo = new DomainEo();
        DtoHelper.dto2Eo((BaseVo)domainDto, (BaseEo)domainEo);
        if (StringUtils.isNotBlank((CharSequence)domainEo.getName())) {
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.like((String)"name", (Object)("%" + domainEo.getName() + "%")));
            domainEo.setSqlFilters(sqlFilters);
        }
        domainEo.setOrderBy("code");
        PageInfo eoPageInfo = this.domainDas.selectPage((BaseEo)domainEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, DomainDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public DomainDto getDomain(Long domainId) {
        DomainEo domainEo = (DomainEo)this.domainDas.selectByPrimaryKey(domainId);
        Assert.isTrue((domainEo != null ? 1 : 0) != 0, (String)"\u6570\u636e\u4e0d\u5b58\u5728");
        DomainDto domainDto = new DomainDto();
        DtoHelper.eo2Dto((BaseEo)domainEo, (BaseVo)domainDto);
        return domainDto;
    }

    @Override
    public void addDomain(DomainDto domainDto) {
        DomainEo domainEo = new DomainEo();
        DtoHelper.dto2Eo((BaseVo)domainDto, (BaseEo)domainEo);
        domainEo.setId(null);
        this.domainDas.insert((BaseEo)domainEo);
    }

    @Override
    public void modifyDomain(DomainDto domainDto) {
        DomainEo domainEo = new DomainEo();
        DtoHelper.dto2Eo((BaseVo)domainDto, (BaseEo)domainEo);
        this.domainDas.updateSelective((BaseEo)domainEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delDomain(Long domainId) {
        this.domainDas.deleteById(domainId);
        EntityEo entityEo = EntityEo.newInstance();
        entityEo.setDomainId(domainId);
        List entityEos = this.entityDas.select((BaseEo)entityEo);
        if (CollectionUtils.isNotEmpty((Collection)entityEos)) {
            ArrayList<Long> entityIds = new ArrayList<Long>();
            for (EntityEo eo : entityEos) {
                this.entityDas.delete((BaseEo)eo);
                entityIds.add(eo.getId());
            }
            if (CollectionUtils.isNotEmpty(entityIds)) {
                ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
                sqlFilters.add(SqlFilter.in((String)"entity_id", (Object)StringUtils.join(entityIds, (String)",")));
                AttributeEo attributeEo = AttributeEo.newInstance();
                attributeEo.setSqlFilters(sqlFilters);
                this.attributeDas.delete((BaseEo)attributeEo);
            }
        }
    }

    @Override
    public PageInfo<EntityDto> queryEntityByPage(EntityDto entityDto, Integer pageNum, Integer pageSize) {
        EntityEo entityEo = new EntityEo();
        DtoHelper.dto2Eo((BaseVo)entityDto, (BaseEo)entityEo);
        PageInfo eoPageInfo = this.entityDas.selectPage((BaseEo)entityEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList<EntityDto> dtoList = new ArrayList<EntityDto>();
        if (CollectionUtils.isNotEmpty((Collection)eoPageInfo.getList())) {
            for (EntityEo eo : eoPageInfo.getList()) {
                EntityDto dto = new EntityDto();
                DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)dto);
                AttributeEo attributeEo = AttributeEo.newInstance();
                attributeEo.setEntityId(eo.getId());
                List attributeEos = this.attributeDas.select((BaseEo)attributeEo);
                ArrayList attributeDtoList = new ArrayList();
                if (CollectionUtils.isNotEmpty((Collection)attributeEos)) {
                    DtoHelper.eoList2DtoList((Collection)attributeEos, attributeDtoList, AttributeDto.class);
                }
                dto.setAttributeDtoList(attributeDtoList);
                dtoList.add(dto);
            }
        }
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public PageInfo<EntityDto> queryControlledEntityByPage(EntityControlledReqDto entityControlledReqDto, Integer pageNum, Integer pageSize) {
        EntityEo entityEo = new EntityEo();
        entityEo.setIsControlled(EntityIsControlledEnum.Y.getCode());
        DtoHelper.dto2Eo((BaseVo)entityControlledReqDto, (BaseEo)entityEo);
        PageInfo eoPageInfo = this.entityDas.selectPage((BaseEo)entityEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList<EntityDto> dtoList = new ArrayList<EntityDto>();
        if (CollectionUtils.isNotEmpty((Collection)eoPageInfo.getList())) {
            for (EntityEo eo : eoPageInfo.getList()) {
                EntityDto dto = new EntityDto();
                DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)dto);
                AttributeEo attributeEo = AttributeEo.newInstance();
                attributeEo.setEntityId(eo.getId());
                attributeEo.setIsCalcFactor(AttributeIsCalcFactorEnum.Y.getCode());
                List attributeEos = this.attributeDas.select((BaseEo)attributeEo, Integer.valueOf(1), Integer.valueOf(1000));
                ArrayList attributeDtoList = new ArrayList();
                if (CollectionUtils.isNotEmpty((Collection)attributeEos)) {
                    DtoHelper.eoList2DtoList((Collection)attributeEos, attributeDtoList, AttributeDto.class);
                }
                dto.setAttributeDtoList(attributeDtoList);
                dtoList.add(dto);
            }
        }
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public EntityDto queryEntityById(Long entityId) {
        EntityEo entityEo = (EntityEo)this.entityDas.selectByPrimaryKey(entityId);
        Assert.isTrue((entityEo != null ? 1 : 0) != 0, (String)"\u6570\u636e\u4e0d\u5b58\u5728");
        AttributeEo attributeEo = AttributeEo.newInstance();
        attributeEo.setEntityId(entityId);
        List attributeEos = this.attributeDas.select((BaseEo)attributeEo);
        ArrayList attributeDtoList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)attributeEos)) {
            DtoHelper.eoList2DtoList((Collection)attributeEos, attributeDtoList, AttributeDto.class);
        }
        EntityDto entityDto = new EntityDto();
        DtoHelper.eo2Dto((BaseEo)entityEo, (BaseVo)entityDto);
        entityDto.setAttributeDtoList(attributeDtoList);
        return entityDto;
    }

    @Override
    public EntityDto queryEntityByCode(String entityCode) {
        EntityEo entityEo = this.getEntityEo(entityCode);
        AttributeEo attributeEo = AttributeEo.newInstance();
        attributeEo.setEntityId(entityEo.getId());
        List attributeEos = this.attributeDas.select((BaseEo)attributeEo);
        ArrayList attributeDtoList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)attributeEos)) {
            DtoHelper.eoList2DtoList((Collection)attributeEos, attributeDtoList, AttributeDto.class);
        }
        EntityDto entityDto = new EntityDto();
        DtoHelper.eo2Dto((BaseEo)entityEo, (BaseVo)entityDto);
        entityDto.setAttributeDtoList(attributeDtoList);
        return entityDto;
    }

    private EntityEo getEntityEo(String entityCode) {
        EntityEo queryEo = new EntityEo();
        queryEo.setCode(entityCode);
        List entityList = this.entityDas.select((BaseEo)queryEo);
        Assert.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)entityList), (String)(entityCode + "\u5b9e\u4f53\u6570\u636e\u4e0d\u5b58\u5728"));
        return (EntityEo)entityList.get(0);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addEntity(EntityDto entityDto) {
        EntityEo entityEo = new EntityEo();
        DtoHelper.dto2Eo((BaseVo)entityDto, (BaseEo)entityEo);
        entityEo.setId(null);
        if (StringUtils.isBlank((CharSequence)entityDto.getExtension())) {
            entityEo.setExtension("");
        }
        this.entityDas.insert((BaseEo)entityEo);
        if (CollectionUtils.isNotEmpty((Collection)entityDto.getAttributeDtoList())) {
            List attributeEos = entityDto.getAttributeDtoList().stream().map(dto -> {
                AttributeEo attributeEo = AttributeEo.newInstance();
                DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)attributeEo);
                attributeEo.setEntityId(entityEo.getId());
                if (StringUtils.isBlank((CharSequence)dto.getExtension())) {
                    attributeEo.setExtension("");
                }
                return attributeEo;
            }).collect(Collectors.toList());
            this.attributeDas.insertBatch(attributeEos);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyEntity(EntityDto entityDto) {
        Long entityId = entityDto.getId();
        Assert.isTrue((entityId != null ? 1 : 0) != 0, (String)"id\u4e0d\u80fd\u4e3aNull");
        Assert.isTrue((this.entityDas.selectByPrimaryKey(entityId) != null ? 1 : 0) != 0, (String)"\u6570\u636e\u4e0d\u5b58\u5728");
        EntityEo entityEo = new EntityEo();
        DtoHelper.dto2Eo((BaseVo)entityDto, (BaseEo)entityEo);
        this.entityDas.updateSelective((BaseEo)entityEo);
        if (CollectionUtils.isNotEmpty((Collection)entityDto.getAttributeDtoList())) {
            AttributeEo deleteEo = AttributeEo.newInstance();
            deleteEo.setEntityId(entityId);
            this.attributeDas.delete((BaseEo)deleteEo);
            List attributeEos = entityDto.getAttributeDtoList().stream().map(dto -> {
                AttributeEo attributeEo = AttributeEo.newInstance();
                DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)attributeEo);
                attributeEo.setEntityId(entityEo.getId());
                if (StringUtils.isBlank((CharSequence)dto.getExtension())) {
                    attributeEo.setExtension("");
                }
                return attributeEo;
            }).collect(Collectors.toList());
            this.attributeDas.insertBatch(attributeEos);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delEntity(Long entityId) {
        this.entityDas.deleteById(entityId);
        AttributeEo deleteEo = AttributeEo.newInstance();
        deleteEo.setEntityId(entityId);
        this.attributeDas.delete((BaseEo)deleteEo);
    }

    @Override
    public FormDto getForm(Long formId) {
        FormEo formEo = (FormEo)this.formDas.selectByPrimaryKey(formId);
        Assert.isTrue((formEo != null ? 1 : 0) != 0, (String)"\u6570\u636e\u4e0d\u5b58\u5728");
        FormDto formDto = new FormDto();
        DtoHelper.eo2Dto((BaseEo)formEo, (BaseVo)formDto);
        return formDto;
    }

    @Override
    public PageInfo<FormDto> queryFormByPage(FormDto formDto, Integer pageNum, Integer pageSize) {
        FormEo formEo = new FormEo();
        DtoHelper.dto2Eo((BaseVo)formDto, (BaseEo)formEo);
        PageInfo eoPageInfo = this.formDas.selectPage((BaseEo)formEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)eoPageInfo.getList())) {
            DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, FormDto.class);
        }
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public void modifyForm(FormDto formDto) {
        Assert.isTrue((formDto.getId() != null ? 1 : 0) != 0, (String)"id\u4e0d\u80fd\u4e3aNull");
        FormEo queryEo = FormEo.newInstance();
        queryEo.setModule(formDto.getModule());
        queryEo.setRoute(formDto.getRoute());
        List results = this.formDas.select((BaseEo)queryEo);
        if (CollectionUtils.isNotEmpty((Collection)results)) {
            Assert.isTrue((results.size() == 1 ? 1 : 0) != 0, (String)"\u4e00\u822c\u671f\u5f85\u6570\u636e\u53ea\u6709\u4e00\u6761");
            if (!((FormEo)results.get(0)).getId().equals(formDto.getId())) {
                throw new BizException(formDto.getModule() + formDto.getRoute() + "\u4fe1\u606f\u5df2\u5b58\u5728");
            }
        }
        FormEo formEo = new FormEo();
        DtoHelper.dto2Eo((BaseVo)formDto, (BaseEo)formEo);
        this.formDas.updateSelective((BaseEo)formEo);
    }

    @Override
    public void addForm(FormDto formDto) {
        FormEo queryEo = FormEo.newInstance();
        queryEo.setModule(formDto.getModule());
        queryEo.setRoute(formDto.getRoute());
        List results = this.formDas.select((BaseEo)queryEo);
        Assert.isTrue((boolean)CollectionUtils.isEmpty((Collection)results), (String)(formDto.getModule() + formDto.getRoute() + "\u4fe1\u606f\u5df2\u5b58\u5728"));
        FormEo formEo = new FormEo();
        DtoHelper.dto2Eo((BaseVo)formDto, (BaseEo)formEo);
        formEo.setId(null);
        if (StringUtils.isBlank((CharSequence)formDto.getExtension())) {
            formEo.setExtension("");
        }
        this.formDas.insert((BaseEo)formEo);
    }

    @Override
    public void processFormByCondition(FormConditionDto formConditionDto) {
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)formConditionDto.getModule()), (String)"\u6240\u5c5e\u6a21\u5757Module\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)formConditionDto.getRoute()), (String)"\u9875\u9762\u8def\u7531Route\u4e0d\u80fd\u4e3a\u7a7a");
        FormEo queryEo = FormEo.newInstance();
        queryEo.setModule(formConditionDto.getModule());
        queryEo.setRoute(formConditionDto.getRoute());
        List results = this.formDas.select((BaseEo)queryEo);
        if (CollectionUtils.isNotEmpty((Collection)results)) {
            Assert.isTrue((results.size() == 1 ? 1 : 0) != 0, (String)"\u4e00\u822c\u671f\u5f85\u6570\u636e\u53ea\u6709\u4e00\u6761");
            FormEo updateEo = FormEo.newInstance();
            DtoHelper.dto2Eo((BaseVo)formConditionDto, (BaseEo)updateEo);
            updateEo.setId(((FormEo)results.get(0)).getId());
            this.formDas.updateSelective((BaseEo)updateEo);
        } else {
            FormEo insertEo = FormEo.newInstance();
            DtoHelper.dto2Eo((BaseVo)formConditionDto, (BaseEo)insertEo);
            this.formDas.insert((BaseEo)insertEo);
        }
    }

    @Override
    public void delForm(Long formId) {
        this.formDas.deleteById(formId);
    }

    @Override
    public List<String> sqlGenerator(List<Long> entityIdList) {
        ArrayList<String> sqlList = new ArrayList<String>();
        for (Long entityId : entityIdList) {
            EntityEo entityEo = (EntityEo)this.entityDas.selectByPrimaryKey(entityId);
            AttributeEo attributeEo = AttributeEo.newInstance();
            attributeEo.setEntityId(entityId);
            List attributeEoList = this.attributeDas.select((BaseEo)attributeEo);
            if (!CollectionUtils.isNotEmpty((Collection)attributeEoList)) continue;
            String sql = this.generateSql(attributeEoList, entityEo.getCode(), entityEo.getName(), entityEo.getRemark());
            sqlList.add(sql);
        }
        return sqlList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long createApp(AppCreateReqDto appCreateReqDto) {
        AppEo checkCodeEo = new AppEo();
        checkCodeEo.setCode(appCreateReqDto.getCode());
        Assert.isTrue((boolean)CollectionUtils.isEmpty((Collection)this.appDas.select((BaseEo)checkCodeEo)), (String)"11001\u5e94\u7528\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u91cd\u8f93");
        AppEo checkNameEo = new AppEo();
        checkNameEo.setName(appCreateReqDto.getName());
        Assert.isTrue((boolean)CollectionUtils.isEmpty((Collection)this.appDas.select((BaseEo)checkNameEo)), (String)"11001\u5e94\u7528\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u91cd\u8f93");
        AppEo appEo = new AppEo();
        DtoHelper.dto2Eo((BaseVo)appCreateReqDto, (BaseEo)appEo);
        appEo.setType(this.getType(appCreateReqDto.getType()));
        this.appDas.insert((BaseEo)appEo);
        if (CollectionUtils.isNotEmpty((Collection)appCreateReqDto.getModuleIdList())) {
            for (Long id : appCreateReqDto.getModuleIdList()) {
                MetaModuleEo metaModuleEo = (MetaModuleEo)this.metaModuleDas.selectByPrimaryKey(id);
                if (metaModuleEo != null) {
                    AppModuleRelationEo appModuleRelationEo = new AppModuleRelationEo();
                    appModuleRelationEo.setAppId(appEo.getId());
                    Assert.isTrue((boolean)this.getType(appCreateReqDto.getType()).equals(metaModuleEo.getType()), (String)"\u5e94\u7528\u4e0e\u6a21\u5757\u7c7b\u578b\u4e0d\u5339\u914d");
                    appModuleRelationEo.setModuleId(id);
                    this.appModuleRelationDas.insert((BaseEo)appModuleRelationEo);
                    continue;
                }
                logger.warn("\u6240\u9009\u6a21\u5757\u4e0d\u5b58\u5728");
            }
        }
        return appEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyApp(AppModifyReqDto appModifyReqDto) {
        AppEo checkNameEo = new AppEo();
        checkNameEo.setName(appModifyReqDto.getName());
        List checkList = this.appDas.select((BaseEo)checkNameEo);
        if (CollectionUtils.isNotEmpty((Collection)checkList)) {
            for (AppEo eo : checkList) {
                if (eo.getId().equals(appModifyReqDto.getId())) continue;
                throw new BizException("11001", "\u5e94\u7528\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u91cd\u8f93");
            }
        }
        AppEo appEo = new AppEo();
        DtoHelper.dto2Eo((BaseVo)appModifyReqDto, (BaseEo)appEo, (String[])new String[]{"instanceId", "tenantId"});
        if (CollectionUtils.isNotEmpty((Collection)appModifyReqDto.getModuleIdList())) {
            Integer appType = ((AppEo)this.appDas.selectByPrimaryKey(appModifyReqDto.getId())).getType();
            AppModuleRelationEo relationEo = new AppModuleRelationEo();
            relationEo.setAppId(appEo.getId());
            List relationEoList = this.appModuleRelationDas.select((BaseEo)relationEo);
            ArrayList<AppModuleRelationEo> newRelationList = new ArrayList<AppModuleRelationEo>();
            if (CollectionUtils.isEmpty((Collection)relationEoList)) {
                for (Long moduleId : appModifyReqDto.getModuleIdList()) {
                    newRelationList.add(this.buildNewRelation(moduleId, appType, appEo.getId()));
                }
                this.appModuleRelationDas.insertBatch(newRelationList);
            } else {
                boolean isExist = true;
                for (Long moduleId : appModifyReqDto.getModuleIdList()) {
                    for (AppModuleRelationEo appModuleRelationEo : relationEoList) {
                        if (!appModifyReqDto.getModuleIdList().contains(appModuleRelationEo.getModuleId())) {
                            this.appModuleRelationDas.logicDelete((BaseEo)appModuleRelationEo);
                        }
                        if (!(isExist = moduleId.equals(appModuleRelationEo.getModuleId()))) continue;
                        break;
                    }
                    if (isExist) continue;
                    newRelationList.add(this.buildNewRelation(moduleId, appType, appEo.getId()));
                }
                this.appModuleRelationDas.insertBatch(newRelationList);
            }
        }
        this.appDas.updateSelective((BaseEo)appEo);
    }

    private AppModuleRelationEo buildNewRelation(Long moduleId, Integer appType, Long appId) {
        AppModuleRelationEo newRelation = new AppModuleRelationEo();
        MetaModuleEo metaModuleEo = (MetaModuleEo)this.metaModuleDas.selectByPrimaryKey(moduleId);
        if (metaModuleEo != null) {
            Assert.isTrue((boolean)appType.equals(metaModuleEo.getType()), (String)"10002\u5e94\u7528\u4e0e\u6a21\u5757\u7c7b\u578b\u4e0d\u5339\u914d");
            newRelation.setExtension("");
            newRelation.setAppId(appId);
            newRelation.setModuleId(moduleId);
            return newRelation;
        }
        return null;
    }

    @Override
    public void removeApp(Long id) {
        this.metaContainerDefService.removeModule(id);
    }

    @Override
    public AppRespDto queryAppById(Long id) {
        AppEo appEo = (AppEo)this.appDas.selectByPrimaryKey(id);
        AppRespDto appRespDto = new AppRespDto();
        DtoHelper.eo2Dto((BaseEo)appEo, (BaseVo)appRespDto);
        ArrayList<ModuleRespDto> moduleRespDtoList = new ArrayList<ModuleRespDto>();
        AppModuleRelationEo appModuleRelationEo = new AppModuleRelationEo();
        appModuleRelationEo.setAppId(id);
        List relationEoList = this.appModuleRelationDas.select((BaseEo)appModuleRelationEo);
        for (AppModuleRelationEo relationEo : relationEoList) {
            moduleRespDtoList.add(this.queryModuleById(relationEo.getModuleId()));
        }
        appRespDto.setRelateModuleRespDtoList(moduleRespDtoList);
        appRespDto.setType(this.getType(appEo.getType()));
        return appRespDto;
    }

    private Integer getType(String typeStr) {
        Integer type = null;
        if (typeStr.equals(ContainerType.BACKEND_APP.getTypeStr())) {
            type = ContainerType.BACKEND_APP.getType();
        }
        if (typeStr.equals(ContainerType.ABILITY_CENTER.getTypeStr())) {
            type = ContainerType.ABILITY_CENTER.getType();
        }
        if (typeStr.equals(ContainerType.FRONTEND_APP.getTypeStr())) {
            type = ContainerType.FRONTEND_APP.getType();
        }
        Assert.isTrue((type != null ? 1 : 0) != 0, (String)"10002\u5e94\u7528\u4e0e\u6a21\u5757\u7c7b\u578b\u4e0d\u5339\u914d");
        return type;
    }

    private String getType(Integer type) {
        String typeStr = null;
        if (type.equals(ContainerType.BACKEND_APP.getType())) {
            typeStr = ContainerType.BACKEND_APP.getTypeStr();
        }
        if (type.equals(ContainerType.ABILITY_CENTER.getType())) {
            typeStr = ContainerType.ABILITY_CENTER.getTypeStr();
        }
        if (type.equals(ContainerType.FRONTEND_APP.getType())) {
            typeStr = ContainerType.FRONTEND_APP.getTypeStr();
        }
        Assert.isTrue((typeStr != null ? 1 : 0) != 0, (String)"10002\u5e94\u7528\u4e0e\u6a21\u5757\u7c7b\u578b\u4e0d\u5339\u914d");
        return typeStr;
    }

    @Override
    public PageInfo<AppRespDto> queryAppByPage(AppQueryReqDto appQueryReqDto, Integer pageNum, Integer pageSize) {
        return this.metaContainerDefService.queryAppByPage(appQueryReqDto, pageNum, pageSize);
    }

    @Override
    public Long createModule(ModuleCreateReqDto moduleCreateReqDto) {
        MetaModuleEo checkCodeEo = new MetaModuleEo();
        checkCodeEo.setCode(moduleCreateReqDto.getCode());
        Assert.isTrue((boolean)CollectionUtils.isEmpty((Collection)this.metaModuleDas.select((BaseEo)checkCodeEo)), (String)"11001\u6a21\u5757\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u91cd\u8f93");
        MetaModuleEo checkNameEo = new MetaModuleEo();
        checkNameEo.setName(moduleCreateReqDto.getName());
        Assert.isTrue((boolean)CollectionUtils.isEmpty((Collection)this.metaModuleDas.select((BaseEo)checkNameEo)), (String)"11001\u6a21\u5757\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u91cd\u8f93");
        MetaModuleEo moduleEo = new MetaModuleEo();
        DtoHelper.dto2Eo((BaseVo)moduleCreateReqDto, (BaseEo)moduleEo);
        moduleEo.setType(this.getType(moduleCreateReqDto.getType()));
        this.metaModuleDas.insert((BaseEo)moduleEo);
        return moduleEo.getId();
    }

    @Override
    public void modifyModule(ModuleModifyReqDto moduleModifyReqDto) {
        MetaModuleEo checkNameEo = new MetaModuleEo();
        checkNameEo.setName(moduleModifyReqDto.getName());
        List checkList = this.metaModuleDas.select((BaseEo)checkNameEo);
        if (CollectionUtils.isNotEmpty((Collection)checkList)) {
            for (MetaModuleEo eo : checkList) {
                if (eo.getId().equals(moduleModifyReqDto.getId())) continue;
                throw new BizException("11001", "\u6a21\u5757\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u91cd\u8f93");
            }
        }
        MetaModuleEo moduleEo = new MetaModuleEo();
        DtoHelper.dto2Eo((BaseVo)moduleModifyReqDto, (BaseEo)moduleEo, (String[])new String[]{"code", "instanceId", "tenantId"});
        this.metaModuleDas.updateSelective((BaseEo)moduleEo);
    }

    @Override
    public void removeModule(Long id) {
        this.metaContainerDefService.removeModule(id);
    }

    @Override
    public ModuleRespDto queryModuleById(Long id) {
        MetaModuleEo moduleEo = (MetaModuleEo)this.metaModuleDas.selectByPrimaryKey(id);
        ModuleRespDto moduleRespDto = new ModuleRespDto();
        DtoHelper.eo2Dto((BaseEo)moduleEo, (BaseVo)moduleRespDto);
        moduleRespDto.setType(this.getType(moduleEo.getType()));
        return moduleRespDto;
    }

    @Override
    public PageInfo<ModuleRespDto> queryModuleByPage(ModuleQueryReqDto moduleQueryReqDto, Integer pageNum, Integer pageSize) {
        return this.metaContainerDefService.queryModuleByPage(moduleQueryReqDto, pageNum, pageSize);
    }

    private String generateSql(List<AttributeEo> attributeEoList, String tableName, String tableZhName, String remark) {
        ArrayList<String> idxList = new ArrayList<String>();
        StringBuilder sqlSb = new StringBuilder(50);
        sqlSb.append("\r\ndrop table if exists `").append(tableName).append("`;\n");
        sqlSb.append("create table `").append(tableName).append("`(\n");
        for (AttributeEo attributeEo : attributeEoList) {
            sqlSb.append("`").append(attributeEo.getCode()).append("` ");
            if (new Integer(1).equals(attributeEo.getIsPk())) {
                sqlSb.append(attributeEo.getDataType()).append("(").append(attributeEo.getLength()).append(")").append(" NOT NULL AUTO_INCREMENT ").append("COMMENT `").append(attributeEo.getName()).append("`");
                sqlSb.append(",\n ");
                continue;
            }
            sqlSb.append(attributeEo.getDataType());
            if (null != attributeEo.getLength()) {
                sqlSb.append("(").append(attributeEo.getLength()).append(") ");
            }
            if (null != attributeEo.getIsNullable() && !attributeEo.getIsNullable().equals(1)) {
                sqlSb.append("NOT NULL ");
            }
            if (null != attributeEo.getDefaultValue()) {
                sqlSb.append("DEFAULT `").append(attributeEo.getDefaultValue()).append("`");
            }
            if (null != attributeEo.getName()) {
                sqlSb.append(" COMMENT `").append(attributeEo.getName()).append("`");
            }
            if (!new Integer(1).equals(attributeEo.getIsPk()) && new Integer(1).equals(attributeEo.getIsIdx())) {
                idxList.add(attributeEo.getCode());
            }
            sqlSb.append(",\n ");
        }
        sqlSb.append("PRIMARY KEY (`").append(attributeEoList.get(0).getCode()).append("`),");
        if (CollectionUtils.isNotEmpty(idxList)) {
            for (String idx : idxList) {
                sqlSb.append("\n KEY `").append(idx).append("` (`").append(idx).append("`) ").append(",");
            }
        }
        sqlSb.append("`)");
        int lastIndex = sqlSb.lastIndexOf(",");
        String sql = sqlSb.substring(0, lastIndex);
        sql = sql.substring(0, sql.length() - 1) + " \n) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT=`" + tableZhName + " " + remark + "`;";
        System.out.println("sql :" + sql);
        return sql;
    }

    @Override
    public PageInfo<SourceAttrRespDto> querySourceAttr(SourceAttrReqDto reqDto, Integer pageNum, Integer pageSize) {
        Assert.notNull((Object)reqDto.getSourceEntity(), (String)"\u503c\u6765\u6e90\u5173\u8054\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)reqDto.getSourceAttr(), (String)"\u503c\u6765\u6e90\u5173\u8054\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)reqDto.getSourceDisplayAttr(), (String)"\u5c55\u793a\u540d\u79f0\u7684\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SourceAttrQueryVo queryVo = new SourceAttrQueryVo();
        CubeBeanUtils.copyProperties((Object)queryVo, (Object)reqDto, (String[])new String[0]);
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getAttrName())) {
            queryVo.setAttrName("'" + reqDto.getAttrName() + "'");
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getAttrCodes())) {
            AttributeEo attributeEo = this.queryByCode(reqDto.getSourceEntity(), reqDto.getSourceAttr());
            if (attributeEo != null && attributeEo.getDataType() != null && attributeEo.getDataType().contains("int")) {
                queryVo.setAttrCodes(Arrays.asList(reqDto.getAttrCodes().trim().split(",")));
            } else {
                List<String> attrCodes = Arrays.asList(reqDto.getAttrCodes().trim().split(","));
                queryVo.setAttrCodes(attrCodes.stream().map(code -> "'" + code + "'").collect(Collectors.toList()));
            }
        }
        queryVo.setStart(Integer.valueOf((pageNum - 1) * pageSize));
        queryVo.setPageSize(pageSize);
        List voList = this.attributeDas.querySourceAttr(queryVo);
        PageInfo dtoPageInfo = new PageInfo();
        if (CollectionUtils.isNotEmpty((Collection)voList)) {
            long total = this.attributeDas.querySourceAttrCount(queryVo);
            ArrayList list = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)list, (Collection)voList, SourceAttrRespDto.class);
            dtoPageInfo.setList((List)list);
            dtoPageInfo.setPageNum(pageNum.intValue());
            dtoPageInfo.setPageSize(pageSize.intValue());
            dtoPageInfo.setSize(voList.size());
            dtoPageInfo.setPages(Long.valueOf(total / (long)pageSize.intValue() + (long)(total % (long)pageSize.intValue() == 0L ? 0 : 1)).intValue());
            dtoPageInfo.setTotal(total);
            dtoPageInfo.setStartRow((pageNum - 1) * pageSize + 1);
            dtoPageInfo.setEndRow((pageNum - 1) * pageSize + voList.size());
        }
        return dtoPageInfo;
    }

    @Override
    public AttributeEo queryByCode(String entityCode, String attributeCode) {
        EntityEo queryEo = new EntityEo();
        queryEo.setCode(entityCode);
        EntityEo entityEo = (EntityEo)this.entityDas.selectOne((BaseEo)queryEo);
        if (entityEo != null) {
            AttributeEo eo = new AttributeEo();
            eo.setEntityId(entityEo.getId());
            eo.setCode(attributeCode);
            return (AttributeEo)this.attributeDas.selectOne((BaseEo)eo);
        }
        return null;
    }

    @Override
    public void controllable(String code) {
        this.setIsControlled(code, EntityIsControlledEnum.Y);
    }

    private void setIsControlled(String code, EntityIsControlledEnum y) {
        EntityEo entityEo = this.getEntityEo(code);
        if (!y.getCode().equals(entityEo.getIsControlled())) {
            entityEo.setIsControlled(y.getCode());
            this.entityDas.updateSelective((BaseEo)entityEo);
        }
    }

    @Override
    public void unControllable(String code) {
        this.setIsControlled(code, EntityIsControlledEnum.N);
    }

    @Override
    public void calcFactor(Long id) {
        this.setIsCalcFactorEnum(id, AttributeIsCalcFactorEnum.Y);
    }

    private void setIsCalcFactorEnum(Long id, AttributeIsCalcFactorEnum y) {
        AttributeEo attributeEo = (AttributeEo)this.attributeDas.selectByPrimaryKey(id);
        Assert.notNull((Object)attributeEo, (String)"\u5c5e\u6027\u6570\u636e\u4e0d\u5b58\u5728");
        if (!y.getCode().equals(attributeEo.getIsCalcFactor())) {
            attributeEo.setIsCalcFactor(y.getCode());
            this.attributeDas.updateSelective((BaseEo)attributeEo);
        }
    }

    @Override
    public void unCalcFactor(Long id) {
        this.setIsCalcFactorEnum(id, AttributeIsCalcFactorEnum.N);
    }
}

