/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.meta.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.meta.api.dto.request.PageReqDto;
import com.dtyunxi.yundt.cube.center.meta.api.dto.response.PageRespDto;
import com.dtyunxi.yundt.cube.center.meta.biz.service.IPageService;
import com.dtyunxi.yundt.cube.center.meta.dao.das.PageDas;
import com.dtyunxi.yundt.cube.center.meta.dao.eo.PageEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PageServiceImpl
implements IPageService {
    @Resource
    private PageDas pageDas;

    @Override
    public Long addPage(PageReqDto addReqDto) {
        PageEo pageEo = new PageEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)pageEo);
        this.pageDas.insert((BaseEo)pageEo);
        return pageEo.getId();
    }

    @Override
    public void modifyPage(PageReqDto modifyReqDto) {
        PageEo pageEo = new PageEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)pageEo);
        this.pageDas.updateSelective((BaseEo)pageEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removePage(Long id) {
        this.pageDas.logicDeleteById(id);
    }

    @Override
    public PageRespDto queryById(Long id) {
        PageEo pageEo = (PageEo)this.pageDas.selectByPrimaryKey(id);
        PageRespDto pageRespDto = new PageRespDto();
        DtoHelper.eo2Dto((BaseEo)pageEo, (BaseVo)pageRespDto);
        return pageRespDto;
    }

    @Override
    public PageInfo<PageRespDto> queryByPage(PageReqDto pageReqDto, Integer pageNum, Integer pageSize) {
        PageEo pageEo = new PageEo();
        DtoHelper.dto2Eo((BaseVo)pageReqDto, (BaseEo)pageEo);
        pageEo.setOrderByDesc("create_time");
        PageInfo eoPageInfo = this.pageDas.selectPage((BaseEo)pageEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, PageRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

