/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.meta.biz.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellUtil {
    private static Logger logger = LoggerFactory.getLogger(ShellUtil.class);

    public static void execShell(String shell) {
        try {
            Runtime.getRuntime().exec(shell);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
    }

    public static void execShellBin(String shell) {
        try {
            Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", shell}, null, null);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
    }

    public static List<String> runShell(String shStr) {
        ArrayList<String> strList = new ArrayList<String>();
        try {
            String line;
            Process process = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", shStr}, null, null);
            InputStreamReader ir = new InputStreamReader(process.getInputStream());
            LineNumberReader input = new LineNumberReader(ir);
            process.waitFor();
            while ((line = input.readLine()) != null) {
                strList.add(line);
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        return strList;
    }

    public static void exec(String shellFolder, String shellFile) {
        ProcessBuilder pb = new ProcessBuilder("./" + shellFile, null, null, null);
        pb.directory(new File(shellFolder));
        int runningStatus = 0;
        Object s = null;
        try {
            Process p = pb.start();
            try {
                runningStatus = p.waitFor();
            }
            catch (InterruptedException e) {
                logger.error("", (Throwable)e);
            }
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
        }
        if (runningStatus != 0) {
            logger.info("Shell\u811a\u672c\u6267\u884c\u5931\u8d25");
        }
    }

    public static void test(String shellFile) {
        InputStream in = null;
        try {
            shellFile = "/datafs1/home/i-de-mpc/lcdp/shuijing.sh";
            Process process = null;
            String command = "chmod 644 " + shellFile;
            process = Runtime.getRuntime().exec(command);
            process.waitFor();
            in = process.getInputStream();
            logger.info("---> exec result: " + in.toString());
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
    }

    public static void test2() {
        String shellFolder = "/datafs1/home/i-de-mpc/lcdp";
        try {
            boolean isWindows = System.getProperty("os.name").toLowerCase().startsWith("windows");
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            if (isWindows) {
                builder.command("cmd.exe", "/c", "dir");
            } else {
                builder.command("sh", "-c", " shuijing.sh");
            }
            builder.directory(new File(shellFolder));
            Process process = builder.start();
            StreamGobbler streamGobbler = new StreamGobbler(process.getInputStream(), System.out::println);
            Executors.newSingleThreadExecutor().submit(streamGobbler);
            int n = process.waitFor();
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
    }

    private static class StreamGobbler
    implements Runnable {
        private InputStream inputStream;
        private Consumer<String> consumer;

        public StreamGobbler(InputStream inputStream, Consumer<String> consumer) {
            this.inputStream = inputStream;
            this.consumer = consumer;
        }

        @Override
        public void run() {
            new BufferedReader(new InputStreamReader(this.inputStream)).lines().forEach(this.consumer);
        }
    }
}

