/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.api.constants;

import com.dtyunxi.yundt.cube.center.price.api.constants.Excel;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ExportExcelUtil<T> {
    public void ResponseInit(HttpServletResponse response, String fileName) {
        try {
            fileName = URLEncoder.encode(fileName, "UTF-8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        response.setHeader("Content-Disposition", String.format("attachment; filename=%s;filename*=utf-8''%s", fileName, fileName));
        response.setHeader("Content-Type", "application/force-download");
        response.setHeader("Content-Transfer-Encoding", "binary");
        response.setHeader("Content-Length", String.valueOf(-1));
    }

    public void POIOutPutStream(HttpServletResponse response, SXSSFWorkbook wb) throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            int bytesRead;
            wb.write((OutputStream)os);
            ServletOutputStream out = response.getOutputStream();
            byte[] content = os.toByteArray();
            ByteArrayInputStream is = new ByteArrayInputStream(content);
            bis = new BufferedInputStream(is);
            bos = new BufferedOutputStream((OutputStream)out);
            byte[] buff = new byte[2048];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                ((BufferedOutputStream)bos).write(buff, 0, bytesRead);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (bis != null) {
                bis.close();
            }
            if (bos != null) {
                bos.close();
            }
        }
    }

    public void export(Class<T> objClass, List<T> dataList, HttpServletResponse response, String fileName) throws Exception {
        this.ResponseInit(response, fileName);
        Method[] methods = objClass.getMethods();
        TreeMap<Integer, String> mapCol = new TreeMap<Integer, String>();
        TreeMap<Integer, String> mapMethod = new TreeMap<Integer, String>();
        for (Method method : methods) {
            Excel excel = method.getAnnotation(Excel.class);
            if (excel == null) continue;
            mapCol.put(excel.order(), excel.colName());
            mapMethod.put(excel.order(), method.getName());
        }
        SXSSFWorkbook wb = new SXSSFWorkbook(200);
        this.POIBuildBody(this.POIBuildHead(wb, fileName, mapCol), objClass, mapMethod, dataList);
        this.POIOutPutStream(response, wb);
    }

    public SXSSFSheet POIBuildHead(SXSSFWorkbook wb, String sheetName, Map<Integer, String> mapCol) {
        SXSSFSheet sheet01 = wb.createSheet(sheetName);
        SXSSFRow row = sheet01.createRow(0);
        int i = 0;
        for (Map.Entry<Integer, String> entry : mapCol.entrySet()) {
            SXSSFCell cell = row.createCell(i++);
            cell.setCellValue(entry.getValue());
        }
        return sheet01;
    }

    public void POIBuildBody(SXSSFSheet sheet01, Class<T> excelClass, Map<Integer, String> mapMethod, List<T> dataList) throws Exception {
        SXSSFRow r = null;
        SXSSFCell c = null;
        if (dataList != null && dataList.size() > 0) {
            for (int i = 0; i < dataList.size(); ++i) {
                r = sheet01.createRow(i + 1);
                int j = 0;
                for (Map.Entry<Integer, String> entry : mapMethod.entrySet()) {
                    c = r.createCell(j++);
                    Object obj = excelClass.getDeclaredMethod(entry.getValue(), new Class[0]).invoke(dataList.get(i), new Object[0]);
                    c.setCellValue(obj == null ? "" : obj + "");
                }
            }
        }
    }
}

