/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.api.enums;

import com.dtyunxi.yundt.cube.center.price.api.enums.ApprovalTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.enums.PriceSystemEnum;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public enum ElementEnum {
    MINI_PURCHASE_NUM("miniPurchaseNum", "\u8d2d\u4e70\u5546\u54c1\u6570\u91cf(\u59cb)"),
    MAX_PURCHASE_NUM("maxPurchaseNum", "\u8d2d\u4e70\u5546\u54c1\u6570\u91cf(\u6b62)"),
    PRICE("price", "\u4ef7\u683c"),
    PRICE_TYPE("priceType", "\u4ef7\u683c\u7c7b\u578b"),
    PRICE_TYPE_NAME("priceTypeName", "\u4ef7\u683c\u7c7b\u578b\u540d\u79f0"),
    PRE_PRICE("prePrice", "\u8c03\u4ef7\u524d\u4ef7\u683c"),
    CUSTOMER_CODE("customerCode", "\u5ba2\u6237\u7f16\u7801"),
    CUSTOMER_NAME("customerName", "\u5ba2\u6237\u540d\u79f0"),
    STANDARD_DISTRIBUTION_PRICE("standardDistributionPrice", "\u57fa\u51c6\u5206\u9500\u4ef7"),
    ONLINE_PROMOTION_PRICE("onlinePromotionPrice", "618,\u53cc11\uff0c\u53cc12\u4ef7\u683c"),
    PRODUCT_CODE("productCode", "\u5546\u54c1\u7f16\u7801"),
    PRODUCT_NAME("productName", "\u5546\u54c1\u540d\u79f0"),
    PRODUCT_SPECS("productSpecs", "\u5546\u54c1\u89c4\u683c"),
    PRODUCT_TYPE("productType", "\u5546\u54c1\u7c7b\u578b"),
    REMARK("remark", "\u5907\u6ce8"),
    CURRENCY("currency", "\u5e01\u79cd"),
    SALES_CHANNEL("salesChannel", "\u5ba2\u6237\u9500\u552e\u6e20\u9053"),
    TAKE_DELIVERY_TYPE("takeDeliveryType", "\u63d0\u8d27\u65b9\u5f0f"),
    END_TIME("endTime", "\u5931\u6548\u65f6\u95f4"),
    EXCEPTION_MSG("errorMessage", "\u9519\u8bef\u4fe1\u606f");

    private String code;
    private String name;

    private ElementEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public static List<String> getVersionElementCodeList(Integer approvalType, Integer priceSystem) {
        ArrayList<String> codeArr = new ArrayList<String>();
        if (ApprovalTypeEnum.ST_PRICE.getType().equals(approvalType)) {
            codeArr.add(PRODUCT_CODE.getCode());
            codeArr.add(MINI_PURCHASE_NUM.getCode());
            codeArr.add(MAX_PURCHASE_NUM.getCode());
        } else if (ApprovalTypeEnum.GP_PRICE.getType().equals(approvalType)) {
            codeArr.add(PRODUCT_CODE.getCode());
            codeArr.add(PRICE_TYPE.getCode());
            if (PriceSystemEnum.GW.getType().equals(priceSystem)) {
                codeArr.add(CURRENCY.getCode());
            }
        } else if (ApprovalTypeEnum.TS_PRICE.getType().equals(approvalType)) {
            codeArr.add(PRODUCT_CODE.getCode());
            codeArr.add(CUSTOMER_CODE.getCode());
            if (PriceSystemEnum.GW.getType().equals(priceSystem)) {
                codeArr.add(CURRENCY.getCode());
                codeArr.add(TAKE_DELIVERY_TYPE.getCode());
                codeArr.add(MINI_PURCHASE_NUM.getCode());
                codeArr.add(MAX_PURCHASE_NUM.getCode());
            }
        }
        Collections.sort(codeArr);
        return codeArr;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }
}

