/*
 * Decompiled with CFR 0.152.
 */
package com.vicutu.center.inventory.api.enums;

public enum WarehouseTypeEnum {
    FINISHED_WAREHOUSE(101, "\u6210\u54c1\u4ed3"),
    FUTURES_WAREHOUSE(102, "\u671f\u8d27\u4ed3"),
    E_COMMERCE_WAREHOUSE(201, "\u7535\u5546\u4ed3"),
    W_E_COMMERCE_WAREHOUSE(202, "\u552f\u54c1\u4f1a\u7535\u5546\u4ed3"),
    MINI_E_COMMERCE_WAREHOUSE(203, "\u5c0f\u7a0b\u5e8f\u7535\u5546\u4ed3"),
    AKS_E_COMMERCE_WAREHOUSE(204, "\u7231\u5e93\u5b58\u7535\u5546\u4ed3"),
    DY_E_COMMERCE_WAREHOUSE(205, "\u6296\u97f3\u7535\u5546\u4ed3"),
    UNDER_DETECTION_WAREHOUSE(301, "\u5f85\u68c0\u4ed3"),
    OFFICE_WAREHOUSE(401, "\u529e\u4e8b\u5904\u4ed3"),
    FRANCHISEE_BACK_WAREHOUSE(402, "\u52a0\u76df\u5546\u4ed3"),
    OFFICE_SHOP(501, "\u529e\u4e8b\u5904\u95e8\u5e97"),
    FRANCHISEE_BACK_SHOP(502, "\u52a0\u76df\u5546\u95e8\u5e97"),
    OTHER_WAREHOUSE(601, "\u5176\u4ed6\u5206\u4ed3"),
    CHANNEL_WAREHOUSE(701, "\u5168\u6e20\u9053\u865a\u62df\u4ed3"),
    MINI_TOTAL_WAREHOUSE(702, "\u5c0f\u7a0b\u5e8f\u865a\u62df\u4ed3"),
    RETURN_WAREHOUSE(901, "\u9000\u8d27\u4ed3");

    private Integer type;
    private String name;

    public WarehouseTypeEnum[] getValues() {
        return WarehouseTypeEnum.values();
    }

    public static WarehouseTypeEnum getNameByType(int code) {
        WarehouseTypeEnum result = null;
        for (WarehouseTypeEnum at : WarehouseTypeEnum.values()) {
            if (at.type != code) continue;
            result = at;
            break;
        }
        return result;
    }

    public static String getWarehouseNameByType(int code) {
        WarehouseTypeEnum result = null;
        for (WarehouseTypeEnum at : WarehouseTypeEnum.values()) {
            if (at.type != code) continue;
            result = at;
            break;
        }
        return result != null ? result.getName() : "";
    }

    public static Integer getTypeByShopType(int shopType) {
        Integer warehouseCode = null;
        switch (shopType) {
            case 1: {
                warehouseCode = FRANCHISEE_BACK_WAREHOUSE.getType();
                break;
            }
            case 2: {
                warehouseCode = OFFICE_WAREHOUSE.getType();
                break;
            }
            case 3: {
                warehouseCode = FRANCHISEE_BACK_SHOP.getType();
                break;
            }
            case 4: {
                warehouseCode = OFFICE_SHOP.getType();
                break;
            }
            case 5: {
                warehouseCode = E_COMMERCE_WAREHOUSE.getType();
                break;
            }
            case 6: {
                warehouseCode = OTHER_WAREHOUSE.getType();
            }
        }
        return warehouseCode;
    }

    public static boolean isOfflineShop(Integer type) {
        if (type == null) {
            return false;
        }
        return OFFICE_SHOP.getType().equals(type) || OFFICE_WAREHOUSE.getType().equals(type) || FRANCHISEE_BACK_WAREHOUSE.getType().equals(type) || FRANCHISEE_BACK_SHOP.getType().equals(type);
    }

    private WarehouseTypeEnum(Integer type, String name) {
        this.type = type;
        this.name = name;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

