/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.ocs.mgmt.application.dto.enums;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public enum VoucherTypeEnum {
    DELIVERY("0", "\u4ea4\u8d27\u51ed\u8bc1"),
    INVOICE("1", "\u5f00\u7968\u51ed\u8bc1");

    private String code;
    private String name;
    private static final Map<String, String> VOUCHER_TYPE_ENUM_MAP;
    public static final Map<String, VoucherTypeEnum> CODE_LOOKUP;
    public static final Map<String, String> CODE_DESC_MAP;

    private VoucherTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public static String getMapName(String code) {
        return VOUCHER_TYPE_ENUM_MAP.get(code);
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static String getDesc(String index) {
        for (VoucherTypeEnum voucherTypeEnum : VoucherTypeEnum.values()) {
            if (!voucherTypeEnum.getCode().equals(index)) continue;
            return voucherTypeEnum.getName();
        }
        return null;
    }

    public static List<Map<String, Object>> toList() {
        ArrayList list = Lists.newArrayList();
        for (VoucherTypeEnum orderTypeEnum : VoucherTypeEnum.values()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("code", orderTypeEnum.getCode());
            map.put("name", orderTypeEnum.getName());
            list.add(map);
        }
        return list;
    }

    public static Map<String, String> toMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (VoucherTypeEnum orderTypeEnum : VoucherTypeEnum.values()) {
            map.put(orderTypeEnum.getCode(), orderTypeEnum.getName());
        }
        return map;
    }

    public static VoucherTypeEnum forCode(String code) {
        return CODE_LOOKUP.get(code);
    }

    public Map<String, String> getCodeAndDesc() {
        return CODE_DESC_MAP;
    }

    static {
        VOUCHER_TYPE_ENUM_MAP = new HashMap<String, String>();
        for (VoucherTypeEnum value : VoucherTypeEnum.values()) {
            VOUCHER_TYPE_ENUM_MAP.put(value.getCode(), value.getName());
        }
        CODE_LOOKUP = Arrays.stream(VoucherTypeEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum));
        CODE_DESC_MAP = Arrays.stream(VoucherTypeEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum.name));
    }
}

