/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.ocs.mgmt.application.mqc.inventory.conversion;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.inventory.dto.entity.PhysicsWarehouseDto;
import com.yunxi.dg.base.center.inventory.dto.entity.PhysicsWarehousePageReqDto;
import com.yunxi.dg.base.center.inventory.proxy.entity.ITransferPositionConfigurationApiProxy;
import com.yunxi.dg.base.center.inventory.proxy.warehouse.IPhysicsWarehouseApiProxy;
import com.yunxi.dg.base.center.report.dto.entity.CsEnterpriseInventoryOrgRelationPageRespDto;
import com.yunxi.dg.base.center.report.dto.entity.CsEnterpriseInventoryOrgRelationQueryReqDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgInOtherStorageOrderDetailDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgInOtherStorageOrderDetailPageReqDto;
import com.yunxi.dg.base.center.report.proxy.customer.IDgEnterpriseOrgRelationQueryApiProxy;
import com.yunxi.dg.base.center.report.proxy.inventory.IDgInOtherStorageOrderApiProxy;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import com.yunxi.dg.base.mgmt.application.rpc.dto.entity.InOtherStorageOrderDetailDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.entity.InOtherStorageOrderDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.entity.LogicWarehousePageReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.entity.LogicWarehouseRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.warehouse.ILogicWarehouseApiProxy;
import com.yunxi.dg.base.mgmt.service.enums.LogicWarehousePropertyEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.BusinessTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.CommitEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.inventory.context.ReceiveDeliveryResultOrderContext;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReceivedResultOrderConvert {
    private static final Logger log = LoggerFactory.getLogger(ReceivedResultOrderConvert.class);
    @Autowired
    private ITransferPositionConfigurationApiProxy iTransferPositionConfigurationApiProxy;
    @Autowired
    private ILogicWarehouseApiProxy iLogicWarehouseApiProxy;
    @Autowired
    private IDgInOtherStorageOrderApiProxy iDgInOtherStorageOrderApiProxy;
    @Autowired
    private IPhysicsWarehouseApiProxy iPhysicsWarehouseApiProxy;
    @Autowired
    private IDgEnterpriseOrgRelationQueryApiProxy iDgEnterpriseOrgRelationQueryApiProxy;

    public InOtherStorageOrderDto convertInOtherStorageOrderDto(ReceiveDeliveryResultOrderContext resultOrderContext) {
        List orderDetailDtos = resultOrderContext.getReceiveDeliveryResultOrderDetailEoList();
        Map<String, DgInOtherStorageOrderDetailDto> skuCodeDetailMap = this.getSkuCodeUnitMap(resultOrderContext);
        LogicWarehouseRespDto logicWarehouseRespDto = this.getLogicWarehouseRespDto();
        PhysicsWarehouseDto logicWarehouseAddress = this.getLogicWarehouseAddress(logicWarehouseRespDto);
        CsEnterpriseInventoryOrgRelationPageRespDto orgRelationPageRespDto = this.getSaleOrganization(logicWarehouseRespDto);
        DgInOtherStorageOrderDetailDto storageOrderDto = this.getStorageOrderDto(resultOrderContext);
        InOtherStorageOrderDto inOtherStorageOrderDto = new InOtherStorageOrderDto();
        inOtherStorageOrderDto.setType(BusinessTypeEnum.OTHER_IN.getType());
        inOtherStorageOrderDto.setBusinessType(BusinessTypeEnum.PARTS_REQUISITION_IN.getType());
        inOtherStorageOrderDto.setBusinessTypeName(BusinessTypeEnum.PARTS_REQUISITION_IN.getDesc());
        inOtherStorageOrderDto.setPushFinance(YesNoHelper.NO.toString());
        inOtherStorageOrderDto.setBizDate(new Date());
        inOtherStorageOrderDto.setCommitType(CommitEnum.AUTOCOMPLETE.getCode());
        inOtherStorageOrderDto.setWarehouseCode(logicWarehouseRespDto.getWarehouseCode());
        inOtherStorageOrderDto.setWarehouseName(logicWarehouseRespDto.getWarehouseName());
        inOtherStorageOrderDto.setPhysicsWarehouseCode(logicWarehouseRespDto.getPhysicsWarehouseCode());
        inOtherStorageOrderDto.setPhysicsWarehouseName(logicWarehouseRespDto.getPhysicsWarehouseName());
        inOtherStorageOrderDto.setCargoOrganizationCode(logicWarehouseRespDto.getOrganizationCode());
        inOtherStorageOrderDto.setCargoOrganizationName(logicWarehouseRespDto.getOrganizationName());
        if (null != logicWarehouseAddress) {
            inOtherStorageOrderDto.setProvinceCode(logicWarehouseAddress.getProvinceCode());
            inOtherStorageOrderDto.setProvinceName(logicWarehouseAddress.getProvince());
            inOtherStorageOrderDto.setCityCode(logicWarehouseAddress.getCityCode());
            inOtherStorageOrderDto.setCityName(logicWarehouseAddress.getCity());
            inOtherStorageOrderDto.setAreaCode(logicWarehouseAddress.getDistrictCode());
            inOtherStorageOrderDto.setAreaName(logicWarehouseAddress.getDistrict());
            inOtherStorageOrderDto.setAddress(logicWarehouseAddress.getDetailAddress());
        }
        if (null != orgRelationPageRespDto) {
            inOtherStorageOrderDto.setSaleOrganizationCode(orgRelationPageRespDto.getEnterpriseCode());
            inOtherStorageOrderDto.setSaleOrganizationName(orgRelationPageRespDto.getEnterpriseName());
        }
        if (null != storageOrderDto) {
            inOtherStorageOrderDto.setCostCenterCode(storageOrderDto.getCostCenterCode());
            inOtherStorageOrderDto.setCostCenterName(storageOrderDto.getCostCenterName());
        }
        ArrayList detailDtoList = Lists.newArrayList();
        orderDetailDtos.forEach(dto -> {
            InOtherStorageOrderDetailDto orderDetailDto = new InOtherStorageOrderDetailDto();
            if (skuCodeDetailMap.containsKey(dto.getSkuCode())) {
                DgInOtherStorageOrderDetailDto dgInOtherStorageOrderDetailDto = (DgInOtherStorageOrderDetailDto)skuCodeDetailMap.get(dto.getSkuCode());
                orderDetailDto.setUnit(dgInOtherStorageOrderDetailDto.getUnit());
                orderDetailDto.setUnitPrice(BigDecimalUtils.toStr((BigDecimal)dgInOtherStorageOrderDetailDto.getUnitPrice()));
            }
            orderDetailDto.setSkuCode(dto.getSkuCode());
            orderDetailDto.setSkuName(dto.getSkuName());
            orderDetailDto.setBatch(dto.getBatch());
            orderDetailDto.setQuantity(dto.getQuantity());
            orderDetailDto.setInventoryProperty(dto.getInventoryProperty());
            detailDtoList.add(orderDetailDto);
        });
        inOtherStorageOrderDto.setInOtherStorageOrderDetailDtos((List)detailDtoList);
        return inOtherStorageOrderDto;
    }

    private CsEnterpriseInventoryOrgRelationPageRespDto getSaleOrganization(LogicWarehouseRespDto logicWarehouseRespDto) {
        CsEnterpriseInventoryOrgRelationQueryReqDto csEnterpriseInventoryOrgRelationQueryReqDto = new CsEnterpriseInventoryOrgRelationQueryReqDto();
        csEnterpriseInventoryOrgRelationQueryReqDto.setPageNum(Integer.valueOf(1));
        csEnterpriseInventoryOrgRelationQueryReqDto.setPageSize(Integer.valueOf(10));
        csEnterpriseInventoryOrgRelationQueryReqDto.setInventoryOrgCode(logicWarehouseRespDto.getOrganizationCode());
        PageInfo relationPageRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.iDgEnterpriseOrgRelationQueryApiProxy.queryInventoryRelationPage(csEnterpriseInventoryOrgRelationQueryReqDto));
        if (CollectionUtil.isEmpty((Collection)relationPageRespDtoPageInfo.getList())) {
            return null;
        }
        return (CsEnterpriseInventoryOrgRelationPageRespDto)relationPageRespDtoPageInfo.getList().get(0);
    }

    private PhysicsWarehouseDto getLogicWarehouseAddress(LogicWarehouseRespDto logicWarehouseRespDto) {
        PhysicsWarehousePageReqDto physicsWarehousePageReqDto = new PhysicsWarehousePageReqDto();
        physicsWarehousePageReqDto.setPageNum(Integer.valueOf(1));
        physicsWarehousePageReqDto.setPageSize(Integer.valueOf(10));
        physicsWarehousePageReqDto.setWarehouseCode(logicWarehouseRespDto.getPhysicsWarehouseCode());
        PageInfo physicsWarehouseDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.iPhysicsWarehouseApiProxy.queryData(physicsWarehousePageReqDto));
        if (CollectionUtil.isEmpty((Collection)physicsWarehouseDtoPageInfo.getList())) {
            return null;
        }
        return (PhysicsWarehouseDto)physicsWarehouseDtoPageInfo.getList().get(0);
    }

    private Map<String, DgInOtherStorageOrderDetailDto> getSkuCodeUnitMap(ReceiveDeliveryResultOrderContext resultOrderContext) {
        DgInOtherStorageOrderDetailPageReqDto detailPageReqDto = new DgInOtherStorageOrderDetailPageReqDto();
        detailPageReqDto.setStorageOrderNo(resultOrderContext.getRelevanceNo());
        detailPageReqDto.setPageNum(Integer.valueOf(1));
        detailPageReqDto.setPageSize(Integer.valueOf(999));
        PageInfo detailDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.iDgInOtherStorageOrderApiProxy.detailPage(detailPageReqDto));
        AssertUtils.notEmpty((Collection)detailDtoPageInfo.getList(), (String)"\u914d\u4ef6\u9886\u7528\u5355\u660e\u7ec6\u4e0d\u5b58\u5728");
        List detailDtoPageInfoList = detailDtoPageInfo.getList();
        Map<String, DgInOtherStorageOrderDetailDto> skuCodeDetailMap = detailDtoPageInfoList.stream().collect(Collectors.toMap(DgInOtherStorageOrderDetailDto::getSkuCode, Function.identity(), (k1, k2) -> k1));
        log.info("\u914d\u4ef6\u9886\u7528\u5355\u67e5\u8be2\u5230\u5546\u54c1\u5355\u4f4d\u4fe1\u606f:{}", (Object)JSON.toJSONString(skuCodeDetailMap));
        return skuCodeDetailMap;
    }

    private LogicWarehouseRespDto getLogicWarehouseRespDto() {
        LogicWarehousePageReqDto logicWarehousePageReqDto = new LogicWarehousePageReqDto();
        logicWarehousePageReqDto.setWarehouseProperty(LogicWarehousePropertyEnum.PARTS_IN.getCode());
        List logicWarehouseRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.iLogicWarehouseApiProxy.queryList(logicWarehousePageReqDto));
        AssertUtils.notEmpty((Collection)logicWarehouseRespDtos, (String)"\u67e5\u4e0d\u5230\u914d\u4ef6\u5165\u5e93\u4ed3");
        if (logicWarehouseRespDtos.size() > 1) {
            throw new BizException("\u67e5\u8be2\u5230\u914d\u4ef6\u5165\u5e93\u6709\u4e24\u4e2a\u4ee5\u4e0a");
        }
        return (LogicWarehouseRespDto)logicWarehouseRespDtos.get(0);
    }

    private DgInOtherStorageOrderDetailDto getStorageOrderDto(ReceiveDeliveryResultOrderContext resultOrderContext) {
        DgInOtherStorageOrderDetailDto storageOrderDto = (DgInOtherStorageOrderDetailDto)RestResponseHelper.extractData((RestResponse)this.iDgInOtherStorageOrderApiProxy.queryDetail(resultOrderContext.getRelevanceNo()));
        return storageOrderDto;
    }
}

