/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.ocs.mgmt.application.mqc.inventory.conversion;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.inventory.dto.entity.BaseOrderAddressDto;
import com.yunxi.dg.base.center.inventory.dto.entity.BaseOrderAddressPageReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.CsPhysicsWarehouseRespDto;
import com.yunxi.dg.base.center.inventory.dto.entity.PhysicsWarehouseQueryDto;
import com.yunxi.dg.base.center.inventory.dto.entity.ShippingMarkManagementDto;
import com.yunxi.dg.base.center.inventory.dto.entity.ShippingMarkManagementPageReqDto;
import com.yunxi.dg.base.center.inventory.dto.inventory.ThirdWarehouseReqDto;
import com.yunxi.dg.base.center.inventory.dto.inventory.ThirdWarehouseRespDto;
import com.yunxi.dg.base.center.inventory.proxy.entity.IBaseOrderAddressApiProxy;
import com.yunxi.dg.base.center.inventory.proxy.entity.IShippingMarkManagementApiProxy;
import com.yunxi.dg.base.center.inventory.proxy.warehouse.IPhysicsWarehouseApiProxy;
import com.yunxi.dg.base.center.inventory.proxy.warehouse.IThirdWarehouseQueryApiProxy;
import com.yunxi.dg.base.center.openapi.dto.request.ReceiverInfo;
import com.yunxi.dg.base.center.openapi.dto.request.SenderInfo;
import com.yunxi.dg.base.center.openapi.dto.request.ShippingMarkDto;
import com.yunxi.dg.base.center.openapi.dto.request.WmsStockOutOrderReqDto;
import com.yunxi.dg.base.center.openapi.dto.wms.WmsItemLine;
import com.yunxi.dg.base.center.report.dto.entity.DgPerformOrderAddrDto;
import com.yunxi.dg.base.center.report.dto.trade.DgPerformOrderInfoDto;
import com.yunxi.dg.base.center.report.proxy.order.IDgOrderReportApiProxy;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.LogUtils;
import com.yunxi.dg.base.mgmt.application.rpc.dto.request.ItemQueryDgReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.DgItemSkuDetailRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.DgItemSkuRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.sku.IItemSkuDgQueryApiProxy;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.OrderTypeConstant;
import com.yunxi.dg.base.ocs.mgmt.application.dto.inventory.InOutNoticeOrderDetailDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.inventory.InOutNoticeOrderPusWmsDto;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PusWmsStockOutOrderConvert {
    private static final Logger log = LoggerFactory.getLogger(PusWmsStockOutOrderConvert.class);
    @Resource
    private IThirdWarehouseQueryApiProxy iThirdWarehouseQueryApiProxy;
    @Resource
    private IBaseOrderAddressApiProxy iBaseOrderAddressApiProxy;
    @Resource
    private IItemSkuDgQueryApiProxy iItemSkuDgQueryApiProxy;
    @Resource
    private IShippingMarkManagementApiProxy iShippingMarkManagementApiProxy;
    @Resource
    private IDgOrderReportApiProxy iDgOrderReportApiProxy;
    @Resource
    private IPhysicsWarehouseApiProxy physicsWarehouseApiProxy;

    public WmsStockOutOrderReqDto toOutPusWmsDto(InOutNoticeOrderPusWmsDto pusWmsDto) {
        AssertUtils.notBlank((String)pusWmsDto.getPhysicsWarehouseCode(), (String)"\u7269\u7406\u4ed3\u7f16\u7801\u4e0d\u5b58\u5728");
        PhysicsWarehouseQueryDto queryDto = new PhysicsWarehouseQueryDto();
        queryDto.setWarehouseCode(pusWmsDto.getPhysicsWarehouseCode());
        List csPhysicsWarehouseRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.physicsWarehouseApiProxy.queryByParam(queryDto));
        AssertUtils.notEmpty((Collection)csPhysicsWarehouseRespDtoList, (String)"\u7269\u7406\u4ed3\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728");
        CsPhysicsWarehouseRespDto physicsWarehouseRespDto = (CsPhysicsWarehouseRespDto)csPhysicsWarehouseRespDtoList.get(0);
        String linkWarehouseCode = StringUtils.isNotBlank((CharSequence)physicsWarehouseRespDto.getThirdCode()) ? physicsWarehouseRespDto.getThirdCode() : physicsWarehouseRespDto.getWarehouseCode();
        AssertUtils.notBlank((String)linkWarehouseCode, (String)"\u63a8\u9001\u7269\u7406\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728");
        log.info("push wms out warehouse code: {}", (Object)linkWarehouseCode);
        List<String> skuCodeList = pusWmsDto.getInOutNoticeOrderDetailEoList().stream().map(InOutNoticeOrderDetailDto::getSkuCode).distinct().collect(Collectors.toList());
        Map<String, DgItemSkuDetailRespDto> skuCodeMap = this.getStringDgItemSkuDetailRespDtoMap(skuCodeList);
        Map<String, ShippingMarkManagementDto> markManagementDtoMap = this.getStringShippingMarkManagementDtoMap(skuCodeList);
        Map<String, DgPerformOrderAddrDto> performOrderAddrDtoMap = this.getStringDgPerformOrderAddrDtoMap(pusWmsDto);
        WmsStockOutOrderReqDto wmsStockOutOrderReqDto = new WmsStockOutOrderReqDto();
        wmsStockOutOrderReqDto.setRemark(pusWmsDto.getRemark());
        wmsStockOutOrderReqDto.setOrderType(Optional.ofNullable(OrderTypeConstant.OUT.get(pusWmsDto.getBusinessType())).orElse(OrderTypeConstant.COMMON_OUT));
        wmsStockOutOrderReqDto.setBusinessType(pusWmsDto.getBusinessType());
        wmsStockOutOrderReqDto.setRelevanceNo(pusWmsDto.getRelevanceNo());
        wmsStockOutOrderReqDto.setDocumentNo(pusWmsDto.getDocumentNo());
        wmsStockOutOrderReqDto.setWarehouseCode(linkWarehouseCode);
        wmsStockOutOrderReqDto.setWarehouseName(physicsWarehouseRespDto.getWarehouseName());
        wmsStockOutOrderReqDto.setLogicWarehouseCode(pusWmsDto.getLogicWarehouseCode());
        wmsStockOutOrderReqDto.setLogicWarehouseName(pusWmsDto.getLogicWarehouseName());
        wmsStockOutOrderReqDto.setLogisticsCode(pusWmsDto.getShipmentEnterpriseCode());
        wmsStockOutOrderReqDto.setLogisticsName(pusWmsDto.getShipmentEnterpriseName());
        wmsStockOutOrderReqDto.setItemLines(pusWmsDto.getInOutNoticeOrderDetailEoList().stream().map(detailEo -> {
            WmsItemLine wmsItemLine = new WmsItemLine();
            wmsItemLine.setBatch(detailEo.getBatch());
            wmsItemLine.setItemCode(detailEo.getSkuCode());
            wmsItemLine.setCargoCode(detailEo.getSkuCode());
            if (null != detailEo.getPreOrderItemId()) {
                wmsItemLine.setTradeOrderItemId(String.valueOf(detailEo.getPreOrderItemId()));
            }
            wmsItemLine.setProductDate(DateUtil.formatDateTime((Date)detailEo.getProduceTime()));
            wmsItemLine.setArrivalDate(DateUtil.formatDateTime((Date)detailEo.getExpireTime()));
            wmsItemLine.setCargoName(detailEo.getSkuName());
            wmsItemLine.setPlanQuantity(detailEo.getPlanQuantity());
            ShippingMarkDto shippingMarkDto = this.getShippingMarkDto(pusWmsDto, skuCodeMap, markManagementDtoMap, performOrderAddrDtoMap, (InOutNoticeOrderDetailDto)detailEo);
            wmsItemLine.setShippingMarkDto(shippingMarkDto);
            return wmsItemLine;
        }).collect(Collectors.toList()));
        String customerId = this.getCustomerId(linkWarehouseCode);
        AssertUtils.notEmpty((String)customerId, (String)"\u7b2c\u4e09\u65b9\u4ed3\u5e93\u4fe1\u606f\u4e0d\u5b58\u5728\u6216\u8005\u5b58\u5728\u591a\u4e2a\u7b2c\u4e09\u65b9\u4ed3\u5e93");
        wmsStockOutOrderReqDto.setCustomerId(customerId);
        List<BaseOrderAddressDto> addressDtoList = this.getReceiptAndDelivery(pusWmsDto);
        log.info("\u67e5\u8be2\u6536\u53d1\u8d27\u4fe1\u606faddressDtoList:{}", (Object)JSON.toJSONString(addressDtoList));
        if (ObjectUtil.isNotEmpty(addressDtoList)) {
            ReceiverInfo receiverInfo = this.getReceiverInfo(addressDtoList);
            wmsStockOutOrderReqDto.setReceiverInfo(receiverInfo);
            SenderInfo delivery = this.getDelivery(addressDtoList);
            wmsStockOutOrderReqDto.setSenderInfo(delivery);
        }
        log.info("transferWmsStockOutOrderReqDto: {}", (Object)LogUtils.buildLogContent((Object)wmsStockOutOrderReqDto));
        return wmsStockOutOrderReqDto;
    }

    private ShippingMarkDto getShippingMarkDto(InOutNoticeOrderPusWmsDto pusWmsDto, Map<String, DgItemSkuDetailRespDto> skuCodeMap, Map<String, ShippingMarkManagementDto> markManagementDtoMap, Map<String, DgPerformOrderAddrDto> performOrderAddrDtoMap, InOutNoticeOrderDetailDto detailEo) {
        ShippingMarkDto shippingMarkDto = new ShippingMarkDto();
        if (skuCodeMap.containsKey(detailEo.getSkuCode())) {
            DgItemSkuDetailRespDto dgItemSkuDetailRespDto = skuCodeMap.get(detailEo.getSkuCode());
            shippingMarkDto.setSkuCode(dgItemSkuDetailRespDto.getSkuCode());
            shippingMarkDto.setSkuName(dgItemSkuDetailRespDto.getSkuName());
            shippingMarkDto.setVolume(dgItemSkuDetailRespDto.getVolume());
            shippingMarkDto.setPackingQuantity(String.valueOf(dgItemSkuDetailRespDto.getPackageNum()));
            shippingMarkDto.setBarCode(dgItemSkuDetailRespDto.getBarCode());
            shippingMarkDto.setGrossWeight(dgItemSkuDetailRespDto.getGrossWeight());
            shippingMarkDto.setNetWeight(dgItemSkuDetailRespDto.getNetWeight());
        }
        if (markManagementDtoMap.containsKey(detailEo.getSkuCode())) {
            ShippingMarkManagementDto shippingMarkManagementDto = markManagementDtoMap.get(detailEo.getSkuCode());
            shippingMarkDto.setInventoryCode(shippingMarkManagementDto.getStocksCode());
            shippingMarkDto.setCustomerBoxCode(shippingMarkManagementDto.getCustOuterCartonCode());
        }
        if (StringUtils.equals((CharSequence)pusWmsDto.getDisplayBusinessType(), (CharSequence)"1001") && performOrderAddrDtoMap.containsKey(pusWmsDto.getRelevanceNo())) {
            DgPerformOrderAddrDto dgPerformOrderAddrDto = performOrderAddrDtoMap.get(pusWmsDto.getRelevanceNo());
            shippingMarkDto.setPurchaseOrder(dgPerformOrderAddrDto.getPurchaseOrderNo());
            shippingMarkDto.setConsigneeName(dgPerformOrderAddrDto.getReceiveName());
        }
        return shippingMarkDto;
    }

    private Map<String, DgItemSkuDetailRespDto> getStringDgItemSkuDetailRespDtoMap(List<String> skuCodeList) {
        ItemQueryDgReqDto itemQueryDgReqDto = new ItemQueryDgReqDto();
        itemQueryDgReqDto.setSkuCodes(skuCodeList);
        List skuDetailRespDtos = (List)Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.iItemSkuDgQueryApiProxy.querySkuList(itemQueryDgReqDto))).orElse(Lists.newArrayList());
        log.info("\u67e5\u8be2\u5230sku\u5546\u54c1\u7684\u8be6\u7ec6\u6570\u636e:{}", (Object)JSON.toJSONString((Object)skuDetailRespDtos));
        Map<String, DgItemSkuDetailRespDto> skuCodeMap = skuDetailRespDtos.stream().collect(Collectors.toMap(DgItemSkuRespDto::getSkuCode, Function.identity(), (k1, k2) -> k1));
        return skuCodeMap;
    }

    private Map<String, ShippingMarkManagementDto> getStringShippingMarkManagementDtoMap(List<String> skuCodeList) {
        ShippingMarkManagementPageReqDto pageReqDto = new ShippingMarkManagementPageReqDto();
        pageReqDto.setSkuCodeList(skuCodeList);
        List shippingMarkManagementDtoList = (List)Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.iShippingMarkManagementApiProxy.list(pageReqDto))).orElse(Lists.newArrayList());
        Map<String, ShippingMarkManagementDto> markManagementDtoMap = shippingMarkManagementDtoList.stream().collect(Collectors.toMap(ShippingMarkManagementDto::getSkuCode, Function.identity(), (k1, k2) -> k1));
        return markManagementDtoMap;
    }

    private Map<String, DgPerformOrderAddrDto> getStringDgPerformOrderAddrDtoMap(InOutNoticeOrderPusWmsDto pusWmsDto) {
        HashMap<String, DgPerformOrderAddrDto> performOrderAddrDtoMap = new HashMap<String, DgPerformOrderAddrDto>();
        if (StringUtils.equals((CharSequence)pusWmsDto.getDisplayBusinessType(), (CharSequence)"1001")) {
            DgPerformOrderInfoDto dgPerformOrderInfoDto = new DgPerformOrderInfoDto();
            dgPerformOrderInfoDto.setSaleOrderNo(pusWmsDto.getRelevanceNo());
            List dgPerformOrderAddrDtos = (List)Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.iDgOrderReportApiProxy.queryOrderAddr(dgPerformOrderInfoDto))).orElse(Lists.newArrayList());
            log.info("\u67e5\u8be2\u5230\u9500\u552e\u8ba2\u5355\u7684\u5730\u5740\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)dgPerformOrderAddrDtos));
            Map addrDtoMap = dgPerformOrderAddrDtos.stream().collect(Collectors.toMap(DgPerformOrderAddrDto::getSaleOrderNo, Function.identity(), (k1, k2) -> k1));
            performOrderAddrDtoMap.putAll(addrDtoMap);
        }
        return performOrderAddrDtoMap;
    }

    private ReceiverInfo getReceiverInfo(List<BaseOrderAddressDto> addressDtoList) {
        List receiverList = addressDtoList.stream().filter(o -> Objects.equals("consignee", o.getContactsType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(receiverList)) {
            BaseOrderAddressDto baseOrderAddressDto = (BaseOrderAddressDto)receiverList.get(0);
            ReceiverInfo receiverInfo = new ReceiverInfo();
            receiverInfo.setTargetWarehouseCode(baseOrderAddressDto.getContacts());
            receiverInfo.setCountry(baseOrderAddressDto.getCountry());
            receiverInfo.setDistrictCode(baseOrderAddressDto.getDistrictCode());
            receiverInfo.setCity(baseOrderAddressDto.getCity());
            receiverInfo.setProvinceCode(baseOrderAddressDto.getProvinceCode());
            receiverInfo.setCustomerCode(baseOrderAddressDto.getCustomerCode());
            receiverInfo.setAreaCode(baseOrderAddressDto.getDistrictCode());
            receiverInfo.setProvince(baseOrderAddressDto.getProvince());
            receiverInfo.setPhone(baseOrderAddressDto.getPhone());
            receiverInfo.setDistrict(baseOrderAddressDto.getDistrict());
            receiverInfo.setDetailAddress(baseOrderAddressDto.getDetailAddress());
            receiverInfo.setContacts(baseOrderAddressDto.getContacts());
            return receiverInfo;
        }
        return null;
    }

    private SenderInfo getDelivery(List<BaseOrderAddressDto> addressDtoList) {
        List deliveryList = addressDtoList.stream().filter(o -> Objects.equals("consignor", o.getContactsType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(deliveryList)) {
            BaseOrderAddressDto baseOrderAddressDto = (BaseOrderAddressDto)deliveryList.get(0);
            SenderInfo senderInfo = new SenderInfo();
            senderInfo.setCountry(baseOrderAddressDto.getCountry());
            senderInfo.setDistrictCode(baseOrderAddressDto.getDistrictCode());
            senderInfo.setCity(baseOrderAddressDto.getCity());
            senderInfo.setProvinceCode(baseOrderAddressDto.getProvinceCode());
            senderInfo.setAreaCode(baseOrderAddressDto.getDistrictCode());
            senderInfo.setProvince(baseOrderAddressDto.getProvince());
            senderInfo.setPhone(baseOrderAddressDto.getPhone());
            senderInfo.setDistrict(baseOrderAddressDto.getDistrict());
            senderInfo.setDetailAddress(baseOrderAddressDto.getDetailAddress());
            senderInfo.setContacts(baseOrderAddressDto.getContacts());
            return senderInfo;
        }
        return null;
    }

    private List<BaseOrderAddressDto> getReceiptAndDelivery(InOutNoticeOrderPusWmsDto pusWmsDto) {
        BaseOrderAddressPageReqDto baseOrderAddressPageReqDto = new BaseOrderAddressPageReqDto();
        baseOrderAddressPageReqDto.setDocumentNo(pusWmsDto.getRelevanceNo());
        baseOrderAddressPageReqDto.setPageNum(Integer.valueOf(1));
        baseOrderAddressPageReqDto.setPageSize(Integer.valueOf(10));
        PageInfo addressDtoPageInfo = (PageInfo)Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.iBaseOrderAddressApiProxy.page(baseOrderAddressPageReqDto))).orElse(new PageInfo());
        List addressDtoList = addressDtoPageInfo.getList();
        return addressDtoList;
    }

    private String getCustomerId(String linkWarehouseCode) {
        if (StringUtils.isNotEmpty((CharSequence)linkWarehouseCode)) {
            ThirdWarehouseReqDto thirdWarehouseReqDto = new ThirdWarehouseReqDto();
            thirdWarehouseReqDto.setWarehouseCode(linkWarehouseCode);
            PageInfo thirdWarehouseRespDtoPageInfo = (PageInfo)Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.iThirdWarehouseQueryApiProxy.queryByPage(Integer.valueOf(1), Integer.valueOf(10), thirdWarehouseReqDto))).orElse(new PageInfo());
            List warehouseRespDtoList = thirdWarehouseRespDtoPageInfo.getList();
            log.info("\u67e5\u8be2\u5230\u7b2c\u4e09\u65b9\u4ed3\u5e93\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)warehouseRespDtoList));
            if (CollectionUtils.isEmpty((Collection)warehouseRespDtoList) || warehouseRespDtoList.size() > 1) {
                return null;
            }
            ThirdWarehouseRespDto thirdWarehouseRespDto = (ThirdWarehouseRespDto)warehouseRespDtoList.get(0);
            if (StringUtils.isEmpty((CharSequence)thirdWarehouseRespDto.getCustomerId())) {
                return null;
            }
            return thirdWarehouseRespDto.getCustomerId();
        }
        return null;
    }
}

