/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.ocs.mgmt.application.mqc.inventory;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.ObjectConvertor;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yundt.boot.center.data.dto.enums.AdjustmentBusinessTypeEnum;
import com.yunxi.dg.base.center.customer.dto.request.DgEnterpriseInventoryOrgRelationQueryReqDto;
import com.yunxi.dg.base.center.customer.dto.response.DgInventoryOrgRelationRespDto;
import com.yunxi.dg.base.center.inventory.proxy.other.IInOtherStorageOrderApiProxy;
import com.yunxi.dg.base.center.openapi.dto.inventory.ErpReceivedDeliveryResultOrderDetailDto;
import com.yunxi.dg.base.center.openapi.dto.inventory.ErpReceivedDeliveryResultOrderDto;
import com.yunxi.dg.base.center.openapi.proxy.erp.IExternalInventoryErpApiProxy;
import com.yunxi.dg.base.center.report.dto.entity.EnterpriceCrossReceiveDeliveryResultDetailDto;
import com.yunxi.dg.base.center.report.dto.entity.EnterpriceCrossReceiveDeliveryResultDto;
import com.yunxi.dg.base.center.report.dto.entity.EnterpriceCrossReceiveDeliveryResultReqDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgInOtherStorageOrderDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgInOtherStorageOrderPageReqDto;
import com.yunxi.dg.base.center.report.proxy.entity.IEnterpriceCrossOrderApiProxy;
import com.yunxi.dg.base.center.report.proxy.inventory.IDgInOtherStorageOrderApiProxy;
import com.yunxi.dg.base.center.user.dto.dto.OrganizationDto;
import com.yunxi.dg.base.center.user.proxy.IDgOrganizationApiProxy;
import com.yunxi.dg.base.commons.utils.LogUtils;
import com.yunxi.dg.base.mgmt.application.rpc.dto.entity.InOtherStorageOrderDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.entity.LogicWarehousePageReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.entity.LogicWarehouseRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.query.IDgInventoryOrgQueryApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.sku.IItemSkuDgQueryApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.warehouse.ILogicWarehouseApiProxy;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.BusinessTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.DisplayBusinessTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.OrderOperateTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.inventory.ReceiveDeliveryResultOrderDetailDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.inventory.ReceiveDeliveryResultOrderDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.inventory.context.ReceiveDeliveryResultOrderContext;
import com.yunxi.dg.base.ocs.mgmt.application.dto.proxy.item.ItemSkuDgRespDto;
import com.yunxi.dg.base.ocs.mgmt.application.mqc.inventory.conversion.ReceivedResultOrderConvert;
import feign.FeignException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ReceivedResultOrderProcess
implements IMessageProcessor<MessageVo> {
    private static final Logger log = LoggerFactory.getLogger(ReceivedResultOrderProcess.class);
    @Resource
    private ILogicWarehouseApiProxy logicWarehouseApiProxy;
    @Resource
    private IItemSkuDgQueryApiProxy itemSkuDgQueryApiProxy;
    @Resource
    private IExternalInventoryErpApiProxy externalInventoryErpApiProxy;
    @Resource
    private IDgOrganizationApiProxy dgOrganizationApiProxy;
    @Resource
    private IDgInventoryOrgQueryApiProxy dgInventoryOrgQueryApiProxy;
    @Resource
    private IInOtherStorageOrderApiProxy inOtherStorageOrderApiProxy;
    @Resource
    private ReceivedResultOrderConvert receivedResultOrderConvert;
    @Resource
    private IDgInOtherStorageOrderApiProxy dgInOtherStorageOrderApiProxy;
    @Autowired
    ILockService lockService;
    @Resource
    private IEnterpriceCrossOrderApiProxy orderApiProxy;
    private static final List<String> ERP_TRANSACTION_BUSINESSTYPE = Lists.newArrayList((Object[])new String[]{BusinessTypeEnum.INVENTORY_ADJUSTMENT_ORDER.getType(), BusinessTypeEnum.OTHER_IN.getType(), BusinessTypeEnum.OTHER_OUT.getType(), BusinessTypeEnum.SCRAP_OUT.getType()});
    private static final List<String> QUERY_OTHER_ORDER_BUSINESSTYPE = Lists.newArrayList((Object[])new String[]{BusinessTypeEnum.OTHER_IN.getType(), BusinessTypeEnum.OTHER_OUT.getType(), BusinessTypeEnum.SCRAP_OUT.getType()});
    private static final List<String> ERP_SUB_INVENTORY_TRANSFER_BUSINESSTYPE = Lists.newArrayList((Object[])new String[]{BusinessTypeEnum.TRANSFER_ORDER.getType(), BusinessTypeEnum.TRANSFER_POSITION_ORDER.getType(), BusinessTypeEnum.MODIFICATION_TRANSFER_ORDER.getType(), BusinessTypeEnum.CW_TRANSFER_ORDER.getType()});
    private static final List<String> ERP_SUB_INVENTORY_TRANSFER_BUSINESSTYPE_DELIVERY = Lists.newArrayList((Object[])new String[]{BusinessTypeEnum.MODIFICATION_TRANSFER_ORDER.getType(), BusinessTypeEnum.CW_TRANSFER_ORDER.getType()});

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageResponse process(MessageVo message) {
        log.info("\u6536\u8d27\u7ed3\u679c\u5355\u5df2\u5b8c\u6210\u6d88\u606finBack\uff1a{}", (Object)LogUtils.buildLogContent((Object)message));
        ReceiveDeliveryResultOrderContext resultOrderContext = (ReceiveDeliveryResultOrderContext)JSONObject.parseObject((String)((String)message.getData()), ReceiveDeliveryResultOrderContext.class);
        try {
            this.dealWithSyncErp(resultOrderContext.getReceiveDeliveryResultOrderEo(), resultOrderContext.getReceiveDeliveryResultOrderDetailEoList());
        }
        catch (FeignException e) {
            log.error("\u540c\u6b65ERP\u5f02\u5e38\uff1a", (Throwable)e);
            if (e.status() == 503) {
                throw e;
            }
        }
        catch (Exception e) {
            log.error("\u540c\u6b65ERP\u5f02\u5e38\uff1a", (Throwable)e);
        }
        if (StringUtils.equals((CharSequence)BusinessTypeEnum.PARTS_REQUISITION_OUT.getType(), (CharSequence)resultOrderContext.getDisplayBusinessType())) {
            Mutex mutex = this.lockService.lock("ReceivedResultOrderProcess#process", resultOrderContext.getRelevanceNo(), 20, 25, TimeUnit.SECONDS);
            try {
                log.info("\u65b0\u589e\u5176\u4ed6\u5165\u5e93\u5355");
                this.addInOtherStorageOrder(resultOrderContext);
            }
            catch (Exception e) {
                log.error("\u65b0\u589e\u5176\u4ed6\u5165\u5e93\u5355\u5f02\u5e38\uff1a", (Throwable)e);
            }
            finally {
                if (Objects.nonNull(mutex)) {
                    this.lockService.unlock(mutex);
                }
            }
        }
        return MessageResponse.SUCCESS;
    }

    @Deprecated
    private void toCenterReport(ReceiveDeliveryResultOrderContext resultOrderContext) {
        List receiveDeliveryResultOrderDetailEoList = resultOrderContext.getReceiveDeliveryResultOrderDetailEoList();
        ReceiveDeliveryResultOrderDto receiveDeliveryResultOrderEo = resultOrderContext.getReceiveDeliveryResultOrderEo();
        boolean interOrganizationTransactionOrderFlag = StringUtils.equals((CharSequence)resultOrderContext.getBusinessType(), (CharSequence)BusinessTypeEnum.INTER_ORGANIZATION_TRANSACTION_ORDER.getType());
        boolean orderSale = "cs_order_sale".equals(receiveDeliveryResultOrderEo.getRelevanceTableName());
        boolean orderSaleRefund = "cs_order_sale_refund".equals(receiveDeliveryResultOrderEo.getRelevanceTableName());
        boolean purchaseOrPurchaseReturn = "in_plan_order".equals(receiveDeliveryResultOrderEo.getRelevanceTableName());
        if (interOrganizationTransactionOrderFlag || orderSale || orderSaleRefund || purchaseOrPurchaseReturn) {
            try {
                EnterpriceCrossReceiveDeliveryResultReqDto reqDto = new EnterpriceCrossReceiveDeliveryResultReqDto();
                EnterpriceCrossReceiveDeliveryResultDto deliveryResultDto = new EnterpriceCrossReceiveDeliveryResultDto();
                BeanUtil.copyProperties((Object)receiveDeliveryResultOrderEo, (Object)deliveryResultDto, (String[])new String[0]);
                List detailList = ObjectConvertor.convertObjects((List)receiveDeliveryResultOrderDetailEoList, EnterpriceCrossReceiveDeliveryResultDetailDto.class, (String[])new String[0]);
                reqDto.setResultDto(deliveryResultDto);
                reqDto.setResultDetailDtoList(detailList);
                log.info("====\u516c\u53f8\u95f4\u4ea4\u6613\u5355\u63a8\u9001\u62a5\u8868\u4e2d\u5fc3:{}", (Object)JSONUtil.toJsonStr((Object)reqDto));
                this.orderApiProxy.receiveDeliveryResult(reqDto);
            }
            catch (Exception e) {
                log.error("\u516c\u53f8\u95f4\u4ea4\u6613\u5355\u63a8\u9001\u62a5\u8868\u4e2d\u5fc3\u5931\u8d25" + e.getMessage(), (Throwable)e);
            }
        }
    }

    private void addInOtherStorageOrder(ReceiveDeliveryResultOrderContext resultOrderContext) {
        InOtherStorageOrderDto inOtherStorageOrderDto = this.receivedResultOrderConvert.convertInOtherStorageOrderDto(resultOrderContext);
        RestResponseHelper.extractData((RestResponse)this.inOtherStorageOrderApiProxy.addOtherStorageOrder(inOtherStorageOrderDto));
    }

    private void dealWithSyncErp(ReceiveDeliveryResultOrderDto orderDto, List<ReceiveDeliveryResultOrderDetailDto> orderDetailDtos) {
        AdjustmentBusinessTypeEnum displayBusinessTypeEnum;
        String businessType;
        LogicWarehousePageReqDto reqDto = new LogicWarehousePageReqDto();
        reqDto.setWarehouseCodeList((List)Lists.newArrayList());
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{orderDto.getDeliveryLogicWarehouseCode()})) {
            reqDto.getWarehouseCodeList().add(orderDto.getDeliveryLogicWarehouseCode());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{orderDto.getReceiveLogicWarehouseCode()})) {
            reqDto.getWarehouseCodeList().add(orderDto.getReceiveLogicWarehouseCode());
        }
        if (CollectionUtil.isEmpty((Collection)reqDto.getWarehouseCodeList())) {
            log.error("\u903b\u8f91\u4ed3\u7f16\u7801\u4e3a\u7a7a\uff0c\u8df3\u8fc7ERP\u540c\u6b65");
            return;
        }
        List warehouseRespDtos = (List)this.logicWarehouseApiProxy.queryList(reqDto).getData();
        if (CollectionUtil.size((Object)warehouseRespDtos) == 0) {
            log.error("\u672a\u67e5\u8be2\u5230\u903b\u8f91\u4ed3\u5e93\u4fe1\u606f\uff0c\u8df3\u8fc7ERP\u540c\u6b65");
            return;
        }
        if (Objects.equals(orderDto.getBusinessType(), BusinessTypeEnum.TRANSFER_ORDER.getType()) && CollectionUtil.size((Object)warehouseRespDtos) != 2) {
            log.error("\u51fa\u5e93\u903b\u8f91\u4ed3\u6216\u5165\u5e93\u903b\u8f91\u4ed3\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff0c\u8df3\u8fc7ERP\u540c\u6b65");
            return;
        }
        ErpReceivedDeliveryResultOrderDto order = new ErpReceivedDeliveryResultOrderDto();
        for (LogicWarehouseRespDto respDto : warehouseRespDtos) {
            if (Objects.equals(respDto.getWarehouseCode(), orderDto.getDeliveryLogicWarehouseCode())) {
                order.setSrcErpId(respDto.getWarehouseCorrespondingSystem());
                order.setSrcOrgCode(respDto.getOrganizationCode());
                continue;
            }
            order.setDistErpId(respDto.getWarehouseCorrespondingSystem());
            order.setDistOrgCode(respDto.getOrganizationCode());
        }
        if (QUERY_OTHER_ORDER_BUSINESSTYPE.contains(orderDto.getBusinessType())) {
            DgInOtherStorageOrderPageReqDto reqDto1 = new DgInOtherStorageOrderPageReqDto();
            reqDto1.setStorageOrderNo(orderDto.getRelevanceNo());
            List orderDtos = (List)this.dgInOtherStorageOrderApiProxy.queryList(reqDto1).getData();
            DgInOtherStorageOrderDto orderDto1 = (DgInOtherStorageOrderDto)orderDtos.get(0);
            order.setCenterCode(orderDto1.getCostCenterCode());
            order.setUseScene("back_scrap_out".equals(orderDto1.getMessage()) ? "\u8fd4\u4fee\u62a5\u5e9f\u51fa\u5e93" : orderDto1.getReceivingSceneName());
            order.setSrcEnterpriseCode(orderDto1.getSaleOrganizationCode());
        } else {
            ArrayList orgCodes = Lists.newArrayList();
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{order.getSrcOrgCode()})) {
                orgCodes.add(order.getSrcOrgCode());
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{order.getDistOrgCode()})) {
                orgCodes.add(order.getDistOrgCode());
            }
            List organizationDtos = null;
            if (CollectionUtil.isNotEmpty((Collection)orgCodes)) {
                organizationDtos = (List)this.dgOrganizationApiProxy.queryOrgListByCode((List)orgCodes).getData();
            }
            if (CollectionUtil.isEmpty(organizationDtos)) {
                log.error("\u51fa\u5e93\u903b\u8f91\u4ed3\u6216\u5165\u5e93\u903b\u8f91\u4ed3\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8df3\u8fc7ERP\u540c\u6b65: {}", (Object)orgCodes);
                return;
            }
            HashMap orgCodeIdMap = Maps.newHashMap();
            for (OrganizationDto tmp : organizationDtos) {
                orgCodeIdMap.putIfAbsent(tmp.getCode(), tmp.getId());
            }
            DgEnterpriseInventoryOrgRelationQueryReqDto relationQueryReqDto = new DgEnterpriseInventoryOrgRelationQueryReqDto();
            ArrayList orgIds = Lists.newArrayList(orgCodeIdMap.values().iterator());
            relationQueryReqDto.setInventoryOrgIdList((List)orgIds);
            List orgEnters = (List)this.dgInventoryOrgQueryApiProxy.queryList(relationQueryReqDto).getData();
            if (CollectionUtil.isEmpty((Collection)orgEnters)) {
                log.error("\u8d27\u6743\u7ec4\u7ec7\u672a\u914d\u7f6e\u9500\u552e\u516c\u53f8\u5173\u7cfb\uff0c\u83b7\u53d6\u516c\u53f8\u4fe1\u606f\u5931\u8d25\uff0c\u8df3\u8fc7ERP\u540c\u6b65: {}", (Object)orgIds);
                return;
            }
            Map<Long, String> orgEntrMap = orgEnters.stream().collect(Collectors.toMap(DgInventoryOrgRelationRespDto::getOrganizationId, DgInventoryOrgRelationRespDto::getEnterpriseCode, (o1, o2) -> o1));
            order.setSrcEnterpriseCode((String)orgEntrMap.getOrDefault(orgCodeIdMap.getOrDefault(order.getSrcOrgCode(), 0L), null));
            order.setDistEnterpriseCode((String)orgEntrMap.getOrDefault(orgCodeIdMap.getOrDefault(order.getDistOrgCode(), 0L), null));
        }
        BusinessTypeEnum businessTypeEnum = BusinessTypeEnum.getEnumByType((String)orderDto.getBusinessType());
        String string = businessType = businessTypeEnum != null ? businessTypeEnum.getDesc() : orderDto.getBusinessType();
        String displayBusinessType = Objects.equals(orderDto.getBusinessType(), BusinessTypeEnum.INVENTORY_ADJUSTMENT_ORDER.getType()) ? ((displayBusinessTypeEnum = AdjustmentBusinessTypeEnum.getEnumByType((String)orderDto.getDisplayBusinessType())) != null ? displayBusinessTypeEnum.getDesc() : orderDto.getDisplayBusinessType()) : ((displayBusinessTypeEnum = DisplayBusinessTypeEnum.getEnumByType((String)orderDto.getDisplayBusinessType())) != null ? displayBusinessTypeEnum.getDesc() : orderDto.getDisplayBusinessType());
        order.setId(orderDto.getId());
        order.setCreateTime(orderDto.getCreateTime());
        order.setDocumentNo(orderDto.getDocumentNo());
        order.setBusinessTypeName(businessType);
        order.setDisplayBusinessTypeName(displayBusinessType);
        order.setDeliveryLogicWarehouseCode(orderDto.getDeliveryLogicWarehouseCode());
        order.setDeliveryLogicWarehouseName(orderDto.getDeliveryLogicWarehouseName());
        order.setReceiveLogicWarehouseCode(orderDto.getReceiveLogicWarehouseCode());
        order.setReceiveLogicWarehouseName(orderDto.getReceiveLogicWarehouseName());
        order.setBusinessDate(orderDto.getBizDate());
        List skus = orderDetailDtos.stream().map(ReceiveDeliveryResultOrderDetailDto::getSkuCode).collect(Collectors.toList());
        List skuRespDtos = (List)this.itemSkuDgQueryApiProxy.queryBySkuCode(skus).getData();
        Map<Object, Object> unitMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty((Collection)skuRespDtos)) {
            unitMap = skuRespDtos.stream().collect(Collectors.toMap(ItemSkuDgRespDto::getCode, ItemSkuDgRespDto::getUnit, (o1, o2) -> o1));
        }
        ArrayList details = Lists.newArrayList();
        for (ReceiveDeliveryResultOrderDetailDto detailDto : orderDetailDtos) {
            ErpReceivedDeliveryResultOrderDetailDto detail = new ErpReceivedDeliveryResultOrderDetailDto();
            detail.setLineNo(detailDto.getLineNo());
            detail.setId(detailDto.getId());
            detail.setSkuCode(detailDto.getSkuCode());
            detail.setSkuName(detailDto.getSkuName());
            detail.setDoneQuantity(detailDto.getDoneQuantity());
            detail.setRemark(detailDto.getRemark());
            if (Objects.equals(orderDto.getBusinessType(), BusinessTypeEnum.INVENTORY_ADJUSTMENT_ORDER.getType()) && OrderOperateTypeEnum.DELIVERY.getCode().equalsIgnoreCase(orderDto.getOrderType())) {
                detail.setDoneQuantity(detailDto.getDoneQuantity().negate());
            }
            detail.setUnit(unitMap.getOrDefault(detail.getSkuCode(), "").toUpperCase());
            details.add(detail);
        }
        order.setDetails((List)details);
        this.dealWithTransferOrder(orderDto, order.getSrcOrgCode(), order.getDistOrgCode(), order);
        if (ERP_TRANSACTION_BUSINESSTYPE.contains(orderDto.getBusinessType())) {
            order.setDisplayBusinessTypeName(businessType);
            this.misTransaction(order);
        } else {
            log.info("\u540c\u6b65ERP-\u6742\u9879\u4e8b\u52a1,\u4e0d\u652f\u6301\u7684\u4e1a\u52a1\u7c7b\u578b, \u4e0d\u63a8ERP. businessType: {}", (Object)orderDto.getBusinessType());
        }
    }

    private void dealWithTransferOrder(ReceiveDeliveryResultOrderDto orderDto, String orgCode, String transferOrgCode, ErpReceivedDeliveryResultOrderDto order) {
        boolean isReceive = OrderOperateTypeEnum.RECEIVE.getCode().equalsIgnoreCase(orderDto.getOrderType());
        if (isReceive && ERP_SUB_INVENTORY_TRANSFER_BUSINESSTYPE.contains(orderDto.getBusinessType())) {
            this.subInventoryTransfer(order);
        } else if (!isReceive && ERP_SUB_INVENTORY_TRANSFER_BUSINESSTYPE_DELIVERY.contains(orderDto.getBusinessType())) {
            this.subInventoryTransfer(order);
        } else {
            log.error("\u53d1\u8d27\u5355\u636e\uff0c\u4e1a\u52a1\u7c7b\u578b\u9519\u8bef\uff0c\u4e0d\u8c03\u7528ERP\u540c\u6b65. orderType: {}, businessType: {}", (Object)orderDto.getOrderType(), (Object)orderDto.getBusinessType());
        }
    }

    private void misTransaction(ErpReceivedDeliveryResultOrderDto order) {
        log.info("\u540c\u6b65ERP-\u6742\u9879\u4e8b\u52a1");
        RestResponse rr = this.externalInventoryErpApiProxy.misTransaction(order);
        log.info("\u540c\u6b65ERP-\u6742\u9879\u4e8b\u52a1\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)rr));
    }

    private void subInventoryTransfer(ErpReceivedDeliveryResultOrderDto order) {
        if (Objects.equals(order.getSrcEnterpriseCode(), order.getDistEnterpriseCode()) && Objects.equals(order.getSrcErpId(), order.getDistErpId())) {
            log.info("\u53d1\u8d27\u4ed3\u5e93\u4e0e\u6536\u8d27\u4ed3\u5e93\u7684\u9500\u552e\u516c\u53f8\u7f16\u7801({})\u4e0eERP ID({})\u76f8\u540c\uff0c\u4e0d\u540c\u6b65ERP", (Object)order.getSrcEnterpriseCode(), (Object)order.getSrcErpId());
            return;
        }
        RestResponse rr = this.externalInventoryErpApiProxy.subInventoryTransfer(order);
        log.info("\u540c\u6b65ERP-\u5b50\u5e93\u5b58\u8f6c\u79fb\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)rr));
    }
}

