/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.ocs.mgmt.application.rest.test;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yundt.boot.center.data.dto.dto.DictDto;
import com.yundt.boot.center.data.proxy.query.IDictQueryApiProxy;
import com.yunxi.dg.base.center.inventory.dto.entity.AdjustmentOrderDetailDto;
import com.yunxi.dg.base.center.inventory.dto.entity.AdjustmentOrderDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicWarehouseRespDto;
import com.yunxi.dg.base.center.inventory.dto.entity.PhysicsWarehouseDto;
import com.yunxi.dg.base.center.inventory.dto.entity.PhysicsWarehousePageReqDto;
import com.yunxi.dg.base.center.inventory.dto.transfer.TransferOrderAggDto;
import com.yunxi.dg.base.center.inventory.dto.transfer.TransferOrderPageDto;
import com.yunxi.dg.base.center.inventory.dto.transfer.TransferOrderSearchDto;
import com.yunxi.dg.base.center.inventory.proxy.order.ITransferOrderApiProxy;
import com.yunxi.dg.base.center.inventory.proxy.warehouse.ILogicWarehouseApiProxy;
import com.yunxi.dg.base.center.inventory.proxy.warehouse.IPhysicsWarehouseApiProxy;
import com.yunxi.dg.base.center.report.api.order.IDgOrderReportApi;
import com.yunxi.dg.base.center.report.dto.entity.DgOrderAfterReportDto;
import com.yunxi.dg.base.center.report.dto.entity.DgOrderAfterReportPageReqDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.mgmt.application.rpc.api.shopbiz.IDgShopQueryApi;
import com.yunxi.dg.base.mgmt.application.rpc.dto.request.DgShopQueryReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.DgShopRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.transfer.TransferOrderComboReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.transfer.TransferOrderDetailReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.transfer.TransferOrderReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.transfer.TransferOrderTypeEnum;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.sku.IItemSkuDgQueryApiProxy;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.TransferOrderStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.proxy.item.ItemSkuDgRespDto;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/test1"})
public class TestRest {
    private static final Logger log = LoggerFactory.getLogger(TestRest.class);
    @Resource
    private IDgOrderReportApi dgOrderReportApi;
    @Resource(name="warehouseApiProxy")
    private ILogicWarehouseApiProxy logicWarehouseApiProxy;
    @Resource
    private IPhysicsWarehouseApiProxy physicsWarehouseApiProxy;
    @Resource
    private ITransferOrderApiProxy transferOrderApiProxy;
    @Resource
    private IDgShopQueryApi dgShopQueryApi;
    @Resource
    private IDictQueryApiProxy iDictQueryApiProxy;
    @Resource
    private IItemSkuDgQueryApiProxy itemSkuDgQueryApiProxy;

    @PostMapping(path={"/seek"})
    @ApiOperation(value="\u6d4b\u8bd5\u63a5\u53e3", notes="\u6d4b\u8bd5\u63a5\u53e3")
    public RestResponse<Void> seek() {
        this.doExecute();
        return RestResponse.VOID;
    }

    @PostMapping(path={"/seek2"})
    @ApiOperation(value="\u6d4b\u8bd5\u63a5\u53e3", notes="\u6d4b\u8bd5\u63a5\u53e3")
    public RestResponse<Void> seek2() {
        this.doExecute1();
        return RestResponse.VOID;
    }

    public void doExecute1() {
        ArrayList list = Lists.newArrayList();
        AtomicInteger pageNum = new AtomicInteger(1);
        TransferOrderSearchDto reqDto = new TransferOrderSearchDto();
        reqDto.setTypeList(Collections.singletonList(TransferOrderTypeEnum.REVERSE_O_TO_O_TRANSFER.getCode()));
        reqDto.setOrderStatusList(Collections.singletonList(TransferOrderStatusEnum.PENDING.getCode()));
        reqDto.setPageSize(Integer.valueOf(1000));
        while (true) {
            int pagNum = pageNum.get();
            reqDto.setPageNum(Integer.valueOf(pagNum));
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.transferOrderApiProxy.page(reqDto));
            if (pageInfo == null || !CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) break;
            list.addAll(pageInfo.getList());
            log.info("\u67e5\u8be2\u672a\u63d0\u4ea4\u7684O2O\u8c03\u62e8\u9000\u8d27\u6c47\u603b\u5355\u8c03\u62e8\u5355, \u5f53\u524d\u7b2c{}\u9875", (Object)pagNum);
            pageNum.addAndGet(1);
        }
        log.info("\u67e5\u8be2\u672a\u63d0\u4ea4\u7684O2O\u8c03\u62e8\u9000\u8d27\u6c47\u603b\u5355\u8c03\u62e8\u5355\u5b8c\u6bd5");
        for (TransferOrderPageDto orderPageDto : list) {
            try {
                this.transferOrderApiProxy.commitTransferOrder(orderPageDto.getTransferOrderNo());
            }
            catch (Exception e) {
                log.error("\u63d0\u4ea4\u8c03\u62e8\u5355\uff1a{}\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\uff01", (Object)orderPageDto.getTransferOrderNo());
            }
        }
    }

    public void doExecute() {
        Map shopCode2DtoMap = this.queryShopList().stream().collect(Collectors.toMap(DgShopRespDto::getStoreCode, Function.identity(), (k1, k2) -> k1));
        if (CollUtil.isEmpty(shopCode2DtoMap)) {
            log.info("\u5e73\u53f0\u5382\u9001\u7684\u5e97\u94fa\u672a\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\u3002");
            return;
        }
        DictDto dictDto = (DictDto)RestResponseHelper.extractData((RestResponse)this.iDictQueryApiProxy.queryByGroupCodeAndCode("COMMON_CONFIG", "AUTO_TRANSFER_4_SETTLEMENT_CONFIG"));
        String config = "";
        if (dictDto == null || StrUtil.isBlank((CharSequence)(config = JSONObject.parseObject((String)dictDto.getValue()).getString("salesReturnTransferIn")))) {
            log.info("\u5e73\u53f0\u5382\u9001\u7684\u5e97\u94fa\u672a\u914d\u7f6e\u9000\u8d27\u5355\u8c03\u62e8\u7ed3\u7b97\u4ed3\u914d\u7f6e\u3002");
            return;
        }
        Date date = DateUtil.addDays((Date)new Date(), (int)-1);
        ArrayList all = Lists.newArrayList();
        AtomicInteger pageNum = new AtomicInteger(1);
        DgOrderAfterReportPageReqDto reqDto = new DgOrderAfterReportPageReqDto();
        reqDto.setReturnStatus("COMPLETE");
        reqDto.setPageSize(Integer.valueOf(1000));
        reqDto.setShopCodes(new ArrayList<String>(shopCode2DtoMap.keySet()));
        reqDto.setCompleteDateStart("2024-07-10 00:00:00");
        reqDto.setCompleteDateEnd("2024-07-10 23:59:59");
        while (true) {
            int pagNum = pageNum.get();
            reqDto.setPageNum(Integer.valueOf(pagNum));
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.dgOrderReportApi.pageOrderAfterParam(reqDto));
            if (pageInfo == null || !CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) break;
            all.addAll(pageInfo.getList());
            log.info("\u67e5\u8be2\u5f53\u65e5\u552e\u540e\u8ba2\u5355\u5546\u54c1\u884c, \u5f53\u524d\u7b2c{}\u9875", (Object)pagNum);
            pageNum.addAndGet(1);
        }
        log.info("\u67e5\u8be2\u5f53\u65e5\u552e\u540e\u8ba2\u5355\u5546\u54c1\u884c\u5b8c\u6bd5");
        Set skuCodes = all.stream().map(DgOrderAfterReportDto::getSkuCode).filter(CharSequenceUtil::isNotEmpty).collect(Collectors.toSet());
        HashMap<String, String> skuCode2UnitMap = new HashMap<String, String>();
        List skuSubLists = CollectionUtil.split(skuCodes, (int)500);
        for (List skuCodeList : skuSubLists) {
            skuCode2UnitMap.putAll(((List)RestResponseHelper.extractData((RestResponse)this.itemSkuDgQueryApiProxy.queryBySkuCode(skuCodeList))).stream().collect(Collectors.toMap(ItemSkuDgRespDto::getCode, ItemSkuDgRespDto::getUnit, (k1, k2) -> k1)));
        }
        String finalConfig = config;
        Map<String, List<DgOrderAfterReportDto>> collect = all.stream().filter(x -> shopCode2DtoMap.containsKey(x.getShopCode())).collect(Collectors.groupingBy(x -> {
            x.setSettlementWarehouseCode(((DgShopRespDto)shopCode2DtoMap.get(x.getShopCode())).getSettlementWarehouseCode());
            return "SUMMARY_TRANSFER".equals(finalConfig) ? StrUtil.join((CharSequence)"_", (Object[])new Object[]{x.getSettlementWarehouseCode(), x.getReturnWarehouseCode()}) : x.getAfterSaleOrderNo();
        }));
        for (Map.Entry<String, List<DgOrderAfterReportDto>> entry : collect.entrySet()) {
            String inLogicWarehouseCode;
            List<DgOrderAfterReportDto> orderDetails = entry.getValue();
            if (CollUtil.isEmpty(orderDetails)) {
                log.info("{}\u4e0d\u5b58\u5728\u9700\u8981\u5904\u7406\u7684\u552e\u540e\u5355", (Object)entry.getKey());
                continue;
            }
            Map<String, List<DgOrderAfterReportDto>> skuDetailMap = orderDetails.stream().collect(Collectors.groupingBy(o -> o.getSkuCode()));
            BigDecimal totalQuantity = BigDecimal.ZERO;
            ArrayList transferOrderDetailDtos = Lists.newArrayList();
            ArrayList adjustmentOrderDetailDtos = Lists.newArrayList();
            for (Map.Entry<String, List<DgOrderAfterReportDto>> skuDetailEntry : skuDetailMap.entrySet()) {
                String skuCode = skuDetailEntry.getKey();
                DgOrderAfterReportDto orderLine = skuDetailEntry.getValue().get(0);
                AssertUtils.notNull((Object)orderLine, (String)"\u8ba2\u5355\u884c\u4e0d\u5b58\u5728");
                orderLine.setUnit((String)skuCode2UnitMap.get(orderLine.getSkuCode()));
                this.buildTransferOrderDetail(skuDetailEntry, orderLine, skuCode, transferOrderDetailDtos);
                this.buildAdjustmentOrderDetail(skuDetailEntry, orderLine, adjustmentOrderDetailDtos);
            }
            String outLogicWarehouseCode = orderDetails.get(0).getSettlementWarehouseCode();
            if (Objects.equals(outLogicWarehouseCode, inLogicWarehouseCode = orderDetails.get(0).getReturnWarehouseCode())) {
                log.info("\u8c03\u62e8\u51fa\u4e0e\u8c03\u62e8\u5165\u7684\u903b\u8f91\u4ed3\u4e00\u81f4\uff0c\u65e0\u6cd5\u521b\u5efa\u8c03\u62e8\u5355");
                continue;
            }
            LogicWarehouseRespDto outLogicWarehouseRespDto = (LogicWarehouseRespDto)RestResponseHelper.extractData((RestResponse)this.logicWarehouseApiProxy.queryLogicWarehouseByCode(outLogicWarehouseCode));
            AssertUtils.notNull((Object)outLogicWarehouseRespDto, (String)String.format("\u8c03\u62e8\u5355\u6307\u5b9a\u8c03\u51fa%s\u903b\u8f91\u4ed3\u4e0d\u5b58\u5728", outLogicWarehouseCode));
            LogicWarehouseRespDto inLogicWarehouseRespDto = (LogicWarehouseRespDto)RestResponseHelper.extractData((RestResponse)this.logicWarehouseApiProxy.queryLogicWarehouseByCode(inLogicWarehouseCode));
            AssertUtils.notNull((Object)inLogicWarehouseRespDto, (String)String.format("\u8c03\u62e8\u5355\u6307\u5b9a\u8c03\u5165%s\u903b\u8f91\u4ed3\u4e0d\u5b58\u5728", inLogicWarehouseCode));
            PhysicsWarehousePageReqDto physicsWarehouseQueryDto = new PhysicsWarehousePageReqDto();
            physicsWarehouseQueryDto.setWarehouseCodeList((List)Lists.newArrayList((Object[])new String[]{inLogicWarehouseRespDto.getPhysicsWarehouseCode()}));
            List dgPhysicsWarehouseDtos = (List)RestResponseHelper.extractData((RestResponse)this.physicsWarehouseApiProxy.queryListData(physicsWarehouseQueryDto));
            AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)dgPhysicsWarehouseDtos), (String)"\u7269\u7406\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728");
            PhysicsWarehouseDto dgPhysicsWarehouseDto = dgPhysicsWarehouseDtos.stream().findFirst().orElse(new PhysicsWarehouseDto());
            AdjustmentOrderDto adjustmentOrderDto = this.buildAdjustmentOrderReqDto(inLogicWarehouseRespDto, dgPhysicsWarehouseDto, adjustmentOrderDetailDtos);
            TransferOrderComboReqDto trOrderReqDto = this.buildTransferOrderReqDto(totalQuantity, outLogicWarehouseRespDto, inLogicWarehouseRespDto, dgPhysicsWarehouseDto, transferOrderDetailDtos);
            log.info("\u521b\u5efa\u6c47\u603b\u5e93\u5b58\u8c03\u6574\u5355\u5165\u53c2\uff1a{}", JSON.toJSON((Object)adjustmentOrderDto));
            TransferOrderAggDto transferOrderAggDto = new TransferOrderAggDto();
            transferOrderAggDto.setAdjustmentOrderDto(adjustmentOrderDto);
            transferOrderAggDto.setTransferOrderComboReqDto(trOrderReqDto);
            transferOrderAggDto.setReverse(Boolean.valueOf(false));
            this.transferOrderApiProxy.autoGenerateTransferOrder(transferOrderAggDto);
        }
    }

    @NotNull
    private AdjustmentOrderDto buildAdjustmentOrderReqDto(LogicWarehouseRespDto outLogicWarehouseRespDto, PhysicsWarehouseDto dgPhysicsWarehouseDto, List<AdjustmentOrderDetailDto> adjustmentOrderDetailDtos) {
        AdjustmentOrderDto adjumentOrderDto = new AdjustmentOrderDto();
        adjumentOrderDto.setAdjustmentOrderDetailDtos(new ArrayList());
        adjumentOrderDto.setEvent("audit_success");
        adjumentOrderDto.setOrderType("INVENTORY_ADJUSTMENT");
        adjumentOrderDto.setPushSap(Integer.valueOf(0));
        adjumentOrderDto.setPushWms(Integer.valueOf(0));
        adjumentOrderDto.setBusinessType("inventory_adjustment");
        adjumentOrderDto.setBizDate(new Date());
        adjumentOrderDto.setWarehouseCode(outLogicWarehouseRespDto.getWarehouseCode());
        adjumentOrderDto.setWarehouseName(outLogicWarehouseRespDto.getWarehouseName());
        adjumentOrderDto.setOrganizationCode(outLogicWarehouseRespDto.getOrganizationCode());
        adjumentOrderDto.setOrganizationName(outLogicWarehouseRespDto.getOrganizationName());
        adjumentOrderDto.setPhysicsWarehouseCode(dgPhysicsWarehouseDto.getWarehouseCode());
        adjumentOrderDto.setPhysicsWarehouseName(dgPhysicsWarehouseDto.getWarehouseName());
        adjumentOrderDto.setAdjustmentOrderDetailDtos(adjustmentOrderDetailDtos);
        return adjumentOrderDto;
    }

    @NotNull
    private TransferOrderComboReqDto buildTransferOrderReqDto(BigDecimal totalQuantity, LogicWarehouseRespDto outLogicWarehouseRespDto, LogicWarehouseRespDto inLogicWarehouseRespDto, PhysicsWarehouseDto dgPhysicsWarehouseDto, List<TransferOrderDetailReqDto> transferOrderDetailDtos) {
        TransferOrderReqDto transferOrderReqDto = new TransferOrderReqDto();
        transferOrderReqDto.setType(TransferOrderTypeEnum.REVERSE_O_TO_O_TRANSFER.getCode());
        transferOrderReqDto.setTotalQuantity(totalQuantity);
        transferOrderReqDto.setIsVirtual(Integer.valueOf(0));
        transferOrderReqDto.setOutLogicWarehouseCode(outLogicWarehouseRespDto.getWarehouseCode());
        transferOrderReqDto.setOutLogicWarehouseName(outLogicWarehouseRespDto.getWarehouseName());
        transferOrderReqDto.setOutOrganizationId(outLogicWarehouseRespDto.getOrganizationId());
        transferOrderReqDto.setOutOrganizationCode(outLogicWarehouseRespDto.getOrganizationCode());
        transferOrderReqDto.setOutOrganization(outLogicWarehouseRespDto.getOrganizationName());
        transferOrderReqDto.setInLogicWarehouseCode(inLogicWarehouseRespDto.getWarehouseCode());
        transferOrderReqDto.setInLogicWarehouseName(inLogicWarehouseRespDto.getWarehouseName());
        transferOrderReqDto.setInOrganizationId(inLogicWarehouseRespDto.getOrganizationId());
        transferOrderReqDto.setInOrganizationCode(inLogicWarehouseRespDto.getOrganizationCode());
        transferOrderReqDto.setInOrganization(inLogicWarehouseRespDto.getOrganizationName());
        transferOrderReqDto.setBizDate(new Date());
        transferOrderReqDto.setContact(dgPhysicsWarehouseDto.getContact());
        transferOrderReqDto.setContactPhone(dgPhysicsWarehouseDto.getPhone());
        transferOrderReqDto.setProvince(dgPhysicsWarehouseDto.getProvince());
        transferOrderReqDto.setProvinceCode(dgPhysicsWarehouseDto.getProvinceCode());
        transferOrderReqDto.setCity(dgPhysicsWarehouseDto.getCity());
        transferOrderReqDto.setCityCode(dgPhysicsWarehouseDto.getCityCode());
        transferOrderReqDto.setArea(dgPhysicsWarehouseDto.getDistrict());
        transferOrderReqDto.setAreaCode(dgPhysicsWarehouseDto.getDistrictCode());
        transferOrderReqDto.setAddress(dgPhysicsWarehouseDto.getDetailAddress());
        TransferOrderComboReqDto trOrderReqDto = new TransferOrderComboReqDto();
        trOrderReqDto.setTransferOrderReqDto(transferOrderReqDto);
        trOrderReqDto.setDetailList(transferOrderDetailDtos);
        return trOrderReqDto;
    }

    private void buildAdjustmentOrderDetail(Map.Entry<String, List<DgOrderAfterReportDto>> skuDetailEntry, DgOrderAfterReportDto orderLine, List<AdjustmentOrderDetailDto> adjustmentOrderDetailDtos) {
        AdjustmentOrderDetailDto detailDto = new AdjustmentOrderDetailDto();
        detailDto.setSkuCode(orderLine.getSkuCode());
        detailDto.setChangeType("decrease");
        detailDto.setChangeQuantity(skuDetailEntry.getValue().stream().map(DgOrderAfterReportDto::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add));
        detailDto.setUnit(orderLine.getUnit());
        adjustmentOrderDetailDtos.add(detailDto);
    }

    private void buildTransferOrderDetail(Map.Entry<String, List<DgOrderAfterReportDto>> skuDetailEntry, DgOrderAfterReportDto orderLine, String skuCode, List<TransferOrderDetailReqDto> detailReqDtos) {
        TransferOrderDetailReqDto detailReqDto = new TransferOrderDetailReqDto();
        detailReqDto.setQuantity(skuDetailEntry.getValue().stream().map(DgOrderAfterReportDto::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add));
        detailReqDto.setSpecification(orderLine.getSkuDesc());
        detailReqDto.setBasicUnit(orderLine.getUnit());
        detailReqDto.setBasicUnitName(orderLine.getUnit());
        detailReqDto.setSkuName(orderLine.getSkuName());
        detailReqDto.setUnit(orderLine.getUnit());
        detailReqDto.setSkuCode(skuCode);
        detailReqDtos.add(detailReqDto);
    }

    public List<DgShopRespDto> queryShopList() {
        DgShopQueryReqDto reqDto = new DgShopQueryReqDto();
        reqDto.setUseSettlementWarehouse(Integer.valueOf(1));
        reqDto.setStatusList(Collections.singletonList(1));
        return (List)this.dgShopQueryApi.queryListShop(reqDto).getData();
    }
}

