/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.context;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.yundt.boot.center.data.dto.request.DictQueryExtReqDto;
import com.yundt.boot.center.data.dto.response.DictExtRespDto;
import com.yundt.boot.center.data.proxy.query.IDictQueryApiProxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Configuration;

@EnableConfigurationProperties
@ConfigurationProperties(prefix="ocs.dg.config", ignoreInvalidFields=true)
@Configuration
public class OcsConfig
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(OcsConfig.class);
    @Resource
    private IDictQueryApiProxy iDictQueryApiProxy;
    protected static boolean UNIT_CONVERSION;

    public static boolean isUnitConversion() {
        return UNIT_CONVERSION;
    }

    @Value(value="${project.item.unit.conversion}")
    public void setUnitConversion(boolean unitConversion) {
        UNIT_CONVERSION = unitConversion;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        DictQueryExtReqDto dictQueryExtReqDto = new DictQueryExtReqDto();
        dictQueryExtReqDto.setCodes(Arrays.asList("DEV_OPS_CONFIG"));
        try {
            List dictExtRespDtoList = (List)this.iDictQueryApiProxy.queryByParam(dictQueryExtReqDto).getData();
            if (CollectionUtils.isNotEmpty((Collection)dictExtRespDtoList)) {
                Map<String, Integer> devOpsConfigMap = dictExtRespDtoList.stream().collect(Collectors.toMap(DictExtRespDto::getCode, DictExtRespDto::getStatus, (o, o1) -> o));
                UNIT_CONVERSION = ObjectUtil.equal((Object)1, (Object)devOpsConfigMap.get("UNIT_ENABLE"));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

