/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.customer.api.query.IDgCsShipmentEnterpriseQueryApi;
import com.yunxi.dg.base.center.customer.dto.request.DgCsShipmentEnterprisePageReqDto;
import com.yunxi.dg.base.center.customer.dto.response.DgCsShipmentEnterpriseRespDto;
import com.yunxi.dg.base.center.inventory.dto.pda.DeliveryInfoDto;
import com.yunxi.dg.base.center.inventory.proxy.pda.IDeliveryLogisticsApiProxy;
import com.yunxi.dg.base.center.inventory.proxy.pda.ILogisticsCompanySiteApiProxy;
import com.yunxi.dg.base.center.report.dto.inventory.DgOutNoticeOrderDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgOutNoticeOrderPageReqDto;
import com.yunxi.dg.base.center.report.proxy.inventory.IDgOutNoticeOrderApiProxy;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.ocs.mgmt.application.constants.BaseOrderStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.ImportDeliveryOrderModeDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_delivery_order")
public class DeliveryOrderCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(DeliveryOrderCommonServiceImpl.class);
    @Autowired
    private IDgOutNoticeOrderApiProxy outNoticeOrderApiProxy;
    @Autowired
    private ILogisticsCompanySiteApiProxy logisticsCompanySiteApiProxy;
    @Autowired
    private IDeliveryLogisticsApiProxy deliveryLogisticsApiProxy;
    @Autowired
    private IDgCsShipmentEnterpriseQueryApi dgCsShipmentEnterpriseQueryApi;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        log.debug("\u7535\u5546\u53d1\u8d27\u5355\u5bfc\u5165\u6570\u636e:{}", (Object)JSONObject.toJSONString(result));
        ArrayList passList = Lists.newArrayList();
        List resultList = BeanUtil.copyToList((Collection)result.getList(), ImportDeliveryOrderModeDto.class);
        if (CollectionUtil.isEmpty((Collection)resultList)) {
            respDto.setErrorMsg("\u5bfc\u5165\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return new ArrayList();
        }
        if (resultList.size() > 2000) {
            respDto.setErrorMsg("\u6279\u91cf\u5bfc\u5165\u4e0d\u652f\u6301\u8d85\u8fc72000\u884c");
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return new ArrayList();
        }
        List documentNoList = resultList.stream().map(ImportDeliveryOrderModeDto::getDocumentNo).collect(Collectors.toList());
        DgOutNoticeOrderPageReqDto pageReqDto = new DgOutNoticeOrderPageReqDto();
        pageReqDto.setPageNum(Integer.valueOf(1));
        pageReqDto.setPageSize(Integer.valueOf(documentNoList.size()));
        pageReqDto.setDocumentNoList(documentNoList);
        List outNoticeOrderDtoList = Optional.ofNullable(((PageInfo)RestResponseHelper.extractData((RestResponse)this.outNoticeOrderApiProxy.page(pageReqDto))).getList()).orElse(new ArrayList());
        Map<String, DgOutNoticeOrderDto> orderDtoMap = outNoticeOrderDtoList.stream().collect(Collectors.toMap(DgOutNoticeOrderDto::getDocumentNo, Function.identity(), (v1, v2) -> v1));
        for (ImportDeliveryOrderModeDto dto : resultList) {
            boolean isPass = this.paramVerify(dto, orderDtoMap);
            if (!isPass) {
                dto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", dto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), dto.getErrorMsg()));
                respDto.getErrorDetails().add(dto);
                continue;
            }
            passList.add(dto);
        }
        respDto.setDetails((List)passList);
        return passList;
    }

    private boolean paramVerify(ImportDeliveryOrderModeDto dto, Map<String, DgOutNoticeOrderDto> orderDtoMap) {
        if (StringUtils.isBlank((CharSequence)dto.getDocumentNo())) {
            dto.setErrorMsg("\u51fa\u5e93\u901a\u77e5\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)dto.getShippingCompanyName())) {
            dto.setErrorMsg("\u7269\u6d41\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (MapUtils.isEmpty(orderDtoMap) || MapUtils.isNotEmpty(orderDtoMap) && !orderDtoMap.containsKey(dto.getDocumentNo())) {
            dto.setErrorMsg("\u51fa\u5e93\u901a\u77e5\u5355\u53f7 " + dto.getDocumentNo() + " \u4e0d\u5b58\u5728");
            return false;
        }
        DgOutNoticeOrderDto orderDto = orderDtoMap.get(dto.getDocumentNo());
        if (BaseOrderStatusEnum.ONO_PORTION_OUT.getCode().equals(orderDto.getOrderStatus()) || BaseOrderStatusEnum.ONO_TOTAL_OUT.getCode().equals(orderDto.getOrderStatus())) {
            dto.setErrorMsg("\u51fa\u5e93\u901a\u77e5\u5355\u53f7\u72b6\u6001\u4e0d\u80fd\u4e3a\u5168\u90e8\u51fa\u5e93");
            return false;
        }
        DgCsShipmentEnterprisePageReqDto dgCsShipmentEnterprisePageReqDtoqDto = new DgCsShipmentEnterprisePageReqDto();
        dgCsShipmentEnterprisePageReqDtoqDto.setPageNum(Integer.valueOf(1));
        dgCsShipmentEnterprisePageReqDtoqDto.setPageSize(Integer.valueOf(1));
        dgCsShipmentEnterprisePageReqDtoqDto.setName(dto.getShippingCompanyName());
        List list = ((PageInfo)RestResponseHelper.extractData((RestResponse)this.dgCsShipmentEnterpriseQueryApi.page(dgCsShipmentEnterprisePageReqDtoqDto))).getList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            dto.setErrorMsg("\u7269\u6d41\u516c\u53f8 " + dto.getShippingCompanyName() + " \u4e0d\u5b58\u5728");
            return false;
        }
        dto.setShippingCompany(((DgCsShipmentEnterpriseRespDto)list.get(0)).getCode());
        return true;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        log.info("\u5bfc\u5165\u7535\u5546\u53d1\u8d27\u51fa\u5e93-callBackImportFileOperationCommonAsync-->result:{}", (Object)JSON.toJSONString(result));
        List passList = (List)object;
        if (CollectionUtil.isEmpty((Collection)passList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        if (CollectionUtil.isNotEmpty((Collection)passList) && !respDto.getErrorDetails().isEmpty()) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode());
        }
        respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
        try {
            ArrayList reqDtos = new ArrayList();
            passList.forEach(dto -> {
                DeliveryInfoDto deliveryInfoDto = new DeliveryInfoDto();
                deliveryInfoDto.setDeliveryNo(dto.getDocumentNo());
                deliveryInfoDto.setShippingCode(dto.getShippingCode());
                deliveryInfoDto.setShippingCompanyName(dto.getShippingCompanyName());
                deliveryInfoDto.setShippingCompany(dto.getShippingCompany());
                deliveryInfoDto.setSubShippingCode(dto.getSubShippingCode());
                deliveryInfoDto.setImportType(this.getImportType());
                reqDtos.add(deliveryInfoDto);
            });
            this.deliveryLogisticsApiProxy.batchUpdateDeliveryInfo(reqDtos);
        }
        catch (Exception e) {
            log.info("\u5bfc\u5165\u7535\u5546\u53d1\u8d27\u51fa\u5e93\u5931\u8d25", (Throwable)e);
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            respDto.setErrorMsg(e.getMessage());
        }
    }

    protected Integer getImportType() {
        return 1;
    }
}

