/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yundt.boot.center.data.dto.dto.DictDto;
import com.yundt.boot.center.data.dto.dto.DictValueDto;
import com.yundt.boot.center.data.proxy.query.IDictQueryApiProxy;
import com.yunxi.dg.base.center.inventory.proxy.order.ITransferOrderApiProxy;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.mgmt.application.rpc.dto.entity.LogicWarehousePageReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.entity.LogicWarehouseRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.inventory.DgLogicInventoryDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.inventory.DgLogicInventoryListReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.transfer.TransferOrderComboReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.transfer.TransferOrderDetailReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.transfer.TransferOrderReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.inventory.IDgLogicInventoryApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.inventorybiz.ICsLogicInventoryQueryApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.inventorybiz.ICsWarehouseAddressQueryApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.sku.IItemSkuDgQueryApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.warehouse.ILogicWarehouseApiProxy;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.inventory.WarehouseAddressDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.inventory.WarehouseAddressPageReqDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.proxy.inventory.CsLogicInventoryQueryDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.proxy.item.ItemSkuDgRespDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.ImportTransferOrderModeDto;
import com.yunxi.dg.base.poi.constant.PoiFileModeMap;
import com.yunxi.dg.base.poi.dto.ExcelImportMultiResult;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import com.yunxi.dg.base.poi.utils.EasyPoiExportUtil;
import com.yunxi.dg.base.poi.utils.excel.NewExcelUtil;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_transfer_order")
public class TransferOrderCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(TransferOrderCommonServiceImpl.class);
    @Resource
    private ILogicWarehouseApiProxy iLogicWarehouseApiProxy;
    @Resource
    private ITransferOrderApiProxy transferOrderApiProxy;
    @Resource
    private ICsLogicInventoryQueryApiProxy csLogicInventoryQueryApiProxy;
    @Resource
    private IDgLogicInventoryApiProxy dgLogicInventoryApiProxy;
    @Resource
    private IItemSkuDgQueryApiProxy itemSkuDgQueryApiProxy;
    @Resource
    private ICsWarehouseAddressQueryApiProxy csWarehouseAddressQueryApiProxy;
    @Resource
    private IDictQueryApiProxy iDictQueryApiProxy;

    public ExcelImportMultiResult<ImportBaseModeDto> parseExcelDataMultiResult(ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ExcelImportMultiResult result = new ExcelImportMultiResult();
        try {
            EasyPoiExportUtil.checkFileInfo((String)commonReqDto.getImportFileUrl());
            List list = (List)PoiFileModeMap.importTemplateMap.get((Object)commonReqDto.getKey());
            Object obj = list.get(0);
            List<Class<Object>> importTemplateList = new ArrayList<Class>();
            boolean multiFlag = obj instanceof List;
            if (multiFlag) {
                importTemplateList = (List)obj;
            } else {
                importTemplateList.add((Class)obj);
            }
            Integer headRows = (Integer)list.get(1);
            NewExcelUtil excelUtil = new NewExcelUtil(importTemplateList, commonReqDto.getImportFileUrl(), Integer.valueOf(headRows == null ? 1 : headRows));
            log.info("\u6267\u884c\u89e3\u6790\u4e861212121wewewe");
            excelUtil.execute();
            result.setVerfiyFail(excelUtil.isVerfiyFail());
            result.setFailMap(excelUtil.getFailMap());
            result.setSuccessMap(excelUtil.getSuccessMap());
            result.setTotalRows(excelUtil.getTotalRows());
            if (result.getTotalRows() == 0) {
                ImportTransferOrderModeDto baseModeDto = new ImportTransferOrderModeDto();
                baseModeDto.setErrorMsg("\u5bfc\u5165\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5bfc\u51fa\u7684 excel \u6587\u4ef6\uff0c\u661f\u53f7 * \u4e3a\u5fc5\u586b\u9879");
                respDto.getErrorDetails().add(baseModeDto);
            }
            if (excelUtil.isVerfiyFail()) {
                log.info("\u5b58\u5728\u6821\u9a8c\u5931\u8d25\u7684\u6570\u636e");
                result.getFailMap().entrySet().forEach(e -> ((List)e.getValue()).forEach(l -> {
                    l.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", l.getRowNum() + headRows, l.getErrorMsg()));
                    if (!multiFlag) {
                        respDto.getErrorDetails().add(l);
                    } else {
                        List errList = respDto.getErrorDetailsMap().getOrDefault(e.getKey(), new ArrayList());
                        errList.add(l);
                        respDto.getErrorDetailsMap().put(e.getKey(), errList);
                    }
                }));
                respDto.setStatus(CollectionUtil.isNotEmpty((Map)result.getSuccessMap()) ? FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode() : FileOperationStatusEnum.IMPORT_ERROR.getCode());
            }
            if (!(obj instanceof List)) {
                if (CollectionUtil.isNotEmpty((Map)result.getSuccessMap())) {
                    result.setList((List)result.getSuccessMap().values().iterator().next());
                }
                if (CollectionUtil.isNotEmpty((Map)result.getFailMap())) {
                    result.setFailList((List)result.getFailMap().values().iterator().next());
                }
            }
        }
        catch (Exception e2) {
            log.error("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25:IO\u5f02\u5e38", (Throwable)e2);
            throw new BizException("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25:" + e2.getMessage());
        }
        return result;
    }

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u62e8\u5355\u5bfc\u5165\u6570\u636e:{}", (Object)JSONObject.toJSONString(result));
        }
        List importTransferOrderModeDtoList = BeanUtil.copyToList((Collection)result.getList(), ImportTransferOrderModeDto.class);
        if (CollectionUtil.isEmpty((Collection)result.getList())) {
            respDto.getErrorDetails().add("\u5bfc\u5165\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5bfc\u51fa\u7684 excel \u6587\u4ef6");
            ImportTransferOrderModeDto errModeDto = new ImportTransferOrderModeDto();
            errModeDto.setErrorMsg("\u5bfc\u5165\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5bfc\u51fa\u7684 excel \u6587\u4ef6, \u7ea2\u8272\u5b57\u4f53\u5217\u4e3a\u5fc5\u586b");
            importTransferOrderModeDtoList.add(errModeDto);
            return importTransferOrderModeDtoList;
        }
        List skuCodeList = importTransferOrderModeDtoList.stream().map(ImportTransferOrderModeDto::getSkuCode).collect(Collectors.toList());
        List itemSkuDgRespDtoList = Optional.ofNullable(this.itemSkuDgQueryApiProxy.queryBySkuCode(skuCodeList).getData()).orElse(new ArrayList());
        Map itemSkuMap = itemSkuDgRespDtoList.stream().collect(Collectors.toMap(ItemSkuDgRespDto::getCode, Function.identity(), (o, o1) -> o));
        Map<String, String> unitSkuCodeMap = itemSkuDgRespDtoList.stream().collect(Collectors.toMap(ItemSkuDgRespDto::getCode, ItemSkuDgRespDto::getUnit, (o, o1) -> o));
        for (ImportTransferOrderModeDto importTransferOrderModeDto : importTransferOrderModeDtoList) {
            if (!unitSkuCodeMap.containsKey(importTransferOrderModeDto.getSkuCode())) continue;
            importTransferOrderModeDto.setUnit(unitSkuCodeMap.get(importTransferOrderModeDto.getSkuCode()));
        }
        Set<String> outWarehouseCodeSet = this.createSetFromDtoList(importTransferOrderModeDtoList, ImportTransferOrderModeDto::getOutLogicWarehouseCode);
        List<LogicWarehouseRespDto> outLogicWarehouseDtoList = this.queryDgLogicWarehouseByCodeList(outWarehouseCodeSet);
        Map<String, LogicWarehouseRespDto> outWarehouseDtoMap = outLogicWarehouseDtoList.stream().collect(Collectors.toMap(LogicWarehouseRespDto::getWarehouseCode, Function.identity(), (o, o1) -> o));
        if (log.isDebugEnabled()) {
            log.debug("outLogicWarehouseDtoList:{}", (Object)JSONObject.toJSONString(outLogicWarehouseDtoList));
            log.debug("outWarehouseDtoMap:{}", (Object)JSONObject.toJSONString(outWarehouseDtoMap));
        }
        Set<String> inWarehouseCodeSet = this.createSetFromDtoList(importTransferOrderModeDtoList, ImportTransferOrderModeDto::getInLogicWarehouseCode);
        List<LogicWarehouseRespDto> inLogicWarehouseDtoList = this.queryDgLogicWarehouseByCodeList(inWarehouseCodeSet);
        Map<String, LogicWarehouseRespDto> inWarehouseDtoMap = inLogicWarehouseDtoList.stream().collect(Collectors.toMap(LogicWarehouseRespDto::getWarehouseCode, Function.identity(), (o, o1) -> o));
        DgLogicInventoryListReqDto queryDto = new DgLogicInventoryListReqDto();
        queryDto.setWarehouseCodeList((List)Lists.newArrayList(outWarehouseCodeSet));
        List logicInventoryRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.dgLogicInventoryApiProxy.queryList(queryDto));
        Map<String, List<DgLogicInventoryDto>> listMap = logicInventoryRespDtoList.stream().collect(Collectors.groupingBy(DgLogicInventoryDto::getWarehouseCode, Collectors.toList()));
        List dictDtoList = ((PageInfo)RestResponseHelper.extractData((RestResponse)this.iDictQueryApiProxy.queryByPage(Integer.valueOf(1), Integer.valueOf(1), "{'code':'transfer_order','groupCode':'transfer_order'}"))).getList();
        HashMap<String, String> bizTypeMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)dictDtoList)) {
            bizTypeMap = ((List)Optional.of(((DictDto)dictDtoList.get(0)).getDictValueList()).orElse(new ArrayList())).stream().collect(Collectors.toMap(DictValueDto::getLabel, DictValueDto::getValue, (key1, key2) -> key1));
        }
        log.info("\u5bf9\u5e94\u8c03\u62e8\u5355\u4e1a\u52a1\u7c7b\u578b\uff1a{}", (Object)JSONObject.toJSONString(bizTypeMap));
        HashMap skuBatchVerifyMap = new HashMap();
        HashMap<Integer, String> sortVerifyMap = new HashMap<Integer, String>();
        for (ImportTransferOrderModeDto transferOrderModeDto : importTransferOrderModeDtoList) {
            this.verifyWarehouseCode(outWarehouseDtoMap, transferOrderModeDto, transferOrderModeDto.getOutLogicWarehouseCode(), "\u8c03\u51fa\u903b\u8f91\u4ed3\u7f16\u7801\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5", "out", commonReqDto, respDto);
            this.verifyWarehouseCode(inWarehouseDtoMap, transferOrderModeDto, transferOrderModeDto.getInLogicWarehouseCode(), "\u8c03\u5165\u903b\u8f91\u4ed3\u7f16\u7801\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5", "in", commonReqDto, respDto);
            this.verifySkuCode(listMap, transferOrderModeDto, commonReqDto, respDto);
            this.verifyBizType(commonReqDto, transferOrderModeDto, bizTypeMap, respDto);
            this.verifySortNo(commonReqDto, sortVerifyMap, transferOrderModeDto, respDto);
        }
        CsLogicInventoryQueryDto csLogicInventoryQueryDto = new CsLogicInventoryQueryDto();
        csLogicInventoryQueryDto.setWarehouseCodeList(importTransferOrderModeDtoList.stream().map(ImportTransferOrderModeDto::getOutLogicWarehouseCode).collect(Collectors.toList()));
        csLogicInventoryQueryDto.setCargoCodeList(importTransferOrderModeDtoList.stream().map(ImportTransferOrderModeDto::getSkuCode).collect(Collectors.toList()));
        return this.fillTransferOrderComboReqDtoList(importTransferOrderModeDtoList, respDto);
    }

    private void verifySortNo(ImportFileOperationCommonReqDto commonReqDto, Map<Integer, String> sortVerifyMap, ImportTransferOrderModeDto importDto, ImportFileOperationCommonRespDto respDto) {
        Integer sortNo = importDto.getSortNo();
        if (Objects.isNull(sortNo)) {
            return;
        }
        String warehouseKey = importDto.getInLogicWarehouseCode() + '_' + importDto.getOutLogicWarehouseCode();
        if (sortVerifyMap.containsKey(sortNo) && !sortVerifyMap.get(sortNo).equals(warehouseKey)) {
            importDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", importDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), "\u540c\u4e00\u4e2a\u8c03\u62e8\u5355\u5e8f\u53f7\u9700\u8c03\u5165\u3001\u8c03\u51fa\u4ed3\u4e00\u81f4"));
            respDto.getErrorDetails().add(importDto);
            return;
        }
        sortVerifyMap.put(sortNo, warehouseKey);
    }

    public void verifyBizType(ImportFileOperationCommonReqDto commonReqDto, ImportTransferOrderModeDto importDto, Map<String, String> bizTypeMap, ImportFileOperationCommonRespDto respDto) {
        if (!bizTypeMap.containsKey(importDto.getBusinessType())) {
            importDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", importDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), "\u5355\u636e\u4e1a\u52a1\u7c7b\u578b\u4e0d\u5b58\u5728"));
            respDto.getErrorDetails().add(importDto);
            return;
        }
        String bizType = bizTypeMap.get(importDto.getBusinessType());
        importDto.setBusinessType(bizType);
    }

    private List<LogicWarehouseRespDto> queryDgLogicWarehouseByCodeList(Collection<String> warehouseCodeSet) {
        LogicWarehousePageReqDto dto = new LogicWarehousePageReqDto();
        dto.setWarehouseCodeList((List)Lists.newArrayList(warehouseCodeSet));
        return (List)RestResponseHelper.extractData((RestResponse)this.iLogicWarehouseApiProxy.queryList(dto));
    }

    private <T, R> Set<R> createSetFromDtoList(List<T> dtoList, Function<T, R> mappingFunction) {
        return dtoList.stream().map(mappingFunction).collect(Collectors.toSet());
    }

    private List<TransferOrderComboReqDto> fillTransferOrderComboReqDtoList(List<ImportTransferOrderModeDto> importTransferOrderModeDtoList, ImportFileOperationCommonRespDto respDto) {
        Map listMap = importTransferOrderModeDtoList.stream().collect(Collectors.groupingBy(this::getTransferOrderKey, Collectors.toList()));
        ArrayList transferOrderComboReqDtoList = Lists.newArrayList();
        listMap.forEach((k, v) -> {
            TransferOrderComboReqDto reqDto = new TransferOrderComboReqDto();
            reqDto.setCommitType("SAVE");
            try {
                this.fillTransferOrderComboReqDto(reqDto, (List<ImportTransferOrderModeDto>)v);
            }
            catch (ParseException e) {
                log.info("\u6570\u636e\u65e5\u671f\u8f6c\u5316\u65e5\u5e38:{}", (Throwable)e);
                respDto.setErrorMsg(e.getMessage());
            }
            transferOrderComboReqDtoList.add(reqDto);
        });
        return transferOrderComboReqDtoList;
    }

    private void fillTransferOrderComboReqDto(TransferOrderComboReqDto reqDto, List<ImportTransferOrderModeDto> transferOrderModeDtoList) throws ParseException {
        TransferOrderReqDto transferOrderReqDto = new TransferOrderReqDto();
        ImportTransferOrderModeDto importTransferOrderModeDto = transferOrderModeDtoList.get(0);
        transferOrderReqDto.setType(importTransferOrderModeDto.getBusinessType());
        transferOrderReqDto.setOutLogicWarehouseName(importTransferOrderModeDto.getOutLogicWarehouseName());
        transferOrderReqDto.setOutLogicWarehouseCode(importTransferOrderModeDto.getOutLogicWarehouseCode());
        transferOrderReqDto.setInLogicWarehouseCode(importTransferOrderModeDto.getInLogicWarehouseCode());
        transferOrderReqDto.setInLogicWarehouseName(importTransferOrderModeDto.getInLogicWarehouseName());
        transferOrderReqDto.setHasBatch(YesNoHelper.NO);
        transferOrderReqDto.setIsVirtual(this.isVirtual(importTransferOrderModeDto.getBusinessType()));
        transferOrderReqDto.setRemark(importTransferOrderModeDto.getRemark());
        transferOrderReqDto.setBizDate(Objects.isNull(importTransferOrderModeDto.getBizDate()) ? new Date() : DateUtils.parseDate((String)importTransferOrderModeDto.getBizDate(), (String[])new String[]{"yyyy/MM/dd"}));
        transferOrderReqDto.setExternalSaleOrderNo(importTransferOrderModeDto.getExternalOrderNo());
        transferOrderReqDto.setCustomerCode(importTransferOrderModeDto.getInLogicWarehouseCode());
        transferOrderReqDto.setCustomerName(importTransferOrderModeDto.getInLogicWarehouseName());
        transferOrderReqDto.setProvince(importTransferOrderModeDto.getProvince());
        transferOrderReqDto.setCity(importTransferOrderModeDto.getCity());
        transferOrderReqDto.setArea(importTransferOrderModeDto.getArea());
        transferOrderReqDto.setAddress(importTransferOrderModeDto.getDetailAddress());
        transferOrderReqDto.setContact(importTransferOrderModeDto.getContact());
        transferOrderReqDto.setContactPhone(importTransferOrderModeDto.getContactPhone());
        transferOrderReqDto.setInOrganization(importTransferOrderModeDto.getInOrganization());
        transferOrderReqDto.setInOrganizationCode(importTransferOrderModeDto.getInOrganizationCode());
        transferOrderReqDto.setOutOrganization(importTransferOrderModeDto.getOutOrganization());
        transferOrderReqDto.setOutOrganizationCode(importTransferOrderModeDto.getOutOrganizationCode());
        transferOrderReqDto.setShipmentEnterpriseCode(importTransferOrderModeDto.getLogisticsCompany());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("platformName", (Object)importTransferOrderModeDto.getPlatformName());
        jsonObject.put("whetherSend", (Object)0);
        transferOrderReqDto.setExtension(jsonObject.toJSONString());
        reqDto.setTransferOrderReqDto(transferOrderReqDto);
        this.fillTransferOrderReqDtoList(reqDto, transferOrderModeDtoList);
    }

    private Integer isVirtual(String businessType) {
        return StrUtil.equalsAny((CharSequence)businessType, (CharSequence[])new CharSequence[]{"\u9500\u552e\u865a\u62df\u8c03\u62e8", "\u666e\u901a\u865a\u62df\u8c03\u62e8"}) ? 1 : 0;
    }

    private void fillTransferOrderReqDtoList(TransferOrderComboReqDto reqDto, List<ImportTransferOrderModeDto> transferOrderModeDtoList) {
        ArrayList<TransferOrderDetailReqDto> detailList = new ArrayList<TransferOrderDetailReqDto>();
        StringBuilder remark = new StringBuilder();
        for (ImportTransferOrderModeDto transferOrderModeDto : transferOrderModeDtoList) {
            TransferOrderDetailReqDto transferOrderDetailReqDto = new TransferOrderDetailReqDto();
            transferOrderDetailReqDto.setSkuCode(transferOrderModeDto.getSkuCode());
            transferOrderDetailReqDto.setSkuName(transferOrderModeDto.getSkuName());
            transferOrderDetailReqDto.setBatch(transferOrderModeDto.getBatch());
            transferOrderDetailReqDto.setQuantity(transferOrderModeDto.getPlanQuantity());
            transferOrderDetailReqDto.setUnit(transferOrderModeDto.getUnit());
            transferOrderDetailReqDto.setInventoryProperty(transferOrderDetailReqDto.getInventoryProperty());
            detailList.add(transferOrderDetailReqDto);
            remark.append(transferOrderModeDto.getRemark());
        }
        if (StrUtil.isNotBlank((CharSequence)remark) && remark.length() > 500) {
            reqDto.getTransferOrderReqDto().setRemark(remark.substring(0, 500));
        } else {
            reqDto.getTransferOrderReqDto().setRemark(remark.toString());
        }
        reqDto.setDetailList(detailList);
    }

    private String getTransferOrderKey(ImportTransferOrderModeDto importTransferOrderModeDto) {
        return String.format("%s_%s_%s_%s", importTransferOrderModeDto.getSortNo(), importTransferOrderModeDto.getBusinessType(), importTransferOrderModeDto.getOutLogicWarehouseCode(), importTransferOrderModeDto.getInLogicWarehouseCode());
    }

    public void callBackImportFileOperationCommonSync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        if (CollectionUtil.isNotEmpty((Collection)respDto.getErrorDetails()) || StringUtils.isNotBlank((CharSequence)respDto.getErrorMsg())) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        try {
            List transferOrderComboReqDtoList = (List)object;
            if (log.isDebugEnabled()) {
                log.info("\u65b0\u589e\u8c03\u62e8\u5355:{}", (Object)JSONObject.toJSONString((Object)transferOrderComboReqDtoList));
            }
            for (TransferOrderComboReqDto transferOrderComboReqDto : transferOrderComboReqDtoList) {
                try {
                    this.transferOrderApiProxy.add(transferOrderComboReqDto);
                }
                catch (Exception e) {
                    log.info("\u8c03\u62e8\u5355\u65b0\u589e\u5931\u8d25:{}", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            log.info("\u5bfc\u5165\u8c03\u62e8\u5355\u5931\u8d25:{}", (Throwable)e);
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            respDto.setErrorMsg(e.getMessage());
        }
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        this.callBackImportFileOperationCommonSync(result, commonReqDto, respDto, object);
    }

    private boolean verifyWarehouseCode(Map<String, LogicWarehouseRespDto> warehouseDtoMap, ImportTransferOrderModeDto importDto, String warehouseCode, String errorMsg, String type, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        if (StrUtil.isNotBlank((CharSequence)importDto.getErrorMsg())) {
            return false;
        }
        if (!warehouseDtoMap.containsKey(warehouseCode)) {
            importDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", importDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), errorMsg));
            respDto.getErrorDetails().add(importDto);
            return false;
        }
        LogicWarehouseRespDto logicWarehouse = warehouseDtoMap.get(warehouseCode);
        if (logicWarehouse != null && "disable".equals(logicWarehouse.getWarehouseStatus())) {
            importDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", importDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), "\u4ed3\u5e93\u5df2\u7981\u7528"));
            respDto.getErrorDetails().add(importDto);
            return false;
        }
        if (logicWarehouse != null) {
            if ("in".equals(type)) {
                importDto.setInLogicWarehouseName(logicWarehouse.getWarehouseName());
                importDto.setInOrganizationCode(logicWarehouse.getOrganizationCode());
                importDto.setInOrganization(logicWarehouse.getOrganizationName());
                this.setReceiveCustomers(logicWarehouse, importDto);
            } else {
                importDto.setOutLogicWarehouseName(logicWarehouse.getWarehouseName());
                importDto.setOutOrganizationCode(logicWarehouse.getOrganizationCode());
                importDto.setOutOrganization(logicWarehouse.getOrganizationName());
            }
        }
        return true;
    }

    private void setReceiveCustomers(LogicWarehouseRespDto logicWarehouse, ImportTransferOrderModeDto transferOrderModeDto) {
        String warehouseCode = logicWarehouse.getPhysicsWarehouseCode();
        if (StringUtils.isBlank((CharSequence)warehouseCode)) {
            return;
        }
        log.info("\u8bbe\u7f6e\u6536\u8d27\u5ba2\u6237\u4fe1\u606f\uff1a\u5165\u5e93\u7269\u7406\u4ed3:{}", (Object)warehouseCode);
        WarehouseAddressPageReqDto reqDto = new WarehouseAddressPageReqDto();
        reqDto.setWarehouseCode(warehouseCode);
        reqDto.setWarehouseClassify("physics");
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csWarehouseAddressQueryApiProxy.page(reqDto));
        log.info("\u67e5\u8be2\u56de\u6765\u7684\u4ed3\u5e93\u5730\u5740\uff1a{}", (Object)JSONObject.toJSONString((Object)pageInfo));
        if (pageInfo == null || CollectionUtil.isEmpty((Collection)pageInfo.getList())) {
            return;
        }
        WarehouseAddressDto warehouseAddressDto = (WarehouseAddressDto)pageInfo.getList().get(0);
        transferOrderModeDto.setProvince(warehouseAddressDto.getProvince());
        transferOrderModeDto.setCity(warehouseAddressDto.getCity());
        transferOrderModeDto.setArea(warehouseAddressDto.getDistrict());
        transferOrderModeDto.setDetailAddress(warehouseAddressDto.getDetailAddress());
        transferOrderModeDto.setContact(warehouseAddressDto.getContacts());
        transferOrderModeDto.setContactPhone(warehouseAddressDto.getPhone());
    }

    private boolean verifySkuStatus(Map<String, ItemSkuDgRespDto> itemSkuMap, ImportTransferOrderModeDto importDto, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ItemSkuDgRespDto itemSkuDgRespDto = itemSkuMap.get(importDto.getSkuCode());
        if (itemSkuDgRespDto != null && itemSkuDgRespDto.getSubStatus() == 0) {
            importDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", importDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), "\u5546\u54c1\u5df2\u88ab\u7981\u7528"));
            respDto.getErrorDetails().add(importDto);
            return false;
        }
        return true;
    }

    private boolean verifySkuCode(Map<String, List<DgLogicInventoryDto>> listMap, ImportTransferOrderModeDto importDto, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        if (listMap.containsKey(importDto.getOutLogicWarehouseCode())) {
            if (StrUtil.isNotBlank((CharSequence)importDto.getErrorMsg())) {
                return false;
            }
            List<DgLogicInventoryDto> csLogicInventoryRespDtos = listMap.get(importDto.getOutLogicWarehouseCode());
            Map skuMap = csLogicInventoryRespDtos.stream().collect(Collectors.toMap(DgLogicInventoryDto::getSkuCode, Function.identity(), (existingValue, newValue) -> newValue));
            if (!skuMap.containsKey(importDto.getSkuCode())) {
                importDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", importDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), "\u5546\u54c1\u7f16\u7801\uff08\u7269\u6599\u7f16\u7801\uff09\u4e0d\u5b58\u5728"));
                respDto.getErrorDetails().add(importDto);
                return false;
            }
            DgLogicInventoryDto dgLogicInventoryDto = (DgLogicInventoryDto)skuMap.get(importDto.getSkuCode());
            importDto.setSkuName(dgLogicInventoryDto.getSkuName());
        }
        return true;
    }

    private boolean verifyBatch(Map<String, List<DgLogicInventoryDto>> listMap, ImportTransferOrderModeDto importDto, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        if (listMap.containsKey(importDto.getOutLogicWarehouseCode())) {
            if (StrUtil.isNotBlank((CharSequence)importDto.getErrorMsg())) {
                return false;
            }
            if (Objects.isNull(importDto.getBatch())) {
                importDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", importDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), "\u6279\u6b21\u53f7\u672a\u586b\u5199"));
                respDto.getErrorDetails().add(importDto);
                return false;
            }
            List<DgLogicInventoryDto> csLogicInventoryRespDtos = listMap.get(importDto.getOutLogicWarehouseCode());
            Map skuMap = csLogicInventoryRespDtos.stream().collect(Collectors.toMap(DgLogicInventoryDto::getBatch, Function.identity(), (existingValue, newValue) -> newValue));
            if (!skuMap.containsKey(importDto.getBatch())) {
                importDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", importDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), "\u6279\u6b21\u4e0d\u5b58\u5728"));
                respDto.getErrorDetails().add(importDto);
                return false;
            }
        }
        return true;
    }
}

