/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.finance.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.ParamConverter;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.finance.dto.entity.ItemSkuDgDto;
import com.yunxi.dg.base.center.finance.dto.entity.SaleOrderBillRecordDto;
import com.yunxi.dg.base.center.finance.dto.entity.SaleOrderBillRecordPageReqDto;
import com.yunxi.dg.base.center.finance.dto.request.BillInfoListQueryDto;
import com.yunxi.dg.base.center.finance.dto.request.BillInfoQueryDto;
import com.yunxi.dg.base.center.finance.dto.request.BillInfoReqDto;
import com.yunxi.dg.base.center.finance.dto.request.BillItemQueryDto;
import com.yunxi.dg.base.center.finance.dto.request.BillItemReqDto;
import com.yunxi.dg.base.center.finance.dto.request.CallBackInvoiceInfoReqDto;
import com.yunxi.dg.base.center.finance.dto.request.InvoiceItemQueryDto;
import com.yunxi.dg.base.center.finance.dto.response.BatchOperationRespDto;
import com.yunxi.dg.base.center.finance.dto.response.BillInfoRespDto;
import com.yunxi.dg.base.center.finance.dto.response.BillItemRespDto;
import com.yunxi.dg.base.center.finance.dto.response.InvoiceItemRespDto;
import com.yunxi.dg.base.center.finance.proxy.entity.IBillInfoApiProxy;
import com.yunxi.dg.base.center.finance.proxy.entity.IBillItemApiProxy;
import com.yunxi.dg.base.center.finance.proxy.entity.IItemDgApiFinanceProxy;
import com.yunxi.dg.base.center.finance.proxy.entity.ISaleOrderBillRecordQueryApiProxy;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.mgmt.service.finance.FinancialManagementInvoiceManagementTocInvoiceManagementService;
import com.yunxi.dg.base.mgmt.service.utils.AssertUtil;
import com.yunxi.dg.base.ocs.mgmt.application.constants.BillTitleTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.BillCreateTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.BillInfoColourTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.BillInfoTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.InvoiceStateEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.AddTocInvoiceParams;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.BatchOperateInvoiceVO;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.BillItemExportVo;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.CheckTocInvoiceOrderStatusParams;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.EditInvoiceBaseInfoBody;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.FetchGoodsTaxRateParams;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.GetInvoiceItemPageParams;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.GetInvoiceTaxGoodsListPageParams;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.GetTocInvoiceGoodsListPageParams;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.GetTocInvoiceLIstPageParams;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.GetTocInvoiceOrderStatusResponseData;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.GoodsVO;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.InvoiceBasicVO;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.InvoiceBatchOperationResponseVO;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.InvoiceItemVO;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.InvoiceReturnParams;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.InvoicingGoodsVO;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.ModifyTocInvoiceRedOrderNoBody;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.ModifyTocInvoiceRemarkBody;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.ModifyTocInvoiceSubjectParams;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.TocInvoiceManagementVO;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.TocInvoiceSubjectVO;
import com.yunxi.dg.base.ocs.mgmt.application.dto.financial.request.SyncResultStatusReqDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.financial.response.SyncResultStatusRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Service(value="AbstractBaseFileOperationCommonService_BILL_INFO")
public class FinancialManagementInvoiceManagementTocInvoiceManagementServiceServiceImpl
extends AbstractBaseFileOperationCommonService
implements FinancialManagementInvoiceManagementTocInvoiceManagementService {
    private static final Logger logger = LoggerFactory.getLogger(FinancialManagementInvoiceManagementTocInvoiceManagementServiceServiceImpl.class);
    @Resource
    private IBillInfoApiProxy billInfoApi;
    @Resource
    private IBillItemApiProxy billItemApi;
    @Resource
    private IItemDgApiFinanceProxy iItemDgApiFinanceProxy;
    @Resource
    private ISaleOrderBillRecordQueryApiProxy saleOrderBillRecordQueryApi;

    @Override
    public RestResponse<Object> addTocInvoice(@ApiParam(value="") @Valid @RequestBody(required=false) AddTocInvoiceParams addTocInvoiceParams) {
        BillInfoReqDto billInfoReqDto = new BillInfoReqDto();
        this.addBillInfoParam(addTocInvoiceParams, billInfoReqDto);
        Long id = (Long)RestResponseHelper.extractData((RestResponse)this.billInfoApi.addBillInfo(billInfoReqDto));
        return new RestResponse((Object)id);
    }

    @Override
    public RestResponse<InvoiceBatchOperationResponseVO> batchAuditTocInvoice(@ApiParam(value="") @Valid @RequestBody(required=false) BatchOperateInvoiceVO batchOperateInvoiceVO) {
        RestResponse batchOperationRespDtoRestResponse = this.billInfoApi.auditBillInfo(batchOperateInvoiceVO.getTradeNos());
        BatchOperationRespDto batchOperationRespDto = (BatchOperationRespDto)RestResponseHelper.extractData((RestResponse)batchOperationRespDtoRestResponse);
        InvoiceBatchOperationResponseVO invoiceBatchOperationResponseVO = new InvoiceBatchOperationResponseVO();
        invoiceBatchOperationResponseVO.setSuccessNum(ParamConverter.convertToBigDecimal((Object)batchOperationRespDto.getSuccessNum()));
        invoiceBatchOperationResponseVO.setFailNum(ParamConverter.convertToBigDecimal((Object)batchOperationRespDto.getFailNum()));
        return new RestResponse((Object)invoiceBatchOperationResponseVO);
    }

    @Override
    public RestResponse<Object> batchCancelTocInvoice(@ApiParam(value="") @Valid @RequestBody(required=false) BatchOperateInvoiceVO batchOperateInvoiceVO) {
        RestResponse batchOperationRespDtoRestResponse = this.billInfoApi.cancelBillInfo(batchOperateInvoiceVO.getTradeNos());
        BatchOperationRespDto batchOperationRespDto = (BatchOperationRespDto)RestResponseHelper.extractData((RestResponse)batchOperationRespDtoRestResponse);
        return new RestResponse((Object)batchOperationRespDto);
    }

    @Override
    public RestResponse<Object> batchInvoicingTocInvoice(@ApiParam(value="") @Valid @RequestBody(required=false) BatchOperateInvoiceVO batchOperateInvoiceVO) {
        RestResponse batchOperationRespDtoRestResponse = this.billInfoApi.addOrderInvoice(batchOperateInvoiceVO.getTradeNos());
        BatchOperationRespDto batchOperationRespDto = (BatchOperationRespDto)RestResponseHelper.extractData((RestResponse)batchOperationRespDtoRestResponse);
        return new RestResponse((Object)batchOperationRespDto);
    }

    @Override
    public RestResponse<Object> batchRedFlushTocInvoice(@ApiParam(value="") @Valid @RequestBody(required=false) BatchOperateInvoiceVO batchOperateInvoiceVO) {
        RestResponse batchOperationRespDtoRestResponse = this.billInfoApi.redOrderInvoice(batchOperateInvoiceVO.getTradeNos());
        BatchOperationRespDto batchOperationRespDto = (BatchOperationRespDto)RestResponseHelper.extractData((RestResponse)batchOperationRespDtoRestResponse);
        return new RestResponse((Object)batchOperationRespDto);
    }

    @Override
    public RestResponse<Object> batchPrintTocInvoice(@ApiParam(value="") @Valid @RequestBody(required=false) BatchOperateInvoiceVO batchOperateInvoiceVO) {
        RestResponse batchOperationRespDtoRestResponse = this.billInfoApi.paperInvoicePrint(batchOperateInvoiceVO.getTradeNos());
        BatchOperationRespDto batchOperationRespDto = (BatchOperationRespDto)RestResponseHelper.extractData((RestResponse)batchOperationRespDtoRestResponse);
        return new RestResponse((Object)batchOperationRespDtoRestResponse);
    }

    @Override
    public RestResponse<Object> fetchGoodsTaxRate(@ApiParam(value="") @Valid @RequestBody(required=false) FetchGoodsTaxRateParams fetchGoodsTaxRateParams) {
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)fetchGoodsTaxRateParams.getGoodsList()), "\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        List itemCodeList = fetchGoodsTaxRateParams.getGoodsList().stream().map(GoodsVO::getGoodsCode).distinct().collect(Collectors.toList());
        List itemSkuDgDtos = (List)RestResponseHelper.extractData((RestResponse)this.iItemDgApiFinanceProxy.queryItemInfoBySkuCode(itemCodeList));
        Map itemSkuDgDtoMap = itemSkuDgDtos.stream().collect(Collectors.toMap(ItemSkuDgDto::getCode, Function.identity(), (v1, v2) -> v2));
        ArrayList invoicingGoodsVOList = new ArrayList();
        fetchGoodsTaxRateParams.getGoodsList().forEach(good -> {
            ItemSkuDgDto itemSkuDgDto;
            InvoicingGoodsVO invoicingGoodsVO = new InvoicingGoodsVO();
            CubeBeanUtils.copyProperties((Object)invoicingGoodsVO, (Object)good, (String[])new String[0]);
            if (itemSkuDgDtoMap.containsKey(good.getGoodsCode()) && null != (itemSkuDgDto = (ItemSkuDgDto)itemSkuDgDtoMap.get(good.getGoodsCode())).getItemRateDgDto() && null != itemSkuDgDto.getItemRateDgDto().getId()) {
                invoicingGoodsVO.setTaxClassificationCode(itemSkuDgDto.getItemRateDgDto().getCode());
                invoicingGoodsVO.setTaxRate(itemSkuDgDto.getItemRateDgDto().getRate());
            }
            invoicingGoodsVOList.add(invoicingGoodsVO);
        });
        return new RestResponse(invoicingGoodsVOList);
    }

    @Override
    public RestResponse<PageInfo<InvoicingGoodsVO>> getInvoiceTaxGoodsListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetInvoiceTaxGoodsListPageParams getInvoiceTaxGoodsListPageParams) {
        return new RestResponse();
    }

    @Override
    public RestResponse<TocInvoiceManagementVO> getTocInvoiceDetail(@NotNull @ApiParam(value="", required=true) @Valid @RequestParam(value="id", required=true) String id) {
        RestResponse billInfoRespDtoRestResponse = this.billInfoApi.queryById(ParamConverter.convertToLong((Object)id));
        BillInfoRespDto billInfoRespDto = (BillInfoRespDto)RestResponseHelper.extractData((RestResponse)billInfoRespDtoRestResponse);
        TocInvoiceManagementVO tocInvoiceManagementVO = new TocInvoiceManagementVO();
        this.getInvoiceResponseParams(tocInvoiceManagementVO, billInfoRespDto);
        return new RestResponse((Object)tocInvoiceManagementVO);
    }

    @Override
    public RestResponse<PageInfo<InvoicingGoodsVO>> getTocInvoiceGoodsListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetTocInvoiceGoodsListPageParams getTocInvoiceGoodsListPageParams) {
        BillItemQueryDto billItemQueryDto = new BillItemQueryDto();
        billItemQueryDto.setBillFlowNo(getTocInvoiceGoodsListPageParams.getTradeNo());
        billItemQueryDto.setPageNum(getTocInvoiceGoodsListPageParams.getPageNum());
        billItemQueryDto.setPageSize(getTocInvoiceGoodsListPageParams.getPageSize());
        PageInfo billItemRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.billItemApi.queryByPage(billItemQueryDto));
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)billItemRespDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        if (CollectionUtils.isEmpty((Collection)billItemRespDtoPageInfo.getList())) {
            new RestResponse((Object)pageInfo);
        }
        List invoicingGoodsVOList = billItemRespDtoPageInfo.getList().stream().map(billInfo -> {
            InvoicingGoodsVO invoicingGoodsVO = new InvoicingGoodsVO();
            this.getInvoiceItemResponseParams(invoicingGoodsVO, (BillItemRespDto)billInfo);
            return invoicingGoodsVO;
        }).collect(Collectors.toList());
        pageInfo.setList(invoicingGoodsVOList);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<PageInfo<TocInvoiceManagementVO>> getTocInvoiceListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetTocInvoiceLIstPageParams getTocInvoiceLIstPageParams) {
        BillInfoQueryDto billInfoQueryDto = new BillInfoQueryDto();
        this.queryPageParam(billInfoQueryDto, getTocInvoiceLIstPageParams);
        RestResponse pageInfoRestResponse = this.billInfoApi.queryByPage(billInfoQueryDto);
        PageInfo billInfoRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)billInfoRespDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        if (CollectionUtils.isEmpty((Collection)billInfoRespDtoPageInfo.getList())) {
            new RestResponse((Object)pageInfo);
        }
        List tocInvoiceManagementVOList = billInfoRespDtoPageInfo.getList().stream().map(billInfo -> {
            TocInvoiceManagementVO tocInvoiceManagementVO = new TocInvoiceManagementVO();
            this.getInvoiceResponseParams(tocInvoiceManagementVO, (BillInfoRespDto)billInfo);
            return tocInvoiceManagementVO;
        }).collect(Collectors.toList());
        pageInfo.setList(tocInvoiceManagementVOList);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<Map<String, BigDecimal>> queryTotal(@ApiParam(value="") @Valid @RequestBody(required=false) GetTocInvoiceLIstPageParams getTocInvoiceLIstPageParams) {
        BillInfoQueryDto billInfoQueryDto = new BillInfoQueryDto();
        this.queryPageParam(billInfoQueryDto, getTocInvoiceLIstPageParams);
        Map resultMap = (Map)RestResponseHelper.extractData((RestResponse)this.billInfoApi.queryTotal(billInfoQueryDto));
        return new RestResponse((Object)resultMap);
    }

    @Override
    public RestResponse<PageInfo<BillItemExportVo>> queryBillItemList(@ApiParam(value="") @Valid @RequestBody(required=false) GetTocInvoiceLIstPageParams getTocInvoiceLIstPageParams) {
        BillInfoQueryDto billInfoQueryDto = new BillInfoQueryDto();
        this.queryPageParam(billInfoQueryDto, getTocInvoiceLIstPageParams);
        RestResponse pageInfoRestResponse = this.billInfoApi.queryBillItemList(billInfoQueryDto);
        PageInfo billInfoRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)billInfoRespDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        if (CollectionUtils.isEmpty((Collection)billInfoRespDtoPageInfo.getList())) {
            new RestResponse((Object)pageInfo);
        }
        List billItemExportVos = billInfoRespDtoPageInfo.getList().stream().map(v -> {
            BillItemExportVo billItemExportVo = new BillItemExportVo();
            CubeBeanUtils.copyProperties((Object)billItemExportVo, (Object)v, (String[])new String[0]);
            return billItemExportVo;
        }).collect(Collectors.toList());
        pageInfo.setList(billItemExportVos);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<PageInfo<InvoiceItemVO>> getInvoiceItemPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetInvoiceItemPageParams getInvoiceItemPageParams) {
        InvoiceItemQueryDto invoiceItemDto = new InvoiceItemQueryDto();
        this.queryInvoiceItemPageParams(getInvoiceItemPageParams, invoiceItemDto);
        logger.info("\u67e5\u8be2\u53d1\u7968\u8be6\u60c5\u8868\u7684\u53c2\u6570\u662f:{}", (Object)JSON.toJSONString((Object)invoiceItemDto));
        RestResponse infoRestResponse = this.billInfoApi.queryItemByPage(invoiceItemDto);
        PageInfo invoiceItemRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)infoRestResponse);
        logger.info("\u53d1\u7968\u8be6\u60c5\u8868\u7684\u7ed3\u679c\u662f\uff1a{}", (Object)JSON.toJSONString((Object)invoiceItemRespDtoPageInfo));
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)invoiceItemRespDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        if (CollectionUtils.isEmpty((Collection)invoiceItemRespDtoPageInfo.getList())) {
            new RestResponse((Object)pageInfo);
        }
        List invoiceItemVOList = invoiceItemRespDtoPageInfo.getList().stream().map(item -> {
            InvoiceItemVO invoiceItemVO = new InvoiceItemVO();
            this.getInvoiceItemVO((InvoiceItemRespDto)item, invoiceItemVO);
            return invoiceItemVO;
        }).collect(Collectors.toList());
        pageInfo.setList(invoiceItemVOList);
        return new RestResponse((Object)pageInfo);
    }

    private void queryInvoiceItemPageParams(GetInvoiceItemPageParams getInvoiceItemPageParams, InvoiceItemQueryDto invoiceItemDto) {
        invoiceItemDto.setPageNum(getInvoiceItemPageParams.getPageNum());
        invoiceItemDto.setPageSize(getInvoiceItemPageParams.getPageSize());
        invoiceItemDto.setInvoicingDateStart(getInvoiceItemPageParams.getInvoicingDateStart());
        invoiceItemDto.setInvoicingDateEnd(getInvoiceItemPageParams.getInvoicingDateEnd());
        invoiceItemDto.setInvoiceChannel(getInvoiceItemPageParams.getInvoiceChannel());
        invoiceItemDto.setInvoiceStatus(getInvoiceItemPageParams.getInvoiceStatus());
        invoiceItemDto.setSkuCode(getInvoiceItemPageParams.getSkuCode());
        invoiceItemDto.setSkuName(getInvoiceItemPageParams.getSkuName());
        if (CollectionUtils.isNotEmpty((Collection)getInvoiceItemPageParams.getInvoiceEntityIdList())) {
            invoiceItemDto.setInvoiceEntityIdList(getInvoiceItemPageParams.getInvoiceEntityIdList().stream().map(item -> ParamConverter.convertToLong((Object)item)).collect(Collectors.toList()));
        }
        if (CollectionUtils.isNotEmpty((Collection)getInvoiceItemPageParams.getShopIdList())) {
            invoiceItemDto.setShopIdList(getInvoiceItemPageParams.getShopIdList().stream().map(item -> ParamConverter.convertToLong((Object)item)).collect(Collectors.toList()));
        }
        if (CollectionUtils.isNotEmpty((Collection)getInvoiceItemPageParams.getInvoiceAccountTypeList())) {
            invoiceItemDto.setInvoiceAccountTypeList(getInvoiceItemPageParams.getInvoiceAccountTypeList());
        }
        if (CollectionUtils.isNotEmpty((Collection)getInvoiceItemPageParams.getInvoiceTypeList())) {
            invoiceItemDto.setInvoiceTypeList(getInvoiceItemPageParams.getInvoiceTypeList());
        }
        if (CollectionUtils.isNotEmpty((Collection)getInvoiceItemPageParams.getPlatformOrderNoList())) {
            invoiceItemDto.setPlatformOrderNoList(getInvoiceItemPageParams.getPlatformOrderNoList());
        }
        if (CollectionUtils.isNotEmpty((Collection)getInvoiceItemPageParams.getInvoiceNoList())) {
            invoiceItemDto.setInvoiceNoList(getInvoiceItemPageParams.getInvoiceNoList());
        }
    }

    private void getInvoiceItemVO(InvoiceItemRespDto item, InvoiceItemVO invoiceItemVO) {
        BigDecimal taxAmount;
        BillInfoTypeEnum billInfoTypeEnum;
        CubeBeanUtils.copyProperties((Object)item, (Object)invoiceItemVO, (String[])new String[0]);
        invoiceItemVO.setInvoiceTradeNo(item.getInvoiceTradeNo());
        invoiceItemVO.setPlatformOrderNo(item.getPlatformOrderNo());
        invoiceItemVO.setBillChannel(item.getBillChannel());
        invoiceItemVO.setShopCode(item.getShopCode());
        invoiceItemVO.setShopName(item.getShopName());
        invoiceItemVO.setShopId(ParamConverter.convertToString((Object)item.getShopId()));
        invoiceItemVO.setCustomerCode(item.getCustomerCode());
        invoiceItemVO.setInvoiceEntityCode(item.getInvoiceEntityCode());
        invoiceItemVO.setInvoiceEntityName(item.getInvoiceEntityName());
        invoiceItemVO.setInvoiceEntityId(ParamConverter.convertToString((Object)item.getInvoiceEntityId()));
        invoiceItemVO.setInvoiceEnterprise(item.getInvoiceEnterprise());
        invoiceItemVO.setInvoiceChannel(item.getInvoiceChannel());
        invoiceItemVO.setInvoiceAccountType(item.getInvoiceAccountType());
        invoiceItemVO.setInvoiceType(item.getInvoiceType());
        invoiceItemVO.setInvoiceAmount(item.getInvoiceAmount());
        invoiceItemVO.setInvoiceCode(item.getInvoiceCode());
        invoiceItemVO.setInvoiceHeader(item.getInvoiceHeader());
        invoiceItemVO.setTaxpayerIdentificationNo(item.getTaxpayerIdentificationNo());
        invoiceItemVO.setQuantity(item.getQuantity());
        invoiceItemVO.setItemCode(item.getItemCode());
        invoiceItemVO.setItemName(item.getItemName());
        invoiceItemVO.setSpecification(item.getSpecification());
        invoiceItemVO.setBillLineItemName(item.getBillLineItemName());
        invoiceItemVO.setInvoiceRemark(item.getInvoiceRemark());
        invoiceItemVO.setTaxRate(item.getTaxRate());
        invoiceItemVO.setTaxAmount(item.getTaxAmount());
        invoiceItemVO.setInvoiceNo(item.getInvoiceNo());
        invoiceItemVO.setInvoicingDate(DateUtil.format((Date)item.getInvoicingDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        invoiceItemVO.setShopId(ParamConverter.convertToString((Object)item.getShopId()));
        invoiceItemVO.setInvoiceEntityId(ParamConverter.convertToString((Object)item.getInvoiceEntityId()));
        BillInfoColourTypeEnum typeEnum = BillInfoColourTypeEnum.getEnumByCode((String)item.getInvoiceAccountType());
        if (typeEnum != null) {
            invoiceItemVO.setInvoiceAccountTypeName(typeEnum.getName());
        }
        if ((billInfoTypeEnum = BillInfoTypeEnum.getEnumByCode((String)item.getInvoiceType())) != null) {
            invoiceItemVO.setInvoiceTypeName(billInfoTypeEnum.getName());
        }
        invoiceItemVO.setStationName(item.getSite());
        BigDecimal amount = item.getAmount();
        if (amount == null) {
            amount = BigDecimal.ZERO;
        }
        if ((taxAmount = item.getTaxAmount()) == null) {
            taxAmount = BigDecimal.ZERO;
            invoiceItemVO.setTaxAmount(taxAmount);
        }
        invoiceItemVO.setNoTaxRateAmount(amount.subtract(taxAmount));
        if (invoiceItemVO.getInvoiceAccountType() != null && Arrays.asList("red_ticket", "cancel_ticket").contains(invoiceItemVO.getInvoiceAccountType())) {
            if (invoiceItemVO.getInvoiceAmount() != null && new BigDecimal(invoiceItemVO.getInvoiceAmount()).compareTo(new BigDecimal("0")) > 0) {
                BigDecimal bigDecimal = new BigDecimal(invoiceItemVO.getInvoiceAmount());
                BigDecimal negativeBigDecimal = bigDecimal.negate();
                invoiceItemVO.setInvoiceAmount(negativeBigDecimal.stripTrailingZeros().toPlainString());
            }
            if (invoiceItemVO.getNoTaxRateAmount() != null && invoiceItemVO.getNoTaxRateAmount().compareTo(new BigDecimal("0")) > 0) {
                invoiceItemVO.setNoTaxRateAmount(invoiceItemVO.getNoTaxRateAmount().negate());
            }
            if (invoiceItemVO.getTaxAmount() != null && invoiceItemVO.getTaxAmount().compareTo(new BigDecimal("0")) > 0) {
                invoiceItemVO.setTaxAmount(invoiceItemVO.getTaxAmount().negate());
            }
        }
    }

    @Override
    public RestResponse<PageInfo<TocInvoiceSubjectVO>> getTocInvoiceSubjectListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetTocInvoiceGoodsListPageParams getTocInvoiceGoodsListPageParams) {
        BillItemQueryDto billItemQueryDto = new BillItemQueryDto();
        billItemQueryDto.setBillFlowNo(getTocInvoiceGoodsListPageParams.getTradeNo());
        billItemQueryDto.setPageNum(getTocInvoiceGoodsListPageParams.getPageNum());
        billItemQueryDto.setPageSize(getTocInvoiceGoodsListPageParams.getPageSize());
        PageInfo billItemRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.billItemApi.queryByPage(billItemQueryDto));
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)billItemRespDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        if (CollectionUtils.isEmpty((Collection)billItemRespDtoPageInfo.getList())) {
            new RestResponse((Object)pageInfo);
        }
        List tocInvoiceSubjectVOList = billItemRespDtoPageInfo.getList().stream().map(billInfo -> {
            TocInvoiceSubjectVO invoiceSubjectVO = new TocInvoiceSubjectVO();
            this.getInvoiceItemResponseParams(invoiceSubjectVO, (BillItemRespDto)billInfo);
            return invoiceSubjectVO;
        }).collect(Collectors.toList());
        pageInfo.setList(tocInvoiceSubjectVOList);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<InvoiceBasicVO> getOrderInvoiceInfo(@ApiParam(value="\u914d\u8d27\u9500\u552e\u8ba2\u5355\u53f7") @Valid @RequestParam(value="saleOrderNo", required=false) String saleOrderNo, @ApiParam(value="\u5e73\u53f0\u8ba2\u5355\u53f7") @Valid @RequestParam(value="platformOrderNo", required=false) String platformOrderNo) {
        InvoiceBasicVO invoiceBasicVO = new InvoiceBasicVO();
        if (StringUtils.isNotEmpty((CharSequence)saleOrderNo)) {
            logger.info("\u914d\u8d27\u8ba2\u5355\u7ef4\u5ea6\u67e5\u8be2\u5f00\u7968\u4fe1\u606f\uff1a{}", (Object)saleOrderNo);
            SaleOrderBillRecordPageReqDto saleOrderBillRecordQueryReqDto = new SaleOrderBillRecordPageReqDto();
            saleOrderBillRecordQueryReqDto.setSaleOrderNo(saleOrderNo);
            List saleOrderBillRecordRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderBillRecordQueryApi.queryByReqDto(saleOrderBillRecordQueryReqDto));
            if (CollectionUtils.isNotEmpty((Collection)saleOrderBillRecordRespDtoList)) {
                SaleOrderBillRecordDto saleOrderBillRecordRespDto = (SaleOrderBillRecordDto)saleOrderBillRecordRespDtoList.stream().sorted(Comparator.comparing(BaseDto::getCreateTime).reversed()).collect(Collectors.toList()).get(0);
                this.getOrderInvoiceInfoParam(invoiceBasicVO, saleOrderBillRecordRespDto);
            }
        } else {
            logger.info("\u5e73\u53f0\u8ba2\u5355\u7ef4\u5ea6\u67e5\u8be2\u5f00\u7968\u4fe1\u606f\uff1a{}", (Object)platformOrderNo);
            SaleOrderBillRecordPageReqDto saleOrderBillRecordQueryReqDto = new SaleOrderBillRecordPageReqDto();
            saleOrderBillRecordQueryReqDto.setPlatformOrderNo(platformOrderNo);
            List saleOrderBillRecordRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderBillRecordQueryApi.queryByReqDto(saleOrderBillRecordQueryReqDto));
            if (CollectionUtils.isNotEmpty((Collection)saleOrderBillRecordRespDtoList)) {
                SaleOrderBillRecordDto saleOrderBillRecordRespDto = (SaleOrderBillRecordDto)saleOrderBillRecordRespDtoList.stream().sorted(Comparator.comparing(BaseDto::getCreateTime).reversed()).collect(Collectors.toList()).get(0);
                this.getOrderInvoiceInfoParam(invoiceBasicVO, saleOrderBillRecordRespDto);
            }
        }
        return new RestResponse((Object)invoiceBasicVO);
    }

    public void getOrderInvoiceInfoParam(InvoiceBasicVO invoiceBasicVO, SaleOrderBillRecordDto saleOrderBillRecordRespDto) {
        BillInfoTypeEnum enumByCode;
        invoiceBasicVO.setInvoiceType(saleOrderBillRecordRespDto.getInvoiceType());
        if (StringUtils.isNotBlank((CharSequence)saleOrderBillRecordRespDto.getInvoiceType()) && null != (enumByCode = BillInfoTypeEnum.getEnumByCode((String)saleOrderBillRecordRespDto.getInvoiceType()))) {
            invoiceBasicVO.setInvoiceTypeName(enumByCode.getName());
        }
        invoiceBasicVO.setInvoiceHeader(saleOrderBillRecordRespDto.getBillTitle());
        invoiceBasicVO.setInvoiceHeaderType(saleOrderBillRecordRespDto.getTitleType());
        if (StringUtils.isNotBlank((CharSequence)saleOrderBillRecordRespDto.getTitleType()) && null != (enumByCode = BillTitleTypeEnum.getEnumByCode((String)saleOrderBillRecordRespDto.getTitleType()))) {
            invoiceBasicVO.setInvoiceHeaderTypeName(enumByCode.getName());
        }
        invoiceBasicVO.setReceiveInvoiceEmail(saleOrderBillRecordRespDto.getMailbox());
        invoiceBasicVO.setReceiveInvoicePhone(saleOrderBillRecordRespDto.getPhone());
        invoiceBasicVO.setBankAccountNo(saleOrderBillRecordRespDto.getBankAccount());
        invoiceBasicVO.setDepositBank(saleOrderBillRecordRespDto.getBank());
        invoiceBasicVO.setRegisterAddress(saleOrderBillRecordRespDto.getRegisteredAddress());
        invoiceBasicVO.setRegisterPhone(saleOrderBillRecordRespDto.getRegisteredPhone());
        invoiceBasicVO.setTaxpayerIdentificationNo(saleOrderBillRecordRespDto.getTaxesCode());
    }

    public void getInvoiceResponseParams(TocInvoiceManagementVO tocInvoiceManagementVO, BillInfoRespDto billInfoRespDto) {
        CubeBeanUtils.copyProperties((Object)tocInvoiceManagementVO, (Object)billInfoRespDto, (String[])new String[0]);
        tocInvoiceManagementVO.setInvoiceTradeNo(billInfoRespDto.getBillFlowNo());
        tocInvoiceManagementVO.setInvoiceApplyNo(billInfoRespDto.getApplyNo());
        tocInvoiceManagementVO.setPlatformOrderNo(billInfoRespDto.getPlatformOrderNo());
        tocInvoiceManagementVO.setStationName(billInfoRespDto.getSite());
        tocInvoiceManagementVO.setShopCode(billInfoRespDto.getShopCode());
        tocInvoiceManagementVO.setShopId(ParamConverter.convertToString((Object)billInfoRespDto.getShopId()));
        tocInvoiceManagementVO.setShopName(billInfoRespDto.getShopName());
        tocInvoiceManagementVO.setChannelId(billInfoRespDto.getChannelId());
        tocInvoiceManagementVO.setChannelCode(billInfoRespDto.getChannelCode());
        tocInvoiceManagementVO.setChannelName(billInfoRespDto.getChannelName());
        tocInvoiceManagementVO.setInvoiceAccountType(billInfoRespDto.getBillType());
        tocInvoiceManagementVO.setInvoiceAccountTypeName(null != BillInfoColourTypeEnum.getEnumByCode((String)billInfoRespDto.getBillType()) ? BillInfoColourTypeEnum.getEnumByCode((String)billInfoRespDto.getBillType()).getName() : null);
        tocInvoiceManagementVO.setInvoiceType(billInfoRespDto.getInvoiceType());
        tocInvoiceManagementVO.setRedInfoOrderNo(billInfoRespDto.getRedInfoOrderNo());
        tocInvoiceManagementVO.setConversionTime(billInfoRespDto.getConversionTime());
        BillInfoTypeEnum billInfoTypeEnum = BillInfoTypeEnum.getEnumByCode((String)billInfoRespDto.getInvoiceType());
        if (billInfoTypeEnum != null) {
            tocInvoiceManagementVO.setInvoiceTypeName(billInfoTypeEnum.getName());
        }
        tocInvoiceManagementVO.setInvoiceHeaderType(billInfoRespDto.getTitleType());
        BillTitleTypeEnum billTitleTypeEnum = BillTitleTypeEnum.getEnumByCode((String)billInfoRespDto.getTitleType());
        if (billTitleTypeEnum != null) {
            tocInvoiceManagementVO.setInvoiceHeaderTypeName(billTitleTypeEnum.getName());
        }
        tocInvoiceManagementVO.setInvoiceHeader(billInfoRespDto.getBillTitle());
        tocInvoiceManagementVO.setTaxpayerIdentificationNo(billInfoRespDto.getTaxesCode());
        tocInvoiceManagementVO.setRegisterAddress(billInfoRespDto.getRegisteredAddress());
        tocInvoiceManagementVO.setRegisterPhone(billInfoRespDto.getRegisteredPhone());
        tocInvoiceManagementVO.setDepositBank(billInfoRespDto.getBank());
        tocInvoiceManagementVO.setBankAccountNo(billInfoRespDto.getBankAccount());
        tocInvoiceManagementVO.setReceiveName(billInfoRespDto.getBillPersonName());
        tocInvoiceManagementVO.setReceivePhone(billInfoRespDto.getBillPersonPhone());
        tocInvoiceManagementVO.setReceiveAddress(billInfoRespDto.getBillAddress());
        tocInvoiceManagementVO.setInvoiceAmount(ParamConverter.convertToString((Object)billInfoRespDto.getInvoiceAmount()));
        tocInvoiceManagementVO.setInvoiceStatus(billInfoRespDto.getInvoiceState());
        tocInvoiceManagementVO.setInvoiceStatusName(InvoiceStateEnum.getNameByCode((String)billInfoRespDto.getInvoiceState()));
        tocInvoiceManagementVO.setInvoiceNo(billInfoRespDto.getExternalInvoiceNo());
        tocInvoiceManagementVO.setInvoiceCode(billInfoRespDto.getExternalInvoiceCode());
        tocInvoiceManagementVO.setInvoicingDate(DateUtil.format((Date)billInfoRespDto.getExternalInvoiceTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        tocInvoiceManagementVO.setOldBlueInvoiceNo(billInfoRespDto.getBlueTicketInvoiceNo());
        tocInvoiceManagementVO.setOldBlueInvoiceCode(billInfoRespDto.getBlueTicketInvoiceCode());
        tocInvoiceManagementVO.setOldBlueInvoiceTradeNo(billInfoRespDto.getBlueTicketFlowNo());
        tocInvoiceManagementVO.setInvoiceFileUrl(billInfoRespDto.getUploadPdfUrl());
        tocInvoiceManagementVO.setInvoiceRemark(billInfoRespDto.getInvoiceRemarks());
        tocInvoiceManagementVO.setInvoiceSource(billInfoRespDto.getCreateType());
        tocInvoiceManagementVO.setInvoiceSourceName(BillCreateTypeEnum.getNameByCode((String)billInfoRespDto.getCreateType()));
        tocInvoiceManagementVO.setAuditPerson(billInfoRespDto.getAuditPerson());
        tocInvoiceManagementVO.setAuditTime(DateUtil.format((Date)billInfoRespDto.getAuditTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        tocInvoiceManagementVO.setCreateTime(DateUtil.format((Date)billInfoRespDto.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        tocInvoiceManagementVO.setUpdateTime(DateUtil.format((Date)billInfoRespDto.getUpdateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        tocInvoiceManagementVO.setReceiveInvoiceEmail(billInfoRespDto.getMailbox());
        tocInvoiceManagementVO.setReceiveInvoicePhone(billInfoRespDto.getPhone());
        tocInvoiceManagementVO.setFailReason(billInfoRespDto.getExtension());
        tocInvoiceManagementVO.setInvoiceEnterprise(billInfoRespDto.getEnterprise());
        tocInvoiceManagementVO.setInvoiceChannel(billInfoRespDto.getBillChannel());
        tocInvoiceManagementVO.setCustomerCode(billInfoRespDto.getCustomerCode());
        tocInvoiceManagementVO.setAuditFailReason(billInfoRespDto.getAuditFailReason());
        tocInvoiceManagementVO.setAllRedFlag(billInfoRespDto.getAllRedFlag());
        tocInvoiceManagementVO.setSumTimeStart(DateUtil.format((Date)billInfoRespDto.getSumTimeStart(), (String)"yyyy-MM-dd HH:mm:ss"));
        tocInvoiceManagementVO.setSumTimeEnd(DateUtil.format((Date)billInfoRespDto.getSumTimeEnd(), (String)"yyyy-MM-dd HH:mm:ss"));
        tocInvoiceManagementVO.setPushPlatformState(billInfoRespDto.getPushPlatformState());
        tocInvoiceManagementVO.setPushPlatformError(billInfoRespDto.getPushPlatformError());
        tocInvoiceManagementVO.setFinanceReceivableNo(billInfoRespDto.getFinanceReceivableNo());
        tocInvoiceManagementVO.setFileUrl(billInfoRespDto.getFileUrl());
        tocInvoiceManagementVO.setSubsidiesType(billInfoRespDto.getSubsidiesType());
        tocInvoiceManagementVO.setDistributionOrderNo(billInfoRespDto.getDistributionOrderNo());
    }

    public void getInvoiceItemResponseParams(InvoicingGoodsVO invoicingGoodsVO, BillItemRespDto billItemRespDto) {
        CubeBeanUtils.copyProperties((Object)invoicingGoodsVO, (Object)billItemRespDto, (String[])new String[0]);
        invoicingGoodsVO.setId(billItemRespDto.getId());
        invoicingGoodsVO.setGoodsCode(billItemRespDto.getItemCode());
        invoicingGoodsVO.setGoodsLongCode(billItemRespDto.getItemCode());
        invoicingGoodsVO.setGoodsName(billItemRespDto.getItemName());
        invoicingGoodsVO.setGoodsNum(billItemRespDto.getQuantity());
        invoicingGoodsVO.setRealPayAmount(billItemRespDto.getAmount());
        invoicingGoodsVO.setTaxClassificationCode(billItemRespDto.getTaxClassificationCode());
        invoicingGoodsVO.setTaxRate(billItemRespDto.getTaxRate());
        invoicingGoodsVO.setTaxRateAmount(billItemRespDto.getTaxAmount());
    }

    public void getInvoiceItemResponseParams(TocInvoiceSubjectVO tocInvoiceSubjectVO, BillItemRespDto billItemRespDto) {
        CubeBeanUtils.copyProperties((Object)tocInvoiceSubjectVO, (Object)billItemRespDto, (String[])new String[0]);
        tocInvoiceSubjectVO.setId(billItemRespDto.getId());
        tocInvoiceSubjectVO.setSubjectName(billItemRespDto.getBillLineItemName());
        tocInvoiceSubjectVO.setSubjectSpecification(billItemRespDto.getSpecification());
        tocInvoiceSubjectVO.setUnitName(billItemRespDto.getUnit());
        tocInvoiceSubjectVO.setNum(billItemRespDto.getQuantity());
        tocInvoiceSubjectVO.setUnitPrice(billItemRespDto.getUnitPrice());
        tocInvoiceSubjectVO.setTotalAmount(billItemRespDto.getAmount());
        tocInvoiceSubjectVO.setTaxClassificationCode(billItemRespDto.getTaxClassificationCode());
        tocInvoiceSubjectVO.setTaxRate(ParamConverter.convertToString((Object)billItemRespDto.getTaxRate()));
        tocInvoiceSubjectVO.setTaxRateAmount(billItemRespDto.getTaxAmount());
        tocInvoiceSubjectVO.setPlatformOrderNo(billItemRespDto.getPlatformOrderNo());
        tocInvoiceSubjectVO.setOrderType(null);
    }

    public void addBillInfoParam(AddTocInvoiceParams addTocInvoiceParams, BillInfoReqDto billInfoReqDto) {
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)addTocInvoiceParams.getIsRelatedOrder()), "\u662f\u5426\u5173\u8054\u8ba2\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        if ("0".equals(addTocInvoiceParams.getIsRelatedOrder())) {
            billInfoReqDto.setRelOrder(Boolean.valueOf(false));
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)addTocInvoiceParams.getInvoiceEntityId()), "\u672a\u5173\u8054\u8ba2\u5355,\u5f00\u7968\u4e3b\u9898\u4e0d\u80fd\u4e3a\u7a7a");
            billInfoReqDto.setEntityId(ParamConverter.convertToLong((Object)addTocInvoiceParams.getInvoiceEntityId()));
        } else {
            billInfoReqDto.setRelOrder(Boolean.valueOf(true));
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)addTocInvoiceParams.getPlatformOrderNo()), "\u5173\u8054\u8ba2\u5355,\u5e73\u53f0\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            billInfoReqDto.setPlatformOrderNo(addTocInvoiceParams.getPlatformOrderNo());
        }
        billInfoReqDto.setInvoiceType(addTocInvoiceParams.getInvoiceType());
        billInfoReqDto.setTitleType(addTocInvoiceParams.getInvoiceHeaderType());
        billInfoReqDto.setBillTitle(addTocInvoiceParams.getInvoiceHeader());
        billInfoReqDto.setTaxesCode(addTocInvoiceParams.getTaxpayerIdentificationNo());
        billInfoReqDto.setRegisteredAddress(addTocInvoiceParams.getRegisterAddress());
        billInfoReqDto.setRegisteredPhone(addTocInvoiceParams.getRegisterPhone());
        billInfoReqDto.setBank(addTocInvoiceParams.getDepositBank());
        billInfoReqDto.setBankAccount(addTocInvoiceParams.getBankAccountNo());
        billInfoReqDto.setBillPersonName(addTocInvoiceParams.getReceiveName());
        billInfoReqDto.setBillPersonPhone(addTocInvoiceParams.getReceivePhone());
        billInfoReqDto.setBillAddress(addTocInvoiceParams.getReceiveAddress());
        billInfoReqDto.setMailbox(addTocInvoiceParams.getReceiveInvoiceEmail());
        billInfoReqDto.setPhone(addTocInvoiceParams.getReceiveInvoicePhone());
        if (CollectionUtils.isNotEmpty((Collection)addTocInvoiceParams.getGoodsList())) {
            ArrayList billItemReqDtoList = new ArrayList();
            addTocInvoiceParams.getGoodsList().forEach(good -> {
                BillItemReqDto billItemReqDto = new BillItemReqDto();
                billItemReqDto.setItemName(good.getGoodsName());
                billItemReqDto.setItemCode(good.getGoodsCode());
                billItemReqDto.setTaxClassificationCode(good.getTaxClassificationCode());
                billItemReqDto.setTaxRate(good.getTaxRate());
                billItemReqDto.setClinchDealAmount(good.getRealPayAmount());
                billItemReqDto.setAmount(good.getRealPayAmount());
                billItemReqDto.setUnitPrice(good.getRealPayAmount().divide(good.getGoodsNum(), 2).setScale(2, 4));
                billItemReqDto.setTaxAmount(good.getRealPayAmount().multiply(good.getTaxRate()));
                billItemReqDto.setQuantity(good.getGoodsNum());
                billItemReqDtoList.add(billItemReqDto);
            });
            billInfoReqDto.setBillItemReqDtoList(billItemReqDtoList);
        }
    }

    public void queryPageParam(BillInfoQueryDto billInfoQueryDto, GetTocInvoiceLIstPageParams getTocInvoiceLIstPageParams) {
        billInfoQueryDto.setPageNum(getTocInvoiceLIstPageParams.getPageNum());
        billInfoQueryDto.setPageSize(getTocInvoiceLIstPageParams.getPageSize());
        billInfoQueryDto.setBillFlowNo(getTocInvoiceLIstPageParams.getInvoiceTradeNo());
        billInfoQueryDto.setApplyNo(getTocInvoiceLIstPageParams.getInvoiceApplyNo());
        billInfoQueryDto.setPlatformOrderNo(getTocInvoiceLIstPageParams.getPlatformOrderNo());
        billInfoQueryDto.setInvoiceChannel(getTocInvoiceLIstPageParams.getInvoiceChannel());
        billInfoQueryDto.setInvoiceHeaderType(getTocInvoiceLIstPageParams.getInvoiceHeaderType());
        if (StringUtils.isNotBlank((CharSequence)getTocInvoiceLIstPageParams.getShopId())) {
            billInfoQueryDto.setShopId(ParamConverter.convertToLong((Object)getTocInvoiceLIstPageParams.getShopId()));
        }
        if (CollectionUtils.isNotEmpty((Collection)getTocInvoiceLIstPageParams.getInvoiceTradeNoList())) {
            billInfoQueryDto.setBillFlowNoList(getTocInvoiceLIstPageParams.getInvoiceTradeNoList());
        }
        if (CollectionUtils.isNotEmpty((Collection)getTocInvoiceLIstPageParams.getPlatformOrderNoList())) {
            billInfoQueryDto.setPlatformOrderNoList(getTocInvoiceLIstPageParams.getPlatformOrderNoList());
        }
        if (CollectionUtils.isNotEmpty((Collection)getTocInvoiceLIstPageParams.getInvoiceNoList())) {
            billInfoQueryDto.setExternalInvoiceNoList(getTocInvoiceLIstPageParams.getInvoiceNoList());
        }
        if (CollectionUtils.isNotEmpty((Collection)getTocInvoiceLIstPageParams.getInvoiceCodeList())) {
            billInfoQueryDto.setExternalInvoiceCodeList(getTocInvoiceLIstPageParams.getInvoiceCodeList());
        }
        billInfoQueryDto.setBillType(getTocInvoiceLIstPageParams.getInvoiceAccountType());
        billInfoQueryDto.setInvoiceType(getTocInvoiceLIstPageParams.getInvoiceType());
        billInfoQueryDto.setBlueTicketInvoiceNo(getTocInvoiceLIstPageParams.getOldBlueInvoiceNo());
        billInfoQueryDto.setBlueTicketInvoiceCode(getTocInvoiceLIstPageParams.getOldBlueInvoiceCode());
        billInfoQueryDto.setCreateBeginTime(getTocInvoiceLIstPageParams.getCreateTimeStart());
        billInfoQueryDto.setCreateEndTime(getTocInvoiceLIstPageParams.getCreateTimeEnd());
        billInfoQueryDto.setExternalInvoiceBeginTime(getTocInvoiceLIstPageParams.getInvoicingDateStart());
        billInfoQueryDto.setExternalInvoiceEndTime(getTocInvoiceLIstPageParams.getInvoicingDateEnd());
        billInfoQueryDto.setExternalInvoiceCode(getTocInvoiceLIstPageParams.getInvoiceCode());
        billInfoQueryDto.setExternalInvoiceNo(getTocInvoiceLIstPageParams.getInvoiceNo());
        if (CollectionUtils.isNotEmpty((Collection)getTocInvoiceLIstPageParams.getInvoiceStatus())) {
            billInfoQueryDto.setInvoiceState((String)getTocInvoiceLIstPageParams.getInvoiceStatus().get(0));
        }
        if (StringUtils.isNotBlank((CharSequence)getTocInvoiceLIstPageParams.getStationId())) {
            billInfoQueryDto.setSiteCode(getTocInvoiceLIstPageParams.getStationId());
        }
        billInfoQueryDto.setCustomerCode(getTocInvoiceLIstPageParams.getCustomerCode());
        billInfoQueryDto.setAuditBeginTime(getTocInvoiceLIstPageParams.getAuditBeginTime());
        billInfoQueryDto.setAuditEndTime(getTocInvoiceLIstPageParams.getAuditEndTime());
        billInfoQueryDto.setWhetherMergeBill(getTocInvoiceLIstPageParams.getWhetherMergeBill());
        billInfoQueryDto.setPushPlatformState(getTocInvoiceLIstPageParams.getPushPlatformState());
        billInfoQueryDto.setConversionBeginTime(getTocInvoiceLIstPageParams.getConversionBeginTime());
        billInfoQueryDto.setConversionEndTime(getTocInvoiceLIstPageParams.getConversionEndTime());
        billInfoQueryDto.setSubsidiesType(getTocInvoiceLIstPageParams.getSubsidiesType());
        billInfoQueryDto.setSiteCodeList(getTocInvoiceLIstPageParams.getSiteCodeList());
        billInfoQueryDto.setShopCodeList(getTocInvoiceLIstPageParams.getShopCodeList());
    }

    @Override
    public RestResponse<Object> modifyTocInvoiceSubject(@ApiParam(value="") @Valid @RequestBody(required=false) ModifyTocInvoiceSubjectParams modifyTocInvoiceSubjectParams) {
        ArrayList billItemReqDtoList = new ArrayList();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)modifyTocInvoiceSubjectParams.getInvoiceTradeNo()), "\u5f00\u7968\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)modifyTocInvoiceSubjectParams.getSubjectList()), "\u7f16\u8f91\u7684\u5546\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        modifyTocInvoiceSubjectParams.getSubjectList().forEach(item -> {
            BillItemReqDto billItemReqDto = new BillItemReqDto();
            billItemReqDto.setBillFlowNo(modifyTocInvoiceSubjectParams.getInvoiceTradeNo());
            billItemReqDto.setId(item.getId());
            billItemReqDto.setBillLineItemName(item.getSubjectName());
            billItemReqDto.setItemName(item.getSubjectName().replace("\u5bb6\u7528\u53a8\u623f\u7535\u5668", ""));
            billItemReqDto.setSpecification(item.getSubjectSpecification());
            billItemReqDto.setUnit(item.getUnitName());
            billItemReqDto.setTaxClassificationCode(item.getTaxClassificationCode());
            if (StringUtils.isNotBlank((CharSequence)item.getTaxRate())) {
                billItemReqDto.setTaxRate(ParamConverter.convertToBigDecimal((Object)item.getTaxRate()));
            }
            billItemReqDtoList.add(billItemReqDto);
        });
        this.billItemApi.updateBillItem(billItemReqDtoList);
        return new RestResponse();
    }

    @Override
    public RestResponse<Object> getTocInvoiceFileUrl(@NotNull @ApiParam(value="\u53d1\u7968\u6d41\u6c34\u53f7", required=true) @Valid @RequestParam(value="tradeNo", required=true) String tradeNo) {
        RestResponse invoicePdf = this.billInfoApi.getInvoicePdf(tradeNo);
        String pdfUrl = (String)RestResponseHelper.extractData((RestResponse)invoicePdf);
        return new RestResponse((Object)pdfUrl);
    }

    @Override
    public RestResponse<GetTocInvoiceOrderStatusResponseData> getTocInvoiceOrderStatus(@NotNull @ApiParam(value="\u5173\u8054\u8ba2\u5355\u53f7\uff08\u591a\u4e2a\u7528\u9017\u53f7\u9694\u5f00\uff09", required=true) @Valid @RequestParam(value="orderNos", required=true) String orderNos) {
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)orderNos), "\u5e73\u53f0\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        String orderNoStr = orderNos.replace("\uff0c", ",");
        List<String> orderNoList = Arrays.asList(orderNos.split(","));
        BillInfoListQueryDto billInfoListQueryDto = new BillInfoListQueryDto();
        billInfoListQueryDto.setPlatformOrderNoList(orderNoList);
        billInfoListQueryDto.setBillType(BillInfoColourTypeEnum.BLUE_TICKET.getCode());
        ArrayList<String> notInvoiceStateList = new ArrayList<String>();
        notInvoiceStateList.add(InvoiceStateEnum.CANCELLED.getCode());
        notInvoiceStateList.add(InvoiceStateEnum.RED_FLUSH.getCode());
        billInfoListQueryDto.setNotInvoiceStateList(notInvoiceStateList);
        List billInfoRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.billInfoApi.queryByBillFlowNoList(billInfoListQueryDto));
        GetTocInvoiceOrderStatusResponseData getTocInvoiceOrderStatusResponseData = new GetTocInvoiceOrderStatusResponseData();
        if (CollectionUtils.isNotEmpty((Collection)billInfoRespDtoList)) {
            getTocInvoiceOrderStatusResponseData.setHasBlueInvoice("1");
            String platformOrderList = billInfoRespDtoList.stream().map(BillInfoRespDto::getPlatformOrderNo).distinct().collect(Collectors.joining(","));
            getTocInvoiceOrderStatusResponseData.setHasBlueInvoiceOrderNos(platformOrderList);
        } else {
            getTocInvoiceOrderStatusResponseData.setHasBlueInvoice("0");
        }
        return new RestResponse((Object)getTocInvoiceOrderStatusResponseData);
    }

    @Override
    public RestResponse<Object> modifyTocInvoiceRemark(@ApiParam(value="") @Valid @RequestBody(required=false) ModifyTocInvoiceRemarkBody modifyTocInvoiceRemarkBody) {
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)modifyTocInvoiceRemarkBody.getInvoiceTradeNo()), "\u4fee\u6539\u7684\u5f00\u7968\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        RestResponse billInfoRespDtoRestResponse = this.billInfoApi.queryByBillFlowNo(modifyTocInvoiceRemarkBody.getInvoiceTradeNo());
        BillInfoRespDto billInfoRespDto = (BillInfoRespDto)RestResponseHelper.extractData((RestResponse)billInfoRespDtoRestResponse);
        if (Objects.isNull(billInfoRespDto)) {
            throw new BizException("\u6839\u636e\u4fee\u6539\u7684\u5f00\u7968\u6d41\u6c34\u53f7\u672a\u67e5\u8be2\u5230\u5f00\u7968\u4fe1\u606f");
        }
        if (!InvoiceStateEnum.WAIT_AUDIT.getCode().equals(billInfoRespDto.getInvoiceState()) && !InvoiceStateEnum.FAILED.getCode().equals(billInfoRespDto.getInvoiceState())) {
            throw new BizException("\u975e\u5f85\u5ba1\u6838/\u5931\u8d25\u72b6\u6001\u65e0\u6cd5\u4fee\u6539\u5f00\u7968\u5907\u6ce8");
        }
        BillInfoReqDto billInfoReqDto = new BillInfoReqDto();
        billInfoReqDto.setId(billInfoRespDto.getId());
        billInfoReqDto.setInvoiceRemarks(modifyTocInvoiceRemarkBody.getInvoiceRemark());
        this.billInfoApi.modifyBillInfo(billInfoReqDto);
        return new RestResponse();
    }

    @Override
    public RestResponse<Object> batchVoidToRedFlushTocInvoice(@ApiParam(value="") @Valid @RequestBody(required=false) BatchOperateInvoiceVO batchOperateInvoiceVO) {
        RestResponse batchOperationRespDtoRestResponse = this.billInfoApi.cancelChangeRedInvoice(batchOperateInvoiceVO.getTradeNos());
        BatchOperationRespDto batchOperationRespDto = (BatchOperationRespDto)RestResponseHelper.extractData((RestResponse)batchOperationRespDtoRestResponse);
        return new RestResponse((Object)batchOperationRespDtoRestResponse);
    }

    @Override
    public RestResponse<Object> modifyTocInvoiceRedOrderNo(@ApiParam(value="") @Valid @RequestBody(required=false) ModifyTocInvoiceRedOrderNoBody modifyTocInvoiceRedOrderNoBody) {
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)modifyTocInvoiceRedOrderNoBody.getInvoiceTradeNo()), "\u4fee\u6539\u7684\u5f00\u7968\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        RestResponse billInfoRespDtoRestResponse = this.billInfoApi.queryByBillFlowNo(modifyTocInvoiceRedOrderNoBody.getInvoiceTradeNo());
        BillInfoRespDto billInfoRespDto = (BillInfoRespDto)RestResponseHelper.extractData((RestResponse)billInfoRespDtoRestResponse);
        if (Objects.isNull(billInfoRespDto)) {
            throw new BizException("\u6839\u636e\u4fee\u6539\u7684\u5f00\u7968\u6d41\u6c34\u53f7\u672a\u67e5\u8be2\u5230\u5f00\u7968\u4fe1\u606f");
        }
        if (!BillInfoTypeEnum.SPECIAL_PAPER_INVOICE.getCode().equals(billInfoRespDto.getInvoiceType())) {
            throw new BizException("\u975e\u7eb8\u8d28\u4e13\u7968\u7c7b\u578b\u65e0\u6cd5\u4fee\u6539\u7ea2\u5b57\u4fe1\u606f\u5355\u53f7");
        }
        BillInfoReqDto billInfoReqDto = new BillInfoReqDto();
        billInfoReqDto.setId(billInfoRespDto.getId());
        billInfoReqDto.setRedInfoOrderNo(modifyTocInvoiceRedOrderNoBody.getInvoiceRedInfoOrderNo());
        this.billInfoApi.modifyBillInfo(billInfoReqDto);
        return new RestResponse();
    }

    @Override
    public RestResponse<Object> modifyTocInvoiceBaseInfo(@ApiParam(value="") @Valid @RequestBody(required=false) EditInvoiceBaseInfoBody editInvoiceBaseInfoBody) {
        BillInfoReqDto billInfoReqDto;
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)editInvoiceBaseInfoBody.getInvoiceTradeNo()), "\u4fee\u6539\u7684\u5f00\u7968\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        RestResponse billInfoRespDtoRestResponse = this.billInfoApi.queryByBillFlowNo(editInvoiceBaseInfoBody.getInvoiceTradeNo());
        BillInfoRespDto billInfoRespDto = (BillInfoRespDto)RestResponseHelper.extractData((RestResponse)billInfoRespDtoRestResponse);
        if (Objects.isNull(billInfoRespDto)) {
            throw new BizException("\u6839\u636e\u4fee\u6539\u7684\u5f00\u7968\u6d41\u6c34\u53f7\u672a\u67e5\u8be2\u5230\u5f00\u7968\u4fe1\u606f");
        }
        if (InvoiceStateEnum.WAIT_AUDIT.getCode().equals(billInfoRespDto.getInvoiceState()) || InvoiceStateEnum.FAILED.getCode().equals(billInfoRespDto.getInvoiceState())) {
            billInfoReqDto = new BillInfoReqDto();
            billInfoReqDto.setId(billInfoRespDto.getId());
            billInfoReqDto.setInvoiceType(editInvoiceBaseInfoBody.getInvoiceType());
            billInfoReqDto.setBillTitle(editInvoiceBaseInfoBody.getInvoiceHeader());
            billInfoReqDto.setTitleType(editInvoiceBaseInfoBody.getInvoiceHeaderType());
            billInfoReqDto.setTaxesCode(editInvoiceBaseInfoBody.getTaxpayerIdentificationNo());
            billInfoReqDto.setRegisteredAddress(editInvoiceBaseInfoBody.getRegisterAddress());
            billInfoReqDto.setRegisteredPhone(editInvoiceBaseInfoBody.getRegisterPhone());
            billInfoReqDto.setBank(editInvoiceBaseInfoBody.getDepositBank());
            billInfoReqDto.setBankAccount(editInvoiceBaseInfoBody.getBankAccountNo());
            billInfoReqDto.setMailbox(editInvoiceBaseInfoBody.getReceiveInvoiceEmail());
            if (StringUtils.isNotBlank((CharSequence)editInvoiceBaseInfoBody.getReceiveInvoicePhone()) && !editInvoiceBaseInfoBody.getReceiveInvoicePhone().matches("1[3-9]\\d{9}")) {
                throw new BizException("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u624b\u673a\u53f7");
            }
        } else {
            throw new BizException("\u975e\u5f85\u5ba1\u6838\u548c\u5931\u8d25\u7684\u7968\u636e\u65e0\u6cd5\u4fee\u6539\u4fe1\u606f");
        }
        billInfoReqDto.setPhone(editInvoiceBaseInfoBody.getReceiveInvoicePhone());
        billInfoReqDto.setBillPersonPhone(editInvoiceBaseInfoBody.getReceivePhone());
        billInfoReqDto.setBillPersonName(editInvoiceBaseInfoBody.getReceiveName());
        billInfoReqDto.setBillAddress(editInvoiceBaseInfoBody.getReceiveAddress());
        billInfoReqDto.setInvoiceState(InvoiceStateEnum.WAIT_AUDIT.getCode());
        this.billInfoApi.modifyBillInfo(billInfoReqDto);
        return new RestResponse();
    }

    @Override
    public RestResponse<GetTocInvoiceOrderStatusResponseData> checkTocInvoiceOrderStatus(@ApiParam(value="") @Valid @RequestBody(required=false) CheckTocInvoiceOrderStatusParams checkTocInvoiceOrderStatusParams) {
        String orderNos = checkTocInvoiceOrderStatusParams.getOrderNos();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)orderNos), "\u5e73\u53f0\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        String orderNoStr = orderNos.replace("\uff0c", ",");
        List<String> orderNoList = Arrays.asList(orderNos.split(","));
        BillInfoListQueryDto billInfoListQueryDto = new BillInfoListQueryDto();
        billInfoListQueryDto.setPlatformOrderNoList(orderNoList);
        billInfoListQueryDto.setBillType(BillInfoColourTypeEnum.BLUE_TICKET.getCode());
        ArrayList<String> notInvoiceStateList = new ArrayList<String>();
        notInvoiceStateList.add(InvoiceStateEnum.CANCELLED.getCode());
        notInvoiceStateList.add(InvoiceStateEnum.RED_FLUSH.getCode());
        billInfoListQueryDto.setNotInvoiceStateList(notInvoiceStateList);
        List billInfoRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.billInfoApi.queryByBillFlowNoList(billInfoListQueryDto));
        GetTocInvoiceOrderStatusResponseData getTocInvoiceOrderStatusResponseData = new GetTocInvoiceOrderStatusResponseData();
        if (CollectionUtils.isNotEmpty((Collection)billInfoRespDtoList)) {
            getTocInvoiceOrderStatusResponseData.setHasBlueInvoice("1");
            String platformOrderList = billInfoRespDtoList.stream().map(BillInfoRespDto::getPlatformOrderNo).distinct().collect(Collectors.joining(","));
            getTocInvoiceOrderStatusResponseData.setHasBlueInvoiceOrderNos(platformOrderList);
        } else {
            getTocInvoiceOrderStatusResponseData.setHasBlueInvoice("0");
        }
        return new RestResponse((Object)getTocInvoiceOrderStatusResponseData);
    }

    @Override
    public RestResponse<Object> tocInvoiceReturn(@ApiParam(value="") @Valid @RequestBody(required=false) InvoiceReturnParams invoiceReturnParams) {
        logger.info("\u53d1\u7968\u56de\u4f20\u6d41\u6c34\u53f7:{}", (Object)JSON.toJSONString((Object)invoiceReturnParams));
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)invoiceReturnParams.getBillFlowNoList()), "\u8bf7\u9009\u62e9\u9700\u8981\u56de\u4f20\u7684\u53d1\u7968");
        List list = (List)RestResponseHelper.extractData((RestResponse)this.billInfoApi.batchBackPassPlatformInvoice(invoiceReturnParams.getBillFlowNoList()));
        return new RestResponse((Object)list);
    }

    @Override
    public RestResponse<SyncResultStatusRespDto> syncResultStatus(SyncResultStatusReqDto statusReqDto) {
        SyncResultStatusRespDto statusRespDto = new SyncResultStatusRespDto();
        for (Long id : statusReqDto.getIds()) {
            RestResponse response = this.billInfoApi.syncInvoiceResult(CallBackInvoiceInfoReqDto.builder().billInfoId(id).extResultCode(statusReqDto.getStatus().equals("RestResponse") ? "0" : "100000").extResultMsg(statusReqDto.getStatus().equals("RestResponse") ? "\u5f00\u7968\u6210\u529f" : "\u624b\u52a8\u5f00\u7968\u5931\u8d25").build());
            if (response.isSuccess()) {
                statusRespDto.setSuccessNum(Integer.valueOf(statusRespDto.getSuccessNum() + 1));
                continue;
            }
            statusRespDto.setFailNum(Integer.valueOf(statusRespDto.getFailNum() + 1));
            statusRespDto.setErrorMsg(response.getResultMsg());
        }
        return new RestResponse((Object)statusRespDto);
    }

    @Override
    public RestResponse<Void> pushInteriorOrderToJiShiASync(List<Long> internalIdList) {
        return this.billInfoApi.pushInteriorOrderToJiShiASync(internalIdList);
    }
}

