/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.finance.dto.request.KeepAccountReqDto;
import com.yunxi.dg.base.center.finance.dto.response.ChargeAccountInfoRespDto;
import com.yunxi.dg.base.center.finance.proxy.entity.IChargeAccountInfoApiProxy;
import com.yunxi.dg.base.mgmt.service.FinancialMagementHdBookkeepingManagementBookkeepingTypeSettingService;
import com.yunxi.dg.base.ocs.mgmt.application.dto.financial.request.GetBookkeepingTypeSettingListPageV2Body;
import com.yunxi.dg.base.ocs.mgmt.application.dto.financial.request.HdBookkeepingTypeSettingDto;
import io.swagger.annotations.ApiParam;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class FinancialMagementHdBookkeepingManagementBookkeepingTypeSettingServiceServiceImpl
implements FinancialMagementHdBookkeepingManagementBookkeepingTypeSettingService {
    @Resource
    private IChargeAccountInfoApiProxy chargeAccountInfoApiProxy;

    @Override
    public RestResponse<Object> addBookkeepingTypSettingV2(@ApiParam(value="") @Valid @RequestBody(required=false) HdBookkeepingTypeSettingDto reqDto) {
        KeepAccountReqDto keepAccountReqDto = new KeepAccountReqDto();
        keepAccountReqDto.setId(reqDto.getId());
        keepAccountReqDto.setBillAccountName(reqDto.getInvoiceCode());
        keepAccountReqDto.setChargeAccountName(reqDto.getBookkeepingCode());
        keepAccountReqDto.setBusinessName(reqDto.getBussinessTypeName());
        keepAccountReqDto.setBusinessType(reqDto.getBussinessTypeCode());
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.chargeAccountInfoApiProxy.addKeepAccount(keepAccountReqDto)));
    }

    @Override
    public RestResponse<Object> deleteBookkeepingTypSettingV2(@ApiParam(value="", required=true) @PathVariable(value="id") String id) {
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.chargeAccountInfoApiProxy.removeChargeAccountInfo(id)));
    }

    @Override
    public RestResponse<PageInfo<HdBookkeepingTypeSettingDto>> getBookkeepingTypSettingListPageV2(@ApiParam(value="") @Valid @RequestBody(required=false) GetBookkeepingTypeSettingListPageV2Body queryPageBody) {
        PageInfo pageInfo = new PageInfo();
        KeepAccountReqDto keepAccountReqDto = new KeepAccountReqDto();
        keepAccountReqDto.setBillAccountName(queryPageBody.getInvoiceCode());
        keepAccountReqDto.setChargeAccountName(queryPageBody.getBookkeepingCode());
        keepAccountReqDto.setSlaveBillAccountName(queryPageBody.getSlaveBillAccountName());
        keepAccountReqDto.setBusinessName(queryPageBody.getBussinessTypeName());
        keepAccountReqDto.setBusinessType(queryPageBody.getBussinessTypeCode());
        PageInfo accountInfoRespDtoPageInfo = (PageInfo)this.chargeAccountInfoApiProxy.queryByPage(queryPageBody.getPageNum(), queryPageBody.getPageSize(), JSON.toJSONString((Object)keepAccountReqDto)).getData();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)accountInfoRespDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        this.getPageInfo((PageInfo<ChargeAccountInfoRespDto>)accountInfoRespDtoPageInfo, (PageInfo<HdBookkeepingTypeSettingDto>)pageInfo);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<Object> updateBookkeepingTypSettingV2(@ApiParam(value="", required=true) @PathVariable(value="id") String id, @ApiParam(value="") @Valid @RequestBody(required=false) HdBookkeepingTypeSettingDto reqDto) {
        KeepAccountReqDto keepAccountReqDto = new KeepAccountReqDto();
        keepAccountReqDto.setId(Long.valueOf(Long.parseLong(id)));
        keepAccountReqDto.setBillAccountName(reqDto.getInvoiceCode());
        keepAccountReqDto.setChargeAccountName(reqDto.getBookkeepingCode());
        keepAccountReqDto.setBusinessName(reqDto.getBussinessTypeName());
        keepAccountReqDto.setBusinessType(reqDto.getBussinessTypeCode());
        keepAccountReqDto.setSlaveBillAccountName(reqDto.getSlaveBillAccountName());
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.chargeAccountInfoApiProxy.addKeepAccount(keepAccountReqDto)));
    }

    public void getPageInfo(PageInfo<ChargeAccountInfoRespDto> accountInfoRespDtoPageInfo, PageInfo<HdBookkeepingTypeSettingDto> pageInfo) {
        List list = accountInfoRespDtoPageInfo.getList();
        ArrayList<HdBookkeepingTypeSettingDto> pageList = new ArrayList<HdBookkeepingTypeSettingDto>();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            for (ChargeAccountInfoRespDto respDto : list) {
                HdBookkeepingTypeSettingDto settingVO = new HdBookkeepingTypeSettingDto();
                settingVO.setId(respDto.getId());
                settingVO.setBussinessTypeCode(respDto.getBusinessType());
                settingVO.setBussinessTypeName(respDto.getBusinessName());
                settingVO.setInvoiceCode(respDto.getBillAccountName());
                settingVO.setBookkeepingCode(respDto.getChargeAccountName());
                settingVO.setSlaveBillAccountName(respDto.getSlaveBillAccountName());
                settingVO.setCreatePerson(respDto.getCreatePerson());
                settingVO.setUpdatePerson(respDto.getUpdatePerson());
                if (Objects.nonNull(respDto.getCreateTime())) {
                    settingVO.setCreateTime(format.format(respDto.getCreateTime()));
                }
                if (Objects.nonNull(respDto.getUpdateTime())) {
                    settingVO.setUpdateTime(format.format(respDto.getUpdateTime()));
                }
                pageList.add(settingVO);
            }
            pageInfo.setList(pageList);
        }
    }
}

