/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yundt.boot.center.data.proxy.query.IDictQueryApiProxy;
import com.yunxi.dg.base.center.inventory.dto.entity.InventoryBatchDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InventoryBatchReqDto;
import com.yunxi.dg.base.center.inventory.proxy.basedata.IInventoryBatchApiProxy;
import com.yunxi.dg.base.center.item.proxy.item.IItemSkuDgReportQueryApiProxy;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicInventoryTotalDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicInventoryTotalPageReqDto;
import com.yunxi.dg.base.center.report.proxy.inventory.IDgLogicInventoryTotalApiProxy;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import com.yunxi.dg.base.mgmt.application.rpc.dto.entity.LogicWarehousePageReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.entity.LogicWarehouseRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.inventory.DgLogicInventoryDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.inventory.DgLogicInventoryListReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.inventory.InventoryTakeStockOrderDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.inventory.InventoryTakeStockOrderItemDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.request.ItemQueryDgReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.request.UnitDgReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.DgItemSkuDetailRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.DgItemSkuRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.UnitDgRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.inventory.IDgLogicInventoryApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.inventory.IInventoryTakeStockOrderApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.inventorybiz.IDgPhysicsWarehouseApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.sku.IItemSkuDgQueryApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.unit.IUnitDgQueryApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.warehouse.ILogicWarehouseApiProxy;
import com.yunxi.dg.base.ocs.mgmt.application.dto.entity.DgPhysicsWarehouseDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.InventoryTakeStockOrderBizTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.InventoryTakeStockOrderStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.LogicWarehouseQualityEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.InventoryTakeStockOrderImportDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.DateUtils;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service(value="AbstractBaseFileOperationCommonService_inventory_take_stock_order_import")
public class InventoryTakeStockOrderCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(InventoryTakeStockOrderCommonServiceImpl.class);
    @Resource
    private IDgLogicInventoryApiProxy dgLogicInventoryApiProxy;
    @Resource
    private IUnitDgQueryApiProxy unitDgQueryApiProxy;
    @Resource
    private IInventoryTakeStockOrderApiProxy iInventoryTakeStockOrderApiProxy;
    @Resource
    private IItemSkuDgQueryApiProxy iItemSkuDgQueryApiProxy;
    @Resource
    private IDictQueryApiProxy iDictQueryApiProxy;
    @Resource
    private IDgPhysicsWarehouseApiProxy dgPhysicsWarehouseApiProxy;
    @Resource
    private ILogicWarehouseApiProxy logicWarehouseApiProxy;
    @Resource
    private IInventoryBatchApiProxy inventoryBatchApiProxy;
    @Resource
    private IDgLogicInventoryTotalApiProxy dgLogicInventoryTotalApiProxy;
    @Resource
    private IItemSkuDgReportQueryApiProxy itemSkuDgReportQueryApiProxy;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList passList = Lists.newArrayList();
        List resultList = BeanUtil.copyToList((Collection)result.getList(), InventoryTakeStockOrderImportDto.class);
        log.info("TSverifyImportFileOperationCommon-->resultList:{}", (Object)JSON.toJSONString((Object)resultList));
        List<String> skuCodes = resultList.stream().map(InventoryTakeStockOrderImportDto::getSkuCode).collect(Collectors.toList());
        List logicWarehouseCodes = resultList.stream().map(InventoryTakeStockOrderImportDto::getLogicWarehouseCode).collect(Collectors.toList());
        List<DgLogicInventoryTotalDto> dgLogicInventoryTotalDtos = this.getDgLogicInventoryTotalDtos(skuCodes);
        List physicsWarehouseDtos = (List)RestResponseHelper.extractData((RestResponse)this.dgPhysicsWarehouseApiProxy.queryAll());
        LogicWarehousePageReqDto warehousePageReqDto = new LogicWarehousePageReqDto();
        warehousePageReqDto.setWarehouseCodeList(logicWarehouseCodes);
        List warehouseRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.logicWarehouseApiProxy.queryList(warehousePageReqDto));
        Map<String, LogicWarehouseRespDto> logicWarehouseCodeMap = warehouseRespDtos.stream().collect(Collectors.toMap(LogicWarehouseRespDto::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
        Map<String, DgPhysicsWarehouseDto> physicsWarehouseCodeMap = physicsWarehouseDtos.stream().collect(Collectors.toMap(DgPhysicsWarehouseDto::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
        Map<String, DgLogicInventoryTotalDto> skuCodeMap = dgLogicInventoryTotalDtos.stream().collect(Collectors.toMap(DgLogicInventoryTotalDto::getSkuCode, Function.identity(), (k1, k2) -> k1));
        for (InventoryTakeStockOrderImportDto dto : resultList) {
            boolean isPass = this.paramVerify(dto, physicsWarehouseCodeMap, logicWarehouseCodeMap, skuCodeMap);
            if (isPass) {
                dto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", dto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), dto.getErrorMsg()));
                respDto.getErrorDetails().add(dto);
                continue;
            }
            passList.add(dto);
        }
        respDto.setDetails((List)passList);
        return passList;
    }

    private boolean paramVerify(InventoryTakeStockOrderImportDto dto, Map<String, DgPhysicsWarehouseDto> physicsWarehouseCodeMap, Map<String, LogicWarehouseRespDto> logicWarehouseCodeMap, Map<String, DgLogicInventoryTotalDto> skuCodeMap) {
        boolean flag = false;
        StringBuilder errorMsg = new StringBuilder();
        if (StringUtils.isBlank((CharSequence)dto.getBizType())) {
            errorMsg.append("\u4e1a\u52a1\u7c7b\u578b\u672a\u586b\u5199;");
            flag = true;
        } else if (ObjectUtils.isEmpty((Object)InventoryTakeStockOrderBizTypeEnum.getByDesc((String)dto.getBizType()))) {
            errorMsg.append("\u4e1a\u52a1\u7c7b\u578b\u4e0d\u5b58\u5728;");
            flag = true;
        }
        if (StringUtils.isBlank((CharSequence)dto.getInventoryPropertyType())) {
            errorMsg.append("\u5e93\u5b58\u6570\u636e\u6765\u6e90\u672a\u586b\u5199;");
            flag = true;
        } else if (ObjectUtil.isEmpty((Object)LogicWarehouseQualityEnum.getByDesc((String)dto.getInventoryPropertyType()))) {
            errorMsg.append("\u5e93\u5b58\u6570\u636e\u6765\u6e90\u586b\u5199\u4e0d\u6b63\u786e;");
            flag = true;
        }
        if (StringUtils.isEmpty((CharSequence)dto.getLogicWarehouseCode())) {
            errorMsg.append("\u903b\u8f91\u4ed3\u7f16\u7801\u672a\u586b\u5199;");
            flag = true;
        } else if (ObjectUtils.isEmpty((Object)logicWarehouseCodeMap.get(dto.getLogicWarehouseCode()))) {
            errorMsg.append("\u903b\u8f91\u4ed3\u7f16\u7801\u4e0d\u5b58\u5728;");
            flag = true;
        }
        if (StringUtils.isEmpty((CharSequence)dto.getPhysicsWarehouseCode())) {
            errorMsg.append("\u7269\u7406\u4ed3\u7f16\u7801\u672a\u586b\u5199;");
            flag = true;
        } else if (ObjectUtils.isEmpty((Object)physicsWarehouseCodeMap.get(dto.getPhysicsWarehouseCode()))) {
            errorMsg.append("\u7269\u7406\u4ed3\u7f16\u7801\u4e0d\u5b58\u5728;");
            flag = true;
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getPhysicsWarehouseCode()) && StringUtils.isNotBlank((CharSequence)dto.getLogicWarehouseCode()) && Objects.nonNull(logicWarehouseCodeMap.get(dto.getLogicWarehouseCode())) && !Objects.equals(logicWarehouseCodeMap.get(dto.getLogicWarehouseCode()).getPhysicsWarehouseCode(), dto.getPhysicsWarehouseCode())) {
            errorMsg.append("\u903b\u8f91\u4ed3\u7f16\u7801" + dto.getLogicWarehouseCode() + "\u4e0d\u5f52\u5c5e\u4e8e\u5f53\u524d\u7684\u7269\u7406\u4ed3" + dto.getPhysicsWarehouseCode() + ";");
            flag = true;
        }
        if (StringUtils.isEmpty((CharSequence)dto.getAccountTime())) {
            errorMsg.append("\u4e1a\u52a1\u65e5\u671f\u672a\u586b\u5199;");
            flag = true;
        } else {
            String accountTimeStr = null;
            try {
                Date accountTime = HSSFDateUtil.getJavaDate((double)(Double.parseDouble(dto.getAccountTime()) + 1.0));
                accountTimeStr = DateUtils.formatDate((Date)accountTime, (String)"yyyy-MM-dd");
            }
            catch (Exception e) {
                log.info("\u4e1a\u52a1\u65e5\u671f\u8f6c\u6362\u5f02\u5e38:{}", (Object)e.getMessage());
                e.printStackTrace();
            }
            if (StringUtils.isBlank((CharSequence)accountTimeStr)) {
                errorMsg.append("\u4e1a\u52a1\u65e5\u671f\u4e0d\u7b26\u5408\u201cYYYY/MM/DD\u201d\u7684\u683c\u5f0f\uff0c\u8bf7\u8c03\u6574;");
                flag = true;
            } else {
                dto.setAccountTime(accountTimeStr);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getRemark()) && dto.getRemark().length() > 200) {
            errorMsg.append("\u5907\u6ce8\u4e0d\u80fd\u8d85\u8fc7200\u4e2a\u5b57\u7b26;");
            flag = true;
        }
        if (StringUtils.isEmpty((CharSequence)dto.getSkuCode())) {
            errorMsg.append("SKU\u7f16\u7801\u672a\u586b\u5199;");
            flag = true;
        } else if (BeanUtil.isEmpty((Object)skuCodeMap.get(dto.getSkuCode()), (String[])new String[0])) {
            errorMsg.append("SKU\u7f16\u7801\u4e0d\u5b58\u5728;");
            flag = true;
        }
        if (ObjectUtils.isEmpty((Object)dto.getAccountNum())) {
            errorMsg.append("\u8d26\u9762\u6570\u91cf\u672a\u586b\u5199;");
            flag = true;
        } else {
            if (BigDecimalUtils.ltZero((BigDecimal)new BigDecimal(dto.getAccountNum())).booleanValue()) {
                errorMsg.append("\u8d26\u9762\u6570\u91cf\u5fc5\u987b\u4e3a\u6b63\u6574\u6570;");
                flag = true;
            }
            if (BigDecimalUtils.gt((BigDecimal)new BigDecimal(dto.getAccountNum()), (BigDecimal)new BigDecimal(10000000L)).booleanValue()) {
                errorMsg.append("\u8d26\u9762\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc77\u4f4d;");
                flag = true;
            }
        }
        if (ObjectUtils.isEmpty((Object)dto.getFirmOfferNum())) {
            errorMsg.append("\u5b9e\u76d8\u6570\u91cf\u672a\u586b\u5199;");
            flag = true;
        } else {
            if (BigDecimalUtils.ltZero((BigDecimal)new BigDecimal(dto.getFirmOfferNum())).booleanValue()) {
                errorMsg.append("\u5b9e\u76d8\u6570\u91cf\u5fc5\u987b\u4e3a\u6b63\u6574\u6570;");
                flag = true;
            }
            if (BigDecimalUtils.gt((BigDecimal)new BigDecimal(dto.getFirmOfferNum()), (BigDecimal)new BigDecimal(10000000L)).booleanValue()) {
                errorMsg.append("\u5b9e\u76d8\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc77\u4f4d;");
                flag = true;
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getItemRemark()) && dto.getItemRemark().length() > 200) {
            errorMsg.append("\u884c\u5907\u6ce8\u4e0d\u80fd\u8d85\u8fc7200\u4e2a\u5b57\u7b26;");
            flag = true;
        }
        dto.setErrorMsg(errorMsg.toString());
        return flag;
    }

    private List<DgLogicInventoryDto> getDgLogicInventoryDtos(List<String> skuCodes) {
        DgLogicInventoryListReqDto reqDto = new DgLogicInventoryListReqDto();
        reqDto.setSkuCodeList(skuCodes);
        reqDto.setPageNum(Integer.valueOf(1));
        reqDto.setPageSize(Integer.valueOf(100000));
        return Optional.ofNullable(((PageInfo)RestResponseHelper.extractData((RestResponse)this.dgLogicInventoryApiProxy.page(reqDto))).getList()).orElse(new ArrayList());
    }

    private List<DgLogicInventoryTotalDto> getDgLogicInventoryTotalDtos(List<String> skuCodes) {
        DgLogicInventoryTotalPageReqDto dto = new DgLogicInventoryTotalPageReqDto();
        dto.setSkuCodeList(skuCodes);
        return (List)RestResponseHelper.extractData((RestResponse)this.dgLogicInventoryTotalApiProxy.queryList(dto));
    }

    private Map<String, UnitDgRespDto> getUnitMap() {
        List unitRespDtos = Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.unitDgQueryApiProxy.queryList(new UnitDgReqDto()))).orElse(new ArrayList());
        Map<String, UnitDgRespDto> unitMap = unitRespDtos.stream().collect(Collectors.toMap(UnitDgRespDto::getName, Function.identity(), (k1, k2) -> k1));
        return unitMap;
    }

    private List<UnitDgRespDto> getUnitList() {
        return Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.unitDgQueryApiProxy.queryList(new UnitDgReqDto()))).orElse(new ArrayList());
    }

    public String uploadImportErrorFile(List<? extends ImportBaseModeDto> errorList, String fileName) {
        return super.uploadImportErrorFile(errorList, fileName);
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        log.info("TScallBackImportFileOperationCommonAsync-->result:{}", (Object)JSON.toJSONString(result));
        log.info("TScallBackImportFileOperationCommonAsync-->commonReqDto:{}", (Object)JSON.toJSONString((Object)commonReqDto));
        log.info("TScallBackImportFileOperationCommonAsync-->respDto:{}", (Object)JSON.toJSONString((Object)respDto));
        log.info("TScallBackImportFileOperationCommonAsync-->object:{}", (Object)JSON.toJSONString((Object)object));
        List passList = (List)object;
        if (CollectionUtil.isEmpty((Collection)passList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
        if (CollectionUtil.isNotEmpty((Collection)passList) && !respDto.getErrorDetails().isEmpty()) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode());
        }
        try {
            List<InventoryTakeStockOrderImportDto> inventoryTakeStockOrderImportDtos = this.mergeInventoryTakeStockOrder(passList);
            List<InventoryTakeStockOrderDto> inventoryTakeStockOrderDtos = this.converterInventoryTakeStockOrder(inventoryTakeStockOrderImportDtos);
            this.iInventoryTakeStockOrderApiProxy.insertBatch(inventoryTakeStockOrderDtos);
        }
        catch (Exception e) {
            log.info("\u5bfc\u5165\u521b\u5efa\u76d8\u70b9\u5355\u5931\u8d25:{}", (Throwable)e);
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            respDto.setErrorMsg(e.getMessage());
        }
    }

    private List<InventoryTakeStockOrderDto> converterInventoryTakeStockOrder(List<InventoryTakeStockOrderImportDto> inventoryTakeStockOrderImportDtos) {
        HashMap inventoryTakeStockOrderDtoMap = Maps.newHashMap();
        String accountTime = DateUtils.formatDate((Date)new Date(), (String)"yyyy/MM/dd");
        List<String> skuCodes = inventoryTakeStockOrderImportDtos.stream().map(InventoryTakeStockOrderImportDto::getSkuCode).collect(Collectors.toList());
        List logicWarehouseCodes = inventoryTakeStockOrderImportDtos.stream().map(InventoryTakeStockOrderImportDto::getLogicWarehouseCode).collect(Collectors.toList());
        LogicWarehousePageReqDto logicWarehousePageReqDto = new LogicWarehousePageReqDto();
        logicWarehousePageReqDto.setWarehouseCodeList(logicWarehouseCodes);
        List warehouseRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.logicWarehouseApiProxy.queryList(logicWarehousePageReqDto));
        ItemQueryDgReqDto itemQueryDgReqDto = new ItemQueryDgReqDto();
        itemQueryDgReqDto.setSkuCodes(skuCodes);
        List itemSkuDgRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemSkuDgReportQueryApiProxy.querySkuList(itemQueryDgReqDto));
        List<DgLogicInventoryDto> dgLogicInventoryDtos = this.getDgLogicInventoryDtos(skuCodes);
        Map dgLogicInventoryDtoMap = dgLogicInventoryDtos.stream().collect(Collectors.toMap(DgLogicInventoryDto::getSkuCode, Function.identity(), (k1, k2) -> k1));
        Map logicWarehouseRespDtoMap = warehouseRespDtos.stream().collect(Collectors.toMap(LogicWarehouseRespDto::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
        Map physicsWarehouseMap = ((List)RestResponseHelper.extractData((RestResponse)this.dgPhysicsWarehouseApiProxy.queryAll())).stream().collect(Collectors.toMap(DgPhysicsWarehouseDto::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
        Map itemSkuDgRespDtoMap = itemSkuDgRespDtos.stream().collect(Collectors.toMap(DgItemSkuRespDto::getSkuCode, Function.identity(), (k1, k2) -> k1));
        for (InventoryTakeStockOrderImportDto dto : inventoryTakeStockOrderImportDtos) {
            InventoryTakeStockOrderItemDto inventoryTakeStockOrderItemDto;
            DgPhysicsWarehouseDto physicsWarehouse = (DgPhysicsWarehouseDto)physicsWarehouseMap.get(dto.getPhysicsWarehouseCode());
            LogicWarehouseRespDto logicWarehouseRespDto = (LogicWarehouseRespDto)logicWarehouseRespDtoMap.get(dto.getLogicWarehouseCode());
            if (StringUtils.isEmpty((CharSequence)dto.getAccountTime())) {
                dto.setAccountTime(accountTime);
            }
            dto.setInventoryPropertyType(LogicWarehouseQualityEnum.getByDesc((String)dto.getInventoryPropertyType()).getCode());
            String key = InventoryTakeStockOrderCommonServiceImpl.concatenateStrings(dto.getBizType(), dto.getPhysicsWarehouseCode(), dto.getInventoryPropertyType(), dto.getAccountTime());
            DgLogicInventoryDto dgLogicInventoryDto = dgLogicInventoryDtoMap.getOrDefault(dto.getSkuCode(), new DgLogicInventoryDto());
            if (inventoryTakeStockOrderDtoMap.containsKey(key)) {
                List mapItemList;
                InventoryTakeStockOrderDto mapInventoryTakeStockOrderDto = (InventoryTakeStockOrderDto)inventoryTakeStockOrderDtoMap.get(key);
                if (ObjectUtil.isNotEmpty((Object)mapInventoryTakeStockOrderDto) && CollectionUtils.isNotEmpty((Collection)(mapItemList = mapInventoryTakeStockOrderDto.getItemList()))) {
                    inventoryTakeStockOrderItemDto = new InventoryTakeStockOrderItemDto();
                    inventoryTakeStockOrderItemDto.setSkuCode(dto.getSkuCode());
                    inventoryTakeStockOrderItemDto.setBatch("0");
                    inventoryTakeStockOrderItemDto.setAccountNum(new BigDecimal(dto.getAccountNum()));
                    inventoryTakeStockOrderItemDto.setFirmOfferNum(new BigDecimal(dto.getFirmOfferNum()));
                    inventoryTakeStockOrderItemDto.setDifferenceNum(inventoryTakeStockOrderItemDto.getFirmOfferNum().subtract(inventoryTakeStockOrderItemDto.getAccountNum()));
                    inventoryTakeStockOrderItemDto.setRemark(dto.getItemRemark());
                    inventoryTakeStockOrderItemDto.setSkuName(dgLogicInventoryDto.getSkuName());
                    inventoryTakeStockOrderItemDto.setSpuCode(dgLogicInventoryDto.getSpuCode());
                    inventoryTakeStockOrderItemDto.setSpuName(dgLogicInventoryDto.getSpuName());
                    if (Objects.nonNull(itemSkuDgRespDtoMap.get(dto.getSkuCode()))) {
                        inventoryTakeStockOrderItemDto.setUnit(((DgItemSkuDetailRespDto)itemSkuDgRespDtoMap.get(dto.getSkuCode())).getUnit());
                    }
                    inventoryTakeStockOrderItemDto.setTakeStockType(Integer.valueOf(1));
                    inventoryTakeStockOrderItemDto.setWarehouseCode(dto.getLogicWarehouseCode());
                    inventoryTakeStockOrderItemDto.setOrganizationName(Objects.nonNull(logicWarehouseRespDto) ? logicWarehouseRespDto.getOrganizationName() : null);
                    inventoryTakeStockOrderItemDto.setOrganizationCode(Objects.nonNull(logicWarehouseRespDto) ? logicWarehouseRespDto.getOrganizationCode() : null);
                    mapItemList.add(inventoryTakeStockOrderItemDto);
                }
                inventoryTakeStockOrderDtoMap.put(key, mapInventoryTakeStockOrderDto);
                continue;
            }
            InventoryTakeStockOrderDto inventoryTakeStockOrderDto = new InventoryTakeStockOrderDto();
            inventoryTakeStockOrderDto.setOrderStatus(InventoryTakeStockOrderStatusEnum.WAIT_COMPLETED.getCode());
            InventoryTakeStockOrderBizTypeEnum bizTypeEnum = InventoryTakeStockOrderBizTypeEnum.getByDesc((String)dto.getBizType());
            if (ObjectUtil.isNotEmpty((Object)bizTypeEnum)) {
                inventoryTakeStockOrderDto.setBizType(bizTypeEnum.getCode());
            }
            inventoryTakeStockOrderDto.setAccountTime(dto.getAccountTime());
            inventoryTakeStockOrderDto.setRemark(dto.getRemark());
            inventoryTakeStockOrderDto.setPhysicsWarehouseCode(Objects.nonNull(physicsWarehouse) ? physicsWarehouse.getWarehouseCode() : dto.getPhysicsWarehouseCode());
            inventoryTakeStockOrderDto.setPhysicsWarehouseName(Objects.nonNull(physicsWarehouse) ? physicsWarehouse.getWarehouseName() : null);
            inventoryTakeStockOrderDto.setInventoryPropertyType(dto.getInventoryPropertyType());
            ArrayList itemList = Lists.newArrayList();
            inventoryTakeStockOrderItemDto = new InventoryTakeStockOrderItemDto();
            inventoryTakeStockOrderItemDto.setSkuCode(dto.getSkuCode());
            inventoryTakeStockOrderItemDto.setBatch("0");
            inventoryTakeStockOrderItemDto.setAccountNum(new BigDecimal(dto.getAccountNum()));
            inventoryTakeStockOrderItemDto.setFirmOfferNum(new BigDecimal(dto.getFirmOfferNum()));
            inventoryTakeStockOrderItemDto.setDifferenceNum(inventoryTakeStockOrderItemDto.getFirmOfferNum().subtract(inventoryTakeStockOrderItemDto.getAccountNum()));
            inventoryTakeStockOrderItemDto.setRemark(dto.getItemRemark());
            inventoryTakeStockOrderItemDto.setSkuName(dgLogicInventoryDto.getSkuName());
            inventoryTakeStockOrderItemDto.setSpuCode(dgLogicInventoryDto.getSpuCode());
            inventoryTakeStockOrderItemDto.setSpuName(dgLogicInventoryDto.getSpuName());
            if (Objects.nonNull(itemSkuDgRespDtoMap.get(dto.getSkuCode()))) {
                inventoryTakeStockOrderItemDto.setUnit(((DgItemSkuDetailRespDto)itemSkuDgRespDtoMap.get(dto.getSkuCode())).getUnit());
            }
            inventoryTakeStockOrderItemDto.setTakeStockType(Integer.valueOf(1));
            inventoryTakeStockOrderItemDto.setWarehouseCode(dto.getLogicWarehouseCode());
            inventoryTakeStockOrderItemDto.setOrganizationName(Objects.nonNull(logicWarehouseRespDto) ? logicWarehouseRespDto.getOrganizationName() : null);
            inventoryTakeStockOrderItemDto.setOrganizationCode(Objects.nonNull(logicWarehouseRespDto) ? logicWarehouseRespDto.getOrganizationCode() : null);
            itemList.add(inventoryTakeStockOrderItemDto);
            inventoryTakeStockOrderDto.setItemList((List)itemList);
            inventoryTakeStockOrderDtoMap.put(key, inventoryTakeStockOrderDto);
        }
        return new ArrayList<InventoryTakeStockOrderDto>(inventoryTakeStockOrderDtoMap.values());
    }

    private List<InventoryBatchDto> getInventoryBatchDtoList(List<String> skuCodes, List<String> batches) {
        InventoryBatchReqDto batchReqDto = new InventoryBatchReqDto();
        batchReqDto.setBatchList(batches);
        batchReqDto.setSkuCodeList(skuCodes);
        return (List)RestResponseHelper.extractData((RestResponse)this.inventoryBatchApiProxy.queryList(batchReqDto));
    }

    private List<InventoryTakeStockOrderImportDto> mergeInventoryTakeStockOrder(List<InventoryTakeStockOrderImportDto> passList) {
        HashMap mergeMap = Maps.newHashMap();
        HashMap remarkMap = Maps.newHashMap();
        for (InventoryTakeStockOrderImportDto dto : passList) {
            StringBuilder remark = new StringBuilder();
            String key = InventoryTakeStockOrderCommonServiceImpl.concatenateStrings(dto.getInventoryPropertyType(), dto.getPhysicsWarehouseCode(), dto.getLogicWarehouseCode(), dto.getBizType(), dto.getAccountTime(), dto.getSkuCode());
            String remarkKey = InventoryTakeStockOrderCommonServiceImpl.concatenateStrings(dto.getBizType(), dto.getPhysicsWarehouseCode(), dto.getInventoryPropertyType(), dto.getAccountTime());
            String tableRemark = dto.getRemark();
            if (remarkMap.containsKey(remarkKey)) {
                tableRemark = (String)remarkMap.get(remarkKey);
            } else {
                remarkMap.put(remarkKey, dto.getRemark());
            }
            if (mergeMap.containsKey(key)) {
                InventoryTakeStockOrderImportDto inventoryTakeStockOrder = (InventoryTakeStockOrderImportDto)mergeMap.get(key);
                inventoryTakeStockOrder.setAccountNum(BigDecimalUtils.add((BigDecimal)new BigDecimal(inventoryTakeStockOrder.getAccountNum()), (BigDecimal)new BigDecimal(dto.getAccountNum())).toString());
                inventoryTakeStockOrder.setFirmOfferNum(BigDecimalUtils.add((BigDecimal)new BigDecimal(inventoryTakeStockOrder.getFirmOfferNum()), (BigDecimal)new BigDecimal(dto.getFirmOfferNum())).toString());
                if (StringUtils.isNotEmpty((CharSequence)inventoryTakeStockOrder.getItemRemark())) {
                    remark.append(inventoryTakeStockOrder.getItemRemark());
                }
                if (StringUtils.isNotEmpty((CharSequence)dto.getItemRemark())) {
                    remark.append(dto.getItemRemark());
                }
                inventoryTakeStockOrder.setItemRemark(remark.toString());
                String itemRemark = inventoryTakeStockOrder.getItemRemark();
                if (StringUtils.isNotEmpty((CharSequence)itemRemark) && itemRemark.length() > 200) {
                    inventoryTakeStockOrder.setItemRemark(itemRemark.substring(0, 200));
                }
                inventoryTakeStockOrder.setRemark(tableRemark);
                mergeMap.put(key, inventoryTakeStockOrder);
                continue;
            }
            dto.setRemark(tableRemark);
            mergeMap.put(key, dto);
        }
        return new ArrayList<InventoryTakeStockOrderImportDto>(mergeMap.values());
    }

    public static String concatenateStrings(String ... strings) {
        StringBuilder result = new StringBuilder();
        for (String str : strings) {
            result.append(str);
        }
        return result.toString();
    }
}

