/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.exceptions.BizException;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.openapi.dto.req.DgAfterSaleOrderValidReqDto;
import com.yunxi.dg.base.center.report.dto.trade.resp.DgAfterSaleOrderRespDto;
import com.yunxi.dg.base.center.report.proxy.aftersale.IDgSmallRefundOrderApiProxy;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterSaleOrderDto;
import com.yunxi.dg.base.center.trade.proxy.aftersale.IDgAfterSaleOrderApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.trade.IDgB2CAfterSaleStatemachineApiProxy;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.SmallRefundReductionFeeImportDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_small_refund_Reduction_fee_import")
public class SmallRefundReductionFeeCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(SmallRefundReductionFeeCommonServiceImpl.class);
    @Resource
    private IDgSmallRefundOrderApiProxy idgSmallRefundOrderApiProxy;
    @Resource
    private IDgB2CAfterSaleStatemachineApiProxy idgB2CAfterSaleStatemachineApiProxy;
    @Resource
    private IDgAfterSaleOrderApiProxy dgAfterSaleOrderApiProxy;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        log.info("\u5c0f\u989d\u9000\u6b3e\u62a5\u9500\u5355\u53f7\u5bfc\u5165\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(result));
        List resultList = BeanUtil.copyToList((Collection)result.getList(), SmallRefundReductionFeeImportDto.class);
        if (CollectionUtil.isEmpty((Collection)resultList)) {
            throw new BizException("\u5bfc\u5165\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        if (resultList.size() > 1000) {
            throw new BizException("\u6279\u91cf\u5bfc\u5165\u4e0d\u652f\u6301\u8d85\u8fc71000\u884c");
        }
        if (resultList.stream().map(SmallRefundReductionFeeImportDto::getRefundOrderNo).count() > 400L) {
            throw new BizException("\u6279\u91cf\u5bfc\u5165\u5c0f\u989d\u9000\u6b3e\u5355\u4e0d\u652f\u6301\u8d85\u8fc7400\u4e2a");
        }
        ArrayList passList = Lists.newArrayList();
        for (SmallRefundReductionFeeImportDto importDto : resultList) {
            boolean isUnPass = this.checkAndInitParam(importDto);
            if (isUnPass) {
                importDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", importDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), importDto.getErrorMsg()));
                respDto.getErrorDetails().add(importDto);
                continue;
            }
            passList.add(importDto);
        }
        log.info("\u6253\u5370\u5c0f\u989d\u9000\u6b3e\u67e5\u8be2\u8ba2\u5355\u4fe1\u606fpassList\uff1a{}", (Object)JSONObject.toJSONString((Object)passList));
        respDto.setDetails((List)passList);
        Collections.sort(respDto.getErrorDetails(), Comparator.comparingInt(ImportBaseModeDto::getRowNum));
        return passList;
    }

    public boolean checkAndInitParam(final SmallRefundReductionFeeImportDto importDto) {
        log.info("\u5f00\u59cb\u6821\u9a8c\u6570\u636e");
        StringBuffer errorMsg = new StringBuffer();
        boolean startsWithAF = importDto.getRefundOrderNo().startsWith("AF");
        if (!startsWithAF) {
            errorMsg.append("\u9000\u6b3e\u5355\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e\uff1b");
        }
        if (null != importDto.getReductionFee() && !SmallRefundReductionFeeCommonServiceImpl.isPositiveInteger(importDto.getReductionFee())) {
            errorMsg.append("\u6838\u51cf\u91d1\u989d\u5fc5\u987b\u4e3a\u6b63\u6574\u6570\uff1b");
        }
        log.info("\u6839\u636e\u9000\u6b3e\u5355\u53f7\u67e5\u8be2");
        List respList = ((PageInfo)this.idgSmallRefundOrderApiProxy.queryByPage(new DgAfterSaleOrderValidReqDto(){
            {
                this.setOrderNo(Stream.of(importDto.getRefundOrderNo()).collect(Collectors.toList()));
            }
        }, Integer.valueOf(1), Integer.valueOf(10)).getData()).getList();
        log.info("\u6839\u636e\u9000\u6b3e\u5355\u53f7\u67e5\u8be2\u7684\u7ed3\u679c{}", (Object)JSONObject.toJSONString((Object)respList));
        if (respList.isEmpty()) {
            errorMsg.append("\u672a\u5339\u914d\u5230\u9000\u6b3e\u5355\u53f7\uff1b");
        } else {
            DgAfterSaleOrderRespDto respDto = (DgAfterSaleOrderRespDto)respList.get(0);
            if (null != respDto) {
                log.info("\u6839\u636e\u9000\u6b3e\u5355\u53f7:{},\u67e5\u5230\u6570\u636e:{}", (Object)importDto.getRefundOrderNo(), (Object)JSONObject.toJSONString((Object)respDto));
                if (null != respDto.getStatus() && !Objects.equals(respDto.getStatus(), "FINISH")) {
                    errorMsg.append("\u5355\u636e\u672a\u5b8c\u6210,\u65e0\u6cd5\u5bfc\u5165\uff1b");
                }
                if (null != respDto.getReimbursementStatus() && Objects.equals(respDto.getReimbursementStatus(), "1")) {
                    errorMsg.append("\u5355\u636e\u5df2\u6838\u9500,\u65e0\u6cd5\u5bfc\u5165\uff1b");
                }
            }
        }
        importDto.setErrorMsg(errorMsg.toString());
        log.info("\u5c0f\u989d\u9000\u6b3e\u6838\u51cf\u91d1\u989d\u5bfc\u5165\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)errorMsg));
        return errorMsg.length() > 0;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        log.info("\u5c0f\u989d\u9000\u6b3e\u62a5\u9500\u5355\u53f7-callBackImportFileOperationCommonAsync-->result:{}", (Object)JSON.toJSONString(result));
        List passList = (List)object;
        if (CollectionUtil.isEmpty((Collection)passList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        if (!respDto.getErrorDetails().isEmpty()) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode());
        }
        log.info("\u5904\u7406\u66f4\u65b0\u64cd\u4f5c");
        for (final SmallRefundReductionFeeImportDto dto : passList) {
            log.info("\u6839\u636e\u9000\u6b3e\u5355\u53f7\u67e5\u8be22");
            List respList = ((PageInfo)this.idgSmallRefundOrderApiProxy.queryByPage(new DgAfterSaleOrderValidReqDto(){
                {
                    this.setOrderNo(Stream.of(dto.getRefundOrderNo()).collect(Collectors.toList()));
                }
            }, Integer.valueOf(1), Integer.valueOf(10)).getData()).getList();
            log.info("\u6839\u636e\u9000\u6b3e\u5355\u53f7\u67e5\u8be2\u7684\u7ed3\u679c{}", (Object)JSONObject.toJSONString((Object)respList));
            DgAfterSaleOrderDto updateDto = new DgAfterSaleOrderDto();
            log.info("\u67e5\u8be2\u5230\u7684\u6570\u636e:{}", (Object)JSONObject.toJSONString(respList.get(0)));
            BeanUtil.copyProperties(respList.get(0), (Object)updateDto, (String[])new String[0]);
            log.info("\u590d\u5236\u4e4b\u540e\u7684\u6570\u636e:{}", (Object)updateDto);
            updateDto.setReductionFee(dto.getReductionFee());
            updateDto.setReimbursementAmount(updateDto.getRefundFee().subtract(updateDto.getReductionFee()));
            this.dgAfterSaleOrderApiProxy.updateAfterOrder(updateDto);
            log.info("\u66f4\u65b0\u7ed3\u675f");
        }
        Collections.sort(respDto.getErrorDetails(), Comparator.comparingInt(ImportBaseModeDto::getRowNum));
        log.info("\u9519\u8bef\u65e5\u5fd7\u6253\u53702\uff1a{}", (Object)JSONObject.toJSONString((Object)respDto.getErrorDetails()));
    }

    public static boolean isPositiveInteger(BigDecimal value) {
        if (value.signum() <= 0) {
            return false;
        }
        return value.scale() <= 0 || value.stripTrailingZeros().scale() <= 0;
    }
}

