/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.item.api.specification.ISpecificationNameApi;
import com.yunxi.dg.base.center.item.dto.entity.SpecificationNameDto;
import com.yunxi.dg.base.center.item.dto.entity.SpecificationNamePageReqDto;
import com.yunxi.dg.base.center.item.dto.request.SpecificationNameReqDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.SpecificationNameImportReqDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_specification_name_import")
public class SpecificationNameCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(SpecificationNameCommonServiceImpl.class);
    @Resource
    private ISpecificationNameApi specificationNameApi;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList list = new ArrayList();
        if (CollectionUtil.isEmpty((Collection)result.getList())) {
            return new ArrayList();
        }
        CubeBeanUtils.copyCollection(list, (Collection)result.getList(), SpecificationNameImportReqDto.class);
        ArrayList<SpecificationNameImportReqDto> passList = new ArrayList<SpecificationNameImportReqDto>();
        ArrayList<String> nameList = new ArrayList<String>();
        for (SpecificationNameImportReqDto importDto : list) {
            if (!Objects.nonNull(importDto.getName())) continue;
            nameList.add(importDto.getName());
        }
        Map<String, Object> nameDtoMap = new HashMap<String, SpecificationNameDto>();
        if (CollectionUtil.isNotEmpty(nameList)) {
            SpecificationNamePageReqDto reqDto = new SpecificationNamePageReqDto();
            reqDto.setNameList(nameList);
            reqDto.setPageNum(Integer.valueOf(1));
            reqDto.setPageSize(Integer.valueOf(nameList.size()));
            List nameDtos = ((PageInfo)this.specificationNameApi.queryPage(reqDto).getData()).getList();
            if (CollectionUtil.isNotEmpty((Collection)nameDtos)) {
                nameDtoMap = nameDtos.stream().collect(Collectors.toMap(SpecificationNameDto::getName, Function.identity(), (k1, k2) -> k2));
            }
        }
        HashSet<String> codeSet = new HashSet<String>();
        HashSet<String> nameSet = new HashSet<String>();
        for (SpecificationNameImportReqDto dto : list) {
            Boolean verify = this.unitVerify(dto, nameDtoMap, codeSet, nameSet);
            if (verify.booleanValue()) {
                passList.add(dto);
                continue;
            }
            dto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", dto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), dto.getErrorMsg()));
            respDto.getErrorDetails().add(dto);
        }
        respDto.setDetails(passList);
        return passList;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        List passList = (List)object;
        if (CollectionUtil.isEmpty((Collection)passList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
        if (CollectionUtil.isNotEmpty((Collection)passList) && !respDto.getErrorDetails().isEmpty()) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode());
        }
        log.info("\u4e0a\u4e0b\u6587userCode:{}", (Object)commonReqDto.getCreatePerson());
        ArrayList reqDtos = Lists.newArrayList();
        try {
            for (SpecificationNameImportReqDto modeDto : passList) {
                SpecificationNameReqDto dto = new SpecificationNameReqDto();
                BeanUtil.copyProperties((Object)modeDto, (Object)dto, (String[])new String[0]);
                reqDtos.add(dto);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.specificationNameApi.batchAdd((List)reqDtos);
    }

    private Boolean unitVerify(SpecificationNameImportReqDto dto, Map<String, SpecificationNameDto> nameDtoMap, Set<String> codeList, Set<String> nameList) {
        if (Objects.isNull(dto.getCode())) {
            dto.setErrorMsg("\u89c4\u683c\u9879\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a");
            return false;
        }
        if (codeList.contains(dto.getCode())) {
            dto.setErrorMsg("\u89c4\u683c\u9879\u7f16\u7801\u5df2\u91cd\u590d\u63d0\u4ea4");
            return false;
        }
        if (Objects.isNull(dto.getName())) {
            dto.setErrorMsg("\u89c4\u683c\u9879\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a");
            return false;
        }
        if (nameList.contains(dto.getName())) {
            dto.setErrorMsg("\u89c4\u683c\u9879\u540d\u79f0\u5df2\u91cd\u590d\u63d0\u4ea4");
            return false;
        }
        if (dto.getName().length() > 6) {
            dto.setErrorMsg("\u89c4\u683c\u9879\u540d\u79f0\u4e0d\u53ef\u8d85\u8fc76\u4e2a\u5b57");
            return false;
        }
        if (dto.getCode().length() > 50) {
            dto.setErrorMsg("\u89c4\u683c\u9879\u7f16\u7801\u4e0d\u53ef\u8d85\u8fc750\u4e2a\u5b57");
            return false;
        }
        if (Objects.nonNull(dto.getExternalCode()) && dto.getExternalCode().length() > 50) {
            dto.setErrorMsg("\u89c4\u683c\u9879\u5916\u90e8\u7f16\u7801\u4e0d\u53ef\u8d85\u8fc750\u4e2a\u5b57");
            return false;
        }
        SpecificationNameDto specificationNameDto = nameDtoMap.get(dto.getName());
        if (Objects.nonNull(specificationNameDto) && !Objects.equals(specificationNameDto.getCode(), dto.getCode())) {
            dto.setErrorMsg("\u89c4\u683c\u9879\u540d\u79f0\u5df2\u5b58\u5728");
            return false;
        }
        codeList.add(dto.getCode());
        nameList.add(dto.getName());
        return true;
    }
}

