/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.finance.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.ParamConverter;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.finance.dto.entity.PerformOrderInfoDto;
import com.yunxi.dg.base.center.finance.dto.request.BillApplyGenerateReqDto;
import com.yunxi.dg.base.center.finance.dto.request.BillApplyImportErrorDto;
import com.yunxi.dg.base.center.finance.dto.request.BillApplyPageQueryReqDto;
import com.yunxi.dg.base.center.finance.dto.response.BillApplyRespDto;
import com.yunxi.dg.base.center.finance.proxy.entity.IBillApplyApiProxy;
import com.yunxi.dg.base.center.finance.proxy.entity.IPerformOrderInfoApiProxy;
import com.yunxi.dg.base.mgmt.service.finance.FinancialManagementInvoiceManagementInvoiceApplyOrderService;
import com.yunxi.dg.base.mgmt.service.utils.AssertUtil;
import com.yunxi.dg.base.ocs.mgmt.application.constants.BillTitleTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.constants.OrderSourceModelTransformationEnum;
import com.yunxi.dg.base.ocs.mgmt.application.constants.WhetherMergeBillTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.entity.BillApplyTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.entity.PmsBillInfoTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.entity.PmsBillTitleTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.AddTocInvoiceParams;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.GetInvoiceApplyOrderListPageParams;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.ImportBillApplyDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.ImportBillApplyErrorDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.InvoiceApplyOrderVO;
import com.yunxi.dg.base.ocs.mgmt.application.dto.finance.ReTransformInvoiceApplyOrderParams;
import com.yunxi.dg.base.ocs.mgmt.application.dto.transform.consts.PlatformOrderStatus;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Service(value="AbstractBaseFileOperationCommonService_FINANCE_BILL_APPLY")
public class FinancialManagementInvoiceManagementInvoiceApplyOrderServiceServiceImpl
extends AbstractBaseFileOperationCommonService
implements FinancialManagementInvoiceManagementInvoiceApplyOrderService {
    private static final Logger logger = LoggerFactory.getLogger(FinancialManagementInvoiceManagementInvoiceApplyOrderServiceServiceImpl.class);
    @Resource
    private IBillApplyApiProxy billApplyApi;
    @Resource
    private IPerformOrderInfoApiProxy performOrderInfoApiQueryProxy;

    @Override
    public RestResponse<Object> applyInvoiceOrder(@ApiParam(value="") @Valid @RequestBody(required=false) AddTocInvoiceParams addTocInvoiceParams) {
        BillApplyGenerateReqDto reqDto = new BillApplyGenerateReqDto();
        CubeBeanUtils.copyProperties((Object)reqDto, (Object)addTocInvoiceParams, (String[])new String[0]);
        if (StringUtils.isNotBlank((CharSequence)addTocInvoiceParams.getPlatformOrderNo())) {
            String[] platformOrderNos = addTocInvoiceParams.getPlatformOrderNo().split(",");
            List platformOrderNoList = Stream.of(platformOrderNos).map(no -> {
                String platformOrderNo = no;
                return platformOrderNo;
            }).collect(Collectors.toList());
            reqDto.setPlatformOrderNoList(platformOrderNoList);
        }
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)addTocInvoiceParams.getInvoiceType()), "\u53d1\u7968\u79cd\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        reqDto.setBillType(addTocInvoiceParams.getInvoiceType());
        reqDto.setBillApplyType(addTocInvoiceParams.getApplyType());
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)addTocInvoiceParams.getInvoiceHeaderType()), "\u62ac\u5934\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        reqDto.setTitleType(addTocInvoiceParams.getInvoiceHeaderType());
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)addTocInvoiceParams.getInvoiceHeader()) && StringUtils.isNotBlank((CharSequence)addTocInvoiceParams.getCompanyName()), "\u53d1\u7968\u62ac\u5934/\u4f01\u4e1a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        reqDto.setBillTitle(addTocInvoiceParams.getInvoiceHeader());
        reqDto.setEnterprise(addTocInvoiceParams.getCompanyName());
        reqDto.setTaxesCode(addTocInvoiceParams.getTaxpayerIdentificationNo());
        reqDto.setRegisteredAddress(addTocInvoiceParams.getRegisterAddress());
        reqDto.setRegisteredPhone(addTocInvoiceParams.getRegisterPhone());
        reqDto.setBankAccount(addTocInvoiceParams.getBankAccountNo());
        reqDto.setBank(addTocInvoiceParams.getDepositBank());
        reqDto.setBillPersonName(addTocInvoiceParams.getReceiveName());
        reqDto.setBillPersonPhone(addTocInvoiceParams.getReceivePhone());
        reqDto.setBillAddress(addTocInvoiceParams.getReceiveAddress());
        reqDto.setMailbox(addTocInvoiceParams.getReceiveInvoiceEmail());
        reqDto.setPhone(addTocInvoiceParams.getReceiveInvoicePhone());
        reqDto.setWhetherMergeBill(addTocInvoiceParams.getWhetherMergeBill());
        reqDto.setFileUrl(addTocInvoiceParams.getFileUrl());
        reqDto.setRemark(addTocInvoiceParams.getRemark());
        if (null == addTocInvoiceParams.getWhetherMergeBill()) {
            reqDto.setWhetherMergeBill(WhetherMergeBillTypeEnum.NO_MERGE.getCode());
        }
        logger.info("\u7533\u8bf7\u5f00\u7968\u5165\u53c2reqDto:{}", (Object)JSON.toJSONString((Object)reqDto));
        RestResponseHelper.extractData((RestResponse)this.billApplyApi.generateBillApply(reqDto));
        return new RestResponse();
    }

    @Override
    public RestResponse<Object> batchReTransformInvoiceApplyOrder(@ApiParam(value="") @Valid @RequestBody(required=false) ReTransformInvoiceApplyOrderParams reTransformInvoiceApplyOrderParams) {
        if (CollectionUtils.isEmpty((Collection)reTransformInvoiceApplyOrderParams.getInvoiceApplyNos())) {
            throw new BizException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        RestResponseHelper.extractData((RestResponse)this.billApplyApi.transformBillApply(reTransformInvoiceApplyOrderParams.getInvoiceApplyNos()));
        return new RestResponse();
    }

    @Override
    public RestResponse<InvoiceApplyOrderVO> getInvoiceApplyOrderDetail(@NotNull @ApiParam(value="", required=true) @Valid @RequestParam(value="id", required=true) String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new BizException("id\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        BillApplyRespDto billApplyRespDto = (BillApplyRespDto)RestResponseHelper.extractData((RestResponse)this.billApplyApi.queryById(ParamConverter.convertToLong((Object)id)));
        AssertUtil.isTrue(Objects.isNull(billApplyRespDto), "\u65e0\u5bf9\u5e94\u5f00\u7968\u7533\u8bf7\u5355\uff01");
        InvoiceApplyOrderVO vo = new InvoiceApplyOrderVO();
        FinancialManagementInvoiceManagementInvoiceApplyOrderServiceServiceImpl.respDto2Vo(billApplyRespDto, vo);
        logger.info("\u53d1\u7968\u7533\u8bf7\u5355\u8be6\u60c5\u8fd4\u56devo:{}", (Object)JSON.toJSONString((Object)vo));
        return new RestResponse((Object)vo);
    }

    @Override
    public RestResponse<PageInfo<InvoiceApplyOrderVO>> getInvoiceApplyOrderListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetInvoiceApplyOrderListPageParams getInvoiceApplyOrderListPageParams) {
        if (Objects.isNull(getInvoiceApplyOrderListPageParams)) {
            throw new BizException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BillApplyPageQueryReqDto reqDto = new BillApplyPageQueryReqDto();
        FinancialManagementInvoiceManagementInvoiceApplyOrderServiceServiceImpl.param2PageReqDto(getInvoiceApplyOrderListPageParams, reqDto);
        logger.info("\u5f00\u7968\u7533\u8bf7\u5206\u9875\u67e5\u8be2\u5165\u53c2reqDto:{}", (Object)JSON.toJSONString((Object)reqDto));
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.billApplyApi.queryPage(reqDto));
        logger.info("\u5f00\u7968\u7533\u8bf7\u5206\u9875\u67e5\u8be2\u51fa\u53c2respDtoPageInfo:{}", (Object)JSON.toJSONString((Object)respDtoPageInfo));
        List<Object> voList = Lists.newArrayList();
        PageInfo voPageInfo = new PageInfo();
        if (CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) {
            BeanUtils.copyProperties((Object)respDtoPageInfo, (Object)voPageInfo);
            voList = respDtoPageInfo.getList().stream().map(respDto -> {
                InvoiceApplyOrderVO vo = new InvoiceApplyOrderVO();
                FinancialManagementInvoiceManagementInvoiceApplyOrderServiceServiceImpl.respDto2Vo(respDto, vo);
                return vo;
            }).collect(Collectors.toList());
        }
        logger.info("\u5f00\u7968\u7533\u8bf7\u5206\u9875\u8fd4\u56devoList:{}", (Object)JSON.toJSONString((Object)voList));
        voPageInfo.setList((List)voList);
        return new RestResponse((Object)voPageInfo);
    }

    private static void respDto2Vo(BillApplyRespDto respDto, InvoiceApplyOrderVO vo) {
        CubeBeanUtils.copyProperties((Object)vo, (Object)respDto, (String[])new String[0]);
        vo.setPlatformOrderNo(respDto.getPlatformOrderNo());
        vo.setPlatformOrderId(Objects.nonNull(respDto.getPlatformOrderId()) ? respDto.getPlatformOrderId().toString() : null);
        vo.setPlatformOrderStatus(respDto.getPlatformOrderStatus());
        String platformOrderStatus = PlatformOrderStatus.getDescByCode((String)respDto.getPlatformOrderStatus());
        vo.setPlatformOrderStatusName(platformOrderStatus);
        vo.setInvoiceApplyNo(respDto.getApplyNo());
        vo.setBussinessOrderNo(respDto.getBusinessOrderNo());
        vo.setApplyType(respDto.getApplyType());
        vo.setStationCode(respDto.getSite());
        vo.setShopCode(respDto.getShopCode());
        vo.setShopName(respDto.getShopName());
        vo.setShopId(ParamConverter.convertToString((Object)respDto.getShopId()));
        vo.setInvoiceType(respDto.getBillType());
        vo.setInvoiceHeaderType(respDto.getTitleType());
        BillTitleTypeEnum billTitleTypeEnum = BillTitleTypeEnum.getEnumByCode((String)respDto.getTitleType());
        if (billTitleTypeEnum != null) {
            vo.setInvoiceHeaderTypeName(billTitleTypeEnum.getName());
        }
        vo.setInvoiceHeader(respDto.getBillTitle());
        vo.setTaxpayerIdentificationNo(respDto.getTaxesCode());
        vo.setRegisterAddress(respDto.getRegisteredAddress());
        vo.setRegisterPhone(respDto.getRegisteredPhone());
        vo.setDepositBank(respDto.getBank());
        vo.setBankAccountNo(respDto.getBankAccount());
        vo.setApplyChannel(respDto.getApplyChannel());
        vo.setTransformStatus(respDto.getChangeType());
        if (respDto.getApplyTime() != null) {
            vo.setApplyTime(DateUtil.format((Date)respDto.getApplyTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        vo.setIsLatestOrder(respDto.getIsLatestOrder());
        vo.setStationCode(respDto.getSite());
        vo.setReceiveInvoiceEmail(respDto.getMailbox());
        vo.setReceiveInvoicePhone(respDto.getPhone());
        vo.setWhetherMergeBill(respDto.getWhetherMergeBill());
        vo.setCreatePerson(respDto.getCreatePerson());
        OrderSourceModelTransformationEnum sourceModelTransformationEnum = OrderSourceModelTransformationEnum.getCodeBySiteCode((String)respDto.getSite());
        if (sourceModelTransformationEnum != null) {
            vo.setStationName(sourceModelTransformationEnum.getDesc());
        }
        vo.setFileUrl(respDto.getFileUrl());
        vo.setRemark(respDto.getRemark());
        vo.setSubsidiesType(respDto.getSubsidiesType());
        vo.setDistributionOrderNo(respDto.getDistributionOrderNo());
    }

    private static void param2PageReqDto(GetInvoiceApplyOrderListPageParams getInvoiceApplyOrderListPageParams, BillApplyPageQueryReqDto reqDto) {
        CubeBeanUtils.copyProperties((Object)reqDto, (Object)getInvoiceApplyOrderListPageParams, (String[])new String[]{"applyChannel"});
        reqDto.setPlatformOrderNo(getInvoiceApplyOrderListPageParams.getPlatformOrderNo());
        reqDto.setApplyNo(getInvoiceApplyOrderListPageParams.getInvoiceApplyNo());
        reqDto.setBusinessOrderNo(getInvoiceApplyOrderListPageParams.getBussinessOrderNo());
        reqDto.setApplyType(getInvoiceApplyOrderListPageParams.getApplyType());
        reqDto.setSite(getInvoiceApplyOrderListPageParams.getStationCode());
        reqDto.setShopId(ParamConverter.convertToLong((Object)getInvoiceApplyOrderListPageParams.getShopId()));
        reqDto.setBillType(getInvoiceApplyOrderListPageParams.getInvoiceType());
        if (StringUtils.isNotBlank((CharSequence)getInvoiceApplyOrderListPageParams.getApplyChannel())) {
            List<String> list = Arrays.asList(getInvoiceApplyOrderListPageParams.getApplyChannel().split(","));
            reqDto.setApplyChannelList(list);
        }
        reqDto.setChangeType(getInvoiceApplyOrderListPageParams.getTransformStatus());
        reqDto.setBeginApplyTime(getInvoiceApplyOrderListPageParams.getApplyTimeStart());
        reqDto.setEndApplyTime(getInvoiceApplyOrderListPageParams.getApplyTimeEnd());
        reqDto.setConversionBeginTime(getInvoiceApplyOrderListPageParams.getConversionBeginTime());
        reqDto.setConversionEndTime(getInvoiceApplyOrderListPageParams.getConversionEndTime());
        if (CollectionUtils.isNotEmpty((Collection)getInvoiceApplyOrderListPageParams.getPlatformOrderNoList())) {
            reqDto.setPlatformOrderNoList(getInvoiceApplyOrderListPageParams.getPlatformOrderNoList());
        }
        reqDto.setCreatePerson(getInvoiceApplyOrderListPageParams.getCreatePerson());
        reqDto.setSubsidiesType(getInvoiceApplyOrderListPageParams.getSubsidiesType());
    }

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        logger.info("\u5bfc\u5165\u5f00\u7968\u7533\u8bf7\u5355\u4fe1\u606flist====>>>{}", (Object)result.getList().size());
        if (CollectionUtil.isEmpty((Collection)result.getList())) {
            return new ArrayList();
        }
        if (result.getList().size() > 1000) {
            respDto.setErrorMsg("\u6279\u91cf\u5bfc\u5165\u4e0d\u652f\u6301\u8d85\u8fc71000\u884c");
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return new ArrayList();
        }
        ArrayList list = new ArrayList();
        CubeBeanUtils.copyCollection(list, (Collection)result.getList(), ImportBillApplyDto.class);
        ArrayList passList = new ArrayList();
        HashSet platformOrderNoSet = new HashSet();
        HashSet repeatPlatformOrderNoSet = new HashSet();
        list.forEach(info -> {
            if (StringUtils.isNotBlank((CharSequence)info.getPlatformOrderNo())) {
                if (platformOrderNoSet.contains(info.getPlatformOrderNo())) {
                    repeatPlatformOrderNoSet.add(info.getPlatformOrderNo());
                } else {
                    platformOrderNoSet.add(info.getPlatformOrderNo());
                }
            }
        });
        List performOrderInfoDtoList = (List)RestResponseHelper.extractData((RestResponse)this.performOrderInfoApiQueryProxy.queryByPlatformOrderNoList(new ArrayList(platformOrderNoSet)));
        Map map = ((List)Optional.ofNullable(performOrderInfoDtoList).orElse(new ArrayList())).stream().collect(Collectors.toMap(PerformOrderInfoDto::getPlatformOrderNo, Function.identity(), (v1, v2) -> v2));
        list.forEach(o -> {
            this.importApplySpaceHandle((ImportBillApplyDto)o);
            ImportBillApplyErrorDto msgDto = new ImportBillApplyErrorDto();
            ImportBillApplyDto successDto = new ImportBillApplyDto();
            ArrayList<String> errorList = new ArrayList<String>();
            if (StringUtils.isBlank((CharSequence)o.getPlatformOrderNo())) {
                errorList.add("\u5e73\u53f0\u5355\u53f7\u4e3a\u7a7a");
            } else if (!map.containsKey(o.getPlatformOrderNo())) {
                errorList.add("\u5e73\u53f0\u5355\u53f7\u4e0d\u5b58\u5728");
            }
            if (repeatPlatformOrderNoSet.contains(o.getPlatformOrderNo())) {
                errorList.add("\u5bfc\u5165\u7684\u5e73\u53f0\u5355\u53f7\u91cd\u590d");
            }
            this.importCheckParams((ImportBillApplyDto)o, (List<String>)errorList);
            if (CollectionUtils.isNotEmpty(errorList)) {
                BeanUtils.copyProperties((Object)o, (Object)msgDto);
                msgDto.setErrorMsg(String.join((CharSequence)",", errorList));
                respDto.getErrorDetails().add(msgDto);
            } else {
                CubeBeanUtils.copyProperties((Object)successDto, (Object)o, (String[])new String[0]);
                passList.add(successDto);
            }
        });
        logger.info("\u91c7\u8d2d\u9000\u8d27\u5355\u6821\u9a8c\u901a\u8fc7\u6570\u91cf====>>>{}", (Object)passList.size());
        return passList;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        List successList = (List)object;
        if (CollectionUtil.isEmpty((Collection)successList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        if (CollectionUtils.isNotEmpty((Collection)successList) && CollectionUtils.isNotEmpty((Collection)respDto.getErrorDetails())) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode());
        } else {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
        }
        ArrayList reqDtoList = new ArrayList();
        successList.forEach(info -> {
            BillApplyGenerateReqDto billApplyGenerateReqDto = new BillApplyGenerateReqDto();
            CubeBeanUtils.copyProperties((Object)billApplyGenerateReqDto, (Object)info, (String[])new String[0]);
            billApplyGenerateReqDto.setBillType(PmsBillInfoTypeEnum.getEnumByName((String)info.getBillType()).getCode());
            billApplyGenerateReqDto.setTitleType(PmsBillTitleTypeEnum.getEnumByName((String)info.getTitleType()).getCode());
            billApplyGenerateReqDto.setEnterprise(info.getBillTitle());
            billApplyGenerateReqDto.setBillApplyType(BillApplyTypeEnum.APPLY_BILL.getCode());
            ArrayList<String> platformOrderNoList = new ArrayList<String>();
            platformOrderNoList.add(info.getPlatformOrderNo());
            billApplyGenerateReqDto.setPlatformOrderNoList(platformOrderNoList);
            reqDtoList.add(billApplyGenerateReqDto);
        });
        List billApplyImportErrorDtoList = (List)RestResponseHelper.extractData((RestResponse)this.billApplyApi.importBillApply(reqDtoList));
        if (CollectionUtils.isNotEmpty((Collection)billApplyImportErrorDtoList)) {
            logger.info("\u5bfc\u5165\u7533\u8bf7\u5355\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)billApplyImportErrorDtoList));
            Map errorDtoMap = billApplyImportErrorDtoList.stream().collect(Collectors.toMap(BillApplyImportErrorDto::getPlatformOrderNo, Function.identity(), (v1, v2) -> v1));
            successList.forEach(error -> {
                if (errorDtoMap.containsKey(error.getPlatformOrderNo())) {
                    ImportBillApplyErrorDto importBillApplyErrorDto = new ImportBillApplyErrorDto();
                    CubeBeanUtils.copyProperties((Object)importBillApplyErrorDto, (Object)error, (String[])new String[0]);
                    importBillApplyErrorDto.setErrorMsg(((BillApplyImportErrorDto)errorDtoMap.get(error.getPlatformOrderNo())).getErrorMsg());
                    respDto.getErrorDetails().add(importBillApplyErrorDto);
                }
            });
        }
    }

    public void importApplySpaceHandle(ImportBillApplyDto importBillApplyDto) {
        if (StringUtils.isNotBlank((CharSequence)importBillApplyDto.getPlatformOrderNo())) {
            importBillApplyDto.setPlatformOrderNo(importBillApplyDto.getPlatformOrderNo().replace(" ", "").replace("\n", ""));
        }
        if (StringUtils.isNotBlank((CharSequence)importBillApplyDto.getBillTitle())) {
            importBillApplyDto.setBillTitle(importBillApplyDto.getBillTitle().replace(" ", "").replace("\n", ""));
        }
        if (StringUtils.isNotBlank((CharSequence)importBillApplyDto.getTitleType())) {
            importBillApplyDto.setTitleType(importBillApplyDto.getTitleType().replace(" ", "").replace("\n", ""));
        }
        if (StringUtils.isNotBlank((CharSequence)importBillApplyDto.getBillType())) {
            importBillApplyDto.setBillType(importBillApplyDto.getBillType().replace(" ", "").replace("\n", ""));
        }
        if (StringUtils.isNotBlank((CharSequence)importBillApplyDto.getTaxesCode())) {
            importBillApplyDto.setTaxesCode(importBillApplyDto.getTaxesCode().replace(" ", "").replace("\n", ""));
        }
        if (StringUtils.isNotBlank((CharSequence)importBillApplyDto.getRegisteredAddress())) {
            importBillApplyDto.setRegisteredAddress(importBillApplyDto.getRegisteredAddress().replace(" ", "").replace("\n", ""));
        }
        if (StringUtils.isNotBlank((CharSequence)importBillApplyDto.getRegisteredPhone())) {
            importBillApplyDto.setRegisteredPhone(importBillApplyDto.getRegisteredPhone().replace(" ", "").replace("\n", ""));
        }
        if (StringUtils.isNotBlank((CharSequence)importBillApplyDto.getBank())) {
            importBillApplyDto.setBank(importBillApplyDto.getBank().replace(" ", "").replace("\n", ""));
        }
        if (StringUtils.isNotBlank((CharSequence)importBillApplyDto.getBankAccount())) {
            importBillApplyDto.setBankAccount(importBillApplyDto.getBankAccount().replace(" ", "").replace("\n", ""));
        }
        if (StringUtils.isNotBlank((CharSequence)importBillApplyDto.getMailbox())) {
            importBillApplyDto.setMailbox(importBillApplyDto.getMailbox().replace(" ", "").replace("\n", ""));
        }
        if (StringUtils.isNotBlank((CharSequence)importBillApplyDto.getPhone())) {
            importBillApplyDto.setPhone(importBillApplyDto.getPhone().replace(" ", "").replace("\n", ""));
        }
        if (StringUtils.isNotBlank((CharSequence)importBillApplyDto.getBillPersonName())) {
            importBillApplyDto.setBillPersonName(importBillApplyDto.getBillPersonName().replace(" ", "").replace("\n", ""));
        }
        if (StringUtils.isNotBlank((CharSequence)importBillApplyDto.getBillPersonPhone())) {
            importBillApplyDto.setBillPersonPhone(importBillApplyDto.getBillPersonPhone().replace(" ", "").replace("\n", ""));
        }
        if (StringUtils.isNotBlank((CharSequence)importBillApplyDto.getBillAddress())) {
            importBillApplyDto.setBillAddress(importBillApplyDto.getBillAddress().replace(" ", "").replace("\n", ""));
        }
    }

    private void importCheckParams(ImportBillApplyDto importBillApplyDto, List<String> errorList) {
        String taxesCode;
        String billTitle;
        String titleType;
        String billType = importBillApplyDto.getBillType();
        if (StringUtils.isNotBlank((CharSequence)billType)) {
            if (null == PmsBillInfoTypeEnum.getEnumByName((String)billType)) {
                errorList.add("\u53d1\u7968\u79cd\u7c7b\u9519\u8bef");
            }
        } else {
            errorList.add("\u53d1\u7968\u79cd\u7c7b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNotBlank((CharSequence)(titleType = importBillApplyDto.getTitleType()))) {
            if (null == PmsBillTitleTypeEnum.getEnumByName((String)titleType)) {
                errorList.add("\u62ac\u5934\u7c7b\u578b\u9519\u8bef");
            }
        } else {
            errorList.add("\u62ac\u5934\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)(billTitle = importBillApplyDto.getBillTitle()))) {
            errorList.add("\u53d1\u7968\u62ac\u5934\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (PmsBillTitleTypeEnum.COMPANY.getName().equals(titleType) && StringUtils.isBlank((CharSequence)(taxesCode = importBillApplyDto.getTaxesCode()))) {
            errorList.add("\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (PmsBillInfoTypeEnum.SPECIAL_PAPER_INVOICE.getName().equals(billType)) {
            String bank;
            String bankAccount;
            String registeredPhone;
            String registeredAddress;
            taxesCode = importBillApplyDto.getTaxesCode();
            if (StringUtils.isBlank((CharSequence)taxesCode)) {
                errorList.add("\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)(registeredAddress = importBillApplyDto.getRegisteredAddress()))) {
                errorList.add("\u6ce8\u518c\u5730\u5740\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)(registeredPhone = importBillApplyDto.getRegisteredPhone()))) {
                errorList.add("\u6ce8\u518c\u7535\u8bdd\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)(bankAccount = importBillApplyDto.getBankAccount()))) {
                errorList.add("\u5f00\u6237\u8d26\u53f7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)(bank = importBillApplyDto.getBank()))) {
                errorList.add("\u5f00\u6237\u94f6\u884c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)importBillApplyDto.getPhone()) && !importBillApplyDto.getPhone().matches("1[3-9]\\d{9}")) {
            errorList.add("\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef");
        }
    }

    private void checkParam(ExcelImportResult<ImportBaseModeDto> result) {
        if (result.isVerfiyFail()) {
            int index = 1;
            result.getFailList().forEach(l -> {
                throw new BizException(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", l.getRowNum() + index, l.getErrorMsg()));
            });
        }
        if (CollectionUtils.isEmpty((Collection)result.getList())) {
            throw new BizException("\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (result.getList().size() > 2000) {
            throw new BizException("\u6700\u591a\u53ea\u80fd\u5bfc\u51652000\u884c\u6570\u636e");
        }
    }
}

