/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.DateUtil;
import com.yunxi.dg.base.center.inventory.dto.entity.InventoryBatchDto;
import com.yunxi.dg.base.center.inventory.proxy.basedata.IInventoryBatchApiProxy;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.mgmt.application.rpc.dto.entity.ItemDgRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.entity.LogicInventoryDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.entity.LogicWarehousePageReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.entity.LogicWarehouseRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.request.ItemQueryDgReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.request.UnitDgReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.DgItemSkuDetailRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.DgItemSkuRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.UnitDgRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.inventory.ILogicInventoryApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.old.IItemDgQueryApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.sku.IItemSkuDgQueryApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.unit.IUnitDgQueryApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.warehouse.ILogicWarehouseApiProxy;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.InventoryTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.LogicWarehouseQualityEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.ImportLogicInventoryOrderModelDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_logic_inventory_order")
public class LogicInventoryOrderCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(LogicInventoryOrderCommonServiceImpl.class);
    @Resource
    private ILogicWarehouseApiProxy iLogicWarehouseApiProxy;
    @Resource
    private IItemSkuDgQueryApiProxy itemSkuDgQueryApiProxy;
    @Resource
    private IUnitDgQueryApiProxy iUnitDgQueryApiProxy;
    @Resource
    private IUnitDgQueryApiProxy unitDgQueryApiProxy;
    @Resource
    private ILogicInventoryApiProxy inventoryApiProxy;
    @Resource
    private IInventoryBatchApiProxy inventoryBatchApiProxy;
    @Resource
    private IItemDgQueryApiProxy itemDgQueryApiProxy;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        log.info("\u5f00\u59cb\u5bfc\u5165\u903b\u8f91\u4ed3\u5e93\u5b58");
        ArrayList<ImportLogicInventoryOrderModelDto> passList = new ArrayList<ImportLogicInventoryOrderModelDto>();
        List resultList = BeanUtil.copyToList((Collection)result.getList(), ImportLogicInventoryOrderModelDto.class);
        log.info("\u5f00\u59cb\u5bfc\u5165\u903b\u8f91\u4ed3\u5e93\u5b58\u6570\u636e:{}", (Object)JSON.toJSONString((Object)resultList));
        List warehouseCodes = resultList.stream().map(ImportLogicInventoryOrderModelDto::getWarehouseCode).distinct().collect(Collectors.toList());
        LogicWarehousePageReqDto reqDto = new LogicWarehousePageReqDto();
        reqDto.setWarehouseCodeList(warehouseCodes);
        List dgLogicInventoryDtos = Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.iLogicWarehouseApiProxy.queryList(reqDto))).orElse(new ArrayList());
        List skuCodes = resultList.stream().map(ImportLogicInventoryOrderModelDto::getSkuCode).collect(Collectors.toList());
        ItemQueryDgReqDto itemReqDto = new ItemQueryDgReqDto();
        itemReqDto.setSkuCodes(skuCodes);
        List dgItemSkuDetailRespDtos = Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.itemSkuDgQueryApiProxy.querySkuList(itemReqDto))).orElse(new ArrayList());
        Map<String, LogicWarehouseRespDto> warehouseCodeMap = dgLogicInventoryDtos.stream().collect(Collectors.toMap(LogicWarehouseRespDto::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
        Map<String, DgItemSkuDetailRespDto> skuCodeMap = dgItemSkuDetailRespDtos.stream().collect(Collectors.toMap(DgItemSkuRespDto::getSkuCode, Function.identity(), (k1, k2) -> k1));
        List unitRespDtos = Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.unitDgQueryApiProxy.queryList(new UnitDgReqDto()))).orElse(new ArrayList());
        Map<String, DgItemSkuDetailRespDto> itemUnitMap = dgItemSkuDetailRespDtos.stream().collect(Collectors.toMap(DgItemSkuRespDto::getSkuCode, Function.identity(), (k1, k2) -> k1));
        Map<String, UnitDgRespDto> unitMap = unitRespDtos.stream().collect(Collectors.toMap(UnitDgRespDto::getCode, Function.identity(), (k1, k2) -> k1));
        for (ImportLogicInventoryOrderModelDto dto : resultList) {
            boolean isPass = this.paramVerify(dto, warehouseCodeMap, skuCodeMap, itemUnitMap, unitMap);
            if (isPass) {
                this.setErrorMsg(dto, String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", dto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), dto.getErrorMsg()));
                respDto.getErrorDetails().add(dto);
                continue;
            }
            passList.add(dto);
        }
        respDto.setDetails(passList);
        return passList;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        List passList = (List)object;
        if (CollectionUtil.isEmpty((Collection)passList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
        if (CollectionUtil.isNotEmpty((Collection)passList) && !respDto.getErrorDetails().isEmpty()) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode());
        }
        try {
            ArrayList<LogicInventoryDto> orderDtoList = new ArrayList<LogicInventoryDto>();
            this.assembleDtos(orderDtoList, passList);
            for (LogicInventoryDto dto : orderDtoList) {
                this.inventoryApiProxy.insert(dto);
            }
            ArrayList<InventoryBatchDto> orderBatchDtoList = new ArrayList<InventoryBatchDto>();
            this.assembleBatchDtos(orderBatchDtoList, passList);
            this.inventoryBatchApiProxy.save(orderBatchDtoList);
        }
        catch (Exception e) {
            log.info("\u5bfc\u5165\u5176\u4ed6\u51fa\u5e93\u5355\u5931\u8d25:{}", (Throwable)e);
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            respDto.setErrorMsg(e.getMessage());
        }
    }

    private void assembleDtos(List<LogicInventoryDto> orderDtoList, List<ImportLogicInventoryOrderModelDto> passList) {
        passList.forEach(v -> {
            Date time;
            LogicInventoryDto dto = new LogicInventoryDto();
            dto.setWarehouseCode(v.getLogicWarehouseCode());
            dto.setWarehouseName(v.getLogicWarehouseName());
            dto.setInventoryProperty(InventoryTypeEnum.getCode((String)v.getInventoryProperty()));
            dto.setSkuCode(v.getSkuCode());
            dto.setSkuName(v.getSkuName());
            if (StringUtils.isNotBlank((CharSequence)v.getBatch())) {
                dto.setBatch(v.getBatch());
            }
            dto.setBalance(new BigDecimal(v.getBalance()));
            dto.setAvailable(new BigDecimal(v.getAvailable()));
            if (StringUtils.isNotBlank((CharSequence)v.getProduceTime())) {
                time = DateUtil.parse((String)v.getProduceTime());
                dto.setProduceTime(time);
            }
            if (StringUtils.isNotBlank((CharSequence)v.getExpireTime())) {
                time = DateUtil.parse((String)v.getExpireTime());
                dto.setExpireTime(time);
            }
            orderDtoList.add(dto);
        });
    }

    private void assembleBatchDtos(List<InventoryBatchDto> orderBatchDtoList, List<ImportLogicInventoryOrderModelDto> passList) {
        List ids = passList.stream().map(ImportLogicInventoryOrderModelDto::getItemId).distinct().collect(Collectors.toList());
        List itemIdList = ids.stream().filter(Objects::nonNull).map(String::valueOf).distinct().collect(Collectors.toList());
        List itemDgRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemDgQueryApiProxy.queryByItemIdsOnPost(itemIdList));
        Map itemDgRespDtoMap = itemDgRespDtos.stream().collect(Collectors.toMap(ItemDgRespDto::getId, Function.identity(), (k1, k2) -> k1));
        passList.forEach(v -> {
            Date time;
            InventoryBatchDto dto = new InventoryBatchDto();
            dto.setSkuCode(v.getSkuCode());
            dto.setSkuName(v.getSkuName());
            if (StringUtils.isNotBlank((CharSequence)v.getBatch())) {
                dto.setBatch(v.getBatch());
            }
            if (StringUtils.isNotBlank((CharSequence)v.getProduceTime())) {
                time = DateUtil.parse((String)v.getProduceTime());
                dto.setProduceTime(time);
            }
            if (StringUtils.isNotBlank((CharSequence)v.getExpireTime())) {
                time = DateUtil.parse((String)v.getExpireTime());
                dto.setExpireTime(time);
            }
            if (itemDgRespDtoMap.containsKey(v.getItemId())) {
                ItemDgRespDto itemDgRespDto = (ItemDgRespDto)itemDgRespDtoMap.get(v.getItemId());
                dto.setSpuCode(Objects.nonNull(itemDgRespDto) ? itemDgRespDto.getCode() : null);
                dto.setSpuName(Objects.nonNull(itemDgRespDto) ? itemDgRespDto.getName() : null);
            }
            orderBatchDtoList.add(dto);
        });
    }

    private boolean paramVerify(ImportLogicInventoryOrderModelDto dto, Map<String, LogicWarehouseRespDto> warehouseCodeMap, Map<String, DgItemSkuDetailRespDto> skuCodeMap, Map<String, DgItemSkuDetailRespDto> itemUnitMap, Map<String, UnitDgRespDto> unitMap) {
        LogicWarehouseRespDto inventoryDto;
        boolean flag = false;
        DgItemSkuDetailRespDto dgItemSkuDetailRespDto = skuCodeMap.get(dto.getSkuCode());
        if (ObjectUtil.isEmpty((Object)dgItemSkuDetailRespDto)) {
            this.setErrorMsg(dto, "SKU\u7f16\u7801\u4e0d\u5b58\u5728");
            flag = true;
        } else {
            dto.setSkuId(dgItemSkuDetailRespDto.getId());
            dto.setItemId(dgItemSkuDetailRespDto.getItemId());
            dto.setSkuName(dgItemSkuDetailRespDto.getSkuName());
        }
        if (ObjectUtil.isEmpty((Object)LogicWarehouseQualityEnum.getByDesc((String)dto.getInventoryProperty()))) {
            this.setErrorMsg(dto, "\u5e93\u5b58\u72b6\u6001\u7c7b\u578b\u4e0d\u5b58\u5728");
            flag = true;
        }
        if (ObjectUtil.isEmpty((Object)(inventoryDto = warehouseCodeMap.get(dto.getWarehouseCode())))) {
            this.setErrorMsg(dto, "\u903b\u8f91\u4ed3\u5e93\u4e0d\u5b58\u5728");
            flag = true;
        } else {
            dto.setLogicWarehouseCode(inventoryDto.getWarehouseCode());
            dto.setLogicWarehouseName(inventoryDto.getWarehouseName());
            dto.setPhysicsWarehouseCode(inventoryDto.getPhysicsWarehouseCode());
            dto.setPhysicsWarehouseName(inventoryDto.getPhysicsWarehouseName());
        }
        if (!dto.getBalance().matches("^(([0-9]+\\.[0-9]*[1-9][0-9]*)|([0-9]*[1-9][0-9]*\\.[0-9]+)|([0-9]*[1-9][0-9]*))$")) {
            this.setErrorMsg(dto, "\u6570\u91cf\u5fc5\u987b\u4e3a\u6b63\u6570");
            flag = true;
        }
        return flag;
    }

    private String setErrorMsg(ImportLogicInventoryOrderModelDto dto, String errorMsg) {
        log.info("\u6821\u9a8c\u9519\u8bef\u4fe1\u606f{}", (Object)errorMsg);
        dto.setErrorMsg(dto.getErrorMsg() + "," + errorMsg);
        return dto.getErrorMsg();
    }
}

