/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.inventorybiz.IDgLogicWarehouseApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.inventorybiz.ILogicWarehouseQueryApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.warehouse.ITransferDispatchWarehouseApiProxy;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.inventory.DgLogicWarehouseDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.inventory.DgLogicWarehousePageReqDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.TransferDispatchWarehouseDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.TransferDispatchWarehousePageReqDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.response.VerifyWarehouseDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import jodd.util.StringUtil;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_transfer_dispatch_warehouse")
public class TransferDispatchWarehouseCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static Logger logger = LoggerFactory.getLogger(TransferDispatchWarehouseCommonServiceImpl.class);
    @Resource
    private ILogicWarehouseQueryApiProxy logicWarehouseQueryApiProxy;
    @Resource
    private ITransferDispatchWarehouseApiProxy transferDispatchWarehouseApiProxy;
    @Resource
    private IDgLogicWarehouseApiProxy dgLogicWarehouseApiProxy;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        List transferDispatchWarehouseDtos = BeanUtil.copyToList((Collection)result.getList(), TransferDispatchWarehouseDto.class);
        logger.info("\u4ed3\u5e93\u914d\u7f6e\u5bfc\u5165={}", JSON.toJSON((Object)transferDispatchWarehouseDtos));
        List<TransferDispatchWarehouseDto> importDtoList = this.dealRepeat(transferDispatchWarehouseDtos);
        Map<String, DgLogicWarehouseDto> mapLogicWarehouseDto = this.mapLogicWarehouseDto(importDtoList);
        List<TransferDispatchWarehousePageReqDto> transferDispatchWarehousePageReqDtos = this.mapTransferDispatchWarehouseExist(importDtoList);
        ArrayList<TransferDispatchWarehouseDto> lastImportList = new ArrayList<TransferDispatchWarehouseDto>();
        for (TransferDispatchWarehouseDto warehouseDto : importDtoList) {
            this.verifyOrg(warehouseDto, respDto, commonReqDto, mapLogicWarehouseDto);
            this.verifyUnique(warehouseDto, respDto, commonReqDto, transferDispatchWarehousePageReqDtos);
            if (!StrUtil.isBlank((CharSequence)warehouseDto.getErrorMsg())) continue;
            lastImportList.add(warehouseDto);
        }
        return lastImportList;
    }

    private List<TransferDispatchWarehouseDto> dealRepeat(List<TransferDispatchWarehouseDto> importDtoList) {
        HashSet<String> set = new HashSet<String>();
        ArrayList<TransferDispatchWarehouseDto> warehouseDtos = new ArrayList<TransferDispatchWarehouseDto>();
        for (TransferDispatchWarehouseDto warehouseDto : importDtoList) {
            String transferDeliverWarehouseCode = warehouseDto.getTransferDeliverWarehouseCode();
            String transferImportWarehouseCode = warehouseDto.getTransferImportWarehouseCode();
            String transferImportPhysicsWarehouseCode = warehouseDto.getTransferImportPhysicsWarehouseCode();
            String key = transferDeliverWarehouseCode + "_" + transferImportWarehouseCode + "_" + transferImportPhysicsWarehouseCode;
            if (!set.add(key)) continue;
            warehouseDtos.add(warehouseDto);
        }
        return warehouseDtos;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
        List importList = (List)object;
        logger.info("\u8c03\u62e8\u8ba1\u5212\u5355\u9a8c\u8bc1\u6210\u529f\u7684\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)importList));
        if (CollectionUtil.isEmpty((Collection)importList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        if (CollectionUtil.isNotEmpty((Collection)importList) && !respDto.getErrorDetails().isEmpty()) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode());
        }
        RestResponse integerRestResponse = this.transferDispatchWarehouseApiProxy.insertBatchNew(importList);
        logger.info("\u8c03\u62e8\u8ba1\u5212\u5355\u6279\u91cf\u6dfb\u52a0\u6570\u636e:{} ,\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)importList.size(), (Object)JSON.toJSONString((Object)integerRestResponse.getData()));
    }

    private void verifyUnique(TransferDispatchWarehouseDto warehouseDto, ImportFileOperationCommonRespDto respDto, ImportFileOperationCommonReqDto commonReqDto, List<TransferDispatchWarehousePageReqDto> warehouseList) {
        if (StrUtil.isNotBlank((CharSequence)warehouseDto.getErrorMsg())) {
            return;
        }
        List existCollect = warehouseList.stream().map(e -> {
            String s = e.getTransferDeliverWarehouseCode() + "_" + e.getTransferImportWarehouseCode() + "_" + e.getTransferImportPhysicsWarehouseCode();
            return s;
        }).collect(Collectors.toList());
        String transferDeliverWarehouseCode = warehouseDto.getTransferDeliverWarehouseCode();
        String transferImportWarehouseCode = warehouseDto.getTransferImportWarehouseCode();
        String transferImportPhysicsWarehouseCode = warehouseDto.getTransferImportPhysicsWarehouseCode();
        String key = transferDeliverWarehouseCode + "_" + transferImportWarehouseCode + "_" + transferImportPhysicsWarehouseCode;
        if (existCollect.contains(key)) {
            warehouseDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", warehouseDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), "\u5b58\u5728\u91cd\u590d\u6570\u636e\uff0c\u8bf7\u68c0\u67e5"));
            respDto.getErrorDetails().add(warehouseDto);
        }
    }

    private List<TransferDispatchWarehousePageReqDto> mapTransferDispatchWarehouseExist(List<TransferDispatchWarehouseDto> importDtoList) {
        List verifyDto = BeanUtil.copyToList(importDtoList, TransferDispatchWarehousePageReqDto.class);
        logger.info("\u5bfc\u5165\u4ed3\u5e93\u914d\u7f6e\u67e5\u8be2\u4ed3\u5e93\u4e0d\u552f\u4e00\u4fe1\u606f\u5165\u53c2={}", JSON.toJSON((Object)verifyDto));
        VerifyWarehouseDto verifyResult = (VerifyWarehouseDto)RestResponseHelper.extractData((RestResponse)this.transferDispatchWarehouseApiProxy.pageVerify(verifyDto));
        logger.info("\u5bfc\u5165\u4ed3\u5e93\u914d\u7f6e\u67e5\u8be2\u4ed3\u5e93\u4e0d\u552f\u4e00\u4fe1\u606f={}", JSON.toJSON((Object)verifyResult.getNoUniqueList()));
        return verifyResult.getNoUniqueList();
    }

    private void verifyOrg(TransferDispatchWarehouseDto warehouseDto, ImportFileOperationCommonRespDto respDto, ImportFileOperationCommonReqDto commonReqDto, Map<String, DgLogicWarehouseDto> mapLogicWarehouseDto) {
        if (StrUtil.isNotBlank((CharSequence)warehouseDto.getErrorMsg())) {
            return;
        }
        DgLogicWarehouseDto inWarehouseRespDto = mapLogicWarehouseDto.get(warehouseDto.getTransferImportWarehouseCode());
        if (Objects.isNull(inWarehouseRespDto)) {
            warehouseDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", warehouseDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), "\u8c03\u5165\u4ed3\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5"));
            respDto.getErrorDetails().add(warehouseDto);
            return;
        }
        DgLogicWarehouseDto outWarehouse = mapLogicWarehouseDto.get(warehouseDto.getTransferDeliverWarehouseCode());
        if (Objects.isNull(outWarehouse)) {
            warehouseDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", warehouseDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), "\u8c03\u51fa\u4ed3\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5"));
            respDto.getErrorDetails().add(warehouseDto);
            return;
        }
        if (!Objects.equals(outWarehouse.getOrganizationCode(), inWarehouseRespDto.getOrganizationCode())) {
            warehouseDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", warehouseDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), "\u8c03\u5165\u4ed3\u548c\u8c03\u51fa\u4ed3\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5"));
            respDto.getErrorDetails().add(warehouseDto);
            return;
        }
        if (!Objects.equals(warehouseDto.getTransferImportPhysicsWarehouseCode(), inWarehouseRespDto.getPhysicsWarehouseCode())) {
            warehouseDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", warehouseDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), "\u8c03\u5165\u4ed3\u548c\u8c03\u5165\u7269\u7406\u4ed3\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5"));
            respDto.getErrorDetails().add(warehouseDto);
            return;
        }
        warehouseDto.setTransferDeliverWarehouseName(outWarehouse.getWarehouseName());
        warehouseDto.setTransferDeliverOrgCode(outWarehouse.getOrganizationCode());
        warehouseDto.setTransferDeliverOrgName(outWarehouse.getOrganizationName());
        warehouseDto.setTransferDeliverPhysicsWarehouseCode(outWarehouse.getPhysicsWarehouseCode());
        warehouseDto.setTransferDeliverPhysicsWarehouseName(outWarehouse.getPhysicsWarehouseName());
        warehouseDto.setTransferImportWarehouseName(inWarehouseRespDto.getWarehouseName());
        warehouseDto.setTransferImportPhysicsWarehouseName(inWarehouseRespDto.getPhysicsWarehouseName());
        warehouseDto.setTransferImportOrgCode(inWarehouseRespDto.getOrganizationCode());
        warehouseDto.setTransferImportOrgName(inWarehouseRespDto.getOrganizationName());
    }

    private Map<String, DgLogicWarehouseDto> mapLogicWarehouseDto(List<TransferDispatchWarehouseDto> importDtoList) {
        HashSet whCodes = new HashSet();
        importDtoList.stream().forEach(e -> {
            if (StringUtil.isNotBlank((CharSequence)e.getTransferDeliverWarehouseCode())) {
                whCodes.add(e.getTransferDeliverWarehouseCode());
            }
            if (StringUtil.isNotBlank((CharSequence)e.getTransferImportWarehouseCode())) {
                whCodes.add(e.getTransferImportWarehouseCode());
            }
        });
        if (whCodes.isEmpty()) {
            return new HashMap<String, DgLogicWarehouseDto>();
        }
        DgLogicWarehousePageReqDto warehousePageReqDto = new DgLogicWarehousePageReqDto();
        warehousePageReqDto.setWarehouseCodes((List)Lists.newArrayList(whCodes));
        RestResponse listRestResponse = this.dgLogicWarehouseApiProxy.queryList(warehousePageReqDto);
        return ((List)Optional.ofNullable(RestResponseHelper.extractData((RestResponse)listRestResponse)).orElse(new ArrayList())).stream().collect(Collectors.toMap(DgLogicWarehouseDto::getWarehouseCode, Function.identity()));
    }
}

